/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.jms;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.jms.JMSConnectionProperties;
import com.indy.engine.actionCodes.jms.Messages;
import com.indy.engine.secret.ISecretContext;
import com.indy.engine.secret.ISecretStatement;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JMSConnection {
    private InitialContext initialContext;
    private Connection connection;
    private JMSConnectionProperties jcp;
    Map<String, SessionInfo> sessions = new HashMap<String, SessionInfo>();

    public JMSConnection(JMSConnectionProperties jcp) {
        this.jcp = jcp;
    }

    public synchronized void connect(ActionCodeTypeI action) throws EngineExceptionI {
        try {
            action.secret((ISecretStatement)new ISecretStatement<Object>(){

                public Object execute(ISecretContext context) throws Throwable {
                    JMSConnection.this.initialContext = new InitialContext(JMSConnection.this.jcp.getProperties());
                    ConnectionFactory connectionFactory = (ConnectionFactory)JMSConnection.this.initialContext.lookup(JMSConnection.this.jcp.getConnectionFactoryName());
                    JMSConnection.this.connection = JMSConnection.this.jcp.getJmsLogin() == null ? connectionFactory.createConnection() : connectionFactory.createConnection(JMSConnection.this.jcp.getJmsLogin().getString(context), JMSConnection.this.jcp.getJmsPassword().decryptString(context));
                    if (JMSConnection.this.jcp.getJmsClientId() != null) {
                        JMSConnection.this.connection.setClientID(JMSConnection.this.jcp.getJmsClientId());
                    }
                    JMSConnection.this.connection.start();
                    return null;
                }
            });
        }
        catch (Throwable e) {
            throw new EngineExceptionI(e);
        }
    }

    public Destination getDestination(String destinationName) throws NamingException {
        return (Destination)this.initialContext.lookup(destinationName);
    }

    public synchronized void createSession(String name, int sessionAcknowledgePolicy) throws JMSException {
        this.createSession(name, sessionAcknowledgePolicy, true);
    }

    public synchronized void createSession(String name, int sessionAcknowledgePolicy, boolean throwErrorIfAlreadyExists) throws JMSException {
        SessionInfo sessionInfo = this.sessions.get(name);
        if (sessionInfo != null && throwErrorIfAlreadyExists) {
            throw new JMSException(Messages.getString("JMSConnection.0") + name + Messages.getString("JMSConnection.1"));
        }
        if (sessionInfo != null) {
            if (sessionInfo.session.getAcknowledgeMode() != sessionAcknowledgePolicy) {
                throw new JMSException(Messages.getString("JMSConnection.2") + name + Messages.getString("JMSConnection.3"));
            }
            return;
        }
        Session session = null;
        if (sessionAcknowledgePolicy == 0) {
            session = this.connection.createSession(true, 0);
            if (session.getAcknowledgeMode() != 0) {
                session.close();
                throw new JMSException(Messages.getString("JMSConnection.4"));
            }
        } else {
            session = this.connection.createSession(false, sessionAcknowledgePolicy);
        }
        SessionInfo si = new SessionInfo();
        si.session = session;
        this.sessions.put(name, si);
    }

    SessionInfo getSessionInfo(String sessionName) throws JMSException {
        return this.getSessionInfo(sessionName, true);
    }

    SessionInfo getSessionInfo(String sessionName, boolean throwErroIfNotExists) throws JMSException {
        SessionInfo sessionInfo = this.sessions.get(sessionName);
        if (sessionInfo == null && throwErroIfNotExists) {
            throw new JMSException(Messages.getString("JMSConnection.5") + sessionName + Messages.getString("JMSConnection.6"), "JMS_SESSION_NOT_EXISTS");
        }
        return sessionInfo;
    }

    Session getSession(String sessionName) throws JMSException {
        SessionInfo sessionInfo = this.getSessionInfo(sessionName);
        return sessionInfo.session;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized MessageConsumer createMessageConsumer(String sessionName, String destinationName, String subscriber, String messageSelector, boolean noLocal) throws JMSException, NamingException {
        SessionInfo sessionInfo = this.getSessionInfo(sessionName);
        MessageConsumer consumer = sessionInfo.consumers.get(destinationName);
        if (consumer != null) throw new JMSException(Messages.getString("JMSConnection.8") + destinationName);
        Destination destination = this.getDestination(destinationName);
        if (subscriber != null && !subscriber.isEmpty()) {
            if (!(destination instanceof Topic)) throw new JMSException(Messages.getString("JMSConnection.7"));
            consumer = sessionInfo.session.createDurableSubscriber((Topic)destination, subscriber, messageSelector, noLocal);
        } else {
            consumer = sessionInfo.session.createConsumer(destination, messageSelector, noLocal);
        }
        sessionInfo.consumers.put(destinationName + "::SUBSCRIBER::" + subscriber, consumer);
        return consumer;
    }

    public synchronized void closeMessageConsumer(String sessionName, String destinationName, String subscriber) throws JMSException {
        MessageConsumer consumer;
        SessionInfo sessionInfo = this.getSessionInfo(sessionName, false);
        if (sessionInfo != null && (consumer = sessionInfo.consumers.get(destinationName + "::SUBSCRIBER::" + subscriber)) != null) {
            consumer.close();
            sessionInfo.consumers.remove(destinationName + "::SUBSCRIBER::" + subscriber);
        }
    }

    public synchronized void closeMessageProducer(String sessionName, String destinationName) throws JMSException {
        MessageProducer producer;
        SessionInfo sessionInfo = this.getSessionInfo(sessionName, false);
        if (sessionInfo != null && (producer = sessionInfo.producers.get(destinationName)) != null) {
            producer.close();
            sessionInfo.producers.remove(destinationName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitSession(String sessionName) throws JMSException {
        SessionInfo si = this.getSessionInfo(sessionName);
        if (si.session.getAcknowledgeMode() == 0) {
            Object object = si.lock;
            synchronized (object) {
                si.session.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackSession(String sessionName) throws JMSException {
        SessionInfo si = this.getSessionInfo(sessionName);
        if (si.session.getAcknowledgeMode() != 0) {
            throw new JMSException(Messages.getString("JMSConnection.9"));
        }
        Object object = si.lock;
        synchronized (object) {
            si.session.rollback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(String sessionName) throws JMSException {
        SessionInfo si = this.getSessionInfo(sessionName);
        Object object = si.lock;
        synchronized (object) {
            si.session.close();
            this.sessions.remove(sessionName);
        }
    }

    public synchronized MessageProducer createMessageProducer(String sessionName, String destinationName) throws JMSException, NamingException {
        SessionInfo sessionInfo = this.getSessionInfo(sessionName);
        MessageProducer producer = sessionInfo.producers.get(destinationName);
        if (producer != null) {
            throw new JMSException(Messages.getString("JMSConnection.10") + destinationName);
        }
        Destination destination = this.getDestination(destinationName);
        Session session = this.getSession(sessionName);
        producer = session.createProducer(destination);
        sessionInfo.producers.put(destinationName, producer);
        return producer;
    }

    public MessageConsumer createMessage(String sessionName, String destinationName) throws JMSException, NamingException {
        Session session = this.getSession(sessionName);
        Destination destination = this.getDestination(destinationName);
        return session.createConsumer(destination);
    }

    public synchronized void closeConnection() throws JMSException, NamingException {
        for (Map.Entry<String, SessionInfo> session : this.sessions.entrySet()) {
            session.getValue().close();
        }
        this.sessions.clear();
        if (this.connection != null) {
            this.connection.stop();
            this.connection.close();
        }
        if (this.initialContext != null) {
            this.initialContext.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeSession(String sessionName) throws JMSException {
        SessionInfo si = this.getSessionInfo(sessionName);
        if (si.session.getAcknowledgeMode() != 2) {
            throw new JMSException(Messages.getString("JMSConnection.11"));
        }
        Object object = si.lock;
        synchronized (object) {
            Message message = si.getLastReceiveMessage();
            if (message != null) {
                message.acknowledge();
                si.setLastReceiveMessage(null);
            }
        }
    }

    public void commit() throws JMSException {
        for (String sessionName : this.sessions.keySet()) {
            this.commitSession(sessionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recoverSession(String jmsSessionName) throws JMSException {
        SessionInfo si = this.getSessionInfo(jmsSessionName);
        Object object = si.lock;
        synchronized (object) {
            si.session.recover();
        }
    }

    class SessionInfo {
        Map<String, MessageProducer> producers = new HashMap<String, MessageProducer>();
        Map<String, MessageConsumer> consumers = new HashMap<String, MessageConsumer>();
        Session session;
        private Message lastReceiveMessage;
        Object lock = new Object();

        SessionInfo() {
        }

        public void close() throws JMSException {
            this.session.close();
            for (Map.Entry<String, MessageProducer> entry : this.producers.entrySet()) {
                entry.getValue().close();
            }
            for (Map.Entry<String, MessageProducer> entry : this.consumers.entrySet()) {
                ((MessageConsumer)entry.getValue()).close();
            }
            this.producers.clear();
            this.consumers.clear();
            this.setLastReceiveMessage(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message getLastReceiveMessage() {
            Object object = this.lock;
            synchronized (object) {
                return this.lastReceiveMessage;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setLastReceiveMessage(Message lastReceiveMessage) {
            Object object = this.lock;
            synchronized (object) {
                this.lastReceiveMessage = lastReceiveMessage;
            }
        }
    }
}

