/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.jms;

import com.indy.engine.secret.ISecretValue;
import java.util.Map;
import java.util.Properties;

public class JMSConnectionProperties {
    private String dnsUrls;
    private String controlFactories;
    private String objectFactories;
    private String stateFactories;
    private String packagePrefixes;
    private String namingLanguage;
    private String namingReferral;
    private Boolean useMostAuthoritative;
    private Integer batchSize;
    private String initialContextFactory;
    private String jndiProviderUrl;
    private String securityAuthentication;
    private String securityCredentials;
    private String securityPrincipals;
    private String securityProtocol;
    private String connectionFactoryName;
    private ISecretValue jmsLogin;
    private ISecretValue jmsPassword;
    Properties additionalProperties = new Properties();
    private String jmsClientId;

    public void setDnsUrls(String dnsUrls) {
        this.dnsUrls = dnsUrls;
    }

    public void setControlFactories(String controlFactories) {
        this.controlFactories = controlFactories;
    }

    public void setObjectFactories(String objectFactories) {
        this.objectFactories = objectFactories;
    }

    public void setStateFactories(String stateFactories) {
        this.stateFactories = stateFactories;
    }

    public void setPackagePrefixes(String packagePrefixes) {
        this.packagePrefixes = packagePrefixes;
    }

    public void setNamingLanguage(String namingLanguage) {
        this.namingLanguage = namingLanguage;
    }

    public void setNamingReferral(String namingReferral) {
        this.namingReferral = namingReferral;
    }

    public void setUseMostAuthoritative(Boolean useMostAuthoritative) {
        this.useMostAuthoritative = useMostAuthoritative;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setInitialContextFactory(String initialContextFactory) {
        this.initialContextFactory = initialContextFactory;
    }

    public void setJndiProviderUrl(String jndiProviderUrl) {
        this.jndiProviderUrl = jndiProviderUrl;
    }

    public void setSecurityAuthentication(String securityAuthentication) {
        this.securityAuthentication = securityAuthentication;
    }

    public void setSecurityCredentials(String securityCredentials) {
        this.securityCredentials = securityCredentials;
    }

    public void setSecurityPrincipals(String securityPrincipals) {
        this.securityPrincipals = securityPrincipals;
    }

    public void setSecurityProtocol(String securityProtocol) {
        this.securityProtocol = securityProtocol;
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public void setJmsLogin(ISecretValue jmsLogin) {
        this.jmsLogin = jmsLogin;
    }

    public void setJmsPassword(ISecretValue jmsPassword) {
        this.jmsPassword = jmsPassword;
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.additionalProperties);
        if (this.useMostAuthoritative != null) {
            if (this.useMostAuthoritative.booleanValue()) {
                props.put("java.naming.authoritative", "true");
            } else {
                props.put("java.naming.authoritative", "false");
            }
        }
        if (this.batchSize != null) {
            props.put("java.naming.batchsize", this.batchSize.toString());
        }
        if (this.dnsUrls != null && this.dnsUrls.length() > 0) {
            props.put("java.naming.dns.url", this.dnsUrls);
        }
        if (this.controlFactories != null && this.controlFactories.length() > 0) {
            props.put("java.naming.factory.control", this.controlFactories);
        }
        if (this.initialContextFactory != null && this.initialContextFactory.length() > 0) {
            props.put("java.naming.factory.initial", this.initialContextFactory);
        }
        if (this.objectFactories != null && this.objectFactories.length() > 0) {
            props.put("java.naming.factory.object", this.objectFactories);
        }
        if (this.stateFactories != null && this.stateFactories.length() > 0) {
            props.put("java.naming.factory.state", this.stateFactories);
        }
        if (this.packagePrefixes != null && this.packagePrefixes.length() > 0) {
            props.put("java.naming.factory.url.pkgs", this.packagePrefixes);
        }
        if (this.namingLanguage != null && this.namingLanguage.length() > 0) {
            props.put("java.naming.language", this.namingLanguage);
        }
        if (this.jndiProviderUrl != null && this.jndiProviderUrl.length() > 0) {
            props.put("java.naming.provider.url", this.jndiProviderUrl);
        }
        if (this.namingReferral != null && this.namingReferral.length() > 0) {
            props.put("java.naming.referral", this.namingReferral);
        }
        if (this.securityAuthentication != null && this.securityAuthentication.length() > 0) {
            props.put("java.naming.security.authentication", this.securityAuthentication);
        }
        if (this.securityCredentials != null && this.securityCredentials.length() > 0) {
            props.put("java.naming.security.credentials", this.securityCredentials);
        }
        if (this.securityPrincipals != null && this.securityPrincipals.length() > 0) {
            props.put("java.naming.security.principal", this.securityPrincipals);
        }
        if (this.securityProtocol != null && this.securityProtocol.length() > 0) {
            props.put("java.naming.security.protocol", this.securityProtocol);
        }
        return props;
    }

    public ISecretValue getJmsLogin() {
        return this.jmsLogin;
    }

    public ISecretValue getJmsPassword() {
        return this.jmsPassword;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setProperty(String arg0, String arg1) {
        this.additionalProperties.setProperty(arg0, arg1);
    }

    public void setJmsClientId(String localStringBindedParameter) {
        this.jmsClientId = localStringBindedParameter;
    }

    public String getJmsClientId() {
        return this.jmsClientId;
    }

    public String getJndiProviderUrl() {
        return this.jndiProviderUrl;
    }
}

