/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.jms;

import com.indy.engine.actionCodes.jms.JMSConnection;
import com.indy.engine.actionCodes.jms.JMSMessageListener;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.NamingException;

public class JMSMessageReceiver {
    List<JMSMessageListener> listeners = Collections.synchronizedList(new ArrayList());
    String sessionName;
    String destinationName;
    String subscriberName;
    String messageSelector = null;
    int pMaxMessageCount = -1;
    int pTimeout = 0;
    boolean noLocal = false;
    MessageConsumer consumer;

    public void addListener(JMSMessageListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(JMSMessageListener listener) {
        this.listeners.remove(listener);
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public void setDestinationName(String destinationName) {
        this.destinationName = destinationName;
    }

    public void setSubscriberName(String subscriberName) {
        this.subscriberName = subscriberName;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public void setMessageNumber(int pMaxMessageCount) {
        this.pMaxMessageCount = pMaxMessageCount;
    }

    public void setTimeout(int pTimeout) {
        this.pTimeout = pTimeout;
    }

    public void setNoLocal(boolean noLocal) {
        this.noLocal = noLocal;
    }

    public void receive(JMSConnection conn) throws JMSException, NamingException, InterruptedException {
        try {
            JMSConnection.SessionInfo si = conn.getSessionInfo(this.sessionName);
            int aknowledgeMode = si.session.getAcknowledgeMode();
            this.consumer = conn.createMessageConsumer(this.sessionName, this.destinationName, this.subscriberName, this.messageSelector, this.noLocal);
            int messageCount = 0;
            boolean timeoutOccured = false;
            while (!(this.pMaxMessageCount != -1 && messageCount >= this.pMaxMessageCount || timeoutOccured)) {
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                Message message = null;
                message = this.pTimeout > 0 ? this.consumer.receive((long)this.pTimeout) : (this.pTimeout == -1 ? this.consumer.receive() : this.consumer.receiveNoWait());
                if (message == null) {
                    timeoutOccured = true;
                    continue;
                }
                if (aknowledgeMode == 2) {
                    si.setLastReceiveMessage(message);
                }
                this.fireMessageEvent(message, messageCount++);
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
        }
        finally {
            this.closeMessageConsumer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireMessageEvent(Message message, int count) throws JMSException {
        List<JMSMessageListener> list = this.listeners;
        synchronized (list) {
            for (JMSMessageListener listener : this.listeners) {
                listener.onMessage(message, count);
            }
        }
    }

    public void closeMessageConsumer() throws JMSException {
        if (this.consumer != null) {
            this.consumer.close();
        }
    }

    public void clear() {
        this.listeners.clear();
        this.consumer = null;
    }
}

