/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.actionCodes.xml.unload;

import com.indy.engine.action.common.ActionCodeTypeI;
import com.indy.engine.actionCodes.JdbcToXmlActionCodeI;
import com.indy.engine.actionCodes.xml.unload.AbstractXmlWriterAPI;
import com.indy.engine.common.tools.OutputStreamTransformer;
import com.indy.engine.common.xml.XmlUtils;
import com.indy.engine.core.module.classloader.ClassLoaderServiceProvider;
import com.indy.runtime.xml.NewLineCharacter;
import com.indy.runtime.xml.XMLOutputFactoryWrapper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class XmlWriterAPI
extends AbstractXmlWriterAPI {
    private String xmlOutPutFactoryClassName;
    private OutputStream os;
    private OutputStreamTransformer wrapper;
    private Map<String, Object> properties;
    private String xmlOutPutFactoryModule;
    private final Logger logger = LogManager.getLogger(XmlWriterAPI.class);

    protected XmlWriterAPI(boolean commit, String encoding, boolean writeXmlDeclaration, String xmlVersion, String xmlOutPutFactoryModule, String xmlOutPutFactoryClassName, File outFile, ActionCodeTypeI actionCode, AbstractXmlWriterAPI.NoDataBehaviour noDataBehaviour, AbstractXmlWriterAPI.FileAlreadyExistsBehaviour fileAlreadyExistsBehaviour, OutputStreamTransformer outputStreamWrapper, Map<String, Object> properties) {
        super(commit, encoding, writeXmlDeclaration, xmlVersion, outFile, actionCode, noDataBehaviour, fileAlreadyExistsBehaviour);
        this.xmlOutPutFactoryModule = xmlOutPutFactoryModule;
        this.xmlOutPutFactoryClassName = xmlOutPutFactoryClassName;
        this.wrapper = outputStreamWrapper;
        this.properties = properties;
    }

    public abstract JdbcToXmlActionCodeI.IndyElement getRoot();

    @Override
    public XMLStreamWriter createWriter(File file, boolean hasRawData) throws XMLStreamException, IOException {
        XMLOutputFactory xof = null;
        if (this.xmlOutPutFactoryClassName != null) {
            try {
                if (this.xmlOutPutFactoryModule != null) {
                    xof = XMLOutputFactoryWrapper.newFactory((String)this.xmlOutPutFactoryClassName, (ClassLoader)ClassLoaderServiceProvider.instance().getClassLoader(this.xmlOutPutFactoryModule));
                }
                xof = XMLOutputFactoryWrapper.newFactory((String)this.xmlOutPutFactoryClassName, (ClassLoader)this.getClass().getClassLoader());
            }
            catch (FactoryConfigurationError e) {
                this.logger.error("Error creating instance", (Throwable)e);
                xof = XMLOutputFactory.newFactory();
            }
            catch (ClassLoaderServiceProvider.ClassLoaderServiceException e) {
                throw new IOException(e);
            }
        } else {
            xof = XMLOutputFactory.newFactory();
        }
        if (this.properties != null) {
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                xof.setProperty(entry.getKey(), entry.getValue());
            }
        }
        this.xmlw = null;
        if (this.encoding == null) {
            this.encoding = Charset.defaultCharset().displayName();
        }
        this.os = new FileOutputStream(file);
        if (this.wrapper != null) {
            this.os = this.wrapper.start(this.os);
        }
        if (this.encoding != null) {
            if (hasRawData) {
                this.osw = new OutputStreamWriter((OutputStream)new BufferedOutputStream(this.os), this.encoding);
                this.xmlw = xof.createXMLStreamWriter(this.osw);
            } else {
                this.xmlw = xof.createXMLStreamWriter(new BufferedOutputStream(this.os), this.encoding);
            }
        } else if (hasRawData) {
            this.osw = new OutputStreamWriter(new BufferedOutputStream(this.os));
            this.xmlw = xof.createXMLStreamWriter(this.osw);
        } else {
            this.xmlw = xof.createXMLStreamWriter(new BufferedOutputStream(this.os));
        }
        return this.getXMLStreamWriter();
    }

    @Override
    public void closeCurrent() throws Exception {
        if (this.osw != null) {
            try {
                this.osw.close();
            }
            catch (IOException e) {
                this.logger.warn("Error closing output stream writer", (Throwable)e);
            }
        }
        if (this.os != null) {
            try {
                this.os.close();
            }
            catch (IOException e) {
                this.logger.warn("Error closing", (Throwable)e);
            }
        }
        if (this.wrapper != null) {
            try {
                this.wrapper.close();
            }
            catch (Throwable e) {
                this.logger.warn("Error closing", e);
            }
        }
    }

    @Override
    public void addRoot() throws XMLStreamException {
        if (this.getRoot() != null) {
            this.writeStartElement(this.getRoot());
            this.getXMLStreamWriter().writeEndElement();
        }
    }

    @Override
    public Exception getWrapperException() {
        if (this.wrapper != null && this.wrapper.getException() != null) {
            return this.wrapper.getException();
        }
        return null;
    }

    @Override
    public void interrupt() {
        super.interrupt();
        if (this.wrapper != null) {
            this.wrapper.interrupt();
        }
    }

    @Override
    public void writeNewLineCharacter() throws Exception {
        NewLineCharacter newLineCharacter = new NewLineCharacter();
        XmlUtils.writeXMLEventToXMLStreamWriter((XMLEvent)newLineCharacter, (XMLStreamWriter)this.getXMLStreamWriter());
    }
}

