/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.module.impl;

import com.indy.engine.core.module.impl.ModuleReloader;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class ModuleWatcher {
    private static final int DELAY = 500;
    private final WatchService watcher;
    private final Map<WatchKey, Path> keys;
    private Path moduleFolder;
    private ModuleReloader reloader;
    private Set<String> modifiedModules = Collections.synchronizedSet(new HashSet());
    private Timer processTimer = null;

    ModuleWatcher(Path moduleFolder, ModuleReloader reloader) throws IOException {
        this.watcher = FileSystems.getDefault().newWatchService();
        this.keys = new HashMap<WatchKey, Path>();
        this.moduleFolder = moduleFolder;
        this.reloader = reloader;
        this.registerAll(this.moduleFolder);
    }

    private void register(Path dir) throws IOException {
        WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.keys.put(key, dir);
    }

    private void registerAll(Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String folderName;
                if ((ModuleWatcher.this.moduleFolder == dir || ModuleWatcher.this.moduleFolder.equals(dir.getParent())) && !"core".equals(folderName = dir.getName(dir.getNameCount() - 1).toString())) {
                    ModuleWatcher.this.register(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    void processEvents() {
        while (true) {
            WatchKey key;
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
                return;
            }
            Path dir = this.keys.get(key);
            if (dir == null) continue;
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent<?> ev = event;
                Path name = (Path)ev.context();
                Path child = dir.resolve(name);
                Path relative = this.moduleFolder.relativize(child);
                this.addModuleToProcess(relative.getName(0).toString());
                if (!child.getParent().equals(this.moduleFolder) || kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                try {
                    if (!Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) continue;
                    this.registerAll(child);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.keys.remove(key);
            if (this.keys.isEmpty()) break;
        }
    }

    private void addModuleToProcess(String moduleName) {
        if (!this.modifiedModules.add(moduleName)) {
            return;
        }
        if (this.processTimer != null) {
            this.processTimer.cancel();
        }
        this.processTimer = new Timer();
        this.processTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                ModuleWatcher.this.process();
            }
        }, 500L);
    }

    private void process() {
        this.reloader.askToReload(this.modifiedModules);
        this.modifiedModules.clear();
    }

    public void watch() {
        Thread th = new Thread(this::processEvents, "Module Watcher");
        th.setDaemon(true);
        th.start();
    }
}

