/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.base.core.auth;

import com.semarchy.xdi.base.core.auth.AuthenticationInfo;
import com.semarchy.xdi.base.core.auth.OAuth;
import com.semarchy.xdi.base.core.auth.OAuthMetadata;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class OAuthAuthentication
extends AuthenticationInfo {
    private OAuthMetadata md = new OAuthMetadata();
    private URL url;
    private String httpMethod;

    public OAuthAuthentication(URL url, String httpMethod, String consumerKey, String consumerSecret, String signatureMethod, String token, String tokenSecret) {
        this.md.consumerKey = consumerKey;
        this.md.consumerSecret = consumerSecret;
        this.md.signatureMethod = signatureMethod;
        this.md.token = token;
        this.md.tokenSecret = tokenSecret;
        this.url = url;
        this.httpMethod = httpMethod;
    }

    @Override
    public String getAuthenticationHeaderValue(String serverAuthenticationHeader) throws Exception {
        try {
            Map<String, String> parameters = this.parseParameters(this.url);
            String authorizationHeaderValue = OAuth.generateHeader(this.url.toString(), this.httpMethod, this.md, parameters);
            return authorizationHeaderValue;
        }
        catch (Exception ex) {
            throw new Exception("Failed to generate OAuth 1 Authorization Header", ex);
        }
    }

    private Map<String, String> parseParameters(URL url) {
        String s = url.getQuery();
        if (s != null && !s.isEmpty()) {
            String[] p;
            HashMap<String, String> m = new HashMap<String, String>();
            String[] stringArray = p = s.split("&");
            int n = p.length;
            int n2 = 0;
            while (n2 < n) {
                String pp = stringArray[n2];
                String[] v = pp.split("=");
                if (v.length == 1) {
                    m.put(v[0], null);
                } else {
                    m.put(v[0], v[1]);
                }
                ++n2;
            }
            return m;
        }
        return Collections.EMPTY_MAP;
    }
}

