/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation;

import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.XDIModelURIResolver;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.core.utils.RuntimeLocationHelper;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import com.semarchy.xdi.designer.generation.Messages;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.URI;

public class AntLaunchHelper {
    public static final String GENERATE_PACKAGE_OUTPUT_FOLDER = "com.indy.launchers.configurations.packageOutputFolder";
    public static final String GENERATE_PACKAGE_OUTPUT_NAME = "com.indy.launchers.configurations.packageOutputName";
    public static final String GENERATE_PACKAGE_OUTPUT_CONF_NAME = "com.indy.launchers.configurations.packageOutputConfName";

    private static String getPackagesDir() {
        return new File(RuntimeLocationHelper.getRuntimeLocation(), File.separator + "build" + File.separator + "packages").getAbsolutePath();
    }

    public static File extractOutputFilePath(ILaunchConfiguration configuration) throws Exception {
        String outMode = configuration.getAttribute("com.indy.launchers.attributes.outputMode", "");
        String out = configuration.getAttribute("com.indy.launchers.attributes.outputFolder", "");
        Object _fName = configuration.getAttribute("com.indy.launchers.attributes.outputName", "");
        if (_fName == null || ((String)_fName).trim().isEmpty()) {
            _fName = configuration.getName();
        }
        String folder = null;
        if (!out.isEmpty()) {
            if (outMode.equals("fileSystem")) {
                folder = out;
            } else if (outMode.equals("workspace")) {
                XDIModelURIResolver uriResolver = (XDIModelURIResolver)E4InjectorHelper.getService(XDIModelURIResolver.class);
                folder = uriResolver.resolve(URI.createPlatformResourceURI((String)out, (boolean)false)).getAbsolutePath();
            }
        }
        if (folder == null) {
            folder = AntLaunchHelper.getPackagesDir();
        }
        if (!((String)_fName).endsWith(".pck")) {
            _fName = (String)_fName + ".pck";
        }
        return new File(folder + "/" + (String)_fName);
    }

    public static Map<String, String> createAntTaskOptions(ILaunchConfiguration configuration) throws Exception {
        XDIModelURIResolver uriResolver = (XDIModelURIResolver)E4InjectorHelper.getService(XDIModelURIResolver.class);
        String outMode = configuration.getAttribute("com.indy.launchers.attributes.outputMode", "");
        String out = configuration.getAttribute("com.indy.launchers.attributes.outputFolder", "");
        Object _fName = configuration.getAttribute("com.indy.launchers.attributes.outputName", "");
        if (_fName == null || ((String)_fName).trim().isEmpty()) {
            _fName = configuration.getName();
        }
        File outputFolder = null;
        outputFolder = outMode.equals("fileSystem") ? new File(out) : (outMode.equals("workspace") ? uriResolver.resolve(URI.createPlatformResourceURI((String)out, (boolean)true)) : new File(AntLaunchHelper.getPackagesDir()));
        outputFolder.mkdirs();
        if (!outputFolder.exists() || !outputFolder.isDirectory()) {
            throw new CoreException((IStatus)new Status(4, "com.indy.ui.build.launchers", Messages.bind((String)Messages.AntJobHelper_26, (Object)outputFolder)));
        }
        IEclipsePreferences pref = InstanceScope.INSTANCE.getNode("com.indy.ui.build");
        Boolean includeSrc = configuration.getAttribute("com.indy.launchers.attributes.includeSources", pref.getBoolean("package.generation.includeSources", false));
        boolean generateDoc = configuration.getAttribute("com.indy.launchers.attributes.hasDocumentation", includeSrc.booleanValue());
        boolean includeSources = configuration.getAttribute("com.indy.launchers.attributes.includeSources", Boolean.FALSE.booleanValue());
        List ids = configuration.getAttribute("com.indy.launchers.attributes.processListId", null);
        List<String> files = null;
        if (ids != null) {
            files = new ArrayList();
            ICacheService cacheService = (ICacheService)E4InjectorHelper.getService(ICacheService.class);
            for (String id : ids) {
                URI uri = cacheService.findResourceURIByFileId(id);
                if (uri == null) {
                    throw new Exception(Messages.bind((String)Messages.AntJobHelper_0, (Object)id));
                }
                files.add(URIUtils.toPath((URI)uri).toString());
            }
        } else {
            files = configuration.getAttribute("com.indy.launchers.attributes.processList", Collections.EMPTY_LIST);
        }
        StringBuffer paths = new StringBuffer();
        HashSet<String> fileNames = new HashSet<String>();
        for (Object e : files) {
            Path p = new Path("/");
            Path encoded = new Path((String)e);
            int i = 0;
            while (i < encoded.segmentCount()) {
                p = p.append(encoded.segment(i));
                ++i;
            }
            File file = null;
            try {
                file = uriResolver.resolve(URI.createPlatformResourceURI((String)p.toString(), (boolean)false));
                if (file == null) {
                    throw new Exception(Messages.bind((String)Messages.AntJobHelper_5, (Object)p.toString()));
                }
                paths.append(file.getAbsolutePath());
            }
            catch (MalformedURLException e2) {
                e2.printStackTrace();
            }
            catch (IOException e3) {
                e3.printStackTrace();
            }
            paths.append("|");
            paths.append(p.toString());
            paths.append(";");
            if (fileNames.add(file.getName())) continue;
            throw new CoreException((IStatus)new Status(4, "com.indy.ui.build.launchers", Messages.AntJobHelper_33 + file.getName() + Messages.AntJobHelper_34));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (!out.isEmpty()) {
            if (outMode.equals("fileSystem")) {
                hashMap.put(GENERATE_PACKAGE_OUTPUT_FOLDER, out);
            } else if (outMode.equals("workspace")) {
                File f = uriResolver.resolve(URI.createPlatformResourceURI((String)out.toString(), (boolean)false));
                hashMap.put(GENERATE_PACKAGE_OUTPUT_FOLDER, f.getAbsolutePath());
            }
        }
        String confName = _fName;
        if (!((String)_fName).endsWith(".pck")) {
            _fName = (String)_fName + ".pck";
        }
        hashMap.put("package.includeSources", "" + includeSources);
        hashMap.put(GENERATE_PACKAGE_OUTPUT_NAME, (String)_fName);
        hashMap.put(GENERATE_PACKAGE_OUTPUT_CONF_NAME, confName);
        hashMap.put("package.multiProc.paths", paths.toString());
        hashMap.put("package.multiProc.generateDocumentation", "" + generateDoc);
        hashMap.put("package.multiProc.packageId", UUID.randomUUID().toString());
        return hashMap;
    }
}

