/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.ant;

import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.OneProcCompilation;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.configuration.MdConfigurationCompilation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Helper {
    private MdConfigurationCompilation mdCompiler;
    private OneProcCompilation procCompoiler;
    private static Helper instance = null;
    private static final Logger logger = LogManager.getLogger(Helper.class);

    private Helper() {
    }

    public static synchronized Helper getHelper(String stambiaRuntimeHome, String iconsPerLevel) {
        if (instance == null) {
            instance = new Helper();
            Helper.instance.mdCompiler = new MdConfigurationCompilation(stambiaRuntimeHome);
            Helper.instance.procCompoiler = new OneProcCompilation(stambiaRuntimeHome);
        }
        Helper.instance.mdCompiler.setIconsPerLevel(Helper.parseIconsPerLevel(iconsPerLevel));
        return instance;
    }

    private static Map<String, URI> parseIconsPerLevel(String iconsPerLevel) {
        if (iconsPerLevel == null) {
            return Collections.emptyMap();
        }
        HashMap<String, URI> res = new HashMap<String, URI>();
        String[] stringArray = iconsPerLevel.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String[] pp;
            String s = stringArray[n2];
            if (!s.isEmpty() && (pp = s.split("=")).length == 2) {
                try {
                    res.put(pp[0], new URI(pp[1]));
                }
                catch (URISyntaxException e) {
                    logger.error("Invalid URI {}", (Object)pp[1], (Object)e);
                }
            }
            ++n2;
        }
        return res;
    }

    public MdConfigurationCompilation getMdCompiler() {
        return this.mdCompiler;
    }

    public OneProcCompilation getProcCompoiler() {
        return this.procCompoiler;
    }
}

