/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.ant;

import com.indy.engine.core.module.IModuleService;
import com.semarchy.xdi.designer.core.services.ICacheService;
import com.semarchy.xdi.designer.core.services.IDesignerVersionProvider;
import com.semarchy.xdi.designer.core.services.IModuleRequirmentService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.generation.ant.Messages;
import com.semarchy.xdi.designer.generation.ant.PackageManifest;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.OneProcCompilation;
import com.semarchy.xdi.designer.generation.xsl.global.Functions;
import jakarta.inject.Inject;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Marshaller;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.stream.IntStream;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.osgi.service.environment.EnvironmentInfo;
import org.osgi.framework.wiring.BundleWiring;

public class ManifestCallback
extends Task {
    private static final String WORK2_PROP = "work2.dir";
    private static final String INTERNAL_FOLDER = "___internal___";
    private String modelsURI;
    private boolean includeSources = false;
    private String inputPropertiesFilePath;
    @Inject
    private ICacheService cacheService;
    @Inject
    private EnvironmentInfo environmentInfo;
    @Inject
    private IDesignerVersionProvider designerVersionProvider;
    @Inject
    private ICacheService.IDependenciesGraphAnalyzer depenciesGraph;
    @Inject
    private IModuleRequirmentService moduleRequirementService;
    @Inject
    private IModuleService moduleService;

    public ManifestCallback() {
        E4InjectorHelper.inject((Object)((Object)this));
    }

    public void setInputPropertiesFile(String inputPropertiesFile) {
        this.inputPropertiesFilePath = inputPropertiesFile;
    }

    public void setModelsURI(String modelsURI) {
        this.modelsURI = modelsURI;
    }

    public void setIncludeSources(boolean include) {
        this.includeSources = include;
    }

    public void execute() throws BuildException {
        Object message;
        String id232;
        Object uri;
        ArrayList<String> processPaths = new ArrayList<String>();
        HashMap<String, String> processIds = new HashMap<String, String>();
        HashMap<String, String> processChecksumIds = new HashMap<String, String>();
        this.log(Messages.ManifestCallback_0);
        String[] stringArray = this.modelsURI.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] p = s.split("\\|");
            processPaths.add(p[1]);
            uri = URI.createPlatformResourceURI((String)p[1], (boolean)true);
            id232 = this.cacheService.getSourceId((URI)uri);
            if (id232 != null) {
                if (id232.endsWith("-proc")) {
                    id232 = id232.substring(0, id232.lastIndexOf("-proc"));
                }
                URI uRI = this.cacheService.findResourceURIByFileId(id232);
                String name = null;
                if (uRI.fragment() != null) {
                    name = CacheHelper.extractEltName((String)uRI.fragment());
                }
                if (name == null) {
                    name = URI.decode((String)uRI.trimFileExtension().lastSegment());
                }
                processIds.put(id232, name);
                processChecksumIds.put(id232, this.getProject().getProperty("checksum." + name));
            }
            ++n2;
        }
        PackageManifest manifest = new PackageManifest();
        manifest.setContainsSources(this.includeSources);
        manifest.setGenerationDate(new Date());
        manifest.setConfigurationName(this.getProject().getProperty("conf"));
        MetadataInfo mdInfo = this.readMetadata();
        manifest.setPackageId(mdInfo.packageId);
        manifest.setUser(mdInfo.user);
        manifest.setType(PackageManifest.Type.Package);
        manifest.setGenerationDate(mdInfo.date);
        manifest.getSystemInfo().setArch(this.environmentInfo.getOSArch());
        manifest.getSystemInfo().setOs(this.environmentInfo.getOS());
        manifest.getSystemInfo().setWs(this.environmentInfo.getWS());
        manifest.getSystemInfo().setDesignerReleaseVersion(this.designerVersionProvider.getReleaseBuildVersion());
        Map requirements = this.depenciesGraph.getRequiredModelsURI(processIds.keySet());
        HashSet<String> udfModelIds = new HashSet<String>();
        if (requirements.remove("UUID_REGISTRY_UDF") != null) {
            Properties props = new Properties();
            try {
                uri = null;
                id232 = null;
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(new File(this.inputPropertiesFilePath)));){
                    props.load(bufferedInputStream);
                    Enumeration<Object> keys = props.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        if (!key.startsWith("udfModelId.")) continue;
                        String modelID = key.substring(key.indexOf(".") + 1);
                        requirements.put(modelID, this.cacheService.findResourceURIByFileId(modelID));
                        udfModelIds.add(modelID);
                    }
                }
                catch (Throwable id232) {
                    if (uri == null) {
                        uri = id232;
                    } else if (uri != id232) {
                        ((Throwable)uri).addSuppressed(id232);
                    }
                    throw uri;
                }
            }
            catch (Exception ex) {
                throw new BuildException(String.format(Messages.ManifestCallback_2, this.inputPropertiesFilePath), (Throwable)ex);
            }
        }
        for (Map.Entry entry : processIds.entrySet()) {
            requirements.put((String)entry.getKey(), this.cacheService.findResourceURIByFileId((String)entry.getKey()));
            PackageManifest.MainProcess main = new PackageManifest.MainProcess();
            main.setProcessId((String)entry.getKey());
            main.setName((String)entry.getValue());
            main.setDeliveryChecksum((String)processChecksumIds.get(entry.getKey()));
            Map map = this.depenciesGraph.getRequiredModelsURI(Collections.singleton((String)entry.getKey()));
            try {
                Job j = this.moduleRequirementService.createRefresh(map.values());
                j.schedule();
                j.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.getProject().log((Task)this, "unexpected interruption", (Throwable)e, 1);
            }
            catch (Exception e) {
                this.getProject().log((Task)this, "unexpected", (Throwable)e, 1);
            }
            HashSet required = new HashSet(map.keySet());
            required.addAll(udfModelIds);
            main.getRequiredModels().addAll(required);
            Collections.sort(main.getRequiredModels());
            manifest.getDeliveriesProcesses().add(main);
            HashMap<String, PackageManifest.ModuleRequirment> requiredModules = new HashMap<String, PackageManifest.ModuleRequirment>();
            for (URI uri2 : map.values()) {
                IModuleService.IBaseModuleInfo baseModule;
                if (uri2 == null || !"md".equals(uri2.fileExtension()) || uri2.segment(2).equals("indy.build")) continue;
                String moduleName = this.moduleRequirementService.getSpecifiedModuleName(uri2);
                String moduleBaseId = null;
                PackageManifest.ModuleRequirment requirment = null;
                if (moduleName == null || (requirment = (PackageManifest.ModuleRequirment)requiredModules.get(moduleName)) != null) continue;
                IModuleService.IModule module = this.moduleService.getModule(moduleName);
                if (module != null && (baseModule = module.getDescriptor().getBaseModuleInfo()) != null) {
                    moduleBaseId = baseModule.getId();
                }
                requirment = new PackageManifest.ModuleRequirment(moduleBaseId, moduleName);
                requiredModules.put(moduleName, requirment);
            }
            requiredModules.values().stream().sorted(Comparator.comparing(PackageManifest.ModuleRequirment::getModuleName)).forEach(r -> {
                boolean bl = main.getRequiredModules().add((PackageManifest.ModuleRequirment)r);
            });
        }
        File docFolder = Paths.get(this.getProject().getProperty(WORK2_PROP), INTERNAL_FOLDER, "doc").toFile();
        manifest.setContainsDocumentation(docFolder.exists());
        File targetSrcFolder = Paths.get(this.getProject().getProperty(WORK2_PROP), INTERNAL_FOLDER, "__src").toFile();
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("MD5");
        }
        catch (Exception exception) {
            message = Messages.ManifestCallback_3;
            this.log((String)message, exception, 0);
            throw new BuildException((String)message, (Throwable)exception);
        }
        for (Map.Entry entry : requirements.entrySet()) {
            URI modelURI = (URI)entry.getValue();
            String u = Functions.findURIByFileId((String)entry.getKey());
            if (u == null || u.isEmpty()) {
                throw new BuildException(String.format("Unable to find URI for %s:%s. There may be an issue within the index.", entry.getKey(), entry.getValue()));
            }
            java.net.URI srcURI = null;
            srcURI = u.startsWith("file:") ? java.net.URI.create(u) : new File(u).toURI();
            String srcRelativePath = null;
            File targetFile = null;
            if (modelURI.isPlatformPlugin()) {
                String[] srcSegments = (String[])IntStream.range(2, modelURI.segmentCount()).mapToObj(i -> OneProcCompilation.unformatURI(modelURI.segment(i))).toArray(String[]::new);
                srcRelativePath = Paths.get("__internalResources__", srcSegments).toString();
                trgPath = Paths.get(targetSrcFolder.toString(), srcRelativePath);
                targetFile = trgPath.toFile();
            } else {
                String[] trgSegments = (String[])IntStream.range(1, modelURI.segmentCount()).mapToObj(i -> OneProcCompilation.unformatURI(modelURI.segment(i))).toArray(String[]::new);
                srcRelativePath = Paths.get("", trgSegments).toString();
                trgPath = Paths.get(targetSrcFolder.toString(), trgSegments);
                targetFile = trgPath.toFile();
            }
            String checksum = this.copyFile(srcURI, targetFile, digest);
            manifest.getSources().add(new PackageManifest.SourceEntry((String)entry.getKey(), checksum, srcRelativePath));
        }
        this.log(Messages.ManifestCallback_4);
        try {
            File file = Paths.get(this.getProject().getProperty(WORK2_PROP), INTERNAL_FOLDER, "manifest.xml").toFile();
            this.serializeManifest(manifest, file);
            this.log(Messages.ManifestCallback_5 + file.getAbsolutePath());
        }
        catch (Exception exception) {
            message = Messages.ManifestCallback_6;
            this.log((String)message, exception, 0);
            throw new BuildException((String)message, (Throwable)exception);
        }
    }

    private void serializeManifest(PackageManifest manifest, File outputFile) throws BuildException {
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(outputFile));){
                    Thread.currentThread().setContextClassLoader(((BundleWiring)Platform.getBundle((String)"com.indy.runtime").adapt(BundleWiring.class)).getClassLoader());
                    JAXBContext ctx = JAXBContext.newInstance((Class[])new Class[]{PackageManifest.class});
                    Marshaller m = ctx.createMarshaller();
                    m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                    m.marshal((Object)manifest, (OutputStream)fos);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                throw new BuildException("Failed to serialize manifest", (Throwable)ex);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(ccl);
        }
    }

    private MetadataInfo readMetadata() throws BuildException {
        File file = Paths.get(this.getProject().getProperty(WORK2_PROP), "metadata.xml").toFile();
        XMLStreamReader reader = null;
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        try {
            MetadataInfo metadataInfo;
            block27: {
                Throwable throwable = null;
                Object var5_7 = null;
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
                try {
                    reader = inputFactory.createXMLStreamReader(is);
                    String packageId = null;
                    String date = null;
                    String userName = null;
                    while (reader.hasNext()) {
                        int type = reader.next();
                        if (type != 1) continue;
                        int i = 0;
                        while (i < reader.getAttributeCount()) {
                            String attName = reader.getAttributeLocalName(i);
                            if (attName.equals("packageId")) {
                                packageId = reader.getAttributeValue(i);
                            } else if (attName.equals("date")) {
                                date = reader.getAttributeValue(i);
                            } else if (attName.equals("userName")) {
                                userName = reader.getAttributeValue(i);
                            }
                            ++i;
                        }
                        break block15;
                    }
                    metadataInfo = new MetadataInfo(packageId, date, userName);
                    if (is == null) break block27;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (is != null) {
                                ((InputStream)is).close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (Exception ex) {
                        throw new BuildException(String.format("Failed to read %s", file), (Throwable)ex);
                    }
                }
                ((InputStream)is).close();
            }
            return metadataInfo;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {
                    this.getProject().log("Unexpected", (Throwable)e, 0);
                }
            }
        }
    }

    private String copyFile(java.net.URI srcFileURI, File targetFile, MessageDigest digest) throws BuildException {
        digest.reset();
        FilterOutputStream bos = null;
        try {
            try {
                Throwable throwable = null;
                Object var6_8 = null;
                try (BufferedInputStream bis = new BufferedInputStream(srcFileURI.toURL().openStream());){
                    if (this.includeSources) {
                        targetFile.getParentFile().mkdirs();
                        bos = new BufferedOutputStream(new FileOutputStream(targetFile));
                    }
                    byte[] buffer = new byte[2048];
                    int sz = -1;
                    while ((sz = bis.read(buffer)) != -1) {
                        if (bos != null) {
                            ((BufferedOutputStream)bos).write(buffer, 0, sz);
                        }
                        digest.update(buffer, 0, sz);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                throw new BuildException(String.format(Messages.ManifestCallback_7, srcFileURI, targetFile, ex));
            }
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    this.getProject().log("Unexpected", (Throwable)e, 1);
                }
            }
        }
        StringBuilder result = new StringBuilder();
        byte[] digestBytes = digest.digest();
        int i = 0;
        while (i < digestBytes.length) {
            result.append(Integer.toString((digestBytes[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return result.toString();
    }

    private class MetadataInfo {
        String user;
        String packageId;
        Date date;

        public MetadataInfo(String packageId, String date, String userName) {
            this.packageId = packageId;
            this.user = userName;
            try {
                XMLGregorianCalendar gc = DatatypeFactory.newInstance().newXMLGregorianCalendar(date);
                this.date = gc.toGregorianCalendar().getTime();
            }
            catch (Exception ex) {
                this.date = new Date();
            }
        }
    }
}

