/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.ant;

import com.semarchy.xdi.designer.generation.ant.Messages;
import com.semarchy.xdi.designer.generation.ant.UDFXslGenerator;
import com.semarchy.xdi.designer.generation.ant.XSLGeneratorUDFCallback;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class XslAggregatorFilter
extends XMLFilterImpl {
    List<XSLGeneratorUDFCallback.LightUDF> implementedUDF;
    Map<XSLGeneratorUDFCallback.LightUDF, String> udfPRefix;
    Map<String, String> udfPrefixReplacements;
    UDFXslGenerator.EscapingBufferedOutputStream os;
    Stack<String> elementStack = new Stack();
    Set<String> functionNames = new HashSet<String>();

    public XslAggregatorFilter(UDFXslGenerator.EscapingBufferedOutputStream os, List<XSLGeneratorUDFCallback.LightUDF> implementedUDF, Map<XSLGeneratorUDFCallback.LightUDF, String> udfPRefix, Map<String, String> udfPrefixReplacements) {
        this.implementedUDF = implementedUDF;
        this.udfPRefix = udfPRefix;
        this.udfPrefixReplacements = udfPrefixReplacements;
        this.os = os;
    }

    AttributesImpl createAttribute(String attName, String attValue) {
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", attName, attName, "CDATA", attValue);
        return atts;
    }

    void writeImplementation(String uri, XSLGeneratorUDFCallback.LightUDF u, String implementationCode, String productCode) throws SAXException {
        try {
            try {
                this.os.escape = true;
                super.startElement(uri, "value-of", "xsl:value-of", this.createAttribute("select", UDFXslGenerator.formatCode(this.udfPrefixReplacements, implementationCode)));
                super.endElement(uri, "value-of", "xsl:value-of");
            }
            catch (Exception ex) {
                throw new SAXException(String.format(Messages.UDFXslGenerator_0, productCode, u.libId), ex);
            }
        }
        finally {
            this.os.escape = false;
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.elementStack.size() == 1) {
            for (XSLGeneratorUDFCallback.LightUDF u : this.implementedUDF) {
                if (this.functionNames.contains(this.udfPRefix.get(u) + u.name)) continue;
                super.startElement(uri, "function", "xsl:function", this.createAttribute("name", this.udfPRefix.get(u) + u.name));
                super.startElement(uri, "param", "xsl:param", this.createAttribute("name", "context"));
                super.endElement(uri, "param", "xsl:param");
                for (String p : u.parameters) {
                    super.startElement(uri, "param", "xsl:param", this.createAttribute("name", p));
                    super.endElement(uri, "param", "xsl:param");
                }
                super.startElement(uri, "variable", "xsl:variable", this.createAttribute("name", "var"));
                super.startElement(uri, "choose", "xsl:choose", new AttributesImpl());
                int implementationCount = 0;
                for (String productCode : u.implPerCode.keySet()) {
                    String code = u.implPerCode.get(productCode);
                    if (code == null || code.trim().isEmpty() || "__default__".equals(productCode)) continue;
                    ++implementationCount;
                    super.startElement(uri, "when", "xsl:when", this.createAttribute("test", "$context/ancestor-or-self::product/@code='" + productCode + "'"));
                    this.writeImplementation(uri, u, code, productCode);
                    super.endElement(uri, "when", "xsl:when");
                }
                String defaultCode = u.implPerCode.get("__default__");
                if (defaultCode != null) {
                    if (implementationCount > 0) {
                        super.startElement(uri, "otherwise", "xsl:otherwise", new AttributesImpl());
                        this.writeImplementation(uri, u, defaultCode, "__default__");
                        super.endElement(uri, "otherwise", "xsl:otherwise");
                    } else {
                        super.startElement(uri, "when", "xsl:when", this.createAttribute("test", "1=1"));
                        this.writeImplementation(uri, u, defaultCode, "__default__");
                        super.endElement(uri, "when", "xsl:when");
                    }
                }
                super.endElement(uri, "choose", "xsl:choose");
                super.endElement(uri, "variable", "xsl:variable");
                super.startElement(uri, "value-of", "xsl:value-of", this.createAttribute("select", "string($var)"));
                super.endElement(uri, "value-of", "xsl:value-of");
                super.endElement(uri, "function", "xsl:function");
            }
        }
        super.endElement(uri, localName, qName);
        this.elementStack.pop();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.elementStack.push(localName);
        if (localName.equals("function")) {
            this.functionNames.add(atts.getValue("name"));
        }
        super.startElement(uri, localName, qName, atts);
    }
}

