/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal;

import com.indy.libraries.build.parser.sql.FunctionParser;
import com.indy.map.Clause;
import com.indy.map.Expression;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.IMetaData;
import com.indy.map.IReferencable;
import com.indy.map.TargetFilter;
import com.indy.map.Template;
import com.indy.map.api.IMetaDataInformationsProvider;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RTemplate;
import com.indy.map.ref.RUsage;
import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.services.registry.UDF;
import com.semarchy.xdi.designer.core.utils.E4InjectorHelper;
import com.semarchy.xdi.designer.generation.mapping.internal.MappingBuildException;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModel;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModelBuilder;
import com.stambia.md.MdNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

class ExpressionsResolver {
    private static final String EMBEDDED_COMMA_REPLACE = "\u00a4\u00a4embeddedComma\u00a4\u00a4";
    private MdModelBuilder builder;
    Logger logger = LogManager.getLogger(ExpressionsResolver.class);
    private Map<String, String> udfPrefixReplacement = null;

    ExpressionsResolver() {
    }

    static ExpressionsResolver of(MdModelBuilder builder) {
        ExpressionsResolver res = new ExpressionsResolver();
        res.builder = builder;
        IRegistryService.IRegistry reg = ((IRegistryService)E4InjectorHelper.getService(IRegistryService.class)).getRegistry(UDF.class);
        res.udfPrefixReplacement = new HashMap<String, String>();
        for (UDF u : reg.getAll()) {
            String prefix = ((UDF.UDFKey)u.getRegistrationKey()).getPrefix();
            if (prefix == null || prefix.trim().isEmpty()) {
                prefix = "udf";
            }
            String libId = CacheHelper.extractFileID((String)u.getMdNodeSourceURI().fragment());
            libId = libId.replace("-", "_");
            res.udfPrefixReplacement.put(prefix, "udf:" + libId + "_");
        }
        return res;
    }

    private Map<MdModel.MdStep, Collection<MdModel.MdExpression>> extractExpressions() {
        HashMap<MdModel.MdStep, Collection<MdModel.MdExpression>> res = new HashMap<MdModel.MdStep, Collection<MdModel.MdExpression>>();
        for (MdModel.MdStep step : this.builder.steps.values()) {
            res.put(step, Stream.concat(Stream.concat(step.fields.stream().map(f -> f.expression), step.filters.stream().map(f -> f.expression)), step.joins.stream().map(f -> f.expression)).collect(Collectors.toSet()));
        }
        return res;
    }

    private String resolveFullExpression(IContainer targetContainer, MdModel.MdExpression expr, ItemReplacer replacer) {
        String res = replacer.getReplacement(this.builder.mapModel.getAPI().getMdEvaluator().evaluateFieldSeparator(targetContainer, IMetaDataInformationsProvider.EvaluationLocation.ON_REF));
        if (Integer.compare(2, expr.version) == 0) {
            expr.sourceNames.add(res);
        }
        return res;
    }

    private String resolve(IContainer targetContainer, MdModel.MdExpression expr, Map<ILogicalField, ItemReplacer> replacers, String unresolvedExpression) {
        Pattern p = Pattern.compile("(\\$\\{[^\\}]*\\}\\$)");
        Matcher m = p.matcher(unresolvedExpression);
        StringBuilder b = new StringBuilder();
        int lastIndex = 0;
        while (m.find()) {
            b.append(unresolvedExpression.substring(lastIndex, m.start(1)));
            String token = unresolvedExpression.substring(m.start(1) + 2, m.end(1) - 2);
            Optional<Map.Entry> opt = replacers.entrySet().stream().filter(e -> ((ILogicalField)e.getKey()).getFullPath().equals(token)).findFirst();
            if (!opt.isPresent()) {
                b.append(String.format("${%s}$", token));
            } else {
                String replacement = ((ItemReplacer)opt.get().getValue()).getReplacement(this.builder.mapModel.getAPI().getMdEvaluator().evaluateFieldSeparator(targetContainer, IMetaDataInformationsProvider.EvaluationLocation.ON_REF));
                b.append(replacement);
                if (Integer.compare(2, expr.version) == 0) {
                    expr.sourceNames.add(replacement);
                }
            }
            lastIndex = m.end(1);
        }
        if (lastIndex < unresolvedExpression.length()) {
            b.append(unresolvedExpression.substring(lastIndex));
        }
        return b.toString();
    }

    public void resolve() {
        Map<MdModel.MdStep, Collection<MdModel.MdExpression>> expressions = this.extractExpressions();
        for (Map.Entry<MdModel.MdStep, Collection<MdModel.MdExpression>> entry : expressions.entrySet()) {
            for (MdModel.MdExpression expr : entry.getValue()) {
                Object resolver;
                String resolvedExpression = null;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Resolving {}/{} -> {}", (Object)entry.getKey().name, (Object)(expr.parent instanceof MdModel.MdField ? ((MdModel.MdField)expr.getParent()).name : "join"), (Object)expr.getSourceExpression());
                }
                if ((resolver = this.computeReplacer(entry.getKey(), expr)) == null) continue;
                IContainer locationContainer = this.computeContainer(entry.getKey());
                if (resolver instanceof ItemReplacer) {
                    resolvedExpression = this.resolveFullExpression(locationContainer, expr, (ItemReplacer)resolver);
                    if (resolver instanceof DirectFieldReplacer) {
                        DirectFieldReplacer directReplacer = (DirectFieldReplacer)resolver;
                        expr.addSourceMd(directReplacer.fieldMdRef);
                        expr.sourceContainer.add(directReplacer.src);
                    } else if (resolver instanceof SourceFieldReplacer) {
                        SourceFieldReplacer fieldReplacer = (SourceFieldReplacer)resolver;
                        expr.sourceContainer.add(fieldReplacer.source);
                    }
                } else if (resolver instanceof Map) {
                    Object currentExpression = null;
                    if (expr.mapModelItem instanceof Clause) {
                        Clause cl = (Clause)expr.mapModelItem;
                        currentExpression = this.builder.buildHelper.getInternalExpression(cl);
                    } else if (expr.mapModelItem instanceof Expression) {
                        Expression ex = (Expression)expr.mapModelItem;
                        currentExpression = this.builder.buildHelper.getInternalExpression(ex);
                    } else {
                        currentExpression = "${" + ((ILogicalField)expr.mapModelItem).getFullPath() + "}$";
                    }
                    Map resolverMap = (Map)resolver;
                    resolvedExpression = this.resolve(locationContainer, expr, resolverMap, (String)currentExpression);
                    HashSet<TargetFilterOnTrgReplacer> targetFilterReplacer = new HashSet<TargetFilterOnTrgReplacer>();
                    for (Map.Entry e : resolverMap.entrySet()) {
                        Object v = e.getValue();
                        if (v instanceof DirectFieldReplacer) {
                            DirectFieldReplacer directReplacer = (DirectFieldReplacer)v;
                            expr.addSourceMd(directReplacer.fieldMdRef);
                            expr.sourceContainer.add(directReplacer.src);
                            continue;
                        }
                        Object v2 = e.getValue();
                        if (v2 instanceof SourceFieldReplacer) {
                            SourceFieldReplacer fieldReplacer = (SourceFieldReplacer)v2;
                            expr.sourceContainer.add(fieldReplacer.source);
                            continue;
                        }
                        Object v3 = e.getValue();
                        if (v3 instanceof TargetFilterOnTrgReplacer) {
                            TargetFilterOnTrgReplacer fieldReplacer = (TargetFilterOnTrgReplacer)v3;
                            if (expr.mapModelItem instanceof TargetFilter) {
                                targetFilterReplacer.add(fieldReplacer);
                                continue;
                            }
                        }
                        if (e.getValue() instanceof TargetUsageOnTrgLocationReplacer && expr.mapModelItem instanceof Expression) continue;
                        throw new MappingBuildException("unexpected");
                    }
                    if (!targetFilterReplacer.isEmpty()) {
                        IContainer trgContainer = (IContainer)((RTemplate)this.builder.stepsByTpl.get(entry.getKey()).getMapReference()).getTargetRef().get(0);
                        String separator = this.builder.mapModel.getAPI().getMdEvaluator().evaluateFieldSeparator(trgContainer, IMetaDataInformationsProvider.EvaluationLocation.ON_REF);
                        MdModel.MdSource dummySrc = this.builder.createMdSourceDirect(trgContainer, Optional.empty(), null);
                        expr.sourceContainer.add(dummySrc);
                        targetFilterReplacer.stream().forEach(r -> {
                            expr.addSourceMd(r.fieldMdRef);
                            mdExpression.sourceNames.add(mdSource.name + separator + "%{" + this.builder.mdLinkFactory.getMdLinkName(r.fieldMdRef) + "}%");
                        });
                    }
                } else {
                    throw new MappingBuildException("unexpected");
                }
                expr.internalExpression = expr.version != 3 || expr.location != MdModel.Location.TRG || !(expr.mapModelItem instanceof Expression) ? this.formatExpression(resolvedExpression) : resolvedExpression;
            }
        }
    }

    private IContainer computeContainer(MdModel.MdStep step) {
        boolean isValidLoadSted;
        Template targetTemplate = this.builder.stepsByTpl.get(step);
        if (step.templateType == RTemplate.Type.LOAD) {
            return (IContainer)((RTemplate)targetTemplate.getMapReference()).getLoad().getContainer().get(0);
        }
        IContainer integrationTarget = (IContainer)((RTemplate)targetTemplate.getMapReference()).getTargetRef().get(0);
        Optional<Map.Entry> hasValidLoadStep = this.builder.stepsByTpl.entrySet().stream().filter(e -> ((MdModel.MdStep)e.getKey()).templateType == RTemplate.Type.LOAD && ((RTemplate)((Template)e.getValue()).getMapReference()).getTargetRef().get(0) == integrationTarget).findAny();
        boolean bl = isValidLoadSted = !hasValidLoadStep.isEmpty();
        if (((RTemplate)targetTemplate.getMapReference()).getLoad() != null || isValidLoadSted) {
            return integrationTarget;
        }
        return (IContainer)((RTemplate)targetTemplate.getMapReference()).getRef().get(0);
    }

    private String formatExpression(String resolvedExpression) {
        String cur = resolvedExpression;
        Optional<String> isUdfFound = this.udfPrefixReplacement.keySet().stream().filter(key -> resolvedExpression.startsWith(key + "::")).findFirst();
        if (isUdfFound.isPresent()) {
            CharSequence[] elementArray = cur.split("'");
            int i = 0;
            while (i < elementArray.length) {
                elementArray[i] = ((String)elementArray[i]).replace("\\,", EMBEDDED_COMMA_REPLACE);
                i += 2;
            }
            cur = String.join((CharSequence)"'", elementArray);
        }
        String parsedExpression = FunctionParser.INSTANCE.parse(cur, this.udfPrefixReplacement);
        return parsedExpression.replace(EMBEDDED_COMMA_REPLACE, ",");
    }

    private String getConnectionId(MdModel.MdStep step) {
        Template tpl = this.builder.stepsByTpl.get(step);
        if (((RTemplate)tpl.getMapReference()).getTemplateType().isIntegration()) {
            return this.builder.mapModel.getAPI().getMdEvaluator().evaluateConnectionId((IContainer)((RTemplate)tpl.getMapReference()).getTargetRef().get(0), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
        }
        return this.builder.mapModel.getAPI().getMdEvaluator().evaluateConnectionId((IContainer)((RTemplate)tpl.getMapReference()).getLoad().getContainer().get(0), IMetaDataInformationsProvider.EvaluationLocation.ON_STAGING);
    }

    private Object computeReplacer(MdModel.MdStep step, MdModel.MdExpression expr) {
        boolean fieldOnSRC;
        Template tpl = this.builder.stepsByTpl.get(step);
        boolean bl = fieldOnSRC = expr.location == MdModel.Location.SRC;
        if (((RTemplate)tpl.getMapReference()).getTemplateType().isIntegration() && expr.getParent() instanceof MdModel.MdField) {
            Object expressionConnectionId;
            Optional<RSourceItem> srcField;
            int mode = -1;
            String integrationConnectionId = this.getConnectionId(step);
            mode = fieldOnSRC ? (!(srcField = ((RExpression)((Expression)expr.mapModelItem).getMapReference()).getRealSourceRef().stream().filter(s -> s.getDataModel() instanceof ILogicalField).findFirst()).isPresent() ? 2 : (!((String)(expressionConnectionId = this.builder.mapModel.getAPI().getMdEvaluator().evaluateConnectionId((IContainer)srcField.get().getDataModel().eContainer(), IMetaDataInformationsProvider.EvaluationLocation.ON_REF))).equals(integrationConnectionId) ? 1 : 2)) : 2;
            if (mode == 1) {
                for (MdModel.MdSource src : step.sources) {
                    if (src.sourceMode != MdModel.MdSourceMode.STEP) continue;
                    MdModel.MdStep curStep = this.builder.stepsByName.get(src.stepName);
                    for (MdModel.MdField f : curStep.fields) {
                        if (f.expression.mapModelItem != expr.mapModelItem) continue;
                        ((MdModel.MdField)expr.getParent()).aggregate = null;
                        ((MdModel.MdField)expr.getParent()).name = f.name;
                        ((MdModel.MdField)expr.getParent()).setWorkName(f.getWorkName());
                        return new SourceFieldReplacer(src, (MdModel.MdField)expr.getParent());
                    }
                }
            }
        }
        HashMap<ILogicalField, ItemReplacer> mdSourcePerField = new HashMap<ILogicalField, ItemReplacer>();
        if (expr.mapModelItem instanceof Expression || expr.mapModelItem instanceof Clause) {
            for (RSourceItem refSrcIt : ((RUsage)((IReferencable)expr.mapModelItem).getMapReference()).getRealSourceRef()) {
                ItemReplacer replacer = null;
                if (!(refSrcIt.getDataModel() instanceof ILogicalField)) continue;
                Optional<MdModel.MdSource> src = Optional.ofNullable(this.builder.mdSourceTracker.find(step, (IContainer)refSrcIt.getDataModel().eContainer(), expr.sourceSetName));
                if (src.isEmpty()) {
                    if (expr.location == MdModel.Location.TRG && expr.mapModelItem instanceof TargetFilter) {
                        replacer = new TargetFilterOnTrgReplacer(((IMetaData)refSrcIt.getDataModel()).getRef());
                    } else if (expr.location == MdModel.Location.TRG && expr.mapModelItem instanceof Expression) {
                        replacer = new TargetUsageOnTrgLocationReplacer(((IMetaData)refSrcIt.getDataModel()).getRef());
                    }
                } else if (src.get().stepName != null) {
                    MdModel.MdField field = this.builder.mdFieldFactory.getLoadedField(this.getConnectionId(step), (ILogicalField)refSrcIt.getDataModel());
                    if (field == null) {
                        field = this.builder.mdFieldFactory.getLoadedField(this.getConnectionId(this.builder.stepsByName.get(src.get().stepName)), (ILogicalField)refSrcIt.getDataModel());
                    }
                    if (src.get().sourceMode == MdModel.MdSourceMode.STEP) {
                        if (field == null) {
                            throw new MappingBuildException("unexpected");
                        }
                        replacer = new SourceFieldReplacer(src.get(), field);
                    } else {
                        EObject nodeRef = (EObject)this.builder.stageObjectTypeMdNode.getOrDefault((IMetaData)refSrcIt.getDataModel(), (MdNode)((IMetaData)refSrcIt.getDataModel()).getRef());
                        if (nodeRef == null) {
                            if (field == null) {
                                throw new MappingBuildException("unexpected");
                            }
                            replacer = new SourceFieldReplacer(src.get(), field);
                        } else {
                            replacer = new DirectFieldReplacer(src.get(), nodeRef);
                        }
                    }
                } else {
                    nodeRef = (EObject)this.builder.stageObjectTypeMdNode.getOrDefault((IMetaData)refSrcIt.getDataModel(), (MdNode)((IMetaData)refSrcIt.getDataModel()).getRef());
                    replacer = new DirectFieldReplacer(src.get(), nodeRef);
                }
                mdSourcePerField.put((ILogicalField)refSrcIt.getDataModel(), replacer);
            }
        } else {
            Optional<MdModel.MdSource> src;
            Iterator iterator = expr.getParent();
            if (iterator instanceof MdModel.MdField) {
                MdModel.MdField mdf = (MdModel.MdField)((Object)iterator);
                if (mdf.serdeOutput == Boolean.TRUE) {
                    return null;
                }
            }
            if ((src = Optional.ofNullable(this.builder.mdSourceTracker.find(step, (IContainer)expr.mapModelItem.eContainer(), expr.sourceSetName))).isEmpty()) {
                throw new MappingBuildException("unexpected");
            }
            DirectFieldReplacer replacer = null;
            nodeRef = (EObject)this.builder.stageObjectTypeMdNode.getOrDefault((IMetaData)expr.mapModelItem, (MdNode)((IMetaData)expr.mapModelItem).getRef());
            if (nodeRef == null) {
                throw new MappingBuildException("unexpected");
            }
            replacer = new DirectFieldReplacer(src.get(), nodeRef);
            mdSourcePerField.put((ILogicalField)expr.mapModelItem, replacer);
        }
        return mdSourcePerField;
    }

    class DirectFieldReplacer
    implements ItemReplacer {
        MdModel.MdSource src;
        EObject fieldMdRef;

        DirectFieldReplacer(MdModel.MdSource src, EObject fieldMdRef) {
            this.src = src;
            this.fieldMdRef = ExpressionsResolver.this.builder.delegate(() -> fieldMdRef);
        }

        @Override
        public String getReplacement(String fieldSeparator) {
            return this.src.name + fieldSeparator + "%{" + ExpressionsResolver.this.builder.mdLinkFactory.getMdLinkName(this.fieldMdRef) + "}%";
        }
    }

    static interface ItemReplacer {
        public String getReplacement(String var1);
    }

    class SourceFieldReplacer
    implements ItemReplacer {
        MdModel.MdSource source;
        MdModel.MdField field;

        SourceFieldReplacer(MdModel.MdSource source, MdModel.MdField field) {
            this.field = field;
            this.source = source;
        }

        @Override
        public String getReplacement(String fieldSeparator) {
            return String.format("%s%s%s", this.source.name, fieldSeparator, this.field.name);
        }
    }

    class TargetFilterOnTrgReplacer
    implements ItemReplacer {
        EObject fieldMdRef;

        TargetFilterOnTrgReplacer(EObject fieldMdRef) {
            this.fieldMdRef = ExpressionsResolver.this.builder.delegate(() -> fieldMdRef);
        }

        @Override
        public String getReplacement(String fieldSeparator) {
            return "__internal__::CONCAT_FOR_EVAL_V3(../mdj:pattern($p2),$" + ExpressionsResolver.this.builder.mdLinkFactory.getMdLinkName(this.fieldMdRef) + "/mdj:pattern($p4))";
        }
    }

    class TargetUsageOnTrgLocationReplacer
    implements ItemReplacer {
        EObject fieldMdRef;

        TargetUsageOnTrgLocationReplacer(EObject fieldMdRef) {
            this.fieldMdRef = ExpressionsResolver.this.builder.delegate(() -> fieldMdRef);
        }

        @Override
        public String getReplacement(String fieldSeparator) {
            return String.format("{../mdj:pattern($p2)}{$%s/mdj:pattern($p4)}", ExpressionsResolver.this.builder.mdLinkFactory.getMdLinkName(this.fieldMdRef));
        }
    }
}

