/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal;

import com.indy.map.Clause;
import com.indy.map.DataSet;
import com.indy.map.Expression;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Inliner;
import com.indy.map.Join;
import com.indy.map.JoinLocation;
import com.indy.map.Map;
import com.indy.map.Outliner;
import com.indy.map.QueryField;
import com.indy.map.SetDescriptor;
import com.indy.map.Template;
import com.indy.map.compute.graph.builder.FlowGraphBuilder;
import com.indy.map.ref.RSourceItem;
import com.indy.map.ref.RTemplate;
import com.semarchy.xdi.designer.generation.mapping.internal.FieldOrderComparator;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModelBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class IntegrationVisitor {
    FlowGraphBuilder.GraphNavigator navigator;
    private MdModelBuilder builder;
    private java.util.Map<Template, IntegrationData> results = new HashMap<Template, IntegrationData>();

    IntegrationVisitor() {
    }

    static IntegrationVisitor of(MdModelBuilder builder) {
        IntegrationVisitor res = new IntegrationVisitor();
        res.navigator = FlowGraphBuilder.createGraphNavigator((Map)builder.mapModel);
        res.builder = builder;
        builder.getSortedTemplate().stream().filter(t -> integrationVisitor.builder.buildHelper.getMapAPI().getTemplateType(t).isIntegration()).forEach(res::visit);
        return res;
    }

    private IntegrationData visit(Template integrationTemplate) {
        IntegrationData res = new IntegrationData();
        res.template = integrationTemplate;
        RTemplate.Type tplType = ((RTemplate)integrationTemplate.getMapReference()).getTemplateType();
        IContainer targetContainer = (IContainer)this.builder.buildHelper.getMapAPI().getTargetRef(integrationTemplate).get(0);
        List sortedFields = targetContainer.getLogicalField().stream().filter(f -> f.isEnable()).filter(f -> !f.getExpression().isEmpty()).sorted(new FieldOrderComparator.FieldComparator(this.builder.buildHelper.getMapAPI())).collect(Collectors.toList());
        res.noLoad = this.hasNoLoad(integrationTemplate);
        res.isMultiSet = tplType == RTemplate.Type.STAGING && targetContainer.getSetDescriptor().size() > 1;
        for (SetDescriptor descriptor : targetContainer.getSetDescriptor()) {
            SetData data = new SetData();
            if (res.isMultiSet) {
                data.sourceSetName = descriptor.getLabel().toString();
            } else if (res.noLoad) {
                data.computeSourceSetForNoLoad(integrationTemplate);
            }
            res.dataPerSet.put(descriptor, data);
            for (ILogicalField f2 : sortedFields) {
                Expression expression = f2.getExpression(descriptor);
                String internalExpression = this.builder.buildHelper.getInternalExpression(expression);
                if (internalExpression == null || internalExpression.trim().isEmpty()) continue;
                data.expressionsPerSet.add(expression);
                if (!(f2 instanceof Field) || !((Field)f2).isExtraStatic()) continue;
                data.extraStaticFields.computeIfAbsent(expression, key -> new ArrayList()).add((Field)f2);
            }
            HashSet allSrcDataset = new HashSet(this.navigator.getDataSetInputs(descriptor));
            for (DataSet ds : allSrcDataset) {
                ArrayList joins = new ArrayList();
                joins.addAll(ds.getJoin());
                joins.removeAll(this.getJoin4Children(ds));
                data.clauses.addAll(joins.stream().filter(j -> j.isEnable() && (integrationData.noLoad || !this.hasFieldCollected((Clause)j) || j.getLocation() == JoinLocation.WRK)).collect(Collectors.toSet()));
                data.clauses.addAll(this.getAllJoin4Parent(ds).stream().filter(j -> j.isEnable() && (integrationData.noLoad || !this.hasFieldCollected((Clause)j) || j.getLocation() == JoinLocation.WRK)).collect(Collectors.toSet()));
                data.clauses.addAll(ds.getFilter().stream().filter(j -> j.isEnable() && (integrationData.noLoad || !this.hasFieldCollected((Clause)j) || j.getLocation() == JoinLocation.WRK)).collect(Collectors.toSet()));
                data.clauses.addAll(ds.getOperator().stream().filter(j -> j.isEnable() && (integrationData.noLoad || !this.hasFieldCollected((Clause)j) || j.getLocation() == JoinLocation.WRK)).collect(Collectors.toSet()));
                data.clauses.addAll(targetContainer.getTargetFilter().stream().filter(j -> j.isEnable() && (allSrcDataset.contains(j.getDataSet()) && (integrationData.noLoad || !this.hasFieldCollected((Clause)j) || j.getLocation() == JoinLocation.WRK) || j.getLocation() == JoinLocation.TRG && j.getDataSet() == targetContainer.getDataset())).collect(Collectors.toSet()));
            }
        }
        if (tplType == RTemplate.Type.SERDE) {
            Stream<QueryField> outputFieldsStream = null;
            if (targetContainer instanceof Outliner) {
                Outliner outliner = (Outliner)targetContainer;
                outputFieldsStream = outliner.getOutputField().stream().map(f -> f);
            } else {
                outputFieldsStream = Stream.of(((Inliner)targetContainer).getOutputField());
            }
            outputFieldsStream.filter(f -> !this.builder.buildHelper.getMapAPI().getUsage(f).isEmpty()).forEach(f -> {
                boolean bl = integrationData.serdeUsedOutputFields.add((ILogicalField)f);
            });
        }
        this.results.put(integrationTemplate, res);
        return res;
    }

    private boolean hasNoLoad(Template tpl) {
        return this.builder.buildHelper.getMapAPI().hasNoLoad(tpl);
    }

    private boolean hasFieldCollected(Clause clause) {
        for (RSourceItem item : this.builder.buildHelper.getSourceRef(clause)) {
            for (Template tpl : this.builder.getSortedTemplate()) {
                if (((RTemplate)tpl.getMapReference()).getTemplateType() != RTemplate.Type.LOAD || !this.builder.buildHelper.getMapAPI().getRef(tpl).contains(item.getDataModel().eContainer())) continue;
                return true;
            }
        }
        return false;
    }

    private List<Join> getJoin4Children(DataSet dataset) {
        ArrayList<Join> list = new ArrayList<Join>();
        for (DataSet child : dataset.getChild()) {
            list.add(dataset.getJoin4Child(child));
        }
        return list;
    }

    private List<Join> getAllJoin4Parent(DataSet dataset) {
        ArrayList<Join> list = new ArrayList<Join>();
        for (DataSet parent : dataset.getParent()) {
            Join join = dataset.getJoin4Parent(parent);
            if (join != null) {
                list.add(join);
            }
            list.addAll(this.getAllJoin4Parent(parent));
        }
        return list;
    }

    public IntegrationData getIntegrationData(Template tpl) {
        return this.results.get(tpl);
    }

    class IntegrationData {
        boolean isMultiSet;
        java.util.Map<SetDescriptor, SetData> dataPerSet = new LinkedHashMap<SetDescriptor, SetData>();
        Set<ILogicalField> serdeUsedOutputFields = new LinkedHashSet<ILogicalField>();
        Template template;
        boolean noLoad;

        IntegrationData() {
        }
    }

    class SetData {
        Collection<Expression> expressionsPerSet = new LinkedHashSet<Expression>();
        java.util.Map<Expression, List<Field>> extraStaticFields = new HashMap<Expression, List<Field>>();
        Set<Clause> clauses = new LinkedHashSet<Clause>();
        String sourceSetName;
        boolean sourceSetNameFromNoLoad = false;

        SetData() {
        }

        private void computeSourceSetForNoLoad(Template integrationTemplate) {
            this.sourceSetNameFromNoLoad = true;
            this.sourceSetName = "L1_" + ((IContainer)IntegrationVisitor.this.builder.buildHelper.getMapAPI().getTargetRef(integrationTemplate).get(0)).getAlias().toString();
        }
    }
}

