/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal;

import com.indy.map.Clause;
import com.indy.map.Filter;
import com.indy.map.IReferencable;
import com.indy.map.Join;
import com.indy.map.JoinLocation;
import com.indy.map.Operator;
import com.indy.map.TargetFilter;
import com.indy.map.ref.RUsage;
import com.semarchy.xdi.designer.generation.mapping.internal.ClauseIdGenerator;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModel;
import java.util.function.Function;
import java.util.stream.Collectors;

class MdClauseFactory {
    private MdClauseFactory() {
    }

    public static MdModel.MdJoin createJoin(ClauseIdGenerator idGenerator, Join join, String sourceSetName) {
        MdModel.MdJoin res = MdModel.MdJoin.of(join);
        res.leftContainer = join.getLeft();
        res.rightContainer = join.getRight();
        if (join.getOrder() != null) {
            res.order = join.getOrder().intValue();
        }
        res.type = join.getJoinType();
        res.mode = join.getJoinMode();
        res.id = idGenerator.getClauseId((Clause)join);
        res.tags = join.getTag().stream().map(Object::toString).collect(Collectors.toList());
        res.expression.version = 2;
        res.expression.sourceSetName = sourceSetName;
        return res;
    }

    public static MdModel.MdFilter createFilter(ClauseIdGenerator idGenerator, Filter filter, Function<IReferencable<? extends RUsage>, String> sourceSetName) {
        MdModel.MdFilter res = MdModel.MdFilter.of((Clause)filter);
        res.aggregate = filter.isAggregate();
        res.qualify = filter.isQualify();
        res.id = idGenerator.getClauseId((Clause)filter);
        res.tags = filter.getTag().stream().map(Object::toString).collect(Collectors.toList());
        res.expression.version = 2;
        if (sourceSetName != null) {
            res.expression.sourceSetName = sourceSetName.apply((IReferencable<? extends RUsage>)filter);
        }
        return res;
    }

    public static MdModel.MdFilter createTargetFilter(ClauseIdGenerator idGenerator, TargetFilter filter, Function<IReferencable<? extends RUsage>, String> sourceSetName) {
        MdModel.MdFilter res = MdModel.MdFilter.of((Clause)filter);
        res.aggregate = filter.isAggregate();
        res.id = idGenerator.getClauseId((Clause)filter);
        res.expression.location = MdModel.Location.valueOf(filter.getLocation().getName());
        res.tags = filter.getTag().stream().map(Object::toString).collect(Collectors.toList());
        res.expression.version = filter.getLocation() == JoinLocation.TRG ? 3 : 2;
        res.expression.sourceSetName = sourceSetName.apply((IReferencable<? extends RUsage>)filter);
        return res;
    }

    public static MdModel.MdFilter createFilter(ClauseIdGenerator idGenerator, Operator operator, String sourceSetName) {
        MdModel.MdFilter res = MdModel.MdFilter.of((Clause)operator);
        res.id = idGenerator.getClauseId((Clause)operator);
        res.tags = operator.getTag().stream().map(Object::toString).collect(Collectors.toList());
        res.expression.version = 2;
        res.expression.sourceSetName = sourceSetName;
        res.operator = operator.getType().getLiteral();
        return res;
    }
}

