/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal;

import com.indy.gmf.proc.Action;
import com.indy.gmf.proc.ActionCode;
import com.indy.gmf.proc.ActionProcess;
import com.indy.gmf.proc.ActionProcessRef;
import com.indy.gmf.proc.ProcFactory;
import com.indy.gmf.proc.SubActionProcess;
import com.indy.gmf.proc.VisibilityType;
import com.indy.map.IContainer;
import com.indy.map.IMetaData;
import com.indy.map.Template;
import com.indy.map.Variable;
import com.indy.map.ref.RTemplate;
import com.semarchy.xdi.designer.core.collections.BidiMap;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.generation.mapping.Messages;
import com.semarchy.xdi.designer.generation.mapping.internal.MappingBuildException;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModel;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModelBuilder;
import com.semarchy.xdi.designer.generation.mapping.internal.ProcModelFactoryHelper;
import com.semarchy.xdi.designer.generation.mapping.internal.ProcessGraphBuilder;
import com.semarchy.xdi.designer.generation.mapping.internal.TemplateParser;
import com.semarchy.xdi.designer.generation.mapping.internal.TemplateSorter;
import com.stambia.md.MdNode;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;

class ProcessBuilder {
    private Map<TemplateSorter.ProcessGraphStep, GraphStepInformation> graphInformationsBySteps = new HashMap<TemplateSorter.ProcessGraphStep, GraphStepInformation>();
    private Map<Template, StepInfo> infosByTPL = new HashMap<Template, StepInfo>();
    private List<VariableInfo> variablesInfo = new ArrayList<VariableInfo>();
    private MdModelBuilder builder;
    private ProcModelFactoryHelper factoryHelper = new ProcModelFactoryHelper();
    private AtomicReference<ActionCode> lastAction = new AtomicReference();
    List<Action> mainSteps = new ArrayList<Action>();
    Map<Action, Collection<Action>> links = new HashMap<Action, Collection<Action>>();
    BidiMap<IContainer, Action> integrationActionPerTrg = new BidiMap();

    ProcessBuilder() {
    }

    static ProcessBuilder of(MdModelBuilder modelBuilder) {
        ProcessBuilder res = new ProcessBuilder();
        res.builder = modelBuilder;
        return res;
    }

    ActionCode getLastVariableAction() {
        return this.lastAction.get();
    }

    private void extractRequiredVariables() {
        HashSet<CallSite> handledID = new HashSet<CallSite>();
        for (Variable v : this.builder.mapModel.getVariable()) {
            String id1;
            URI uri = null;
            EObject mdRef = v.basicGetRef();
            uri = mdRef.eIsProxy() ? ((InternalEObject)v.basicGetRef()).eProxyURI() : EcoreUtil.getURI((EObject)v.basicGetRef());
            URI fromVariableMgr = this.builder.udfVariableRequired.get(v.getAlias().toString());
            String eltId = CacheHelper.extractEltID((String)uri.fragment());
            String fileId = CacheHelper.extractFileID((String)uri.fragment());
            if (fromVariableMgr != null && !(id1 = CacheHelper.extractEltID((String)fromVariableMgr.fragment())).equals(eltId)) {
                throw new MappingBuildException(NLS.bind((String)Messages.MetadataAndProcessBuilder_2, (Object)v.getAlias().toString()));
            }
            if (!handledID.add((CallSite)((Object)(fileId + "/" + eltId)))) continue;
            this.variablesInfo.add(new VariableInfo(v.getAlias().toString(), uri));
        }
        for (Map.Entry<String, URI> e : this.builder.udfVariableRequired.entrySet()) {
            String eltId = CacheHelper.extractEltID((String)e.getValue().fragment());
            String fileId = CacheHelper.extractFileID((String)e.getValue().fragment());
            if (!handledID.add((CallSite)((Object)(fileId + "/" + eltId)))) continue;
            this.variablesInfo.add(new VariableInfo(e.getKey(), e.getValue()));
        }
    }

    private void extractTemplateInfo() {
        block5: for (Template tpl : this.builder.tplSorter.getSortedTemplates()) {
            StepInfo info = null;
            switch (((RTemplate)tpl.getMapReference()).getTemplateType()) {
                case LOAD: {
                    if (this.builder.buildHelper.getMapAPI().hasNoLoad(tpl)) break;
                    info = this.extractLoadInfo(tpl);
                    break;
                }
                case INTEGRATION: 
                case STAGING: 
                case SERDE: {
                    info = this.extractIntegrationInfo(tpl);
                    break;
                }
                case REJECT: {
                    info = this.extractRejectInfo(tpl);
                    break;
                }
                default: {
                    continue block5;
                }
            }
            this.infosByTPL.put(tpl, info);
        }
    }

    public void buildProcess(Map<Template, MdNode> mdNodePerTemplate, ActionProcess mainProcess) {
        this.extractRequiredVariables();
        this.extractTemplateInfo();
        int count = 0;
        for (VariableInfo v : this.variablesInfo) {
            Result res = v.createProcModelEntities(null, null);
            res.createdActions.get(0).setId(this.builder.mapModel.getId() + "-procVAR" + count++);
            this.mainSteps.addAll(res.createdActions);
            this.lastAction.set((ActionCode)res.createdActions.get(0));
        }
        if (this.variablesInfo.size() > 1) {
            ActionCode a = ProcFactory.eINSTANCE.createActionCode();
            a.setTechnology("com.indy.engine.actionCodes.EmptyActionCodeI");
            a.setName("");
            a.setId(this.builder.mapModel.getId() + "-procVARjoin");
            this.lastAction.set(a);
            this.mainSteps.stream().forEach(action -> {
                boolean bl = this.links.computeIfAbsent((Action)action, k -> new LinkedHashSet()).add(a);
            });
            this.mainSteps.add((Action)a);
        }
        for (Template tpl : this.builder.tplSorter.getSortedTemplates()) {
            StepInfo info = this.infosByTPL.get(tpl);
            if (info == null || info instanceof RejectInfo) continue;
            Result res = info.createProcModelEntities(tpl, mdNodePerTemplate::get);
            this.mainSteps.addAll(res.createdActions);
            res.links.entrySet().stream().forEach(e -> {
                boolean bl = this.links.computeIfAbsent((Action)e.getKey(), k -> new LinkedHashSet()).addAll((Collection)e.getValue());
            });
            this.graphInformationsBySteps.put(this.builder.tplSorter.tplToProcessGraphStep.get(tpl), res.sdsContrib);
        }
        this.factoryHelper.handleParameters();
        ProcessGraphBuilder graphBuilder = ProcessGraphBuilder.of(this.builder, this);
        graphBuilder.buildGraph();
        for (Action a : this.mainSteps) {
            if (a instanceof ActionCode) {
                ActionCode ac = (ActionCode)a;
                mainProcess.getActionCode().add((Object)ac);
                continue;
            }
            if (a instanceof SubActionProcess) {
                SubActionProcess s = (SubActionProcess)a;
                mainProcess.getSubProcess().add((Object)s);
                continue;
            }
            if (!(a instanceof ActionProcessRef)) continue;
            ActionProcessRef ar = (ActionProcessRef)a;
            mainProcess.getActionProcessRef().add((Object)ar);
        }
        for (Action action2 : this.mainSteps) {
            this.reduceProcessLevel(action2);
        }
    }

    private LoadInfo extractLoadInfo(Template tpl) {
        LoadInfo info = new LoadInfo();
        info.loadRef = TemplateParser.getTplStepByType(tpl.getProcess(), TemplateParser.TPL_TYPE.EXECUTE);
        info.loadAsyncRef = TemplateParser.getTplStepByType(tpl.getProcess(), TemplateParser.TPL_TYPE.EXECUTE_ASYNCH);
        info.cleanupRef = TemplateParser.getTplStepByType(tpl.getProcess(), TemplateParser.TPL_TYPE.CLEANUP);
        info.cleanupAsynchRef = TemplateParser.getTplStepByType(tpl.getProcess(), TemplateParser.TPL_TYPE.CLEANUP_ASYNCH);
        info.setupRef = TemplateParser.getTplStepByType(tpl.getProcess(), TemplateParser.TPL_TYPE.SETTUP);
        return info;
    }

    private IntegrationInfo extractIntegrationInfo(Template tpl) {
        IContainer target = (IContainer)this.builder.buildHelper.getMapAPI().getTargetRef(tpl).get(0);
        IntegrationInfo info = new IntegrationInfo(target);
        String prefix = null;
        switch (((RTemplate)tpl.getMapReference()).getTemplateType()) {
            case INTEGRATION: {
                prefix = "Integration";
                break;
            }
            case STAGING: {
                prefix = "Staging";
                break;
            }
            case SERDE: {
                prefix = "Outlining";
                break;
            }
            default: {
                throw new MappingBuildException("unexpected");
            }
        }
        info.stepName = String.format("%s%s", prefix, tpl.getName().replaceFirst("[A-Z][0-9]*_", ""));
        info.rejectTemplate = this.findRejectTemplate(target);
        info.integrationRef = TemplateParser.getTplStepByType(tpl.getProcess(), TemplateParser.TPL_TYPE.EXECUTE);
        info.integrationAsyncRef = TemplateParser.getTplStepByType(tpl.getProcess(), TemplateParser.TPL_TYPE.EXECUTE_ASYNCH);
        info.prepareRef = TemplateParser.getTplStepByType(tpl.getProcess(), TemplateParser.TPL_TYPE.PREPARE);
        info.cleanupRef = TemplateParser.getTplStepByType(tpl.getProcess(), TemplateParser.TPL_TYPE.CLEANUP);
        info.cleanupAsynchRef = TemplateParser.getTplStepByType(tpl.getProcess(), TemplateParser.TPL_TYPE.CLEANUP_ASYNCH);
        info.setupRef = TemplateParser.getTplStepByType(tpl.getProcess(), TemplateParser.TPL_TYPE.SETTUP);
        return info;
    }

    private RejectInfo extractRejectInfo(Template tpl) {
        RejectInfo info = new RejectInfo(tpl);
        info.rejectActionRef = TemplateParser.getTplStepByType(tpl.getProcess(), TemplateParser.TPL_TYPE.EXECUTE);
        return info;
    }

    private Template findRejectTemplate(IContainer target) {
        Optional<Template> opt = this.builder.getSortedTemplate().stream().filter(t -> ((RTemplate)t.getMapReference()).getTemplateType() == RTemplate.Type.REJECT && this.builder.buildHelper.getMapAPI().getTargetRef(t).contains(target)).findFirst();
        if (opt.isPresent()) {
            return opt.get();
        }
        return null;
    }

    GraphStepInformation getSDSContrib(TemplateSorter.ProcessGraphStep graphStep) {
        return this.graphInformationsBySteps.get(graphStep);
    }

    private void reduceProcessLevel(Action action) {
        if (action instanceof SubActionProcess) {
            SubActionProcess toRemove = (SubActionProcess)action;
            ActionProcess parent = (ActionProcess)toRemove.eContainer();
            if (toRemove.getAction().size() == 1) {
                Object e = ((SubActionProcess)action).getAction().get(0);
                if (e instanceof ActionProcessRef) {
                    ActionProcessRef child = (ActionProcessRef)e;
                    parent.getActionProcessRef().add((Object)child);
                    parent.getAction().stream().flatMap(a -> a.getLink().stream()).filter(l -> l.getTargetId() == action).forEach(l -> l.setTargetId((Action)child));
                    child.getLink().addAll((Collection)toRemove.getLink());
                    child.setName(toRemove.getName());
                    child.getMetaDataLink().addAll((Collection)toRemove.getMetaDataLink());
                    child.getParameter().addAll((Collection)toRemove.getParameter());
                    parent.getSubProcess().remove((Object)toRemove);
                }
            } else {
                for (Action _act : ((SubActionProcess)action).getAction()) {
                    this.reduceProcessLevel(_act);
                }
            }
        }
    }

    static class GraphStepInformation {
        Action during;
        Action before;
        Action after;
        boolean beforeIsLinked = false;
        boolean afterIsLinked = false;

        GraphStepInformation() {
        }
    }

    class IntegrationInfo
    implements StepInfo {
        IContainer target;
        String stepName;
        ActionProcess integrationRef;
        ActionProcess integrationAsyncRef;
        ActionProcess cleanupRef;
        ActionProcess cleanupAsynchRef;
        ActionProcess setupRef;
        ActionProcess prepareRef;
        Template rejectTemplate;

        private IntegrationInfo(IContainer target) {
            this.target = target;
        }

        @Override
        public Result createProcModelEntities(Template tpl, Function<Template, MdNode> refMdProvider) {
            Result res = new Result();
            MdModel.MdStep step = ProcessBuilder.this.builder.steps.get(tpl);
            SubActionProcess integrationSub = ProcFactory.eINSTANCE.createSubActionProcess();
            integrationSub.setName(ProcessBuilder.this.factoryHelper.formatStepName(step, tpl, ((RTemplate)tpl.getMapReference()).getTemplateType().getStepMdTypeAttributeValue()));
            integrationSub.setId(String.format("%s-proc_%s%d", ProcessBuilder.this.builder.mapModel.getId(), ((RTemplate)tpl.getMapReference()).getTemplateType().getProcessStepNamePrefix(), step.number));
            ProcessBuilder.this.factoryHelper.addMdLlink((Action)integrationSub, "REF", EcoreUtil.getURI((EObject)((EObject)refMdProvider.apply(tpl))));
            ProcessBuilder.this.integrationActionPerTrg.put((Object)this.target, (Object)integrationSub);
            res.createdActions.add((Action)integrationSub);
            res.sdsContrib.during = integrationSub;
            ProcessBuilder.this.factoryHelper.addAltId((Action)integrationSub, "container", this.target.getId());
            if (this.target instanceof IMetaData) {
                ProcessBuilder.this.factoryHelper.addAltId((Action)integrationSub, "mdNode", CacheHelper.extractEltID((EObject)((IMetaData)this.target).basicGetRef()));
            }
            ActionProcessRef prepare = null;
            if (this.prepareRef != null) {
                prepare = ProcessBuilder.this.factoryHelper.createProcessRef(this.prepareRef, step, tpl, null, ProcessBuilder.this.builder.mapModel.getId(), 1, "Prepare", step.number);
                integrationSub.getActionProcessRef().add((Object)prepare);
            }
            ActionProcessRef reject = null;
            if (this.rejectTemplate != null) {
                Result rejectRes = ProcessBuilder.this.infosByTPL.get(this.rejectTemplate).createProcModelEntities(this.rejectTemplate, refMdProvider);
                reject = (ActionProcessRef)rejectRes.createdActions.get(0);
                integrationSub.getActionProcessRef().add((Object)reject);
            }
            ActionProcessRef integration = ProcessBuilder.this.factoryHelper.createProcessRef(this.integrationRef, step, tpl, null, ProcessBuilder.this.builder.mapModel.getId(), 3, "Integration", step.number);
            integrationSub.getActionProcessRef().add((Object)integration);
            if (this.integrationAsyncRef != null) {
                ActionProcessRef integrationAsync = ProcessBuilder.this.factoryHelper.createProcessRef(this.integrationAsyncRef, step, tpl, refMdProvider.apply(tpl), ProcessBuilder.this.builder.mapModel.getId(), 1, "Integration-Asynch", step.number);
                res.createdActions.add((Action)integrationAsync);
                res.links.computeIfAbsent((Action)integration, k -> new HashSet()).add(integrationAsync);
            }
            if (reject != null) {
                if (prepare != null) {
                    res.links.computeIfAbsent((Action)prepare, k -> new HashSet()).add(reject);
                }
                res.links.computeIfAbsent((Action)reject, k -> new HashSet()).add(integration);
            } else if (prepare != null) {
                res.links.computeIfAbsent((Action)prepare, k -> new HashSet()).add(integration);
            }
            if (this.cleanupRef != null) {
                ActionProcessRef cleanup = ProcessBuilder.this.factoryHelper.createProcessRef(this.cleanupRef, step, tpl, refMdProvider.apply(tpl), ProcessBuilder.this.builder.mapModel.getId(), 4, "Cleanup", step.number);
                res.createdActions.add((Action)cleanup);
                res.sdsContrib.after = cleanup;
                if (this.cleanupAsynchRef != null) {
                    ActionProcessRef cleanupAsynch = ProcessBuilder.this.factoryHelper.createProcessRef(this.cleanupAsynchRef, step, tpl, refMdProvider.apply(tpl), ProcessBuilder.this.builder.mapModel.getId(), 7, "Cleanup-Asynch", step.number);
                    res.createdActions.add((Action)cleanupAsynch);
                    res.links.computeIfAbsent((Action)cleanup, k -> new HashSet()).add(cleanupAsynch);
                }
            }
            if (this.setupRef != null) {
                ActionProcessRef setup = ProcessBuilder.this.factoryHelper.createProcessRef(this.setupRef, step, tpl, refMdProvider.apply(tpl), ProcessBuilder.this.builder.mapModel.getId(), 5, "Setup", step.number);
                res.createdActions.add((Action)setup);
                res.sdsContrib.before = setup;
            }
            return res;
        }
    }

    class LoadInfo
    implements StepInfo {
        ActionProcess loadRef;
        ActionProcess loadAsyncRef;
        ActionProcess cleanupRef;
        ActionProcess cleanupAsynchRef;
        ActionProcess setupRef;

        LoadInfo() {
        }

        @Override
        public Result createProcModelEntities(Template tpl, Function<Template, MdNode> mdRefProvider) {
            Result res = new Result();
            MdModel.MdStep step = ProcessBuilder.this.builder.steps.get(tpl);
            ActionProcessRef load = ProcessBuilder.this.factoryHelper.createProcessRef(this.loadRef, step, tpl, mdRefProvider.apply(tpl), ProcessBuilder.this.builder.mapModel.getId(), 1, "Load", step.number);
            res.createdActions.add((Action)load);
            res.sdsContrib.during = load;
            if (this.loadAsyncRef != null) {
                ActionProcessRef loadAsynch = ProcessBuilder.this.factoryHelper.createProcessRef(this.loadAsyncRef, step, tpl, mdRefProvider.apply(tpl), ProcessBuilder.this.builder.mapModel.getId(), 4, "Load-Asynch", step.number);
                res.createdActions.add((Action)loadAsynch);
                res.links.computeIfAbsent((Action)load, k -> new HashSet()).add(loadAsynch);
            }
            ActionProcessRef cleanup = ProcessBuilder.this.factoryHelper.createProcessRef(this.cleanupRef, step, tpl, mdRefProvider.apply(tpl), ProcessBuilder.this.builder.mapModel.getId(), 2, "Cleanup", step.number);
            res.createdActions.add((Action)cleanup);
            if (this.cleanupAsynchRef != null) {
                ActionProcessRef cleanupAsync = ProcessBuilder.this.factoryHelper.createProcessRef(this.loadAsyncRef, step, tpl, mdRefProvider.apply(tpl), ProcessBuilder.this.builder.mapModel.getId(), 5, "Cleanup-Asynch", step.number);
                res.createdActions.add((Action)cleanupAsync);
                res.links.computeIfAbsent((Action)cleanup, k -> new HashSet()).add(cleanupAsync);
            }
            res.sdsContrib.after = cleanup;
            if (this.setupRef != null) {
                ActionProcessRef setup = ProcessBuilder.this.factoryHelper.createProcessRef(this.loadAsyncRef, step, tpl, mdRefProvider.apply(tpl), ProcessBuilder.this.builder.mapModel.getId(), 3, "Setup", step.number);
                res.createdActions.add((Action)setup);
                res.sdsContrib.before = setup;
            }
            return res;
        }
    }

    class RejectInfo
    implements StepInfo {
        ActionProcess rejectActionRef;

        private RejectInfo(Template rejectTpl) {
            ProcessBuilder.this.graphInformationsBySteps.put(ProcessBuilder.this.builder.tplSorter.tplToProcessGraphStep.get(rejectTpl), new GraphStepInformation());
        }

        @Override
        public Result createProcModelEntities(Template tpl, Function<Template, MdNode> refMdProvider) {
            Result res = new Result();
            MdModel.MdStep step = ProcessBuilder.this.builder.steps.get(tpl);
            ActionProcessRef reject = ProcessBuilder.this.factoryHelper.createProcessRef(this.rejectActionRef, step, tpl, refMdProvider.apply(tpl), ProcessBuilder.this.builder.mapModel.getId(), 2, "", step.number);
            res.createdActions.add((Action)reject);
            return res;
        }
    }

    private static class Result {
        List<Action> createdActions = new ArrayList<Action>();
        Map<Action, Collection<Action>> links = new HashMap<Action, Collection<Action>>();
        GraphStepInformation sdsContrib = new GraphStepInformation();

        private Result() {
        }
    }

    static interface StepInfo {
        public Result createProcModelEntities(Template var1, Function<Template, MdNode> var2);
    }

    class VariableInfo
    implements StepInfo {
        URI refURI;
        String name;

        public VariableInfo(String name, URI refURI) {
            this.name = name;
            this.refURI = refURI;
        }

        @Override
        public Result createProcModelEntities(Template tpl, Function<Template, MdNode> mdRefProvider) {
            Result res = new Result();
            ActionCode action = ProcFactory.eINSTANCE.createActionCode();
            action.setName(this.name);
            action.setTechnology("com.indy.engine.actionCodes.VariableManagerActionCodeI");
            ProcessBuilder.this.factoryHelper.addMdLlink((Action)action, this.name, this.refURI).setVisibility(VisibilityType.PARENT);
            res.createdActions.add((Action)action);
            return res;
        }
    }
}

