/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal;

import com.indy.gmf.proc.Action;
import com.indy.gmf.proc.ActionCode;
import com.indy.gmf.proc.Link;
import com.indy.gmf.proc.LinkType;
import com.indy.gmf.proc.MandatoryType;
import com.indy.gmf.proc.ProcFactory;
import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModelBuilder;
import com.semarchy.xdi.designer.generation.mapping.internal.ProcessBuilder;
import com.semarchy.xdi.designer.generation.mapping.internal.TemplateSorter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ProcessGraphBuilder {
    MdModelBuilder builder;
    ProcessBuilder processBuilder;

    static ProcessGraphBuilder of(MdModelBuilder builder, ProcessBuilder processBuilder) {
        ProcessGraphBuilder res = new ProcessGraphBuilder();
        res.builder = builder;
        res.processBuilder = processBuilder;
        return res;
    }

    private ProcessGraphBuilder() {
    }

    private ProcessBuilder.GraphStepInformation getContrib(TemplateSorter.ProcessGraphStep sds) {
        return this.processBuilder.getSDSContrib(sds);
    }

    public void buildGraph() {
        for (TemplateSorter.ProcessGraphStep sds : this.builder.tplSorter.tplToProcessGraphStep.values()) {
            ActionCode actionCode = this.processBuilder.getLastVariableAction();
            if (actionCode != null) {
                this.attachActionToFirstStep(sds, actionCode);
            }
            for (TemplateSorter.ProcessGraphStep processGraphStep : sds.previousSteps) {
                if (this.getContrib((TemplateSorter.ProcessGraphStep)processGraphStep).during == null) continue;
                this.processBuilder.links.computeIfAbsent(this.getContrib((TemplateSorter.ProcessGraphStep)processGraphStep).during, k -> new LinkedHashSet()).add(this.getContrib((TemplateSorter.ProcessGraphStep)sds).during);
            }
            if (this.getContrib((TemplateSorter.ProcessGraphStep)sds).after != null) {
                this.setAfter(sds, this.getContrib((TemplateSorter.ProcessGraphStep)sds).after);
                this.getContrib((TemplateSorter.ProcessGraphStep)sds).afterIsLinked = true;
            }
            if (this.getContrib((TemplateSorter.ProcessGraphStep)sds).before == null) continue;
            this.setBefore(sds, this.getContrib((TemplateSorter.ProcessGraphStep)sds).before);
            this.getContrib((TemplateSorter.ProcessGraphStep)sds).beforeIsLinked = true;
        }
        HashMap<IContainer, Integer> trgPriority = new HashMap<IContainer, Integer>();
        HashMap<DataSet, List> inverseLink = new HashMap<DataSet, List>();
        for (Map.Entry entry : this.processBuilder.integrationActionPerTrg.entrySet()) {
            for (Action trgAction : (Collection)this.processBuilder.links.getOrDefault(entry.getValue(), Collections.emptyList())) {
                List list;
                IContainer trg = (IContainer)this.processBuilder.integrationActionPerTrg.getFrom((Object)trgAction);
                if (trg == null || (list = inverseLink.computeIfAbsent(trg.getDataset(), k -> new ArrayList())).contains(((IContainer)entry.getKey()).getDataset())) continue;
                list.add(((IContainer)entry.getKey()).getDataset());
            }
            trgPriority.put((IContainer)entry.getKey(), ((IContainer)entry.getKey()).getPriorityOrder());
        }
        for (Map.Entry entry : trgPriority.entrySet()) {
            trgPriority.entrySet().stream().filter(e -> e != containerPriority && (Integer)e.getValue() > (Integer)containerPriority.getValue()).forEach(e -> {
                Action min = (Action)this.processBuilder.integrationActionPerTrg.get(containerPriority.getKey());
                Action max = (Action)this.processBuilder.integrationActionPerTrg.get(e.getKey());
                if (!this.hasAlreadyContraflowLink(null, ((IContainer)containerPriority.getKey()).getDataset(), ((IContainer)e.getKey()).getDataset(), inverseLink)) {
                    this.processBuilder.links.computeIfAbsent(min, k -> new LinkedHashSet()).add(max);
                }
            });
        }
        HashMap<Action, Set<Link>> hashMap = new HashMap<Action, Set<Link>>();
        for (Map.Entry entry : this.processBuilder.links.entrySet()) {
            boolean isMainAction = this.processBuilder.mainSteps.contains(entry.getKey());
            if (entry.getKey() == null) continue;
            for (IContainer trg : (Collection)entry.getValue()) {
                if (trg == null) continue;
                Link link = ProcFactory.eINSTANCE.createLink();
                link.setMandatory(MandatoryType.MANDATORY);
                link.setGenerationType(LinkType.OKKO);
                link.setTargetId((Action)trg);
                ((Action)entry.getKey()).getLink().add((Object)link);
                if (!isMainAction) continue;
                hashMap.computeIfAbsent((Action)trg, k -> new HashSet()).add(link);
            }
        }
        HashSet<Link> hashSet = new HashSet<Link>();
        for (Action parent : this.processBuilder.mainSteps) {
            for (Link link : parent.getLink()) {
                if (!this.existsLongerWay(parent, link, hashMap)) continue;
                hashSet.add(link);
            }
        }
        for (Link link : hashSet) {
            ((Action)link.eContainer()).getLink().remove((Object)link);
        }
    }

    private boolean existsLongerWay(Action src, Link link, Map<Action, Set<Link>> sourceLink) {
        HashSet<Link> already = new HashSet<Link>();
        already.add(link);
        return this.reachActions(src, link.getTargetId(), sourceLink, already) > 0;
    }

    private int reachActions(Action src, Action trg, Map<Action, Set<Link>> sourceLink, Set<Link> visited) {
        for (Link _link : sourceLink.getOrDefault(trg, Collections.emptySet())) {
            if (visited.contains(_link)) continue;
            visited.add(_link);
            if (_link.eContainer() == src) {
                return 1;
            }
            int i = this.reachActions(src, (Action)_link.eContainer(), sourceLink, visited);
            if (i <= 0) continue;
            return i;
        }
        return 0;
    }

    private boolean hasAlreadyContraflowLink(DataSet start, DataSet source, DataSet search, Map<DataSet, List<DataSet>> inverseLink) {
        if (source == search) {
            return true;
        }
        if (start == source) {
            return false;
        }
        List<DataSet> list = inverseLink.get(source);
        if (list == null) {
            return false;
        }
        return list.stream().anyMatch(a -> this.hasAlreadyContraflowLink(start == null ? source : start, (DataSet)a, search, inverseLink));
    }

    private boolean attachActionToFirstStep(TemplateSorter.ProcessGraphStep graphStep, ActionCode varActionCode) {
        boolean ok = false;
        for (TemplateSorter.ProcessGraphStep p : graphStep.previousSteps) {
            if (!this.attachActionToFirstStep(p, varActionCode)) continue;
            ok = true;
        }
        if (!ok) {
            if (this.getContrib((TemplateSorter.ProcessGraphStep)graphStep).before != null) {
                this.processBuilder.links.computeIfAbsent((Action)varActionCode, k -> new LinkedHashSet()).add(this.getContrib((TemplateSorter.ProcessGraphStep)graphStep).before);
                return true;
            }
            if (this.getContrib((TemplateSorter.ProcessGraphStep)graphStep).during != null) {
                this.processBuilder.links.computeIfAbsent((Action)varActionCode, k -> new LinkedHashSet()).add(this.getContrib((TemplateSorter.ProcessGraphStep)graphStep).during);
                return true;
            }
            return false;
        }
        return false;
    }

    private void setAfter(TemplateSorter.ProcessGraphStep graphStep, Action after) {
        if (!graphStep.nextSteps.isEmpty() && !this.getContrib((TemplateSorter.ProcessGraphStep)graphStep).afterIsLinked) {
            for (TemplateSorter.ProcessGraphStep next : graphStep.nextSteps) {
                if (this.getContrib((TemplateSorter.ProcessGraphStep)next).after != null) {
                    this.processBuilder.links.computeIfAbsent(this.getContrib((TemplateSorter.ProcessGraphStep)next).after, k -> new LinkedHashSet()).add(after);
                    continue;
                }
                this.setAfter(next, after);
            }
        } else if (this.getContrib((TemplateSorter.ProcessGraphStep)graphStep).after != null && this.getContrib((TemplateSorter.ProcessGraphStep)graphStep).after != after) {
            this.processBuilder.links.computeIfAbsent(this.getContrib((TemplateSorter.ProcessGraphStep)graphStep).after, k -> new LinkedHashSet()).add(after);
        } else {
            this.processBuilder.links.computeIfAbsent(this.getContrib((TemplateSorter.ProcessGraphStep)graphStep).during, k -> new LinkedHashSet()).add(after);
        }
    }

    private void setBefore(TemplateSorter.ProcessGraphStep current, Action before) {
        List<TemplateSorter.ProcessGraphStep> firstBefore = this.setBeforeRetrieveBeforeParent(current);
        for (TemplateSorter.ProcessGraphStep parent : firstBefore) {
            this.processBuilder.links.computeIfAbsent(this.getContrib((TemplateSorter.ProcessGraphStep)parent).before, k -> new LinkedHashSet()).add(before);
        }
        List<TemplateSorter.ProcessGraphStep> lastChildren = this.setBeforeRetrieveDuringChildren(current);
        for (TemplateSorter.ProcessGraphStep child : lastChildren) {
            this.processBuilder.links.computeIfAbsent(this.getContrib((TemplateSorter.ProcessGraphStep)child).before, k -> new LinkedHashSet()).add(this.getContrib((TemplateSorter.ProcessGraphStep)current).during);
        }
    }

    private List<TemplateSorter.ProcessGraphStep> setBeforeRetrieveBeforeParent(TemplateSorter.ProcessGraphStep current) {
        HashSet<TemplateSorter.ProcessGraphStep> parents = new HashSet<TemplateSorter.ProcessGraphStep>(current.previousSteps);
        for (TemplateSorter.ProcessGraphStep parent : current.previousSteps) {
            if (!this.builder.buildHelper.getMapAPI().hasNoLoad(this.builder.tplSorter.processGraphStepToTpl.get(parent))) continue;
            parents.remove(parent);
        }
        ArrayList<TemplateSorter.ProcessGraphStep> list = new ArrayList<TemplateSorter.ProcessGraphStep>();
        for (TemplateSorter.ProcessGraphStep parent : parents) {
            if (this.getContrib((TemplateSorter.ProcessGraphStep)parent).before != null) {
                list.add(parent);
                continue;
            }
            list.addAll(this.setBeforeRetrieveBeforeParent(parent));
        }
        return list;
    }

    private List<TemplateSorter.ProcessGraphStep> setBeforeRetrieveDuringChildren(TemplateSorter.ProcessGraphStep action) {
        ArrayList<TemplateSorter.ProcessGraphStep> list = new ArrayList<TemplateSorter.ProcessGraphStep>();
        if (this.getContrib((TemplateSorter.ProcessGraphStep)action).during != null) {
            list.add(action);
        }
        for (TemplateSorter.ProcessGraphStep child : action.nextSteps) {
            list.addAll(this.setBeforeRetrieveDuringChildren(child));
        }
        return list;
    }
}

