/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal;

import com.indy.map.Constraint;
import com.indy.map.Datastore;
import com.indy.map.Field;
import com.indy.map.IContainer;
import com.indy.map.IExpression;
import com.indy.map.RejectNullValueType;
import com.indy.map.Template;
import com.indy.map.ref.RTemplate;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModel;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModelBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class RejectVisitor {
    MdModelBuilder builder;
    private Map<Template, RejectResult> results = new HashMap<Template, RejectResult>();

    RejectVisitor() {
    }

    static RejectVisitor of(MdModelBuilder builder) {
        RejectVisitor res = new RejectVisitor();
        res.builder = builder;
        builder.getSortedTemplate().stream().filter(t -> rejectVisitor.builder.mapModel.getAPI().getTemplateType(t) == RTemplate.Type.REJECT).forEach(res::visit);
        return res;
    }

    private void visit(Template rejectTemplate) {
        RejectResult res = new RejectResult();
        IContainer trgContainer = (IContainer)this.builder.mapModel.getAPI().getTargetRef(rejectTemplate).get(0);
        if (!(trgContainer instanceof Datastore)) {
            return;
        }
        for (Constraint cons : ((Datastore)trgContainer).getConstraint()) {
            if (!cons.isReject() || cons.basicGetRef() == null) continue;
            MdModel.MdConstraint constraint = new MdModel.MdConstraint();
            constraint.name = cons.getName();
            constraint.setMdRef(this.builder.delegate(() -> ((Constraint)cons).getRef()));
            constraint.type = this.builder.mapModel.getAPI().getConstraintType(cons);
            res.constraint.add(constraint);
        }
        for (Field field : ((Datastore)trgContainer).getField()) {
            boolean enable = false;
            if (field.isEnable()) {
                enable = field.getExpression().stream().anyMatch(IExpression::isMapped);
            }
            if (!enable) continue;
            boolean check = false;
            if (field.getRejectNullValue() == RejectNullValueType.TRUE) {
                check = true;
            } else if (field.getRejectNullValue() == RejectNullValueType.DEFAULT) {
                check = this.builder.mapModel.getAPI().isMandatory(field);
            }
            if (!check) continue;
            MdModel.MdConstraint constraint = new MdModel.MdConstraint();
            constraint.name = "NN_" + field.getName();
            constraint.type = "NN";
            constraint.setMdRef(this.builder.delegate(() -> ((Field)field).basicGetRef()));
            res.constraint.add(constraint);
        }
        this.results.put(rejectTemplate, res);
    }

    public List<MdModel.MdConstraint> getConstraint(Template tpl) {
        RejectResult r = this.results.get(tpl);
        if (r == null) {
            return Collections.emptyList();
        }
        return r.constraint;
    }

    class RejectResult {
        List<MdModel.MdConstraint> constraint = new ArrayList<MdModel.MdConstraint>();

        RejectResult() {
        }
    }
}

