/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal;

import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.Template;
import com.semarchy.xdi.designer.generation.mapping.internal.MdModelBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;

class TemplateSorter {
    Map<Template, ProcessGraphStep> tplToProcessGraphStep = new HashMap<Template, ProcessGraphStep>();
    Map<ProcessGraphStep, Template> processGraphStepToTpl = new HashMap<ProcessGraphStep, Template>();
    MdModelBuilder builder;
    Map<IContainer, Template> targetTemplate = new HashMap<IContainer, Template>();
    private List<Template> graphSorted = new ArrayList<Template>();

    static TemplateSorter of(MdModelBuilder builder) {
        return new TemplateSorter(builder);
    }

    private TemplateSorter(MdModelBuilder builder) {
        this.builder = builder;
        List sortedTpl = builder.mapModel.getTemplate().stream().filter(tpl -> !mdModelBuilder.buildHelper.getMapAPI().getTargetRef(tpl).isEmpty()).sorted((o1, o2) -> o1.getName().compareTo(o2.getName())).collect(Collectors.toList());
        for (Template t : sortedTpl) {
            if (!t.getName().startsWith("I")) continue;
            for (IContainer cont : builder.buildHelper.getMapAPI().getTargetRef(t)) {
                this.targetTemplate.put(cont, t);
            }
        }
        for (Template t : sortedTpl) {
            this.createSubset(t);
        }
        sortedTpl.stream().forEach(this::visit);
    }

    public List<Template> getSortedTemplates() {
        return this.graphSorted;
    }

    private void visit(Template t) {
        ProcessGraphStep sds = this.tplToProcessGraphStep.get(t);
        if (sds == null || sds.done) {
            return;
        }
        for (ProcessGraphStep parent : sds.previousSteps) {
            this.visit(this.processGraphStepToTpl.get(parent));
        }
        sds.done = true;
        this.graphSorted.add(t);
    }

    ProcessGraphStep createSubset(Template tpl) {
        ProcessGraphStep t;
        Template integration;
        ProcessGraphStep sds = this.tplToProcessGraphStep.get(tpl);
        if (sds != null) {
            return sds;
        }
        sds = new ProcessGraphStep(tpl);
        this.tplToProcessGraphStep.put(tpl, sds);
        this.processGraphStepToTpl.put(sds, tpl);
        for (IContainer container : this.builder.buildHelper.getMapAPI().getRef(tpl)) {
            integration = this.targetTemplate.get(container);
            if (integration != null && integration != tpl) {
                t = this.createSubset(integration);
                t.addNext(sds);
            }
            DataSet ds = container.getDataset();
            EList parents = ds.getParent();
            for (DataSet parent : parents) {
                for (IContainer c : parent.getContainer()) {
                    Template integrationTpl = this.targetTemplate.get(c);
                    if (integrationTpl == null || integrationTpl == tpl) continue;
                    ProcessGraphStep t2 = this.createSubset(integrationTpl);
                    t2.addNext(sds);
                }
            }
        }
        for (IContainer container : this.builder.buildHelper.getMapAPI().getTargetRef(tpl)) {
            integration = this.targetTemplate.get(container);
            if (integration == null || integration == tpl) continue;
            t = this.createSubset(integration);
            sds.addNext(t);
        }
        return sds;
    }

    class AncestorsVisitor {
        Set<ProcessGraphStep> visited = new HashSet<ProcessGraphStep>();

        AncestorsVisitor() {
        }

        void accept(ProcessGraphStep sds) {
            for (ProcessGraphStep a : sds.previousSteps) {
                this.visit(a);
            }
        }

        private void visit(ProcessGraphStep a) {
            if (this.visited.add(a)) {
                a.previousSteps.stream().forEach(this::visit);
            }
        }
    }

    class ProcessGraphStep
    implements Comparable<ProcessGraphStep> {
        Set<ProcessGraphStep> nextSteps = new TreeSet<ProcessGraphStep>();
        Set<ProcessGraphStep> previousSteps = new TreeSet<ProcessGraphStep>();
        Set<ProcessGraphStep> allPrevious = null;
        boolean done = false;
        Template tpl;

        ProcessGraphStep(Template tpl) {
            this.tpl = tpl;
        }

        void addNext(ProcessGraphStep sds) {
            if (sds != this) {
                this.nextSteps.add(sds);
                sds.previousSteps.add(this);
            }
        }

        @Override
        public int compareTo(ProcessGraphStep o) {
            return TemplateSorter.this.processGraphStepToTpl.get(this).getName().compareTo(TemplateSorter.this.processGraphStepToTpl.get(o).getName());
        }

        public boolean equals(Object obj) {
            if (obj instanceof ProcessGraphStep) {
                if (obj == this) {
                    return true;
                }
                return TemplateSorter.this.processGraphStepToTpl.get(this).getName().equals(TemplateSorter.this.processGraphStepToTpl.get(obj).getName());
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.tpl);
        }

        boolean belongsToPrevious(ProcessGraphStep tested) {
            if (this.allPrevious == null) {
                AncestorsVisitor v = new AncestorsVisitor();
                v.accept(this);
                this.allPrevious = v.visited;
            }
            return this.allPrevious.contains(tested);
        }
    }
}

