/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.mapping.internal.debug;

import com.indy.gmf.proc.ActionCode;
import com.indy.gmf.proc.ActionProcess;
import com.indy.gmf.proc.ActionProcessRef;
import com.indy.gmf.proc.Link;
import com.indy.gmf.proc.MetaDataLink;
import com.indy.gmf.proc.Parameter;
import com.indy.gmf.proc.ProcPackage;
import com.indy.gmf.proc.SubActionProcess;
import com.indy.gmf.proc.util.custom.StbProcResourceFactoryImpl;
import com.semarchy.xdi.designer.core.models.BuiltPlatformResourceURIHandler;
import com.semarchy.xdi.designer.core.models.InternalResourceURIConverter;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.generation.mapping.internal.MappingBuildException;
import com.semarchy.xdi.designer.generation.mapping.internal.debug.DebugMdModel;
import com.semarchy.xdi.designer.generation.mapping.internal.debug.DebugProcModel;
import com.semarchy.xdi.designer.generation.mapping.internal.debug.MdDiffAnalizer;
import com.semarchy.xdi.designer.generation.mapping.internal.debug.MdModelSerializer;
import com.semarchy.xdi.designer.generation.mapping.internal.debug.ProcDiffAnalizer;
import com.semarchy.xdi.designer.generation.mapping.internal.debug.ProcModelSerializer;
import com.stambia.md.Attribute;
import com.stambia.md.DocumentRoot;
import com.stambia.md.MdLink;
import com.stambia.md.MdNode;
import com.stambia.md.MdPackage;
import com.stambia.md.MdRootNode;
import com.stambia.md.util.StbMdResourceFactoryImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class DebugTool {
    private ResourceSet resourceSet;
    private Logger logger = LogManager.getLogger(DebugTool.class);

    public DebugTool() {
        this.init();
    }

    private void init() {
        this.resourceSet = new ResourceSetImpl();
        this.resourceSet.setURIConverter((URIConverter)new InternalResourceURIConverter(){
            URIHandler builtFileHandler = new BuiltPlatformResourceURIHandler();

            public URIHandler getURIHandler(URI uri) {
                if (uri.isPlatformResource() && uri.segment(2).equals("indy.build") && this.builtFileHandler.canHandle(uri)) {
                    return this.builtFileHandler;
                }
                return super.getURIHandler(uri);
            }
        });
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("proc", new StbProcResourceFactoryImpl());
        this.resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("md", new StbMdResourceFactoryImpl());
        this.resourceSet.getPackageRegistry().put((Object)"http://www.example.org/proc", (Object)ProcPackage.eINSTANCE);
        this.resourceSet.getPackageRegistry().put((Object)"http://www.stambia.com/md", (Object)MdPackage.eINSTANCE);
    }

    private DebugMdModel generateMdModel(URI mdModelURI) {
        Resource resource = this.resourceSet.getResource(mdModelURI, true);
        MdRootNode root = ((DocumentRoot)resource.getContents().get(0)).getNode();
        TreeIterator it = root.eAllContents();
        DebugMdModel model = new DebugMdModel();
        DebugMdModel.Step currentStep = this.readStep(model, (MdNode)root);
        DebugMdModel.Source currentSource = null;
        DebugMdModel.Field currentField = null;
        block18: while (it.hasNext()) {
            EObject current;
            block26: {
                current = (EObject)it.next();
                if (current.eClass() != MdPackage.eINSTANCE.getMdNode()) break block26;
                MdNode mdNode = (MdNode)current;
                switch (mdNode.getDefType()) {
                    case "com.stambia.flow.step": {
                        currentStep = this.readStep(model, mdNode);
                        model.steps.add(currentStep);
                        break;
                    }
                    case "com.stambia.flow.source": {
                        currentSource = this.readSource(model, mdNode);
                        currentStep.source.add(currentSource);
                        break;
                    }
                    case "com.stambia.flow.field": {
                        currentField = this.readField(model, mdNode);
                        currentStep.field.add(currentField);
                        break;
                    }
                    case "com.stambia.flow.join": {
                        currentStep.join.add(this.readJoin(model, mdNode));
                        break;
                    }
                    case "com.stambia.flow.filter": {
                        currentStep.filter.add(this.readFilter(model, mdNode));
                        break;
                    }
                    case "com.stambia.flow.constraint": {
                        currentStep.constraint.add(this.readConstraint(model, mdNode));
                        break;
                    }
                    case "com.stambia.flow.extrafield": {
                        if (currentField == null) continue block18;
                        currentField.extraStaticRelation.add(this.readExtra(model, mdNode));
                    }
                }
                continue;
            }
            if (current.eClass() != MdPackage.eINSTANCE.getMdLink()) continue;
            model.mdLinks.add(this.readMdLink((MdLink)current));
            it.prune();
        }
        return model;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compareMdResult(File outputFolder, URI newMdURI, URI oldMdURI) throws DiagnosticException, MappingBuildException {
        DebugMdModel newModel = this.generateMdModel(newMdURI);
        DebugMdModel oldModel = this.generateMdModel(oldMdURI);
        newModel.replacePlaceHolders();
        oldModel.replacePlaceHolders();
        try {
            File legacyFile = new File(outputFolder, "old.md.txt");
            File newFile = new File(outputFolder, "new.md.txt");
            MdModelSerializer.serializeModel(newModel, newFile);
            MdModelSerializer.serializeModel(oldModel, legacyFile);
            Throwable throwable = null;
            Object var9_12 = null;
            try {
                FileInputStream oldIs = new FileInputStream(legacyFile);
                try {
                    try (FileInputStream newIs = new FileInputStream(newFile);){
                        if (MdDiffAnalizer.hasDiff(newIs, oldIs)) {
                            throw new DiagnosticException("MD file is different");
                        }
                    }
                    if (oldIs == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (oldIs == null) throw throwable;
                    ((InputStream)oldIs).close();
                    throw throwable;
                }
                ((InputStream)oldIs).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (MappingBuildException | DiagnosticException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappingBuildException("unexpected error", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void compareProcResult(File outputFolder, URI newProcURI, URI oldProcURI) throws DiagnosticException, MappingBuildException {
        DebugProcModel newModel = this.generateProcModel(newProcURI);
        DebugProcModel oldModel = this.generateProcModel(oldProcURI);
        try {
            File legacyFile = new File(outputFolder, "old.proc.txt");
            File newFile = new File(outputFolder, "new.proc.txt");
            ProcModelSerializer.serializeModel(newModel, newFile);
            ProcModelSerializer.serializeModel(oldModel, legacyFile);
            Throwable throwable = null;
            Object var9_12 = null;
            try {
                FileInputStream oldIs = new FileInputStream(legacyFile);
                try {
                    try (FileInputStream newIs = new FileInputStream(newFile);){
                        if (ProcDiffAnalizer.hasDiff(newIs, oldIs)) {
                            throw new DiagnosticException("PROC file is different");
                        }
                    }
                    if (oldIs == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (oldIs == null) throw throwable;
                    ((InputStream)oldIs).close();
                    throw throwable;
                }
                ((InputStream)oldIs).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (MappingBuildException | DiagnosticException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MappingBuildException("unexpected error", e);
        }
    }

    private DebugProcModel generateProcModel(URI modelURI) {
        Resource resource = this.resourceSet.getResource(modelURI, true);
        ActionProcess root = ((com.indy.gmf.proc.DocumentRoot)resource.getContents().get(0)).getProcess();
        TreeIterator it = root.eAllContents();
        DebugProcModel model = new DebugProcModel();
        while (it.hasNext()) {
            EObject current = (EObject)it.next();
            if (current instanceof ActionCode) {
                ActionCode a = (ActionCode)current;
                model.steps.add(this.parseActionCode(a));
                continue;
            }
            if (current instanceof SubActionProcess) {
                SubActionProcess a = (SubActionProcess)current;
                DebugProcModel.ProcStep last = model.getLastStep();
                model.steps.add(this.parseSubProcess(a, last == null ? null : last.name));
                continue;
            }
            if (current instanceof ActionProcessRef) {
                ActionProcessRef a = (ActionProcessRef)current;
                model.steps.add(this.parseProcessRef(a));
                continue;
            }
            if (current instanceof Parameter) {
                Parameter p = (Parameter)current;
                model.getLastStep().params.add(this.parseProcParam(p));
                continue;
            }
            if (current instanceof MetaDataLink) {
                MetaDataLink mdl = (MetaDataLink)current;
                model.getLastStep().mdLinks.add(this.parseProcMdLink(mdl));
                continue;
            }
            if (!(current instanceof Link)) continue;
            model.addLink(model.getLastStep().name, ((Link)current).getTargetId().getName());
        }
        return model;
    }

    private DebugProcModel.ProcMdLink parseProcMdLink(MetaDataLink p) {
        DebugProcModel.ProcMdLink res = new DebugProcModel.ProcMdLink();
        if (p.getTarget() != null) {
            res.refId = CacheHelper.extractEltID((EObject)p.getTarget());
        }
        res.name = p.getName().toString();
        if (p.getVisibility() != null) {
            res.visibility = p.getVisibility().getName();
        }
        return res;
    }

    private DebugProcModel.ProcParam parseProcParam(Parameter p) {
        DebugProcModel.ProcParam res = new DebugProcModel.ProcParam();
        res.name = p.getName();
        res.value = p.getValue();
        if (p.getRef() != null) {
            res.ref = p.getRef().getId();
        }
        return res;
    }

    private DebugProcModel.ProcStep parseProcessRef(ActionProcessRef a) {
        DebugProcModel.ProcStepReference res = new DebugProcModel.ProcStepReference();
        res.id = a.getId();
        res.name = a.getName();
        res.refURI = CacheHelper.getURIFragment((EObject)a.getTargetAsProxy());
        return res;
    }

    private DebugProcModel.ProcStep parseSubProcess(SubActionProcess a, String parentId) {
        DebugProcModel.SubStep res = new DebugProcModel.SubStep();
        res.id = a.getId();
        res.parent = parentId;
        res.name = a.getName();
        return res;
    }

    private DebugProcModel.ProcStep parseActionCode(ActionCode a) {
        DebugProcModel.ProcActionCode res = new DebugProcModel.ProcActionCode();
        res.id = a.getId();
        res.javaclass = a.getTechnology();
        res.name = a.getName();
        return res;
    }

    private String getRef(Attribute att) {
        if (att == null) {
            return null;
        }
        EObject obj = att.getRef();
        return EcoreUtil.getURI((EObject)obj).fragment();
    }

    private List<String> getList(Attribute att) {
        if (att == null) {
            return null;
        }
        return att.getValues();
    }

    private List<DebugMdModel.PlaceHolder> toPlaceHolder(DebugMdModel model, List<String> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.stream().map(model::placeHolder).collect(Collectors.toList());
    }

    private DebugMdModel.Step readStep(DebugMdModel model, MdNode mdNode) {
        DebugMdModel.Step step = new DebugMdModel.Step();
        step.name = mdNode.getName();
        step.number = mdNode.getAttributeValueByShortCode("number");
        step.outputStructureReference = this.getRef(mdNode.getAttributeByShortCode("outputStructureRef"));
        step.setExpression = mdNode.getAttributeValueByShortCode("setExpression");
        step.integrationStepNames = this.getList(mdNode.getAttributeByShortCode("integrationStepName"));
        step.targetUpdateKeyRef = model.placeHolder(mdNode.getAttributeValueByShortCode("trgUpdateKeyProviderRef"));
        step.type = mdNode.getAttributeValueByShortCode("type");
        return step;
    }

    private DebugMdModel.Source readSource(DebugMdModel model, MdNode mdNode) {
        DebugMdModel.Source res = new DebugMdModel.Source();
        res.filteringSource = mdNode.getAttributeValueByShortCode("filteringSource");
        res.isCDC = mdNode.getAttributeValueByShortCode("cdc");
        res.name = mdNode.getName();
        res.number = mdNode.getAttributeValueByShortCode("number");
        res.order = mdNode.getAttributeValueByShortCode("order");
        res.sourceSetName = mdNode.getAttributeValueByShortCode("sourceSet");
        res.stepName = mdNode.getAttributeValueByShortCode("stepName");
        res.tags = this.getList(mdNode.getAttributeByShortCode("tag"));
        res.target = model.placeHolder(mdNode.getAttributeValueByShortCode("target"));
        return res;
    }

    private DebugMdModel.Field readField(DebugMdModel model, MdNode mdNode) {
        DebugMdModel.Field res = new DebugMdModel.Field();
        res.base = model.placeHolder(mdNode.getAttributeValueByShortCode("base"));
        res.expression = model.placeHolder(mdNode.getAttributeValueByShortCode("expr"));
        res.insert = mdNode.getAttributeValueByShortCode("insert");
        res.location = mdNode.getAttributeValueByShortCode("location");
        res.mdNodeFieldReference = this.getRef(mdNode.getAttributeByShortCode("mdFieldRef"));
        res.name = mdNode.getName();
        res.number = mdNode.getAttributeValueByShortCode("number");
        res.outlinerInput = mdNode.getAttributeValueByShortCode("input");
        res.outlinerOutput = mdNode.getAttributeValueByShortCode("output");
        res.sourceContainers = this.getList(mdNode.getAttributeByShortCode("sourceContainer"));
        res.sourceNames = this.toPlaceHolder(model, this.getList(mdNode.getAttributeByShortCode("sourceNames")));
        res.sources = this.toPlaceHolder(model, this.getList(mdNode.getAttributeByShortCode("source")));
        res.sourceSetName = mdNode.getAttributeValueByShortCode("sourceSet");
        res.tags = this.getList(mdNode.getAttributeByShortCode("tag"));
        res.target = model.placeHolder(mdNode.getAttributeValueByShortCode("target"));
        res.targets = this.toPlaceHolder(model, this.getList(mdNode.getAttributeByShortCode("targets")));
        res.update = mdNode.getAttributeValueByShortCode("update");
        res.updateKey = mdNode.getAttributeValueByShortCode("updatekey");
        res.version = mdNode.getAttributeValueByShortCode("version");
        res.workName = mdNode.getAttributeValueByShortCode("workname");
        return res;
    }

    private DebugMdModel.Join readJoin(DebugMdModel model, MdNode mdNode) {
        DebugMdModel.Join res = new DebugMdModel.Join();
        res.expression = model.placeHolder(mdNode.getAttributeValueByShortCode("expr"));
        res.left = mdNode.getAttributeValueByShortCode("left");
        res.mode = mdNode.getAttributeValueByShortCode("mode");
        res.order = mdNode.getAttributeValueByShortCode("order");
        res.right = mdNode.getAttributeValueByShortCode("right");
        res.sourceContainers = this.getList(mdNode.getAttributeByShortCode("sourceContainer"));
        res.sourceNames = this.toPlaceHolder(model, this.getList(mdNode.getAttributeByShortCode("sourceNames")));
        res.sources = this.toPlaceHolder(model, this.getList(mdNode.getAttributeByShortCode("source")));
        res.sourceSetName = mdNode.getAttributeValueByShortCode("sourceSet");
        res.tags = this.getList(mdNode.getAttributeByShortCode("tag"));
        res.type = mdNode.getAttributeValueByShortCode("type");
        res.version = mdNode.getAttributeValueByShortCode("version");
        return res;
    }

    private DebugMdModel.Filter readFilter(DebugMdModel model, MdNode mdNode) {
        DebugMdModel.Filter res = new DebugMdModel.Filter();
        res.aggregate = mdNode.getAttributeValueByShortCode("aggregate");
        res.expression = "TRG".equals(mdNode.getAttributeValueByShortCode("location")) ? model.placeHolder4TrgField(mdNode.getAttributeValueByShortCode("expr")) : model.placeHolder(mdNode.getAttributeValueByShortCode("expr"));
        res.location = mdNode.getAttributeValueByShortCode("location");
        res.operator = mdNode.getAttributeValueByShortCode("operator");
        res.qualify = mdNode.getAttributeValueByShortCode("qualify");
        res.sourceContainers = this.getList(mdNode.getAttributeByShortCode("sourceContainer"));
        res.sourceNames = this.toPlaceHolder(model, this.getList(mdNode.getAttributeByShortCode("sourceNames")));
        res.sources = this.toPlaceHolder(model, this.getList(mdNode.getAttributeByShortCode("source")));
        res.sourceSetName = mdNode.getAttributeValueByShortCode("sourceSet");
        res.tags = this.getList(mdNode.getAttributeByShortCode("tag"));
        res.version = mdNode.getAttributeValueByShortCode("version");
        return res;
    }

    private DebugMdModel.Constraint readConstraint(DebugMdModel model, MdNode mdNode) {
        DebugMdModel.Constraint res = new DebugMdModel.Constraint();
        res.name = mdNode.getName();
        res.target = model.placeHolder(mdNode.getAttributeValueByShortCode("target"));
        res.type = mdNode.getAttributeValueByShortCode("type");
        return res;
    }

    private DebugMdModel.ExtraStatic readExtra(DebugMdModel model, MdNode mdNode) {
        DebugMdModel.ExtraStatic res = new DebugMdModel.ExtraStatic();
        res.child = model.placeHolder(mdNode.getAttributeValueByShortCode("child"));
        res.parent = model.placeHolder(mdNode.getAttributeValueByShortCode("parent"));
        return res;
    }

    private DebugMdModel.MdLink readMdLink(MdLink current) {
        DebugMdModel.MdLink res = new DebugMdModel.MdLink();
        res.name = current.getName();
        try {
            res.referenceURI = current.getTarget().eIsProxy() ? ((InternalEObject)current.getTarget()).eProxyURI().fragment() : EcoreUtil.getURI((EObject)current.getTarget()).fragment();
        }
        catch (Exception ex) {
            this.logger.error("unexpected", (Throwable)ex);
        }
        return res;
    }

    public class DiagnosticException
    extends Exception {
        private String mappingModelPath;

        public DiagnosticException(String message) {
            super(message);
        }

        public void setMappingModelPath(String mappingModelPath) {
            this.mappingModelPath = mappingModelPath;
        }

        @Override
        public String getMessage() {
            if (this.mappingModelPath != null) {
                return String.format("%s %s", super.getMessage(), this.mappingModelPath);
            }
            return super.getMessage();
        }
    }
}

