/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.md;

import com.semarchy.xdi.designer.generation.md.Md2XmlConverter;
import com.semarchy.xdi.designer.generation.md.MdReader;
import com.stambia.tech.Level;
import com.stambia.tech.Property;
import com.stambia.tech.PropertyType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamWriter;

public class MdConfWriter {
    private XMLStreamWriter mdtoXmlWriter;
    private String confName;
    private Stack<MdReader.NodeEvent> stack = new Stack();
    private Stack<MdReader.NodeEvent> opened = new Stack();
    private Map<MdReader.NodeEvent, Map<String, MdReader.AttributeEvent>> attributes = new HashMap<MdReader.NodeEvent, Map<String, MdReader.AttributeEvent>>();
    private Map<MdReader.NodeEvent, Map<String, Boolean>> externalization = new HashMap<MdReader.NodeEvent, Map<String, Boolean>>();
    private MdReader.ConfEvent currentConf;
    private Md2XmlConverter.AttributeDefaultValueEvaluator defaultAttributeEvaluator = null;

    public MdConfWriter(XMLStreamWriter writer, String confName) {
        this.mdtoXmlWriter = writer;
        this.confName = confName;
    }

    public void setAttributesDefaultValues(Md2XmlConverter.AttributeDefaultValueEvaluator evaluator) {
        this.defaultAttributeEvaluator = evaluator;
    }

    public void writeInheritanceInfo(Collection<String> inheritedAttributes) throws Exception {
        for (String s : inheritedAttributes) {
            this.mdtoXmlWriter.writeStartElement("ex:inheritedAttribute");
            this.mdtoXmlWriter.writeAttribute("attributeId", s);
            this.mdtoXmlWriter.writeEndElement();
        }
    }

    public void handle(MdReader.Event event) throws Exception {
        if (event instanceof MdReader.NodeEvent) {
            this.handleNode((MdReader.NodeEvent)event);
        } else if (event instanceof MdReader.EndNode) {
            this.handleNode((MdReader.EndNode)event);
        } else if (event instanceof MdReader.AttributeEvent) {
            this.handleAttribute((MdReader.AttributeEvent)event);
        } else if (event instanceof MdReader.ConfEvent) {
            this.currentConf = (MdReader.ConfEvent)event;
        } else if (event instanceof MdReader.EndConf) {
            this.currentConf = null;
        } else if (event instanceof MdReader.ExternalizeEvent) {
            this.handleExternalize((MdReader.ExternalizeEvent)event);
        }
    }

    private void handleExternalize(MdReader.ExternalizeEvent event) throws Exception {
        if (this.currentConf != null && !this.currentConf.confName.equals(this.confName)) {
            return;
        }
        Map<String, Boolean> map = this.externalization.get(this.stack.peek());
        if (map == null) {
            map = new HashMap<String, Boolean>();
            this.externalization.put(this.stack.peek(), map);
        }
        map.put(event.defType, event.enabled);
    }

    private void handleNode(MdReader.EndNode event) throws Exception {
        this.computeExternalizedAttributes(this.stack.peek());
        Map<String, MdReader.AttributeEvent> c = this.attributes.get(this.stack.peek());
        MdReader.NodeEvent ev = this.stack.pop();
        if (!this.opened.isEmpty() && this.opened.peek() == ev) {
            this.opened.pop();
            this.mdtoXmlWriter.writeEndElement();
        } else if (c != null && !c.isEmpty()) {
            this.serialize(ev);
            this.opened.pop();
            this.mdtoXmlWriter.writeEndElement();
        }
    }

    private void handleAttribute(MdReader.AttributeEvent event) {
        if (this.currentConf != null && !this.currentConf.confName.equals(this.confName)) {
            return;
        }
        Level curLvl = this.stack.peek().lvl;
        Property prop = curLvl.getAttributeByCode(event.defType);
        if (prop != null) {
            Map<String, MdReader.AttributeEvent> c = this.attributes.get(this.stack.peek());
            if (c == null) {
                c = new HashMap<String, MdReader.AttributeEvent>();
                this.attributes.put(this.stack.peek(), c);
            }
            if (event.value != null || event.values != null || event.map != null) {
                c.put(event.defType, event);
            }
            if (this.currentConf != null) {
                Map<String, Boolean> map = this.externalization.get(this.stack.peek());
                if (map == null) {
                    map = new HashMap<String, Boolean>();
                    this.externalization.put(this.stack.peek(), map);
                }
                map.put(event.defType, true);
            } else if (prop.isExternalize()) {
                Map<String, Boolean> map = this.externalization.get(this.stack.peek());
                if (map == null) {
                    map = new HashMap<String, Boolean>();
                    this.externalization.put(this.stack.peek(), map);
                }
                map.put(event.defType, true);
            }
        }
    }

    private void handleNode(MdReader.NodeEvent event) throws Exception {
        List<MdReader.AttributeEvent> atts;
        if (!this.stack.isEmpty()) {
            this.computeExternalizedAttributes(this.stack.peek());
            Map<String, MdReader.AttributeEvent> c = this.attributes.get(this.stack.peek());
            if (c != null && !c.isEmpty()) {
                this.serialize(this.stack.peek());
            }
        }
        this.stack.push(event);
        if (this.defaultAttributeEvaluator != null && !(atts = this.defaultAttributeEvaluator.getDefaultValues(event.id).stream().map(v -> MdReader.AttributeEvent.of(v.prop.getFullCode(), v.prop.getXmlName(), v.value, null, null, null, null)).collect(Collectors.toList())).isEmpty()) {
            HashMap ev = new HashMap();
            atts.forEach(v -> ev.put(v.defType, v));
            this.attributes.put(event, ev);
        }
    }

    private void computeExternalizedAttributes(MdReader.NodeEvent ev) {
        Map<String, MdReader.AttributeEvent> atts = this.attributes.get(this.stack.peek());
        Map<String, Boolean> externalizRules = this.externalization.get(ev);
        if (externalizRules == null) {
            if (atts != null) {
                for (String s : new ArrayList<String>(atts.keySet())) {
                    Property p = ev.lvl.getAttributeByCode(s);
                    if (p != null && p.isExternalize()) continue;
                    atts.remove(s);
                }
                if (atts.isEmpty()) {
                    this.attributes.remove(this.stack.peek());
                }
            }
        } else if (atts != null) {
            for (String s : externalizRules.keySet()) {
                Boolean b = externalizRules.get(s);
                if (b.booleanValue()) continue;
                atts.remove(s);
            }
            if (atts.isEmpty()) {
                this.attributes.remove(this.stack.peek());
            }
        }
    }

    private void serialize(MdReader.NodeEvent ev) throws Exception {
        for (MdReader.NodeEvent e : this.stack) {
            if (e == ev) break;
            if (this.opened.contains(e)) continue;
            this.serialize(e);
        }
        if (this.opened.contains(ev)) {
            return;
        }
        this.opened.push(ev);
        this.mdtoXmlWriter.writeStartElement("ex:node");
        this.mdtoXmlWriter.writeAttribute("xmlName", ev.lvl.getXmlName());
        this.mdtoXmlWriter.writeAttribute("name", ev.name == null ? "" : ev.name);
        this.mdtoXmlWriter.writeAttribute("id", ev.id);
        this.mdtoXmlWriter.writeAttribute("defType", ev.defType);
        Map<String, MdReader.AttributeEvent> atts = this.attributes.remove(ev);
        Map<String, Boolean> externalizRules = this.externalization.remove(ev);
        if (atts != null) {
            for (MdReader.AttributeEvent a : atts.values()) {
                boolean externalizationAllowed;
                Boolean b;
                Property p = ev.lvl.getAttributeByCode(a.defType);
                if (p == null || p.getType() == PropertyType.REFERENCE) continue;
                Boolean externalized = null;
                if (externalizRules != null && (b = externalizRules.get(p.getFullCode())) != null) {
                    externalized = b;
                }
                if (externalized == null) {
                    externalized = p.isExternalize();
                }
                boolean bl = externalizationAllowed = p.isSetExternalizable() ? p.isExternalizable() : true;
                if (!externalized.booleanValue() || !externalizationAllowed || a.value == null && a.values == null && a.map == null) continue;
                this.mdtoXmlWriter.writeStartElement("ex:attribute");
                this.mdtoXmlWriter.writeAttribute("xmlName", p.getXmlName());
                this.mdtoXmlWriter.writeAttribute("displayName", p.getDisplayName());
                this.mdtoXmlWriter.writeAttribute("already", "false");
                this.mdtoXmlWriter.writeAttribute("type", p.getType().getLiteral());
                if (a.value != null) {
                    this.mdtoXmlWriter.writeStartElement("value");
                    this.mdtoXmlWriter.writeCharacters(a.value);
                    this.mdtoXmlWriter.writeEndElement();
                } else if (a.values != null) {
                    for (String s : a.values) {
                        this.mdtoXmlWriter.writeStartElement("value");
                        this.mdtoXmlWriter.writeAttribute("id", UUID.randomUUID().toString());
                        this.mdtoXmlWriter.writeCharacters(s);
                        this.mdtoXmlWriter.writeEndElement();
                    }
                } else if (a.map != null) {
                    for (String k : a.map.keySet()) {
                        this.mdtoXmlWriter.writeStartElement("value");
                        this.mdtoXmlWriter.writeAttribute("id", UUID.randomUUID().toString());
                        this.mdtoXmlWriter.writeAttribute("key", k);
                        this.mdtoXmlWriter.writeCharacters(a.map.get(k));
                        this.mdtoXmlWriter.writeEndElement();
                    }
                }
                this.mdtoXmlWriter.writeEndElement();
            }
        }
    }

    public void startRoot() throws Exception {
        this.mdtoXmlWriter.writeStartDocument("UTF-8", "1.0");
        this.mdtoXmlWriter.writeStartElement("ex:externalize");
        this.mdtoXmlWriter.writeNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
        this.mdtoXmlWriter.writeNamespace("md", "http://www.stambia.com/md");
        this.mdtoXmlWriter.writeNamespace("ex", "http://www.stambia.com/externalize");
    }

    public void closeRoot() throws Exception {
        this.mdtoXmlWriter.writeEndElement();
        this.mdtoXmlWriter.writeEndDocument();
    }
}

