/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.model.xdg.internal;

import com.indy.map.DataSet;
import com.indy.map.IContainer;
import com.indy.map.ILogicalField;
import com.indy.map.Map;
import com.indy.map.ref.RClause;
import com.indy.map.ref.RExpression;
import com.indy.map.ref.RMap;
import com.indy.map.ref.RSourceSet;
import com.semarchy.xdi.designer.core.utils.URIUtils;
import com.semarchy.xdi.designer.generation.model.xdg.internal.Builder;
import com.stambia.md.DocumentRoot;
import com.stambia.md.MdFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MappingVisitor {
    List<SourceInfo> ssInfo = new ArrayList<SourceInfo>();
    Collection<IContainer> involvedContainers = new HashSet<IContainer>();
    Builder builder = new Builder();

    private void visit(Map map) {
        this.builder.setMappingResource(map);
        for (RSourceSet sourceSet : ((RMap)map.getMapReference()).getSourceSetRef()) {
            IContainer target = (IContainer)sourceSet.getTargetSet().getContainerModel().get(0);
            this.involvedContainers.add(target);
            SourceInfo info = new SourceInfo(target);
            this.ssInfo.add(info);
            target.getLogicalField().stream().filter(f -> f.isMapped()).forEach(f -> f.getExpression().stream().filter(e -> !e.getExpression().trim().isEmpty()).flatMap(e -> ((RExpression)e.getMapReference()).getRealSourceRef().stream()).filter(i -> i.getDataModel() instanceof ILogicalField).map(i -> (ILogicalField)i.getDataModel()).forEach(i -> info.addMappedField((ILogicalField)f, (ILogicalField)i)));
            for (DataSet ds : sourceSet.getDataSet()) {
                Stream clauses = Stream.of(ds.getFilter().stream(), ds.getJoin().stream(), ds.getOperator().stream()).flatMap(c -> c);
                clauses.filter(e -> !e.getExpression().trim().isEmpty()).flatMap(e -> ((RClause)e.getMapReference()).getRealSourceRef().stream()).filter(i -> i.getDataModel() instanceof ILogicalField).map(i -> (ILogicalField)i.getDataModel()).forEach(info::addSrcField);
            }
        }
    }

    private void createMd() {
        this.involvedContainers.forEach(this.builder::createDatastore);
        for (SourceInfo info : this.ssInfo) {
            this.builder.createSourceSet(info.target);
            info.srcFields.stream().forEach(src -> this.builder.createSourceSetField((ILogicalField)src, sourceInfo.target));
            for (Map.Entry<ILogicalField, Collection<ILogicalField>> e : info.mappedFieldPerSrc.entrySet()) {
                for (ILogicalField mappedField : e.getValue()) {
                    this.builder.createLineage(e.getKey(), mappedField);
                }
            }
        }
    }

    public URI createMdResource(Map mapModel, ResourceSet buildResourceSet) throws IOException {
        this.visit(mapModel);
        this.createMd();
        URI xdgURI = URIUtils.getMappingBuiltXdgMdFile((URI)mapModel.eResource().getURI());
        HashMap<String, Object> saveOptions = new HashMap<String, Object>();
        saveOptions.put("ENCODING", "UTF-8");
        saveOptions.put("EXTENDED_META_DATA", true);
        Resource xdgAsMd = buildResourceSet.createResource(xdgURI);
        xdgAsMd.eSetDeliver(false);
        DocumentRoot doc = MdFactory.eINSTANCE.createDocumentRoot();
        doc.setNode(this.builder.createRootMd(mapModel.getId()));
        xdgAsMd.getContents().add((Object)doc);
        xdgAsMd.eSetDeliver(true);
        xdgAsMd.save(saveOptions);
        return EcoreUtil.getURI((EObject)doc.getNode());
    }

    class SourceInfo {
        IContainer target;
        Set<ILogicalField> srcFields = new LinkedHashSet<ILogicalField>();
        java.util.Map<ILogicalField, Collection<ILogicalField>> mappedFieldPerSrc = new HashMap<ILogicalField, Collection<ILogicalField>>();

        SourceInfo(IContainer target) {
            this.target = target;
            this.addInvolvedContainer(target);
        }

        void addMappedField(ILogicalField trg, ILogicalField src) {
            this.mappedFieldPerSrc.computeIfAbsent(src, k -> new HashSet()).add(trg);
            this.addSrcField(src);
            this.addInvolvedContainer((IContainer)trg.eContainer());
            this.addInvolvedContainer((IContainer)src.eContainer());
        }

        void addSrcField(ILogicalField field) {
            this.srcFields.add(field);
            this.addInvolvedContainer((IContainer)field.eContainer());
        }

        private void addInvolvedContainer(IContainer c) {
            MappingVisitor.this.involvedContainers.add(c);
        }
    }
}

