/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.xsl.gene.process;

import com.semarchy.xdi.designer.generation.xsl.gene.process.Graph;
import com.semarchy.xdi.designer.generation.xsl.gene.process.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;

public class GenerationEventHandler {
    private Graph oneProcGraph;
    private Stack<NodeInfo> stackNode = new Stack();
    private HashMap<String, NodeInfo> infos = new HashMap();
    private HashMap<String, List<NodeInfo>> infosByNodeId = new HashMap();
    private NodeInfo currentNode;
    private List<NodeInfo> orphans = new ArrayList<NodeInfo>();
    private NodeInfo root;
    List<String> iterationGroupIdNodeId = new ArrayList<String>();

    public GenerationEventHandler(Graph graph) {
        this.oneProcGraph = graph;
    }

    public String handleEvent(GenerationEvent event) {
        switch (event.type) {
            case START: {
                this.currentNode = new NodeInfo(event.nodeId, this.stackNode.isEmpty() ? null : this.stackNode.peek().getId());
                List<NodeInfo> c = this.infosByNodeId.get(event.nodeId);
                if (c == null) {
                    c = new ArrayList<NodeInfo>();
                    this.infosByNodeId.put(event.nodeId, c);
                }
                c.add(this.currentNode);
                if (this.root == null) {
                    this.root = this.currentNode;
                    this.stackNode.push(this.root);
                    break;
                }
                this.orphans.add(this.currentNode);
                break;
            }
            case PUSH: {
                this.stackNode.push(this.infos.get(event.nodeId));
                break;
            }
            case POP: {
                this.stackNode.pop();
                break;
            }
            case END: {
                this.currentNode = null;
                break;
            }
            case BUILD_CONTENT: {
                NodeInfo inf = this.stackNode.peek();
                if (inf != null && inf.getNode().getType() == Graph.Type.PROCESS) {
                    this.buildGraph(inf);
                }
                if (inf == null) {
                    throw new RuntimeException("Unexpected");
                }
                return inf.id;
            }
            case NO_GENERATE: {
                this.currentNode.generated = false;
                this.currentNode.name = this.getName(event.nodeId);
                break;
            }
            case GENERATE: {
                this.currentNode.generated = true;
                this.currentNode.name = this.getName(event.nodeId);
                break;
            }
            case ITERATION: {
                this.currentNode.generated = true;
                this.currentNode.name = this.getName(event.nodeId) + " - " + event.additional;
                this.currentNode.isIteration = true;
                this.currentNode.iterationGroup = this.generateIterationGroupId(event.nodeId);
                return this.currentNode.id;
            }
        }
        return null;
    }

    private String generateIterationGroupId(String nodeId) {
        int i = this.iterationGroupIdNodeId.indexOf(nodeId);
        if (i == -1) {
            i = this.iterationGroupIdNodeId.size();
            this.iterationGroupIdNodeId.add(nodeId);
        }
        return "iter_" + i + "-group";
    }

    private String getName(String nodeId) {
        Graph.Node n = this.oneProcGraph.getNodeById(nodeId);
        if (n instanceof Graph.Step) {
            return ((Graph.Step)n).getName();
        }
        if (n instanceof Graph.Action) {
            return ((Graph.Action)n).getName();
        }
        return null;
    }

    private void buildGraph(NodeInfo info) {
        Graph.Node n;
        HashSet<Graph.Node> withRepetition = new HashSet<Graph.Node>();
        ArrayList<NodeInfo> nodesInfosWithoutRepetition = new ArrayList<NodeInfo>();
        HashMap<Graph.Node, ArrayList<NodeInfo>> iterationSequentialst = new HashMap<Graph.Node, ArrayList<NodeInfo>>();
        for (NodeInfo i : info.children) {
            Graph.Node n2 = i.getNode();
            if (i.generated && n2.getRepetitionQuery() != null) {
                Iterator<Object> iterator;
                Graph.Node nI2;
                List<NodeInfo> l;
                if (!withRepetition.add(n2) || (l = this.getNodesInfos4(n2, info.children)) == null) continue;
                List<Graph.Node> inputsNode = this.oneProcGraph.getInput(n2);
                List<Graph.Node> outputsNode = this.oneProcGraph.getOutput(n2);
                if ("Parallelize".equals(n2.getRepetitionType())) {
                    for (NodeInfo k : l) {
                        for (Graph.Node nI2 : inputsNode) {
                            for (NodeInfo in : this.getNodesInfos4(nI2, info.children)) {
                                in.outputs.add(k);
                                k.inputs.add(in);
                            }
                        }
                        iterator = outputsNode.iterator();
                        while (iterator.hasNext()) {
                            nI2 = (Graph.Node)iterator.next();
                            for (NodeInfo out : this.getNodesInfos4(nI2, info.children)) {
                                k.outputs.add(out);
                                out.inputs.add(k);
                            }
                        }
                    }
                    continue;
                }
                NodeInfo last = i;
                ArrayList<NodeInfo> ll = (ArrayList<NodeInfo>)iterationSequentialst.get(n2);
                if (ll == null) {
                    ll = new ArrayList<NodeInfo>();
                    iterationSequentialst.put(n2, ll);
                }
                ll.add(i);
                for (NodeInfo k : l) {
                    if (k != last) {
                        last.outputs.add(k);
                        k.inputs.add(last);
                    }
                    last = k;
                }
                for (Graph.Node nI2 : inputsNode) {
                    for (NodeInfo in : this.getNodesInfos4(nI2, info.children)) {
                        in.outputs.add(i);
                        i.inputs.add(in);
                    }
                }
                iterator = outputsNode.iterator();
                while (iterator.hasNext()) {
                    nI2 = (Graph.Node)iterator.next();
                    for (NodeInfo out : this.getNodesInfos4(nI2, info.children)) {
                        i.outputs.remove(out);
                        out.inputs.remove(i);
                        last.outputs.add(out);
                        out.inputs.add(last);
                    }
                }
                continue;
            }
            nodesInfosWithoutRepetition.add(i);
        }
        for (NodeInfo i : nodesInfosWithoutRepetition) {
            for (Graph.Node _src : this.oneProcGraph.getInput(i.getNode())) {
                if (withRepetition.contains(_src)) continue;
                for (NodeInfo src : this.getNodesInfos4(_src, info.children)) {
                    NodeInfo trg = i;
                    src.outputs.add(trg);
                    trg.inputs.add(src);
                }
            }
            for (Graph.Node _trg : this.oneProcGraph.getOutput(i.getNode())) {
                NodeInfo src;
                if (withRepetition.contains(_trg)) continue;
                src = i;
                for (NodeInfo trg : this.getNodesInfos4(_trg, info.children)) {
                    src.outputs.add(trg);
                    trg.inputs.add(src);
                }
            }
        }
        LinkTypeVisitor2 vis = new LinkTypeVisitor2();
        vis.accept(info);
        HashSet<NodeInfo> beginCandidates = new HashSet<NodeInfo>(info.children);
        for (NodeInfo i : info.children) {
            n = i.getNode();
            if (n.getType() != Graph.Type.LINK) {
                HashMap<NodeInfo, Collection<Graph.NodeLink>> realOutputMap = this.getRealOutput(i);
                for (NodeInfo o : realOutputMap.keySet()) {
                    for (Graph.NodeLink lk : realOutputMap.get(o)) {
                        i.addOutput(o, lk == null ? null : lk.getModelInfo(), lk == null ? false : lk.isBind(), lk);
                    }
                    beginCandidates.remove(o);
                }
                continue;
            }
            beginCandidates.remove(i);
        }
        for (NodeInfo i : info.children) {
            n = i.getNode();
            if (n.getType() == Graph.Type.LINK) continue;
            if (beginCandidates.contains(i)) {
                i.isBegin = true;
                continue;
            }
            if (!n.isStarting()) continue;
            if (!i.isIteration) {
                i.isBegin = true;
                continue;
            }
            if ("Parallelize".equals(n.getRepetitionType())) {
                i.isBegin = true;
                continue;
            }
            List l = (List)iterationSequentialst.get(n);
            if (l == null || l.isEmpty() || l.get(0) != i) continue;
            i.isBegin = true;
        }
    }

    private void dumpForWebgraphiz(NodeInfo info) {
        for (NodeInfo i : info.children) {
            for (NodeInfo o : i.outputs) {
                System.out.println("\"" + i.name + "(" + i.id + ")\" -> \"" + o.name + "(" + o.id + ")\";");
            }
        }
        for (NodeInfo i : info.children) {
            if (!i.generated) continue;
            System.out.println("\"" + i.name + "(" + i.id + ")\" [color=blue" + (i.getNode().needGeneration() ? ", shape=box" : "") + "];");
        }
    }

    private HashMap<NodeInfo, Collection<Graph.NodeLink>> getRealOutput(NodeInfo i) {
        OutputWalker w = new OutputWalker();
        return w.getRealOutputs(i);
    }

    private List<NodeInfo> getNodesInfos4(Graph.Node t, Collection<NodeInfo> children) {
        Collection cur = this.infosByNodeId.get(t.getBaseId());
        if (cur == null) {
            return new ArrayList<NodeInfo>();
        }
        ArrayList<NodeInfo> c = new ArrayList<NodeInfo>(cur);
        c.retainAll(children);
        return c;
    }

    public NodeInfo getDeliveryGraph() throws Exception {
        ArrayList c = new ArrayList(this.infosByNodeId.get(this.oneProcGraph.getRoot().getBaseId()));
        if (c.size() != 1) {
            throw new Exception(Messages.GenerationEventHandler_0);
        }
        return (NodeInfo)c.get(0);
    }

    public boolean isEvaluated(String nodeInfoId) {
        return this.infos.get((Object)nodeInfoId).generated;
    }

    public List<String> getChildrenSteps(String nodeInfoId) {
        NodeInfo i = this.infos.get(nodeInfoId);
        ArrayList<String> res = new ArrayList<String>();
        if (i != null) {
            for (NodeInfo c : i.children) {
                res.add(c.id);
            }
        }
        return res;
    }

    public boolean needGeneration(String nodeInfoId) {
        NodeInfo i = this.infos.get(nodeInfoId);
        Graph.Node n = i.getNode();
        return n.needGeneration();
    }

    public NodeInfo getNodeInfo(String nodeInfoId) {
        return this.infos.get(nodeInfoId);
    }

    public String getCurrentPath() {
        StringBuilder b = new StringBuilder();
        for (NodeInfo i : this.stackNode) {
            b.append("/node[@id='");
            b.append(i.getNode().getBaseId());
            b.append("']");
        }
        return b.toString();
    }

    public NodeInfo getCurrentNodeInfo() {
        return this.stackNode.peek();
    }

    public String getFirstNodeInfoIdWithRepetition(String fromNodeInfoId) {
        NodeInfo curInfo = this.infos.get(fromNodeInfoId);
        while (curInfo != null && curInfo.getNode().getRepetitionQuery() == null) {
            curInfo = curInfo.parent;
        }
        if (curInfo != null) {
            return curInfo.id;
        }
        return null;
    }

    public static class GenerationEvent {
        String nodeId;
        GenerationEventType type;
        String additional;

        public GenerationEvent(String nodeId, GenerationEventType type, String additional) {
            this.nodeId = nodeId;
            this.type = type;
            this.additional = additional;
        }

        public GenerationEvent(String nodeId, GenerationEventType type) {
            this.nodeId = nodeId;
            this.type = type;
        }
    }

    public static enum GenerationEventType {
        GENERATE,
        NO_GENERATE,
        ITERATION,
        START,
        END,
        BUILD_CONTENT,
        SET_PARENT,
        PUSH,
        POP;

    }

    private class LinkTypeVisitor2 {
        Collection<NodeInfo> visited = new HashSet<NodeInfo>();
        Set<NodeInfo> toKeep = new HashSet<NodeInfo>();
        Set<NodeInfo> toByPass = new HashSet<NodeInfo>();
        Set<NodeInfo> toDelete = new HashSet<NodeInfo>();
        NodeInfo root;

        private LinkTypeVisitor2() {
        }

        public void accept(NodeInfo rootInfo) {
            ArrayList<NodeInfo> curChild = new ArrayList<NodeInfo>(rootInfo.children);
            this.root = rootInfo;
            for (NodeInfo n : curChild) {
                if (!n.inputs.isEmpty() && !GenerationEventHandler.this.oneProcGraph.isStarting(n.getNode())) continue;
                this.visit1(n);
            }
            for (NodeInfo i : this.toByPass) {
                if (this.toKeep.contains(i)) continue;
                this.byPassChild(i);
            }
            this.toDelete.addAll(this.root.getChildren());
            this.toDelete.removeAll(this.toKeep);
            for (NodeInfo i : this.toDelete) {
                if (i.inputs.size() != 1 && (!this.toDelete.containsAll(i.inputs) || !Collections.disjoint(i.inputs, this.toKeep))) continue;
                for (NodeInfo ii : i.outputs) {
                    ii.inputs.remove(i);
                }
                i.parent.children.remove(i);
                for (NodeInfo ii : i.inputs) {
                    ii.outputs.remove(i);
                }
            }
        }

        void byPassChild(NodeInfo c) {
            ArrayList<NodeInfo> inputs = new ArrayList<NodeInfo>(c.inputs);
            ArrayList<NodeInfo> outputs = new ArrayList<NodeInfo>(c.outputs);
            for (NodeInfo o : outputs) {
                for (NodeInfo i : inputs) {
                    o.inputs.add(i);
                    i.outputs.add(o);
                }
                o.inputs.remove(c);
                c.outputs.remove(o);
            }
            for (NodeInfo i : inputs) {
                i.outputs.remove(c);
                for (NodeInfo o : outputs) {
                    i.outputs.add(o);
                    o.inputs.add(i);
                }
                c.inputs.remove(i);
            }
            c.parent.children.remove(c);
        }

        private void visit1(NodeInfo n) {
            if (!this.visited.add(n)) {
                return;
            }
            ArrayList<NodeInfo> l = new ArrayList<NodeInfo>(n.outputs);
            if (n.getNode().getType() != Graph.Type.LINK) {
                if (!n.generated) {
                    this.toByPass.add(n);
                } else {
                    this.toKeep.add(n);
                }
                for (NodeInfo o : l) {
                    this.visit1(o);
                }
            } else {
                NodeInfo linkInput;
                Graph.NodeLink lk = (Graph.NodeLink)n.getNode();
                Graph.GenerationMode m = lk.getMode();
                NodeInfo nodeInfo = linkInput = n.getInputs().isEmpty() ? null : n.getInputs().iterator().next();
                if (n.generated) {
                    if (m == null && lk.isBind() || m == Graph.GenerationMode.OK_KO || m == Graph.GenerationMode.OK && linkInput != null && (linkInput.generated || this.toKeep.contains(linkInput)) || m == Graph.GenerationMode.KO && linkInput != null && (!linkInput.generated || !this.toKeep.contains(linkInput) && this.toDelete.contains(linkInput))) {
                        this.toKeep.add(n);
                        for (NodeInfo o : l) {
                            if (o.getNode().getType() != Graph.Type.LINK) {
                                this.visit1(o);
                                continue;
                            }
                            if (((Graph.NodeLink)o.getNode()).getMode() != Graph.GenerationMode.KO) {
                                this.visit1(o);
                                continue;
                            }
                            this.toDelete(o, false);
                        }
                    } else {
                        for (NodeInfo o : l) {
                            if (o.getNode().getType() != Graph.Type.LINK) {
                                this.toDelete(o, linkInput == null || linkInput.generated);
                                continue;
                            }
                            if (((Graph.NodeLink)o.getNode()).getMode() != Graph.GenerationMode.KO) {
                                this.toDelete(o, linkInput == null || linkInput.generated);
                                continue;
                            }
                            this.visit1(o);
                        }
                    }
                } else {
                    for (NodeInfo o : l) {
                        if (o.getNode().getType() != Graph.Type.LINK) {
                            this.toDelete(o, linkInput == null ? true : linkInput.generated);
                            continue;
                        }
                        if (((Graph.NodeLink)o.getNode()).getMode() != Graph.GenerationMode.KO) {
                            this.toDelete(o, linkInput == null ? true : linkInput.generated);
                            continue;
                        }
                        this.visit1(o);
                    }
                }
            }
        }

        private void toDelete(NodeInfo o, boolean interuptAll) {
            if (this.toDelete.add(o)) {
                for (NodeInfo k : o.outputs) {
                    if (interuptAll) {
                        this.toDelete(k, interuptAll);
                        continue;
                    }
                    if (k.getNode().getType() == Graph.Type.LINK) {
                        if (((Graph.NodeLink)k.getNode()).getMode() == Graph.GenerationMode.KO) continue;
                        this.toDelete(k, interuptAll);
                        continue;
                    }
                    this.toDelete(k, interuptAll);
                }
            }
        }
    }

    public class NodeInfo {
        NodeInfo parent;
        List<NodeInfo> children = new ArrayList<NodeInfo>();
        String nodeId;
        boolean generated;
        Set<NodeInfo> outputs = new HashSet<NodeInfo>();
        Set<NodeInfo> inputs = new HashSet<NodeInfo>();
        Set<NodeInfo> outputSteps = new HashSet<NodeInfo>();
        Set<String> bindedOutputIds = new HashSet<String>();
        HashMap<NodeInfo, Set<Graph.ModelInfo>> outputInfos = new HashMap();
        Map<String, HashMap<String, String>> linkIdByRealOutputId = new HashMap<String, HashMap<String, String>>();
        String id;
        String normalizedId;
        String path;
        String name;
        boolean isIteration = false;
        boolean isBegin = false;
        String iterationGroup;
        Graph.Node node;

        void addOutput(NodeInfo info, Graph.ModelInfo m, boolean isBind, Graph.NodeLink shortCuttedNodeLink) {
            this.outputSteps.add(info);
            Set<Graph.ModelInfo> s = this.outputInfos.get(info);
            if (s == null) {
                s = new HashSet<Graph.ModelInfo>();
                this.outputInfos.put(info, s);
            }
            s.add(m);
            if (isBind) {
                this.bindedOutputIds.add(info.id);
            }
            if (shortCuttedNodeLink != null) {
                for (NodeInfo in : info.getInput4NodeLinks()) {
                    Graph.Node n = in.getNode();
                    if (n != shortCuttedNodeLink) continue;
                    HashMap<String, String> c = this.linkIdByRealOutputId.get(info.getId());
                    if (c == null) {
                        c = new HashMap();
                        this.linkIdByRealOutputId.put(info.getId(), c);
                    }
                    c.put(m.srcId, in.id);
                    break;
                }
            }
        }

        private List<NodeInfo> getInput4NodeLinks() {
            ArrayList<NodeInfo> l = new ArrayList<NodeInfo>();
            for (NodeInfo i : this.inputs) {
                if (i.getNode().getType() != Graph.Type.LINK) continue;
                l.add(i);
                l.addAll(i.getInput4NodeLinks());
            }
            return l;
        }

        private String getPath() {
            if (this.path == null) {
                Object t = "";
                if (this.parent != null) {
                    t = this.parent.getPath();
                }
                this.path = t = (String)t + "/" + this.getName();
            }
            return this.path;
        }

        public String getNormalizedId() {
            if (this.parent == null) {
                return this.getId();
            }
            if (this.normalizedId == null) {
                String p = this.getPath();
                this.normalizedId = Graph.MD5(p);
            }
            return this.normalizedId;
        }

        public Graph.Node getNode() {
            if (this.node == null) {
                this.node = GenerationEventHandler.this.oneProcGraph.getNodeById(this.nodeId);
            }
            return this.node;
        }

        public NodeInfo(String nodeId, String parentId) {
            this.nodeId = nodeId;
            this.parent = parentId == null ? null : GenerationEventHandler.this.infos.get(parentId);
            this.id = UUID.randomUUID().toString();
            GenerationEventHandler.this.infos.put(this.id, this);
            if (this.parent != null) {
                this.parent.children.add(this);
            }
        }

        public Collection<NodeInfo> getChildren() {
            return this.children;
        }

        public Collection<NodeInfo> getOutputSteps() {
            return this.outputSteps;
        }

        public Collection<NodeInfo> getInputs() {
            return this.inputs;
        }

        public Collection<Graph.ModelInfo> getOutputInfo(NodeInfo output) {
            return this.outputInfos.get(output);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public boolean isInIteration() {
            if (this.isIteration) {
                return true;
            }
            if (this.parent != null) {
                return this.parent.isIteration;
            }
            return false;
        }

        public String isBegin() {
            return "" + this.isBegin;
        }

        public boolean isOutputBind(NodeInfo o, Graph.ModelInfo i) {
            if (this.bindedOutputIds.contains(o.getId())) {
                if (i != null) {
                    String linkNodeId = this.getLinkNodeIdFromOutputId(o.getId(), i.srcId);
                    NodeInfo linkNode = Graph.getNodeInfo(linkNodeId);
                    for (NodeInfo n : linkNode.outputs) {
                        if (n.getNode().getType() != Graph.Type.LINK) continue;
                        return false;
                    }
                    return true;
                }
                return true;
            }
            return false;
        }

        public String getLinkNodeIdFromOutputId(String realStepOutputId, String srcLinkObjectId) {
            HashMap<String, String> m = this.linkIdByRealOutputId.get(realStepOutputId);
            return m.get(srcLinkObjectId);
        }

        public String getIterationGroup() {
            if (this.isIteration) {
                return this.iterationGroup;
            }
            if (this.parent.isIteration) {
                return this.parent.iterationGroup;
            }
            return null;
        }
    }

    class OutputWalker {
        private HashMap<NodeInfo, List<List<NodeInfo>>> paths = new HashMap();
        private Stack<NodeInfo> currentPath = new Stack();
        private Set<NodeInfo> visited = new HashSet<NodeInfo>();

        OutputWalker() {
        }

        public HashMap<NodeInfo, Collection<Graph.NodeLink>> getRealOutputs(NodeInfo startingNode) {
            assert (startingNode.getNode().getType() != Graph.Type.LINK);
            for (NodeInfo output : startingNode.outputs) {
                this.visit(output);
            }
            HashMap<NodeInfo, Collection<Graph.NodeLink>> res = new HashMap<NodeInfo, Collection<Graph.NodeLink>>();
            for (NodeInfo trg : this.paths.keySet()) {
                res.put(trg, new HashSet());
                boolean hasBind = false;
                for (List<NodeInfo> path : this.paths.get(trg)) {
                    for (NodeInfo i : path) {
                        if (!((Graph.NodeLink)i.getNode()).isBind()) continue;
                        hasBind = true;
                        break;
                    }
                    if (!path.isEmpty()) {
                        if (hasBind) {
                            res.get(trg).add((Graph.NodeLink)path.get(0).getNode());
                            continue;
                        }
                        res.get(trg).add((Graph.NodeLink)path.get(path.size() - 1).getNode());
                        continue;
                    }
                    res.get(trg).add(null);
                }
            }
            return res;
        }

        private void createPath(NodeInfo terminalNodeInfo) {
            this.paths.computeIfAbsent(terminalNodeInfo, key -> new ArrayList());
            ArrayList<NodeInfo> path = new ArrayList<NodeInfo>(this.currentPath);
            this.paths.get(terminalNodeInfo).add(path);
        }

        private void visit(NodeInfo node) {
            if (node.getNode().getType() != Graph.Type.LINK) {
                this.createPath(node);
                return;
            }
            if (!this.visited.add(node)) {
                return;
            }
            this.currentPath.push(node);
            for (NodeInfo output : node.outputs) {
                this.visit(output);
            }
            this.currentPath.pop();
        }
    }
}

