/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.xsl.gene.process.internal.configuration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class MdXmlParser {
    private static final QName ATT_NAME = new QName("name");
    private static final QName ATT_ID = new QName("id");
    private static final QName ATT_MD_REF_ID = new QName("http://www.stambia.com/md", "refId", "md");
    private static final QName ATT_TRG = new QName("target");
    private XMLEventReader reader;
    private XMLStreamWriter writer;
    private String configuration;
    private Stack<StartElement> stack = new Stack();
    private HashMap<String, Collection<String>> discardedByConfigurationChildNodes = new HashMap();
    private boolean inTech = false;
    private Map<Info, String> result = new HashMap<Info, String>();
    private String modelId;
    private Set<String> requestedModels = new HashSet<String>();
    private Set<StartElement> needAttributeFlush = new HashSet<StartElement>();
    private static Pattern GEN_PATTERN = Pattern.compile("(%\\{.+\\}%)|(%x\\{.+\\}x%)");
    private XMLEvent currentEvent;
    private HashMap<String, HashMap<QName, Object>> configurationStore = new HashMap();
    private Properties configurationValues = null;
    private Set<String> externalizedAttributes;
    private String externalizationPrefix;
    private String externalisationSuffix;
    private int externalizationVarIndex;
    private HashMap<String, Integer> externalizedAttributesIndexes;
    private HashMap<String, Collection<String>> inheritedAttributesPerNode;
    private boolean needGeneration = false;

    public boolean needGeneration() {
        return this.needGeneration;
    }

    public MdXmlParser(XMLEventReader reader, XMLStreamWriter writer, String configurationToApply, Properties configurationValues) {
        this.reader = reader;
        this.writer = writer;
        this.configuration = configurationToApply;
        this.configurationValues = configurationValues;
    }

    public MdXmlParser(XMLEventReader reader, XMLStreamWriter writer, String configurationToApply, Properties configurationValues, HashMap<String, Collection<String>> inheritedAttributesPerNode, Set<String> externalizedAttributes, HashMap<String, Integer> externalizedAttributesIndexes, String externalizationPrefix, String externalisationSuffix, int externalizationVarIndex) {
        this(reader, writer, configurationToApply, configurationValues);
        this.externalizedAttributes = externalizedAttributes;
        this.externalizedAttributesIndexes = externalizedAttributesIndexes;
        this.externalizationPrefix = externalizationPrefix;
        this.externalisationSuffix = externalisationSuffix;
        this.externalizationVarIndex = externalizationVarIndex;
        this.inheritedAttributesPerNode = inheritedAttributesPerNode;
    }

    public HashMap<String, Integer> getResult() {
        return this.externalizedAttributesIndexes;
    }

    public String getModelId() {
        return this.modelId;
    }

    public Collection<String> getRequiredModelId() {
        return this.requestedModels;
    }

    private void handleCharacters(XMLEvent event) throws XMLStreamException {
        this.writeAttributes();
        Characters v = event.asCharacters();
        if (v.isCData()) {
            this.writer.writeCData(v.getData());
        } else {
            String val = v.getData();
            if (!val.isEmpty() && this.hasNodeId() && GEN_PATTERN.matcher(val).find()) {
                this.needGeneration = true;
                this.result.put(new Info(this.extractNodeId(), ""), val);
            }
            this.writer.writeCharacters(val);
        }
    }

    private void handleStart(XMLEvent event) throws XMLStreamException {
        XMLEvent ev;
        int i;
        Attribute a;
        StartElement start = event.asStartElement();
        if (start.getName().getPrefix().equals("tech") && start.getName().getLocalPart().equals("tech")) {
            this.inTech = true;
            this.write(event);
            return;
        }
        if (!this.inTech && start.getName().getLocalPart().equals("metaDataLink") && (a = start.getAttributeByName(ATT_TRG)) != null && (i = a.getValue().indexOf("?fileId=")) > -1) {
            String f = a.getValue().substring(i + 8);
            int end = f.indexOf("$");
            if (end == -1) {
                end = f.indexOf("?");
            }
            String fileId = f.substring(0, end);
            this.requestedModels.add(fileId);
        }
        if (!this.stack.isEmpty()) {
            Collection<String> c = this.discardedByConfigurationChildNodes.get(this.extractNodeId());
            Attribute a2 = this.stack.peek().getAttributeByName(ATT_MD_REF_ID);
            if (a2 != null) {
                Collection<String> __c = this.discardedByConfigurationChildNodes.get(a2.getValue());
                if (c == null) {
                    c = __c;
                } else if (__c != null) {
                    HashSet<String> tmp = new HashSet<String>(c);
                    tmp.addAll(__c);
                    c = tmp;
                }
            }
            if (c != null && c.contains(start.getName().getLocalPart())) {
                Stack<XMLEvent> s = new Stack<XMLEvent>();
                s.push(start);
                while (!s.isEmpty()) {
                    XMLEvent e = this.reader.nextEvent();
                    if (e.isStartElement()) {
                        s.push(e);
                        continue;
                    }
                    if (!e.isEndElement()) continue;
                    s.pop();
                }
                return;
            }
        }
        if ((ev = this.reader.nextEvent()).getEventType() == 4) {
            this.writeAttributes();
            this.stack.push(start);
            this.needAttributeFlush.add(start);
            this.writer.writeStartElement(this.stack.peek().getName().getPrefix(), this.stack.peek().getName().getLocalPart(), this.stack.peek().getName().getNamespaceURI());
            this.currentEvent = ev;
            this.handleEvent(this.currentEvent);
        } else if (ev.getEventType() == 2) {
            this.writeAttributes();
            this.stack.push(start);
            this.needAttributeFlush.add(start);
            this.writer.writeStartElement(this.stack.peek().getName().getPrefix(), this.stack.peek().getName().getLocalPart(), this.stack.peek().getName().getNamespaceURI());
            this.handleEnd(ev);
        } else if (ev.getEventType() == 1) {
            this.writeAttributes();
            this.stack.push(start);
            this.writer.writeStartElement(this.stack.peek().getName().getPrefix(), this.stack.peek().getName().getLocalPart(), this.stack.peek().getName().getNamespaceURI());
            this.needAttributeFlush.add(start);
            while (ev.isStartElement() && (start.getName().getLocalPart() + "Conf").equals(ev.asStartElement().getName().getLocalPart())) {
                this.handleConf(ev.asStartElement());
                ev = this.reader.nextEvent();
            }
            this.currentEvent = ev;
            this.handleEvent(this.currentEvent);
        }
    }

    private XMLEvent handleConf(StartElement configurationElement) throws XMLStreamException {
        Object m;
        String confName = configurationElement.getAttributeByName(ATT_NAME).getValue();
        boolean isConfiguring = this.configuration.equals(confName);
        if (!isConfiguring) {
            Stack<XMLEvent> stack = new Stack<XMLEvent>();
            stack.push(configurationElement);
            XMLEvent ev = null;
            while (!stack.isEmpty()) {
                ev = this.reader.nextEvent();
                if (ev.getEventType() == 1) {
                    stack.push(ev);
                    continue;
                }
                if (ev.getEventType() != 2) continue;
                stack.pop();
            }
            return ev;
        }
        String nodeId = this.extractNodeId();
        String subMdId = this.extractSubParentNodeId();
        Stack<StartElement> stack = new Stack<StartElement>();
        ArrayList<XMLEvent> nested = new ArrayList<XMLEvent>();
        stack.push(configurationElement);
        XMLEvent ev = null;
        while (!stack.isEmpty()) {
            ev = this.reader.nextEvent();
            if (ev.getEventType() == 1) {
                stack.push(ev.asStartElement());
                Collection<String> c = this.discardedByConfigurationChildNodes.get(this.extractNodeId());
                if (c == null) {
                    c = new HashSet<String>();
                    this.discardedByConfigurationChildNodes.put(this.extractNodeId(), c);
                }
                c.add(((StartElement)stack.peek()).getName().getLocalPart());
            } else if (ev.getEventType() == 2) {
                stack.pop();
            }
            if (stack.isEmpty()) continue;
            nested.add(ev);
        }
        LinkedHashMap<QName, String> attValues = new LinkedHashMap<QName, String>();
        Iterator<Attribute> it = configurationElement.getAttributes();
        while (it.hasNext()) {
            String val;
            Attribute att = it.next();
            if (att.getName().getLocalPart().equals("name") || (val = att.getValue()).isEmpty()) continue;
            attValues.put(att.getName(), val);
        }
        LinkedHashMap multiValuatedAtts = new LinkedHashMap();
        if (!nested.isEmpty()) {
            Iterator i = nested.iterator();
            XMLEvent _ev = null;
            while (i.hasNext()) {
                if (_ev == null) {
                    _ev = (XMLEvent)i.next();
                }
                if (!_ev.isStartElement()) continue;
                ArrayList<ArrayList<XMLEvent>> ll = (ArrayList<ArrayList<XMLEvent>>)((HashMap)multiValuatedAtts).get(_ev.asStartElement().getName());
                if (ll == null) {
                    ll = new ArrayList<ArrayList<XMLEvent>>();
                    multiValuatedAtts.put(_ev.asStartElement().getName(), ll);
                }
                ArrayList<XMLEvent> l = new ArrayList<XMLEvent>();
                while (i.hasNext() && !_ev.isEndElement()) {
                    l.add(_ev);
                    _ev = (XMLEvent)i.next();
                }
                l.add(_ev);
                ll.add(l);
                if (!i.hasNext()) continue;
                _ev = (XMLEvent)i.next();
            }
        }
        LinkedHashMap confStore = new LinkedHashMap(attValues);
        confStore.putAll(multiValuatedAtts);
        this.configurationStore.put(this.extractNodeId(), confStore);
        LinkedHashMap<QName, List> nestedFromParentConf = new LinkedHashMap<QName, List>();
        Attribute a = this.stack.peek().getAttributeByName(ATT_MD_REF_ID);
        if (a != null && (m = this.configurationStore.get(a.getValue())) != null) {
            for (QName q : ((HashMap)m).keySet()) {
                if (((HashMap)attValues).get(q) != null) continue;
                Object v = ((HashMap)m).get(q);
                if (v instanceof String && !((String)v).isEmpty()) {
                    attValues.put(q, (String)v);
                    continue;
                }
                if (!(v instanceof List) || ((List)v).isEmpty()) continue;
                nestedFromParentConf.put(q, (List)v);
            }
        }
        it = this.stack.peek().getAttributes();
        while (it.hasNext()) {
            Attribute att = it.next();
            if (((HashMap)attValues).get(att.getName()) != null && !((String)((HashMap)attValues).get(att.getName())).isEmpty()) continue;
            attValues.put(att.getName(), att.getValue());
        }
        for (QName s : ((HashMap)attValues).keySet()) {
            String val = (String)((HashMap)attValues).get(s);
            if (GEN_PATTERN.matcher(val).find()) {
                if (this.isExternalized(this.extractNodeId(), this.extractSubParentNodeId(), s.getLocalPart()) && val != null && !val.isEmpty()) {
                    this.nextExternalizedValue(this.extractNodeId(), this.extractSubParentNodeId(), s.getLocalPart());
                }
                this.result.put(new Info(this.extractNodeId(), s.toString()), val);
                this.needGeneration = true;
            }
            if (nodeId != null && this.isExternalized(nodeId, subMdId, s.getLocalPart()) && val != null && !val.isEmpty()) {
                val = this.nextExternalizedValue(nodeId, subMdId, s.getLocalPart());
            }
            if (s.getPrefix() == null || s.getPrefix().isEmpty()) {
                this.writeAttribute(s.getLocalPart(), val, subMdId);
                continue;
            }
            this.writeAttribute(s.getPrefix(), s.getNamespaceURI(), s.getLocalPart(), val, subMdId);
        }
        HashSet<QName> nestedAttNames = new HashSet<QName>();
        for (XMLEvent s : nested) {
            this.write(s);
            if (!s.isStartElement()) continue;
            nestedAttNames.add(s.asStartElement().getName());
        }
        for (QName q : ((HashMap)nestedFromParentConf).keySet()) {
            if (nestedAttNames.contains(q)) continue;
            for (List l : (List)((HashMap)nestedFromParentConf).get(q)) {
                for (XMLEvent s : l) {
                    this.write(s);
                }
            }
        }
        this.needAttributeFlush.remove(this.stack.peek());
        return ev;
    }

    private void writeAttributes() throws XMLStreamException {
        if (this.stack.isEmpty()) {
            return;
        }
        StartElement start = this.stack.peek();
        if (this.needAttributeFlush.remove(start)) {
            Object o;
            Object val;
            HashMap<QName, Object> subMdParentConfValues = null;
            Attribute a = start.getAttributeByName(ATT_MD_REF_ID);
            if (a != null) {
                subMdParentConfValues = this.configurationStore.get(a.getValue());
            }
            Iterator<Namespace> ns = start.getNamespaces();
            while (ns.hasNext()) {
                Namespace n = ns.next();
                this.writer.writeNamespace(n.getPrefix(), n.getNamespaceURI());
            }
            HashMap<QName, String> attsValues = new HashMap<QName, String>();
            Iterator<Attribute> it = start.getAttributes();
            while (it.hasNext()) {
                Attribute att = it.next();
                attsValues.put(att.getName(), att.getValue());
                if (subMdParentConfValues == null || !((val = subMdParentConfValues.get(att.getName())) instanceof String) || ((String)val).isEmpty()) continue;
                attsValues.put(att.getName(), (String)val);
            }
            if (subMdParentConfValues != null) {
                for (QName k : subMdParentConfValues.keySet()) {
                    if (attsValues.get(k) != null || !((o = subMdParentConfValues.get(k)) instanceof String)) continue;
                    attsValues.put(k, (String)o);
                }
            }
            for (QName name : attsValues.keySet()) {
                String subMdId;
                Attribute attId;
                val = (String)attsValues.get(name);
                if (!((String)val).isEmpty() && this.hasNodeId() && GEN_PATTERN.matcher((CharSequence)val).find()) {
                    this.result.put(new Info(this.extractNodeId(), name.getLocalPart()), (String)val);
                    this.needGeneration = true;
                }
                String id = (attId = start.getAttributeByName(ATT_ID)) == null ? null : attId.getValue();
                Attribute subParentId = start.getAttributeByName(ATT_MD_REF_ID);
                String string = subMdId = subParentId == null ? null : subParentId.getValue();
                if (!this.inTech && id != null && this.isExternalized(id, subMdId, name.getLocalPart()) && val != null) {
                    val = this.nextExternalizedValue(id, subMdId, name.getLocalPart());
                }
                if (name.getPrefix() == null || name.getPrefix().isEmpty()) {
                    this.writeAttribute(name.getLocalPart(), (String)val, subMdId);
                    continue;
                }
                this.writeAttribute(name.getPrefix(), name.getNamespaceURI(), name.getLocalPart(), (String)val, subMdId);
            }
            if (subMdParentConfValues != null) {
                for (QName n : subMdParentConfValues.keySet()) {
                    o = subMdParentConfValues.get(n);
                    if (!(o instanceof List)) continue;
                    List ll = (List)o;
                    for (List l : ll) {
                        for (XMLEvent e : l) {
                            this.write(e);
                        }
                    }
                }
            }
        }
    }

    private void writeAttribute(String localName, String value, String subMdParentId) throws XMLStreamException {
        Attribute att;
        if (this.configurationValues != null && (att = this.stack.peek().getAttributeByName(ATT_ID)) != null) {
            String s = this.configurationValues.getProperty(att.getValue() + "/" + localName);
            if (s == null && subMdParentId != null) {
                s = this.configurationValues.getProperty(subMdParentId + "/" + localName);
            }
            if (s != null) {
                value = s;
            }
        }
        this.writer.writeAttribute(localName, value);
    }

    private void writeAttribute(String prefix, String namespaceURI, String localName, String value, String subMdParentId) throws XMLStreamException {
        Attribute att;
        if (this.configurationValues != null && (att = this.stack.peek().getAttributeByName(ATT_ID)) != null) {
            String s = this.configurationValues.getProperty(att.getValue() + "/" + localName);
            if (s == null && subMdParentId != null) {
                s = this.configurationValues.getProperty(subMdParentId + "/" + localName);
            }
            if (s != null) {
                value = s;
            }
        }
        this.writer.writeAttribute(prefix, namespaceURI, localName, value);
    }

    private void handleEnd(XMLEvent event) throws XMLStreamException {
        this.writeAttributes();
        if (!this.stack.isEmpty()) {
            StartElement start = this.stack.pop();
            this.writer.writeEndElement();
            this.needAttributeFlush.remove(start);
        }
    }

    private void handleEvent(XMLEvent ev) throws XMLStreamException {
        switch (this.currentEvent.getEventType()) {
            case 4: {
                this.handleCharacters(ev);
                break;
            }
            case 1: {
                this.handleStart(ev);
                break;
            }
            case 2: {
                this.handleEnd(ev);
                break;
            }
            case 7: {
                this.writer.writeStartDocument("UTF-8", "1.0");
                ev = this.reader.nextEvent();
                this.write(ev);
                break;
            }
            case 8: {
                this.writer.writeEndElement();
                this.writer.writeEndDocument();
            }
        }
    }

    public Map<Info, String> parse() throws XMLStreamException {
        while (this.reader.hasNext()) {
            this.currentEvent = this.reader.nextEvent();
            if (this.inTech) {
                this.write(this.currentEvent);
                continue;
            }
            this.handleEvent(this.currentEvent);
        }
        return this.result;
    }

    private void write(XMLEvent event) throws XMLStreamException {
        if (event.isEndElement()) {
            this.writer.writeEndElement();
        } else if (event.isStartElement()) {
            int i;
            Attribute a;
            StartElement s = event.asStartElement();
            if (!this.inTech && s.getName().getLocalPart().equals("metaDataLink") && (a = s.getAttributeByName(ATT_TRG)) != null && (i = a.getValue().indexOf("?fileId=")) > -1) {
                String f = a.getValue().substring(i);
                int end = f.indexOf("$");
                if (end == -1) {
                    end = f.indexOf("?");
                }
                String fileId = f.substring(0, end);
                this.requestedModels.add(fileId);
            }
            this.writer.writeStartElement(s.getName().getPrefix(), s.getName().getLocalPart(), s.getName().getNamespaceURI());
            Iterator<Namespace> ns = s.getNamespaces();
            while (ns.hasNext()) {
                Namespace n = ns.next();
                this.writer.writeNamespace(n.getPrefix(), n.getNamespaceURI());
            }
            Iterator<Attribute> it = s.getAttributes();
            while (it.hasNext()) {
                Attribute att = it.next();
                if (att.getName().getPrefix() == null || att.getName().getPrefix().isEmpty()) {
                    this.writer.writeAttribute(att.getName().getLocalPart(), att.getValue());
                    continue;
                }
                this.writer.writeAttribute(att.getName().getPrefix(), att.getName().getNamespaceURI(), att.getName().getLocalPart(), att.getValue());
            }
        } else if (event.isCharacters()) {
            Characters v = event.asCharacters();
            if (v.isCData()) {
                this.writer.writeCData(v.getData());
            } else {
                String val = v.getData();
                if (!val.isEmpty() && this.hasNodeId() && GEN_PATTERN.matcher(val).find()) {
                    this.result.put(new Info(this.extractNodeId(), ""), val);
                } else {
                    this.writer.writeCharacters(val);
                }
            }
        }
    }

    private boolean hasNodeId() {
        if (!this.stack.isEmpty()) {
            Attribute a = this.stack.peek().getAttributeByName(ATT_ID);
            return a != null;
        }
        return false;
    }

    private String extractNodeId() {
        Attribute a;
        if (!this.stack.isEmpty() && (a = this.stack.peek().getAttributeByName(ATT_ID)) != null) {
            return a.getValue();
        }
        return UUID.randomUUID().toString();
    }

    private String extractSubParentNodeId() {
        Attribute a;
        if (!this.stack.isEmpty() && (a = this.stack.peek().getAttributeByName(ATT_MD_REF_ID)) != null) {
            return a.getValue();
        }
        return null;
    }

    private String getCurrentPath() {
        StringBuffer buf = new StringBuffer("/md[1]");
        int i = 0;
        while (i < this.stack.size()) {
            buf.append("/" + ((StartElement)this.stack.get(i)).getName().toString() + "[@id='" + ((StartElement)this.stack.get(i)).getAttributeByName(ATT_ID).getValue() + "']");
            ++i;
        }
        return buf.toString();
    }

    private String nextExternalizedValue(String id, String subMdParentId, String attName) {
        Integer i = this.externalizedAttributesIndexes.get(id + "." + attName);
        if (i != null) {
            return this.externalizationPrefix + i + this.externalisationSuffix;
        }
        if (subMdParentId != null && (i = this.externalizedAttributesIndexes.get(subMdParentId + "." + attName)) != null) {
            return this.externalizationPrefix + i + this.externalisationSuffix;
        }
        String s = this.externalizationPrefix + ++this.externalizationVarIndex + this.externalisationSuffix;
        this.externalizedAttributesIndexes.put(id + "." + attName, this.externalizationVarIndex);
        return s;
    }

    private boolean isExternalized(String id, String subMdParentId, String attName) {
        Collection<String> discardedByConf;
        Collection<String> inheritedAttsName;
        if (this.externalizedAttributes == null) {
            return false;
        }
        boolean b = this.externalizedAttributes.contains(id + "." + attName);
        if (!(b || subMdParentId == null || this.inheritedAttributesPerNode == null || (inheritedAttsName = this.inheritedAttributesPerNode.get(id)) == null || !inheritedAttsName.contains(attName) || (discardedByConf = this.discardedByConfigurationChildNodes.get(id)) != null && discardedByConf.contains(attName))) {
            b = this.externalizedAttributes.contains(subMdParentId + "." + attName);
        }
        return b;
    }

    public class Info {
        String nodeId;
        String attributeName;
        String nodePath;
        String xmlEntityType;

        Info(String nodeId, String attributeName) {
            this.nodeId = nodeId;
            this.nodePath = MdXmlParser.this.getCurrentPath();
            this.attributeName = attributeName;
            this.xmlEntityType = attributeName == null || attributeName.isEmpty() ? "text" : "attribute";
        }

        public String getNodePath() {
            return this.nodePath;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public String getNodeId() {
            return this.nodeId;
        }

        public String getXMLEntityType() {
            return this.xmlEntityType;
        }
    }
}

