/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.xsl.global;

import com.indy.libraries.build.parser.sql.OuterModificator;
import com.indy.libraries.build.parser.sql.RemoveAndRestoreVarTags;
import com.indy.libraries.build.utils.ParsingUtils;
import com.indy.libraries.build.utils.StringUtils;
import com.indy.libraries.build.utils.XSLException;
import com.semarchy.xdi.designer.generation.xsl.DiagnosticException;
import com.semarchy.xdi.designer.generation.xsl.gene.StackedVariableManager;
import com.semarchy.xdi.designer.generation.xsl.gene.process.Graph;
import com.semarchy.xdi.designer.generation.xsl.gene.process.internal.OneProcCompilation;
import com.semarchy.xdi.designer.generation.xsl.global.Messages;
import com.semarchy.xdi.designer.generation.xsl.global.Strings;
import com.semarchy.xdi.designer.generation.xsl.global.Variables;
import com.semarchy.xdi.designer.generation.xsl.global.XPathEvaluatorI;
import com.semarchy.xdi.designer.generation.xsl.global.Xpath;
import com.semarchy.xdi.designer.generation.xsl.global.XpathCache;
import com.semarchy.xdi.designer.generation.xsl.saxon.extension.impl.Configuration4Generation;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathVariableResolver;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.ParseException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathEvaluator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Functions {
    private static Logger logger = LogManager.getLogger(Functions.class);
    public static final Functions INSTANCE = new Functions();
    private static Map<String, String> memoryCache;
    public static NodeInfo mapper;
    private static Map<String, String> memoryCache2;
    private static Map<String, String> memoryCache3;
    static final Pattern PATTERN_XPATH_VARIABLE;
    private static final HashMap<Configuration, XPathEvaluatorI> evaluatorWithControllerMap;
    private static final HashMap<Configuration, XPathEvaluatorI> evaluatorWithoutControllerMap;
    static Map<String, NodeInfo> mapLevel;
    public static TreeMap<String, String> xpathPatternMapper;
    public static TreeMap<String, NodeInfo> xpathExpressionCache;
    private static TreeMap<String, List> refCache;
    static Map<DocumentInfo, Map<String, List>> cachedObjectsByIds;

    static {
        PATTERN_XPATH_VARIABLE = Pattern.compile("\\$[a-zA-Z0-9_]*");
        evaluatorWithControllerMap = new HashMap();
        evaluatorWithoutControllerMap = new HashMap();
        mapLevel = new TreeMap<String, NodeInfo>();
        cachedObjectsByIds = new HashMap<DocumentInfo, Map<String, List>>();
    }

    public static boolean isNode(ValueRepresentation value) {
        return !(value instanceof StringValue) && !(value instanceof Orphan);
    }

    public static void setMemoryCache(Map<String, String> map) {
        memoryCache = map;
    }

    public static void setMemoryCache2(Map<String, String> map) {
        memoryCache2 = map;
    }

    public static void setMemoryCache3(Map<String, String> map) {
        memoryCache3 = map;
    }

    public static String addFilterOuterWord(String expression, String outerWOrd, List<String> aliasList) throws XSLException, ParseException {
        String result = expression;
        try {
            result = OuterModificator.addFilterOuterWord((String)expression, (String)outerWOrd, aliasList);
        }
        catch (Exception e) {
            throw new XSLException(String.format("Failed to add outer word on filter expression %s.", expression), (Throwable)e);
        }
        return result;
    }

    public static String addJoinOuterWord(String expression, String outerWOrd, String innerAlias, String outerAlias) throws JSQLParserException, ParseException, XSLException {
        String result = expression;
        try {
            result = OuterModificator.addJoinOuterWord((String)expression, (String)outerWOrd, (String)innerAlias, (String)outerAlias);
        }
        catch (Exception e) {
            throw new XSLException(String.format("Failed to add outer word on join expression %s.", expression), (Throwable)e);
        }
        return result;
    }

    public static List xpath(XPathContext c, ValueRepresentation context) throws XPathExpressionException, XPathException, TransformerException, XSLException, URISyntaxException {
        return Functions.xpath(c, context, null);
    }

    public static List xpath(XPathContext c, ValueRepresentation context, String code) throws XPathExpressionException, XPathException, TransformerException, XSLException, URISyntaxException {
        return Xpath.call(c, context, code);
    }

    public static List xpath(XPathContext c, ValueRepresentation context, String motif, ValueRepresentation param1) throws XPathExpressionException, TransformerException, XSLException, URISyntaxException {
        return Xpath.call(c, context, motif, param1);
    }

    public static List xpath(XPathContext c, ValueRepresentation context, String motif, ValueRepresentation param1, ValueRepresentation param2) throws XPathExpressionException, TransformerException, XSLException, URISyntaxException {
        return Xpath.call(c, context, motif, param1, param2);
    }

    public static List findMetaDataRef(NodeInfo context, String name) throws XPathExpressionException, TransformerException, URISyntaxException {
        XPathEvaluatorI e = Functions.getXPathEvaluator(context, null);
        return Functions.findMetaDataRef(context, name, e);
    }

    public static List getMdRef(XPathContext context, NodeInfo node, String mdLinkName) throws XPathExpressionException, TransformerException, URISyntaxException {
        XPathEvaluatorI e = Functions.getXPathEvaluator(node, context != null ? context.getController() : null);
        return Functions.findMetaDataRef(context, node, mdLinkName, e);
    }

    @Deprecated
    public static List findMetaDataRef(NodeInfo context, String name, XPathEvaluator e) throws XPathExpressionException, TransformerException, URISyntaxException {
        return Functions.findMetaDataRef(null, context, name, e);
    }

    public static List findMetaDataRef(XPathContext ctx, NodeInfo context, String name, XPathEvaluator e) throws XPathExpressionException, TransformerException, URISyntaxException {
        String localName = name.replaceAll("\\$", "");
        NodeInfo metaDataLink = (NodeInfo)e.evaluate("ancestor-or-self::*[exists(metaDataLink[@name='" + localName + "'])][1]/metaDataLink[@name='" + localName + "'][1]", (Object)context, XPathConstants.NODE);
        if (metaDataLink != null) {
            List retour = Functions.getMetaDataRef(ctx, metaDataLink);
            return retour;
        }
        return null;
    }

    public static List getMetaDataRef(XPathContext ctx, NodeInfo metaDataLink) throws XPathExpressionException, TransformerException, URISyntaxException {
        XPathEvaluatorI e = Functions.getXPathEvaluator(metaDataLink, ctx == null ? null : ctx.getController());
        String file = e.evaluate("substring-before(@target,'#')", metaDataLink);
        String id = e.evaluate("substring-after(@target,'#')", metaDataLink);
        return Functions.getRef(ctx, metaDataLink, file, id, e);
    }

    public static List getMdRef(XPathContext c, NodeInfo metaDataLink) throws XPathExpressionException, TransformerException, URISyntaxException {
        return Functions.getMetaDataRef(c, metaDataLink);
    }

    public static List getRef(XPathContext cts, NodeInfo context, String path) throws XPathExpressionException, XPathException, TransformerException, URISyntaxException {
        if (path.indexOf("#") > -1) {
            String file = path;
            file = Functions.findURIByMemoryCache(file);
            file = file.substring(0, file.indexOf("#"));
            String id = path.substring(path.indexOf("#") + 1, path.length());
            return Functions.getRef(cts, context, file, id, Functions.getXPathEvaluator(context, cts == null ? null : cts.getController()));
        }
        return null;
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, XPathVariableResolver xPathVariableResolver) throws XPathException, XPathExpressionException, XSLException {
        return (List)Functions.evaluate(c, context, expr, XPathConstants.NODESET, xPathVariableResolver);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr) throws XPathException, XPathExpressionException, XSLException {
        return (List)Functions.evaluate(c, context, expr, XPathConstants.NODESET);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, ValueRepresentation p1) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, p1, null, null, null, null, null, null, null, null);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, ValueRepresentation p1, ValueRepresentation p2) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, p1, p2, null, null, null, null, null, null, null);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, p1, p2, p3, null, null, null, null, null, null);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, p1, p2, p3, p4, null, null, null, null, null);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4, ValueRepresentation p5) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, p1, p2, p3, p4, p5, null, null, null, null);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4, ValueRepresentation p5, ValueRepresentation p6) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, p1, p2, p3, p4, p5, p6, null, null, null);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4, ValueRepresentation p5, ValueRepresentation p6, ValueRepresentation p7) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, p1, p2, p3, p4, p5, p6, p7, null, null);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4, ValueRepresentation p5, ValueRepresentation p6, ValueRepresentation p7, ValueRepresentation p8) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, p1, p2, p3, p4, p5, p6, p7, p8, null);
    }

    public static List evaluate(XPathContext c, NodeInfo context, String expr, final ValueRepresentation p1, final ValueRepresentation p2, final ValueRepresentation p3, final ValueRepresentation p4, final ValueRepresentation p5, final ValueRepresentation p6, final ValueRepresentation p7, final ValueRepresentation p8, final ValueRepresentation p9) throws XPathException, XPathExpressionException, XSLException {
        return (List)Functions.evaluate(c, context, expr, XPathConstants.NODESET, new XPathVariableResolver(){

            @Override
            public Object resolveVariable(QName variableName) {
                String v = variableName.getLocalPart();
                if (v.equals("p1")) {
                    return p1;
                }
                if (v.equals("p2")) {
                    return p2;
                }
                if (v.equals("p3")) {
                    return p3;
                }
                if (v.equals("p4")) {
                    return p4;
                }
                if (v.equals("p5")) {
                    return p5;
                }
                if (v.equals("p6")) {
                    return p6;
                }
                if (v.equals("p7")) {
                    return p7;
                }
                if (v.equals("p8")) {
                    return p8;
                }
                if (v.equals("p9")) {
                    return p9;
                }
                return null;
            }
        });
    }

    public static String evaluateXPathVariableExpression(XPathContext ctx, String expression) {
        String s = new String(expression);
        StringBuilder buf = new StringBuilder();
        Matcher m = PATTERN_XPATH_VARIABLE.matcher(s);
        int lastIndex = 0;
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            buf.append(s.substring(lastIndex, start));
            lastIndex = end;
            String varName = s.substring(start, end);
            StringBuilder b = new StringBuilder(varName);
            int i = end;
            Character c = null;
            while (i < s.length() && !Character.isWhitespace((c = Character.valueOf(s.charAt(i++))).charValue())) {
                b.append(c);
            }
            try {
                List l = Functions.evaluate(ctx, (NodeInfo)ctx.getContextItem(), b.toString());
                if (l != null && !l.isEmpty()) {
                    for (Object o : l) {
                        if (o instanceof NodeInfo) {
                            buf.append(((NodeInfo)o).getStringValue());
                            continue;
                        }
                        buf.append(o.toString());
                    }
                    if (c != null && i < s.length()) {
                        buf.append(c);
                    }
                } else {
                    buf.append(s.substring(start));
                }
            }
            catch (Exception ex) {
                buf.append(s.substring(start));
            }
            s = s.substring(i);
            m.reset(s);
            lastIndex = 0;
        }
        return buf.toString();
    }

    public static Object evaluate(XPathContext c, NodeInfo context, String expr, QName mode) throws XPathException, XPathExpressionException, XSLException {
        return Functions.evaluate(c, context, expr, mode, null);
    }

    public static boolean evaluateCondition(XPathContext c, NodeInfo oneProcNode, Object expr) throws XPathException, XSLException {
        try {
            Object o = Functions._evaluate(c, oneProcNode, (String)expr, XPathConstants.BOOLEAN, null, false);
            if (o instanceof AtomicValue) {
                return ((AtomicValue)o).effectiveBooleanValue();
            }
            return o != null;
        }
        catch (Throwable ex) {
            Graph.Node n = null;
            try {
                String nodeId = (String)Functions._evaluate(c, (NodeInfo)c.getContextItem(), "@srcId", XPathConstants.STRING, null, true);
                n = Graph.getCurrentGraph().getNodeBySrcId(nodeId);
            }
            catch (Exception e) {
                logger.error("Failed to evaluate condition {}", expr, (Object)e);
            }
            if (n != null) {
                throw new DiagnosticException(String.format(Messages.Functions_0, n.getDiagnosticPath()), ex);
            }
            if (ex instanceof XPathException) {
                throw (XPathException)ex;
            }
            if (ex instanceof XSLException) {
                throw (XSLException)ex;
            }
            throw new XPathException(ex);
        }
    }

    public static XPathEvaluatorI getXPathEvaluator(NodeInfo context, Controller controller) throws XPathException {
        if (controller != null) {
            XPathEvaluatorI evaluatorWithController = evaluatorWithControllerMap.get(context.getConfiguration());
            if (evaluatorWithController == null) {
                evaluatorWithController = new XPathEvaluatorI((Source)context);
                evaluatorWithController.initNamespaces();
                evaluatorWithController.setXPathVariableResolver(new EvaluationVariableResolver());
                evaluatorWithController.initControler(controller);
                evaluatorWithControllerMap.put(context.getConfiguration(), evaluatorWithController);
            }
            if (evaluatorWithController.controller != controller) {
                evaluatorWithController.initControler(controller);
            }
            return evaluatorWithController;
        }
        XPathEvaluatorI evaluatorWithoutController = evaluatorWithoutControllerMap.get(context.getConfiguration());
        evaluatorWithoutController = new XPathEvaluatorI((Source)context);
        evaluatorWithoutController.initNamespaces();
        evaluatorWithoutController.setXPathVariableResolver(new EvaluationVariableResolver());
        evaluatorWithoutControllerMap.put(context.getConfiguration(), evaluatorWithoutController);
        return evaluatorWithoutController;
    }

    public static Object _evaluate(XPathContext c, NodeInfo context, String expr, QName mode, XPathVariableResolver xPathVariableResolver, boolean doJavaConversion) throws XPathException, XSLException {
        XPathEvaluatorI e = Functions.getXPathEvaluator(context, c.getController());
        try {
            ((EvaluationVariableResolver)e.getXPathVariableResolver()).pushContext(c, context, c.getStackFrame(), xPathVariableResolver);
            Object object = e.evaluate2(expr, context, mode, doJavaConversion);
            ((EvaluationVariableResolver)e.getXPathVariableResolver()).popContext();
            return object;
        }
        catch (Throwable throwable) {
            try {
                ((EvaluationVariableResolver)e.getXPathVariableResolver()).popContext();
                throw throwable;
            }
            catch (XPathExpressionException e1) {
                String id = Navigator.getAttributeValue((NodeInfo)context, null, (String)"id");
                XSLException ex = new XSLException(String.format(Messages.Functions_4, expr, e1.getCause(), context.getBaseURI(), id), (Throwable)e1);
                throw ex;
            }
        }
    }

    public static Object evaluate(XPathContext c, NodeInfo context, String expr, QName mode, XPathVariableResolver xPathVariableResolver) throws XPathException, XPathExpressionException, XSLException {
        return Functions._evaluate(c, context, expr, mode, xPathVariableResolver, true);
    }

    private static String findURIByMemoryCache(String uri) throws XPathExpressionException {
        String tmp = uri;
        if (tmp != null && tmp.contains("#") && memoryCache != null) {
            if (tmp.contains("fileId=")) {
                tmp = tmp.substring(tmp.indexOf("fileId=") + 7);
            }
            if (tmp.contains("$")) {
                tmp = tmp.substring(0, tmp.indexOf("$"));
            } else if (tmp.contains("?")) {
                tmp = tmp.substring(0, tmp.indexOf("?"));
            }
            String retour = memoryCache.get(tmp);
            if (retour != null) {
                return retour;
            }
        }
        return uri;
    }

    public static String findURIByFileId(String id) {
        return memoryCache2.get(id);
    }

    public static String findURIByFileId(String id, boolean absoluth) {
        if (absoluth) {
            return memoryCache2.get(id);
        }
        return memoryCache3.get(id);
    }

    public static List getRef(XPathContext c, NodeInfo context) throws XPathExpressionException, XPathException, TransformerException, URISyntaxException {
        if (context != null && context.getStringValue() != null && !context.getStringValue().isEmpty()) {
            String str = context.getStringValue();
            if (str.indexOf("#") > -1) {
                if (str.indexOf("#") > 0) {
                    return Functions.getRef(c, context, str);
                }
                return Functions.getLocalRef(c, context, str.substring(1));
            }
            return Functions.getLocalRef(c, context, context.getStringValue());
        }
        return null;
    }

    public static List getLevel(XPathContext ctx, NodeInfo context) throws XPathExpressionException, TransformerException {
        String defType = Navigator.getAttributeValue((NodeInfo)context, null, (String)"defType");
        return Functions.getLevel(ctx, context, defType);
    }

    public static List getLevel(XPathContext ctx, NodeInfo context, String defType) throws XPathExpressionException, TransformerException {
        String key;
        NodeInfo level;
        XPathEvaluatorI e = Functions.getXPathEvaluator(context, ctx == null ? null : ctx.getController());
        if (defType == null) {
            defType = e.evaluate("@defType", context);
        }
        if ((level = mapLevel.get(key = defType + "/" + context.getBaseURI())) != null && level.getConfiguration().isCompatible(context.getConfiguration())) {
            ArrayList<NodeInfo> list = new ArrayList<NodeInfo>();
            list.add(level);
            return list;
        }
        List result = (List)e.evaluate("/md/*/level[@code='" + defType + "'][1]", context, XPathConstants.NODESET);
        if (result.size() == 1) {
            mapLevel.put(key, (NodeInfo)result.get(0));
        }
        return result;
    }

    public static List getLevelByRef(XPathContext ctx, NodeInfo context, String defType) throws XPathExpressionException, TransformerException, URISyntaxException {
        String str;
        NodeInfo level;
        XPathEvaluatorI e = Functions.getXPathEvaluator(context, ctx == null ? null : ctx.getController());
        if (defType == null || defType.equals("")) {
            defType = e.evaluate("@defType", context);
        }
        if ((level = mapLevel.get(defType)) != null && level.getConfiguration().isCompatible(context.getConfiguration())) {
            ArrayList<NodeInfo> list = new ArrayList<NodeInfo>();
            list.add(level);
            return list;
        }
        List result = (List)e.evaluate("/*/level[@code='" + defType + "'][1]", context, XPathConstants.NODESET);
        if (result != null && result.isEmpty() && (str = e.evaluate("ancestor-or-self::*/@md:ref[1]", context)) != null && (result = Functions.getRef(null, context, str)) != null && !result.isEmpty()) {
            return Functions.getLevelByRef(ctx, (NodeInfo)result.get(0), defType);
        }
        if (result != null && result.size() == 1) {
            mapLevel.put(defType, (NodeInfo)result.get(0));
        }
        return result;
    }

    public static List getAncestorOrSelf(XPathContext ctx, NodeInfo context, String expression) throws XPathExpressionException, TransformerException, URISyntaxException {
        XPathEvaluatorI e = Functions.getXPathEvaluator(context, ctx == null ? null : ctx.getController());
        List result = (List)e.evaluate("ancestor-or-self::" + expression, context, XPathConstants.NODESET);
        if (result.size() == 0) {
            String str = e.evaluate("ancestor-or-self::*/@md:ref[1]", context);
            if (str == null || str.equals("")) {
                str = e.evaluate("ancestor-or-self::*/@ref[1]", context);
            }
            if (str != null && (result = Functions.getRef(ctx, context, str)) != null && result.size() > 0) {
                return Functions.getAncestorOrSelf(ctx, (NodeInfo)result.get(0), expression);
            }
        }
        return result;
    }

    public static List getRef(XPathContext ctx, NodeInfo context, String file, String id, XPathEvaluator e) throws XPathExpressionException, TransformerException, URISyntaxException {
        file = file.replace(" ", "%20");
        String documentKey = Functions.getDocumentKey(context, file);
        if (refCache != null) {
            List tmp = refCache.get(id + "#" + documentKey);
            if (tmp != null && !tmp.isEmpty() && !((NodeInfo)tmp.get(0)).getConfiguration().isCompatible(context.getConfiguration())) {
                tmp = null;
                refCache.remove(id + "#" + documentKey);
            }
            if (tmp != null) {
                return tmp;
            }
        }
        DocumentInfo doc = null;
        try {
            doc = Functions.document(ctx, context, file);
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
        if (doc != null) {
            List result = Functions.getLocalRef(ctx, (NodeInfo)doc, id);
            if (result == null) {
                return null;
            }
            if (refCache != null) {
                refCache.put(id + "#" + documentKey, result);
            }
            return result;
        }
        return null;
    }

    public static void clear() {
        cachedObjectsByIds.clear();
        evaluatorWithControllerMap.clear();
        evaluatorWithoutControllerMap.clear();
        cachedObjectsByIds.clear();
    }

    private static List getLocalRef(XPathContext ctx, NodeInfo context, String id) throws XPathExpressionException, TransformerException {
        if (id != null && !id.isEmpty()) {
            List o;
            Map<String, List> m = cachedObjectsByIds.get(context.getDocumentRoot());
            if (m == null) {
                m = new HashMap<String, List>();
                cachedObjectsByIds.put(context.getDocumentRoot(), m);
            }
            if ((o = m.get(id)) == null) {
                List result;
                XPathEvaluatorI e = Functions.getXPathEvaluator(context, ctx == null ? null : ctx.getController());
                if (id.contains("?")) {
                    id = id.substring(0, id.indexOf("?"));
                }
                o = result = (List)e.evaluate("//*[@id='" + id + "'][1]", context, XPathConstants.NODESET);
                m.put(id, result);
            }
            return o;
        }
        return null;
    }

    public static String translateExpToXsl(String string) {
        String _return = string;
        HashSet<String> ht = new HashSet<String>();
        ht.add("INS");
        ht.add("UPD");
        ht.add("TRG");
        ht.add("WRK");
        ht.add("SRC");
        ht.add("UK");
        ht.add("PK");
        ht.add("REW");
        ht.add("MAP");
        for (String elt : ht) {
            String elt2 = "%" + elt + "%";
            String elt3 = "\u00a43\u00a4";
            _return = _return.replaceAll("'" + elt + "'", elt3);
            String elt4 = "\u00a44\u00a4";
            _return = _return.replaceAll("\\[" + elt + "\\]", elt4);
            _return = _return.replaceAll(elt, elt2);
            _return = _return.replaceAll("!" + elt2, "not([" + elt + "])");
            _return = _return.replaceAll("!\\(" + elt2 + "\\)", "not([" + elt + "])");
            _return = _return.replaceAll("NOT " + elt2, "not([" + elt + "])");
            _return = _return.replaceAll(elt2, " [" + elt + "] ");
            _return = _return.replaceAll(elt3, "'" + elt + "'");
            _return = _return.replaceAll(elt4, "[" + elt + "]");
        }
        _return = _return.replaceAll(" AND ", " and ");
        _return = _return.replaceAll(" OR ", " or ");
        return _return;
    }

    public static String addFileScheme(String path) throws URISyntaxException {
        String path2 = path.replace('\\', '/');
        if (path2.indexOf(":") == 1) {
            return "file:/" + path2;
        }
        if (path2.startsWith("file:/")) {
            return path2;
        }
        if (path2.startsWith("/")) {
            return "file:" + URLEncoder.encode(path2.replace("%20", " ")).replace("%2F", "/").replace("+", "%20");
        }
        return "file:/" + URLEncoder.encode(path2.replace("%20", " ")).replace("%2F", "/").replace("+", "%20");
    }

    private static URI pathToURI(String path) throws URISyntaxException {
        return new URI(OneProcCompilation.formatURI(Functions.addFileScheme(path)));
    }

    public static String relativizeURI(String baseUriAsString, String suppliedUriAsString) throws URISyntaxException {
        URI baseURI = new URI(OneProcCompilation.formatURI(baseUriAsString)).normalize();
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (i < Path.of(baseURI).getNameCount() - 1) {
            b.append("../");
            ++i;
        }
        URI suppliedURI = new URI(OneProcCompilation.formatURI(suppliedUriAsString)).normalize();
        b.append(suppliedURI.getPath().substring(1));
        return b.toString();
    }

    public static String normalizeURI(String path1) throws URISyntaxException {
        URI uri = Functions.pathToURI(path1.replace(" ", "%20")).normalize();
        return uri.toString();
    }

    public static String resolveURI(String uri) {
        return OneProcCompilation.unformatURI(uri);
    }

    public static String getFileInfo(String path, String infoName) throws URISyntaxException {
        URI uri = Functions.pathToURI(path.replace(" ", "%20").replace("//", "/").replace("\\\\", "/"));
        if (infoName.equals("name")) {
            return new File(uri).getName();
        }
        if (infoName.equals("exists")) {
            return new File(uri).exists() ? "true" : "false";
        }
        if (infoName.equals("parent")) {
            return new File(uri).getParent();
        }
        if (infoName.equals("extension")) {
            String str = new File(uri).getName();
            return str.lastIndexOf(".") > -1 ? str.substring(str.lastIndexOf(".") + 1) : "";
        }
        return null;
    }

    public static String[] motifList(String vExpression, String pattern) {
        return StringUtils.motifList((String)vExpression, (String)pattern);
    }

    public static String resolveExpressionValue(NodeInfo node) throws XPathException, XPathExpressionException {
        String[] list;
        String vExpression;
        XPathEvaluatorI e = Functions.getXPathEvaluator(node, null);
        String ret = vExpression = node.getStringValue();
        String[] stringArray = list = ParsingUtils.variableList$((String)vExpression);
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String paramName = stringArray[n2];
            String value = e.evaluate("ancestor::*/parameter[@name='" + paramName + "'][1]/@value", node);
            if (value != null && value.equals("")) {
                value = "";
            }
            if (value != null) {
                value = value.replaceAll("\\$", "\u00b5\u00a4\u00b5\u00a4");
                ret = ret.replaceAll("\\$\\{" + paramName + "\\}\\$", value);
                ret = ret.replaceAll("\u00b5\u00a4\u00b5\u00a4", "\\$");
            }
            ++n2;
        }
        return ret;
    }

    /*
     * Loose catch block
     */
    public static String includeFile(String relativePath, String currentPath) throws URISyntaxException, IOException {
        Object path = currentPath + relativePath;
        path = OneProcCompilation.formatURI((String)path);
        URI uri = new URI((String)path);
        uri = uri.normalize();
        File file = new File(uri);
        Throwable throwable = null;
        Object var6_7 = null;
        try (FileInputStream fis = new FileInputStream(file);){
            String string;
            BufferedInputStream bis;
            Throwable throwable2;
            block30: {
                throwable2 = null;
                Object var9_12 = null;
                bis = new BufferedInputStream(fis);
                StringBuilder sb = new StringBuilder();
                Throwable throwable3 = null;
                Object var13_18 = null;
                try (InputStreamReader isr = new InputStreamReader((InputStream)bis, System.getProperty("file.encoding"));){
                    int count = 0;
                    char[] chars = new char[8192];
                    int position = 0;
                    do {
                        sb.append(chars, position, count);
                        position = count;
                    } while ((count = isr.read(chars)) != -1);
                }
                catch (Throwable throwable4) {
                    if (throwable3 == null) {
                        throwable3 = throwable4;
                    } else if (throwable3 != throwable4) {
                        throwable3.addSuppressed(throwable4);
                    }
                    throw throwable3;
                }
                string = sb.toString();
                if (bis == null) break block30;
                bis.close();
            }
            return string;
            {
                catch (Throwable throwable5) {
                    try {
                        if (bis != null) {
                            bis.close();
                        }
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        if (throwable2 == null) {
                            throwable2 = throwable6;
                        } else if (throwable2 != throwable6) {
                            throwable2.addSuppressed(throwable6);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        catch (Throwable throwable7) {
            if (throwable == null) {
                throwable = throwable7;
            } else if (throwable != throwable7) {
                throwable.addSuppressed(throwable7);
            }
            throw throwable;
        }
    }

    public static String replaceAll(String str, String target, String replacement) {
        return StringUtils.replaceAll((String)str, (String)target, (String)replacement);
    }

    public static String replaceAll(String src, String[] regexp, String[] replacement) {
        return StringUtils.replaceAll((String)src, (String[])regexp, (String[])replacement);
    }

    public static String replaceAll2(String src, String regex1, String regex2, String replacement) {
        return Strings.replaceAll2(src, regex1, regex2, replacement);
    }

    public static NodeInfo xpathCache(XPathContext c, NodeInfo convertFile, String query) throws XPathExpressionException {
        return XpathCache.xpathCache(c, convertFile, query);
    }

    public static NodeInfo xpathCache(XPathContext c, String query) throws XPathExpressionException {
        return XpathCache.xpathCache(c, query);
    }

    public static void resetXpathCache() {
        XpathCache.resetXpathCache();
    }

    private static String getDocumentKey(NodeInfo context, String file) throws URISyntaxException {
        URI BaseUri = Functions.pathToURI(context.getBaseURI());
        URI uri2 = BaseUri.resolve(OneProcCompilation.formatURI(file));
        return uri2.toString().replace("%5B", "[").replace("%5D", "]").replace("%25", "%");
    }

    public static DocumentInfo document(XPathContext ctx, NodeInfo context, String file) throws URISyntaxException, TransformerException {
        String documentKey = Functions.getDocumentKey(context, (String)file);
        URI uri = new URI(OneProcCompilation.formatURI(documentKey));
        DocumentInfo doc = null;
        if (!new File(uri).exists() && context.getConfiguration() instanceof Configuration4Generation) {
            file = (String)file + ".tmp";
            documentKey = Functions.getDocumentKey(context, (String)file);
        }
        if ((doc = context.getConfiguration().getGlobalDocumentPool().find(documentKey)) == null && ctx != null) {
            doc = ctx.getController().getDocumentPool().find(documentKey);
        }
        if (doc == null) {
            Source source = context.getConfiguration().getURIResolver().resolve((String)file, context.getBaseURI());
            try {
                doc = context.getConfiguration().buildDocument(source);
            }
            catch (Exception ex) {
                throw new TransformerException(ex);
            }
        }
        if (doc != null) {
            context.getConfiguration().getGlobalDocumentPool().add(doc, documentKey);
        }
        return doc;
    }

    public static void resetXpathPatternMapper() {
        xpathPatternMapper = null;
    }

    public static void resetXpathExpressionCache() {
        xpathExpressionCache = new TreeMap();
    }

    public static void resetRefCache() {
        refCache = new TreeMap();
    }

    public static void resetMapLevel() {
        mapLevel = new TreeMap<String, NodeInfo>();
    }

    public static String pattern(XPathContext c, String pattern) {
        return Functions.pattern(c, pattern, null);
    }

    public static String pattern(XPathContext c, String pattern, ValueRepresentation p1) {
        return Functions.pattern(c, pattern, p1, null, null, null, null, null, null, null, null);
    }

    public static String pattern(XPathContext c, String pattern, ValueRepresentation p1, ValueRepresentation p2) {
        return Functions.pattern(c, pattern, p1, p2, null, null, null, null, null, null, null);
    }

    public static String pattern(XPathContext c, String pattern, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3) {
        return Functions.pattern(c, pattern, p1, p2, p3, null, null, null, null, null, null);
    }

    public static String pattern(XPathContext c, String pattern, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4) {
        return Functions.pattern(c, pattern, p1, p2, p3, p4, null, null, null, null, null);
    }

    public static String pattern(XPathContext c, String pattern, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4, ValueRepresentation p5) {
        return Functions.pattern(c, pattern, p1, p2, p3, p4, p5, null, null, null, null);
    }

    public static String pattern(XPathContext c, String pattern, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4, ValueRepresentation p5, ValueRepresentation p6) {
        return Functions.pattern(c, pattern, p1, p2, p3, p4, p5, p6, null, null, null);
    }

    public static String pattern(XPathContext c, String pattern, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4, ValueRepresentation p5, ValueRepresentation p6, ValueRepresentation p7) {
        return Functions.pattern(c, pattern, p1, p2, p3, p4, p5, p6, p7, null, null);
    }

    public static String pattern(XPathContext c, String pattern, ValueRepresentation p1, ValueRepresentation p2, ValueRepresentation p3, ValueRepresentation p4, ValueRepresentation p5, ValueRepresentation p6, ValueRepresentation p7, ValueRepresentation p8) {
        return Functions.pattern(c, pattern, p1, p2, p3, p4, p5, p6, p7, p8, null);
    }

    public static String pattern(XPathContext c, String pattern, XPathVariableResolver xPathVariableResolver) {
        if (pattern != null && !pattern.equals("")) {
            Object value;
            String code;
            String[] list;
            RemoveAndRestoreVarTags rarsc = new RemoveAndRestoreVarTags(pattern);
            pattern = rarsc.remove();
            String startAcc = "\u00a4\u20ac\u20ac\u00a4";
            String endAcc = "\u00a4\u00a3\u00a3\u00a4";
            String startCroch = "\u00a4\u20ac\u00a3\u00a4";
            String endCroch = "\u00a4\u00a3\u20ac\u00a4";
            pattern = pattern.replaceAll("\\{\\{", startAcc);
            pattern = pattern.replaceAll("\\}\\}", endAcc);
            String[] stringArray = list = Functions.motifList(pattern, "\\{[^}]*\\}");
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                code = stringArray[n2];
                List _value = null;
                if (c.getContextItem() instanceof NodeInfo) {
                    try {
                        _value = Functions.evaluate(c, (NodeInfo)c.getContextItem(), code, xPathVariableResolver);
                    }
                    catch (XSLException | XPathExpressionException | XPathException e) {
                        logger.error("Failed to evaluate pattern {}", (Object)code, (Object)e);
                    }
                }
                value = "";
                if (_value instanceof List) {
                    for (Object elt : (List)_value) {
                        if (elt instanceof ValueRepresentation) {
                            try {
                                value = (String)value + ((ValueRepresentation)elt).getStringValue();
                            }
                            catch (XPathException e) {
                                logger.error("unexpected", (Object)code, (Object)e);
                            }
                            continue;
                        }
                        value = (String)value + elt.toString();
                    }
                } else if (_value instanceof String) {
                    value = (String)((Object)_value);
                } else if (_value != null) {
                    value = _value.toString();
                }
                value = ((String)value).replaceAll("\\[", startCroch);
                value = ((String)value).replaceAll("\\]", endCroch);
                pattern = Functions.replaceAll(pattern, "\\{" + ParsingUtils.replaceRegexpString((String)code) + "\\}", (String)value);
                ++n2;
            }
            pattern = pattern.replaceAll("\\[\\[", startCroch);
            pattern = pattern.replaceAll("\\]\\]", endCroch);
            stringArray = list = Functions.motifList(pattern, "\\[[^]]*\\]");
            n = list.length;
            n2 = 0;
            while (n2 < n) {
                code = stringArray[n2];
                List _list = null;
                if (c.getContextItem() instanceof NodeInfo) {
                    try {
                        _list = Functions.evaluate(c, (NodeInfo)c.getContextItem(), "mdj:xpath(.,'[" + code + "]')");
                    }
                    catch (XSLException | XPathExpressionException | XPathException e) {
                        logger.error("Failed to evaluate xPath {}", (Object)code, (Object)e);
                    }
                }
                value = _list != null && _list.size() > 0 ? _list.get(0) : "";
                String tmp = value.toString();
                pattern = Functions.replaceAll(pattern, "\\[" + ParsingUtils.replaceRegexpString((String)code) + "\\]", tmp);
                ++n2;
            }
            pattern = rarsc.restore(pattern);
            pattern = pattern.replaceAll(startAcc, "{");
            pattern = pattern.replaceAll(endAcc, "}");
            pattern = pattern.replaceAll(startCroch, "[");
            pattern = pattern.replaceAll(endCroch, "]");
        }
        return pattern;
    }

    public static String pattern(XPathContext c, String pattern, final ValueRepresentation p1, final ValueRepresentation p2, final ValueRepresentation p3, final ValueRepresentation p4, final ValueRepresentation p5, final ValueRepresentation p6, final ValueRepresentation p7, final ValueRepresentation p8, final ValueRepresentation p9) {
        return Functions.pattern(c, pattern, p1 != null || p2 != null || p3 != null || p4 != null ? new XPathVariableResolver(){

            @Override
            public Object resolveVariable(QName variableName) {
                String v = variableName.getLocalPart();
                if (v.equals("p1")) {
                    return p1;
                }
                if (v.equals("p2")) {
                    return p2;
                }
                if (v.equals("p3")) {
                    return p3;
                }
                if (v.equals("p4")) {
                    return p4;
                }
                if (v.equals("p5")) {
                    return p5;
                }
                if (v.equals("p6")) {
                    return p6;
                }
                if (v.equals("p7")) {
                    return p7;
                }
                if (v.equals("p8")) {
                    return p8;
                }
                if (v.equals("p9")) {
                    return p9;
                }
                return null;
            }
        } : null);
    }

    public static String reduceUUID(String uuid) {
        long l = ByteBuffer.wrap(uuid.getBytes()).getLong();
        return Long.toString(l, 36);
    }

    public static String toJavaProperties(NodeInfo context) throws Exception {
        String s;
        Properties prop = new Properties();
        XPathEvaluatorI e = Functions.getXPathEvaluator(context, null);
        for (Object o : (Collection)e.evaluate("@*", context, XPathConstants.NODESET)) {
            s = ((NodeInfo)o).getDisplayName();
            String v = ((NodeInfo)o).getStringValue();
            prop.put(s, v);
        }
        for (Object o : (Collection)e.evaluate("*[@position!='']", context, XPathConstants.NODESET)) {
            s = (String)e.evaluate("concat(./name(), '|', @position, '|', @key , '|', ./text())", o, XPathConstants.STRING);
            String[] p = s.split("\\|");
            if (p.length < 4) continue;
            prop.put(p[0] + "." + p[1], p[3]);
            if (p[2].isEmpty()) continue;
            prop.put(p[0] + "." + p[1] + ".key", p[2]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        prop.store(bos, null);
        return new String(bos.toByteArray(), "UTF-8");
    }

    public static String toJavaProperties(NodeInfo context, Collection<String> allowedProperties) throws XPathExpressionException, XPathException {
        String s;
        Properties prop = new Properties();
        XPathEvaluatorI e = Functions.getXPathEvaluator(context, null);
        for (Object o : (Collection)e.evaluate("@*", context, XPathConstants.NODESET)) {
            s = ((NodeInfo)o).getDisplayName();
            String v = ((NodeInfo)o).getStringValue();
            if (!allowedProperties.contains(s)) continue;
            prop.put(s, v);
        }
        for (Object o : (Collection)e.evaluate("*[@position!='']", context, XPathConstants.NODESET)) {
            s = (String)e.evaluate("concat(./name(), '|', @position, '|', @key , '|', ./text())", o, XPathConstants.STRING);
            String[] p = s.split("\\|");
            if (p.length < 4 || !allowedProperties.contains(p[0])) continue;
            prop.put(p[0] + "." + p[1], p[3]);
            if (p[2].isEmpty()) continue;
            prop.put(p[0] + "." + p[1] + ".key", p[2]);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            prop.store(bos, null);
            return new String(bos.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new XPathException("unexpected", (Throwable)ex);
        }
    }

    public static String formatUriPreservingFragment(String path) {
        String[] p = path.split("#");
        if (p.length > 2) {
            StringBuilder b = new StringBuilder();
            int i = 0;
            while (i < p.length) {
                if (i == p.length - 1) {
                    b.append("#");
                } else if (i > 0) {
                    b.append("%23");
                }
                b.append(p[i]);
                ++i;
            }
            return b.toString();
        }
        return path;
    }

    private static class EvaluationVariableResolver
    implements XPathVariableResolver {
        Stack<Ctx> stackCtx = new Stack();

        private EvaluationVariableResolver() {
        }

        void pushContext(XPathContext ctx, NodeInfo context, StackFrame stackFrame, XPathVariableResolver r) {
            this.stackCtx.push(new Ctx(ctx, r, stackFrame, context));
        }

        void popContext() {
            this.stackCtx.pop();
        }

        @Override
        public Object resolveVariable(QName variableName) {
            StackedVariableManager.StackedVariable vs;
            block7: {
                Object result;
                XPathContext xPathCtx = this.stackCtx.peek().ctx;
                NodeInfo context = this.stackCtx.peek().context;
                StackFrame stackFrame = this.stackCtx.peek().stackFrame;
                XPathVariableResolver wrappedResolver = this.stackCtx.peek().wrappedResolver;
                if (wrappedResolver != null && (result = wrappedResolver.resolveVariable(variableName)) != null) {
                    return result;
                }
                int i = -1;
                for (QName name : Variables.valueRepresentationMap.keySet()) {
                    if (!name.equals(variableName)) continue;
                    ValueRepresentation result2 = Variables.valueRepresentationMap.get(variableName);
                    return result2;
                }
                for (QName var : stackFrame.getStackFrameMap().getVariableMap()) {
                    ++i;
                    if (!((Object)var).toString().equals(variableName.toString())) continue;
                    ValueRepresentation result3 = stackFrame.getStackFrameValues()[i];
                    return result3;
                }
                try {
                    List result4 = Functions.getMdRef(xPathCtx, context, variableName.toString());
                    if (result4 != null) {
                        return result4;
                    }
                }
                catch (URISyntaxException | TransformerException | XPathExpressionException e) {
                    if (!logger.isDebugEnabled()) break block7;
                    logger.debug("Failed to find mdRef for variable {} from mdLinks. We will look into the variable stack ", (Object)variableName, (Object)e);
                }
            }
            if ((vs = StackedVariableManager.INSTANCE.getVariable(variableName.getLocalPart())) != null) {
                return vs.peekValue(false);
            }
            return null;
        }

        private class Ctx {
            private XPathVariableResolver wrappedResolver = null;
            private StackFrame stackFrame;
            private NodeInfo context;
            private XPathContext ctx;

            Ctx(XPathContext ctx, XPathVariableResolver wrappedResolver, StackFrame stackFrame, NodeInfo context) {
                this.ctx = ctx;
                this.wrappedResolver = wrappedResolver;
                this.stackFrame = stackFrame;
                this.context = context;
            }
        }
    }
}

