/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.xsl.global;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GraphUtil {
    static boolean computed = false;
    static Map<String, Node> graphNodes = new HashMap<String, Node>();

    public static void main(String[] args) {
        GraphUtil.addRelation("A.1", "B.1");
        GraphUtil.addRelation("A.2", "B.1");
        GraphUtil.addRelation("A.3", "B.1");
        GraphUtil.addRelation("B.1", "C.1");
        GraphUtil.addRelation("B.1", "C.2");
        GraphUtil.addRelation("B.1", "C.3");
        GraphUtil.addRelation("B.1", "C.6");
        GraphUtil.addRelation("B.1", "C.5");
        GraphUtil.addRelation("C.3", "D.3");
        GraphUtil.addRelation("B.1", "C.4");
        GraphUtil.addRelation("C.1", "D.1");
        GraphUtil.addRelation("B.1", "C.7");
        GraphUtil.addRelation("C.7", "D.7");
        GraphUtil.addRelation("C.2", "D.2");
        GraphUtil.addRelation("C.4", "D.4");
        GraphUtil.addRelation("C.5", "D.5");
        GraphUtil.addRelation("C.6", "D.6");
        GraphUtil.addRelation("F.1", "G.1");
        GraphUtil.addRelation("E.1", "F.1");
        GraphUtil.addRelation("F.5", "G.1");
        GraphUtil.addRelation("D.1", "E.1");
        GraphUtil.addRelation("F.3", "G.1");
        GraphUtil.addRelation("F.2", "G.1");
        GraphUtil.addRelation("F.4", "G.1");
        GraphUtil.addRelation("F.7", "G.1");
        GraphUtil.addRelation("F.6", "G.1");
        GraphUtil.addRelation("G.1", "I.1");
        for (Node node : graphNodes.values()) {
            System.out.println(node.id + " : " + node.proof());
        }
        GraphUtil.resetGraph();
        GraphUtil.addRelation("U_DEFAULT_NUMBER", "Empty");
        GraphUtil.addRelation("U_DEFAULT_SHORT_CHAR", "Empty");
        GraphUtil.addRelation("Empty", "L1-VENTES_HORS_JDE-Load");
        GraphUtil.addRelation("Empty", "S13-DS_CUSTOMER_CAT5_L-Staging");
        GraphUtil.addRelation("Empty", "S1-DS_SPE_SHIP_TO_CUST_SID_L-Staging");
        GraphUtil.addRelation("Empty", "S15-DS_MTRL_SID_L-Staging");
        GraphUtil.addRelation("Empty", "S14-DS_SALES_ORG_SID_L-Staging");
        GraphUtil.addRelation("Empty", "S3-DS_SPE_RESEAU_DISTRIBUTION_SID-Staging");
        GraphUtil.addRelation("Empty", "S2-DS_SHIPPING_PNT_SID_L-Staging");
        GraphUtil.addRelation("U_SEPARATOR_CHAR", "");
        GraphUtil.addRelation("L1-VENTES_HORS_JDE-Load", "S10-VENTES_HORS_JDE-Staging");
        GraphUtil.addRelation("S1-DS_SPE_SHIP_TO_CUST_SID_L-Staging", "S5-CUSTOMER_LIV_CD-Staging");
        GraphUtil.addRelation("S2-DS_SHIPPING_PNT_SID_L-Staging", "S8-SHIPPING_POINT_CD-Staging");
        GraphUtil.addRelation("S3-DS_SPE_RESEAU_DISTRIBUTION_SID-Staging", "S9-SPE_RESEAU_DISTRIBUTION_CD-Staging");
        GraphUtil.addRelation("S13-DS_CUSTOMER_CAT5_L-Staging", "S4-CUSTOMER_CAT5_CD-Staging");
        GraphUtil.addRelation("S4-CUSTOMER_CAT5_CD-Staging", "I1-TRG_VENTES_HORS_JDE_WT-Integration");
        GraphUtil.addRelation("S5-CUSTOMER_LIV_CD-Staging", "I1-TRG_VENTES_HORS_JDE_WT-Integration");
        GraphUtil.addRelation("S15-DS_MTRL_SID_L-Staging", "S6-MATERIAL_DIM_ID-Staging");
        GraphUtil.addRelation("S6-MATERIAL_DIM_ID-Staging", "I1-TRG_VENTES_HORS_JDE_WT-Integration");
        GraphUtil.addRelation("S14-DS_SALES_ORG_SID_L-Staging", "S7-ORGANIZATION_DIM_ID-Staging");
        GraphUtil.addRelation("S7-ORGANIZATION_DIM_ID-Staging", "I1-TRG_VENTES_HORS_JDE_WT-Integration");
        GraphUtil.addRelation("S8-SHIPPING_POINT_CD-Staging", "I1-TRG_VENTES_HORS_JDE_WT-Integration");
        GraphUtil.addRelation("S9-SPE_RESEAU_DISTRIBUTION_CD-Staging", "I1-TRG_VENTES_HORS_JDE_WT-Integration");
        GraphUtil.addRelation("S10-VENTES_HORS_JDE-Staging", "S11-DATASTREAM-Staging");
        GraphUtil.addRelation("S11-DATASTREAM-Staging", "S12-TRANSFORMATION_MODEL-Staging");
        GraphUtil.addRelation("S12-TRANSFORMATION_MODEL-Staging", "I1-TRG_VENTES_HORS_JDE_WT-Integration");
        GraphUtil.addRelation("I1-TRG_VENTES_HORS_JDE_WT-Integration", "L1-VENTES_HORS_JDE-Cleanup");
        for (Node node : graphNodes.values()) {
            if (node.id.equals("_864800de-ea9c-4ebe-b8aa-eaf71a348f8b")) {
                System.out.println();
            }
            System.out.println(node.id + "\t" + node.proof());
        }
    }

    public static void resetGraph() {
        for (Node node : graphNodes.values()) {
            node.clear();
        }
        graphNodes.clear();
        computed = false;
    }

    public static void computeProof() {
        if (!computed) {
            for (Node node : graphNodes.values()) {
                node.compute();
            }
            computed = true;
        }
    }

    public static void addRelation(String parent, String child) {
        Node childNode;
        Node parentNode = graphNodes.get(parent);
        if (parentNode == null) {
            parentNode = new Node();
            parentNode.id = parent;
            graphNodes.put(parent, parentNode);
        }
        if ((childNode = graphNodes.get(child)) == null) {
            childNode = new Node();
            childNode.id = child;
            graphNodes.put(child, childNode);
        }
        childNode.parents.add(parentNode);
    }

    public static int getOrder(String id) {
        Node node = graphNodes.get(id);
        if (node != null) {
            return node.proof();
        }
        return 0;
    }

    static class Node {
        List<Node> parents = new ArrayList<Node>();
        String id;
        int proof = -2;

        Node() {
        }

        public String toString() {
            return "Node [ id=" + this.id + "parents=" + String.valueOf(this.parents) + "]";
        }

        void clear() {
            this.parents.clear();
        }

        @Deprecated
        int getOrder() {
            int order = this.getOrder(new ArrayList<Node>());
            return order;
        }

        @Deprecated
        int getOrder(List<Node> already) {
            already.add(this);
            int max = 0;
            for (Node parent : this.parents) {
                if (already.contains(parent)) {
                    if (max != 0) continue;
                    max = -1;
                    continue;
                }
                int tmp = parent.getOrder(already);
                if (tmp == -1 || ++tmp <= max) continue;
                max = tmp;
            }
            return max;
        }

        int proof() {
            GraphUtil.computeProof();
            return this.proof;
        }

        boolean compute() {
            if (this.proof == -2) {
                this.proof = -1;
                int max = 0;
                for (Node parent : this.parents) {
                    if (parent.compute()) continue;
                    int p = parent.proof;
                    if (++p <= max) continue;
                    max = p;
                }
                this.proof = max;
                return false;
            }
            return this.proof == -1;
        }
    }
}

