/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.generation.xsl.global;

import com.semarchy.xdi.designer.generation.xsl.global.Messages;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.EarlyEvaluationContext;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.functions.NumberFn;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.SlotManager;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.om.UnfailingIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.om.VirtualNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceExtent;
import net.sf.saxon.xpath.XPathExpressionImpl;

public class XPathExpressionImplI
extends XPathExpressionImpl {
    private Executable executable2;
    private Expression expression2;
    private Receiver receiver;
    private Controller controller;
    private boolean doJavaConvertion = true;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object evaluate(Object node, QName qName) throws XPathExpressionException {
        NodeInfo contextNode = null;
        if (node != null) {
            if (node instanceof NodeInfo) {
                if (!((NodeInfo)node).getConfiguration().isCompatible(this.getConfiguration())) {
                    throw new XPathExpressionException(Messages.XPathExpressionImplI_0);
                }
                contextNode = (NodeInfo)node;
            } else {
                ValueRepresentation val;
                JPConverter converter = JPConverter.allocate(node.getClass(), (Configuration)this.getConfiguration());
                try {
                    val = converter.convert(node, (XPathContext)new EarlyEvaluationContext(this.getConfiguration(), null));
                }
                catch (XPathException e) {
                    throw new XPathExpressionException(String.format(Messages.XPathExpressionImplI_1, node.getClass().getName(), e.getMessage()));
                }
                if (!(val instanceof NodeInfo)) {
                    throw new XPathExpressionException(String.format(Messages.XPathExpressionImplI_2, node.getClass().getName()));
                }
                contextNode = (NodeInfo)val;
            }
        }
        IndyXPathContextMajor context = new IndyXPathContextMajor((Item)contextNode, this.controller);
        if (this.receiver != null) {
            context.getController().setMessageEmitter(this.receiver);
        }
        context.getController().setRuleManager(this.executable2.getRuleManager());
        context.openStackFrame(this.getStackFrameMap());
        try {
            SequenceIterator iter;
            if (qName.equals(XPathConstants.BOOLEAN)) {
                if (this.doJavaConvertion) {
                    return this.expression2.effectiveBooleanValue((XPathContext)context);
                }
                return this.expression2.iterate((XPathContext)context).next();
            }
            if (qName.equals(XPathConstants.STRING)) {
                iter = this.expression2.iterate((XPathContext)context);
                Item first = iter.next();
                if (first == null) {
                    return "";
                }
                if (this.doJavaConvertion) {
                    return first.getStringValue();
                }
                return first;
            }
            if (qName.equals(XPathConstants.NUMBER)) {
                Atomizer atomize2 = null;
                if (atomize2 == null) {
                    atomize2 = new Atomizer(this.expression2, this.getConfiguration());
                }
                SequenceIterator iter2 = atomize2.iterate((XPathContext)context);
                Item first = iter2.next();
                if (!this.doJavaConvertion) {
                    return first;
                }
                if (first == null) {
                    return new Double(Double.NaN);
                }
                if (first instanceof NumericValue) {
                    return new Double(((NumericValue)first).getDoubleValue());
                }
                DoubleValue v = NumberFn.convert((AtomicValue)((AtomicValue)first));
                return new Double(v.getDoubleValue());
            }
            if (qName.equals(XPathConstants.NODE)) {
                iter = this.expression2.iterate((XPathContext)context);
                Item first = iter.next();
                if (first instanceof VirtualNode) {
                    return ((VirtualNode)first).getUnderlyingNode();
                }
                if (first != null && !(first instanceof NodeInfo)) {
                    throw new XPathExpressionException(Messages.XPathExpressionImplI_3);
                }
                return first;
            }
            if (!qName.equals(XPathConstants.NODESET)) {
                throw new IllegalArgumentException(Messages.XPathExpressionImplI_4);
            }
            iter = this.rawIterator2(context);
            SequenceExtent extent = new SequenceExtent(iter);
            if (this.doJavaConvertion) {
                PJConverter converter = PJConverter.allocateNodeListCreator((Configuration)this.getConfiguration(), (Object)node);
                return converter.convert((ValueRepresentation)extent, Object.class, (XPathContext)context);
            }
            return extent;
        }
        catch (XPathException e) {
            throw new XPathExpressionException(e);
        }
    }

    public void setMessageEmitter(Receiver messageEmitter) {
        this.receiver = messageEmitter;
    }

    private SequenceIterator rawIterator2(XPathContextMajor context) throws XPathException {
        context.openStackFrame(this.getStackFrameMap());
        SequenceIterator iterator = this.expression2.iterate((XPathContext)context);
        return iterator;
    }

    protected void setStackFrameMap(SlotManager map) {
        super.setStackFrameMap(map);
    }

    protected XPathExpressionImplI(Expression exp, Executable exec, boolean doJavaConvertion) {
        super(exp, exec);
        this.expression2 = exp;
        this.executable2 = exec;
        this.doJavaConvertion = doJavaConvertion;
    }

    protected XPathExpressionImplI(Expression exp, Controller controller, boolean doJavaConvertion) {
        super(exp, controller.getExecutable());
        this.expression2 = exp;
        this.executable2 = controller.getExecutable();
        this.controller = controller;
        this.doJavaConvertion = doJavaConvertion;
    }

    private class IndyXPathContextMajor
    extends XPathContextMajor {
        public IndyXPathContextMajor(Item item, Controller controller) {
            super(controller);
            if (item != null) {
                UnfailingIterator iter = SingletonIterator.makeIterator((Item)item);
                iter.next();
                this.setCurrentIterator((SequenceIterator)iter);
            }
        }
    }
}

