/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.shared.configuration;

import com.indy.engine.shared.configuration.Messages;
import com.indy.engine.shared.configuration.VariableHandler;
import com.indy.engine.shared.plugin.IPluginFactory;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.ArrayList;
import java.util.List;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class DefaultPluginConfigurationImpl
implements IPluginFactory.IPluginConfiguration {
    public static final String P_MODULE_PROVIDER = "module";
    public static final String P_PLUGIN_FACTORY_CLASS = "class";
    @XmlAttribute(name="module")
    String moduleProvider = "internal";
    @XmlAttribute(name="class")
    String pluginFactoryClassName = null;
    @XmlElement(name="parameter")
    protected List<Parameter> parameters = new ArrayList<Parameter>();

    @Override
    public String getModuleProvider() {
        return this.handleVariables(this.moduleProvider);
    }

    @Override
    public String getPluginFactoryClassName() {
        return this.handleVariables(this.pluginFactoryClassName);
    }

    @Override
    public String getProperty(String propertyName) {
        String value = null;
        if (P_MODULE_PROVIDER.equals(propertyName)) {
            value = this.getModuleProvider();
        }
        if (P_PLUGIN_FACTORY_CLASS.equals(propertyName)) {
            value = this.getPluginFactoryClassName();
        }
        return value;
    }

    protected String getParameterValue(String name) {
        for (Parameter p : this.parameters) {
            if (!p.name.equals(name)) continue;
            return this.handleVariables(p.value);
        }
        return null;
    }

    protected void setModuleProvider(String moduleProvider) {
        this.moduleProvider = moduleProvider;
    }

    public void setPluginFactoryClassName(String pluginFactoryClassName) {
        this.pluginFactoryClassName = pluginFactoryClassName;
    }

    protected String handleVariables(String value) {
        if (value == null) {
            return value;
        }
        try {
            return VariableHandler.updateString(value);
        }
        catch (Exception ex) {
            throw new RuntimeException(Messages.getString("DefaultPluginConfigurationImpl.1"), ex);
        }
    }

    public static class Parameter {
        @XmlAttribute(name="name", required=true)
        String name;
        @XmlAttribute(name="value", required=true)
        String value;

        public Parameter() {
        }

        public Parameter(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            if (this.value == null) {
                return this.value;
            }
            try {
                return VariableHandler.updateString(this.value);
            }
            catch (Exception ex) {
                throw new RuntimeException(String.format(Messages.getString("DefaultPluginConfigurationImpl.0"), this.name, this.value), ex);
            }
        }
    }
}

