/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.shared.configuration.repository;

import com.indy.engine.shared.configuration.ConfigurationReader;
import com.indy.engine.shared.configuration.repository.LegacyXmlBean;
import com.indy.engine.shared.configuration.repository.RepositoryXmlBean;
import com.indy.engine.shared.plugin.IPluginFactory;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

@XmlRootElement(name="repositories")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class RepositoryConfigurationProvider {
    @XmlElement(name="httpRepository")
    List<LegacyXmlBean> compatibilityHttpConfs = new ArrayList<LegacyXmlBean>();
    @XmlElement(name="fileRepository")
    List<LegacyXmlBean> compatibilityFileConfs = new ArrayList<LegacyXmlBean>();
    @XmlElement(name="deliveryRepository")
    List<RepositoryXmlBean> repositoriesConfigurations = new ArrayList<RepositoryXmlBean>();
    @XmlTransient
    List<IPluginFactory.IPluginConfiguration> configurations = new ArrayList<IPluginFactory.IPluginConfiguration>();

    public List<IPluginFactory.IPluginConfiguration> getConfigurations() {
        return this.configurations;
    }

    public static RepositoryConfigurationProvider load(InputStream runtimeEngineParameters) throws Exception {
        RepositoryConfigurationProvider provider = ConfigurationReader.parse(runtimeEngineParameters, "repositories", RepositoryConfigurationProvider.class);
        if (provider != null) {
            provider.init();
        }
        return provider;
    }

    private void init() {
        for (LegacyXmlBean cfg : this.compatibilityHttpConfs) {
            String environment = cfg.getProperty("environment");
            if (environment != null && !environment.isEmpty()) {
                cfg.setPluginFactoryClassName("com.stambia.repository.delivery.HttpDeliveryRepositoryV2Plugin");
                continue;
            }
            cfg.setPluginFactoryClassName("com.stambia.repository.delivery.HttpDeliveryRepositoryV1Plugin");
        }
        for (LegacyXmlBean cfg : this.compatibilityFileConfs) {
            cfg.setPluginFactoryClassName("com.stambia.repository.delivery.FileDeliveryRepositoryPlugin");
        }
        this.configurations.addAll(this.compatibilityFileConfs);
        this.configurations.addAll(this.compatibilityHttpConfs);
        this.configurations.addAll(this.repositoriesConfigurations);
    }
}

