/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.file.fileMetadata;

import com.stambia.jdbc.driver.file.fileMetadata.IMetadataColumn;
import com.stambia.jdbc.driver.file.fileMetadata.Messages;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataFile;
import com.stambia.jdbc.driver.file.fileMetadata.MetadataServer;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;

public class MetadataColumn
implements IMetadataColumn {
    StringToNumberConverter converter;
    String name;
    String label;
    String className;
    String format = null;
    String expression;
    int type;
    int displaySize;
    int position;
    int index;
    int precision;
    int scale = -1;
    int ancestorLevel;
    int startPosition;
    String numericSeparator;
    int offset;
    int columnIndex = -1;
    String stringDelimiter = null;
    String decimalSeparator = MetadataServer.DEFAULT_NUMERIC_SEPARATOR;
    String groupingSeparator = MetadataServer.DEFAULT_NUMERIC_GROUPING_CHAR;
    DecimalFormatSymbols dfs = new DecimalFormatSymbols();
    DecimalFormat decimalFormat = null;
    DateFormat dateFormat = null;
    DateFormat defaultDateFormat = null;
    DecimalFormat defaultDecimalFormat = null;
    String id;
    String defaultValue;
    ByteOrder byteOrder;
    int physicalSize;
    String numericPaddingChar = MetadataServer.DEFAULT_NUMERIC_PADDING_CHAR;

    public void setConverter(StringToNumberConverter converter) {
        this.converter = converter;
    }

    @Override
    public StringToNumberConverter getConverter() {
        return this.converter;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void computeFormats(MetadataFile file) throws SQLException {
        if (this.type != 2) {
            this.setScale(0);
        }
        if (this.type == 2) {
            this.dfs.setDecimalSeparator(this.decimalSeparator.toCharArray()[0]);
            String _groupingSeparator = file.getDefaultGroupingSeparator();
            if (this.groupingSeparator != null && !this.groupingSeparator.isEmpty()) {
                _groupingSeparator = this.groupingSeparator;
            }
            if (_groupingSeparator != null) {
                if (_groupingSeparator.length() > 1) {
                    throw new SQLException(Messages.getString("MetadataColumn.0"));
                }
                if (_groupingSeparator.length() == 1) {
                    this.dfs.setGroupingSeparator(_groupingSeparator.toCharArray()[0]);
                }
            }
            String decimalFormatStr = file.getDefaultDecimalFormat();
            if (this.format != null && !this.format.isEmpty()) {
                decimalFormatStr = this.format;
            }
            if (decimalFormatStr == null) {
                decimalFormatStr = "#,##0.###;-#,##0.###";
            }
            this.decimalFormat = new DecimalFormat(decimalFormatStr, this.dfs);
            if (_groupingSeparator == null || _groupingSeparator.length() == 0) {
                this.decimalFormat.setGroupingUsed(false);
            }
            this.decimalFormat.setParseBigDecimal(true);
            if (this.getScale() > -1) {
                this.decimalFormat.setMinimumFractionDigits(this.getScale());
                this.decimalFormat.setMaximumFractionDigits(this.getScale());
            } else {
                this.setScale(this.decimalFormat.getMaximumFractionDigits());
            }
        } else if (this.type == 93 || this.type == 91 || this.type == 92) {
            String defaultFormat = null;
            if (this.type == 93) {
                defaultFormat = file.getDefaultTimestampFormat();
            } else if (this.type == 91) {
                defaultFormat = file.getDefaultDateFormat();
            }
            if (defaultFormat == null) {
                this.format = MetadataServer.DEFAULT_DATE_FORMAT;
            }
            if (defaultFormat != null) {
                this.defaultDateFormat = new SimpleDateFormat(defaultFormat);
                this.defaultDateFormat.setLenient(false);
            }
            if (this.format == null || this.format.isEmpty()) {
                this.format = defaultFormat;
                this.dateFormat = this.defaultDateFormat;
            } else {
                this.dateFormat = new SimpleDateFormat(this.format);
                this.dateFormat.setLenient(false);
            }
            this.dateFormat.setLenient(false);
        }
    }

    @Override
    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    @Override
    public DateFormat getDefaultDateFormat() {
        return this.defaultDateFormat;
    }

    @Override
    public DecimalFormat getDecimalFormat() {
        return this.decimalFormat;
    }

    public void setDecimalFormat(DecimalFormat decimalFormat) {
        this.decimalFormat = decimalFormat;
    }

    public String getDecimalSeparator() {
        return this.decimalSeparator;
    }

    public void setHexaDecimalSeparator(String decimalSeparator) throws UnsupportedEncodingException {
        this.setDecimalSeparator(MetadataServer.hexStringToString(decimalSeparator));
    }

    public String getGroupingSeparator() {
        return this.groupingSeparator;
    }

    public void setHexaGroupingSeparator(String groupingSeparator) throws UnsupportedEncodingException {
        this.groupingSeparator = MetadataServer.hexStringToString(groupingSeparator);
        this.dfs.setGroupingSeparator(this.groupingSeparator.charAt(0));
    }

    public void setGroupingSeparator(String groupingSeparator) throws UnsupportedEncodingException {
        this.dfs.setGroupingSeparator(groupingSeparator.charAt(0));
    }

    public String getStringDelimiter() {
        return this.stringDelimiter;
    }

    public void setStringDelimiter(String stringDelimiter) {
        this.stringDelimiter = stringDelimiter;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public int getDisplaySize() {
        return this.displaySize;
    }

    public void setDisplaySize(int displaySize) {
        this.displaySize = displaySize;
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public int getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(int startPosition) {
        this.startPosition = startPosition;
    }

    public String getNumericSeparator() {
        return this.numericSeparator;
    }

    public void setNumericSeparator(String numericSeparator) {
        this.numericSeparator = numericSeparator;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setDecimalSeparator(String decimalSeparator) {
        if (decimalSeparator != null && decimalSeparator.length() > 0) {
            this.decimalSeparator = decimalSeparator;
            this.dfs.setDecimalSeparator(decimalSeparator.charAt(0));
        }
    }

    public void setAncestorLevel(int parseInt) {
        this.ancestorLevel = parseInt;
    }

    @Override
    public int getAncestorLevel() {
        return this.ancestorLevel;
    }

    public void setExpression(String nodeValue) {
        if (nodeValue != null && !nodeValue.isEmpty()) {
            this.expression = nodeValue;
        }
    }

    @Override
    public String getExpression() {
        return this.expression;
    }

    @Override
    public void close() {
        this.dateFormat = null;
        this.decimalFormat = null;
        this.dfs = null;
        this.converter = null;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setPhysicalSize(int physicalSize) {
        this.physicalSize = physicalSize;
    }

    @Override
    public int getPhysicalSize() {
        return this.physicalSize;
    }

    public void setNumericPaddingChar(String numericPaddingChar) {
        this.numericPaddingChar = numericPaddingChar;
    }

    @Override
    public String getNumericPaddingChar() {
        return this.numericPaddingChar;
    }

    public static interface StringToNumberConverter {
        public BigDecimal parse(String var1, String var2, IMetadataColumn var3) throws Exception;
    }
}

