/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.common.parser;

import com.stambia.jdbc.common.parser.AbstractVisitor;
import com.stambia.jdbc.common.parser.Messages;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import net.sf.jsqlparser.schema.Column;

public abstract class FunctionDataTypeVisitor
extends AbstractVisitor {
    private String alias;
    private String functionName;

    public FunctionDataTypeVisitor(String alias) {
        this.alias = alias;
    }

    @Override
    public void visit(ExpressionList paramExpressionList) {
        if (paramExpressionList.getExpressions().size() > 1) {
            throw new RuntimeException(Messages.getString("FunctionDataTypeVisitor.0"));
        }
        ((Column)paramExpressionList.getExpressions().get(0)).accept((ExpressionVisitor)this);
    }

    @Override
    public void visit(Function function) {
        this.functionName = function.getName();
        function.getParameters().accept((ItemsListVisitor)this);
    }

    @Override
    public void visit(Column tableColumn) {
        if (this.functionName.equalsIgnoreCase(FUNCTION_DATA_TYPE.TIMESTAMP.dataTypeLabel)) {
            this.addColumn(tableColumn, this.alias, 93);
        } else if (this.functionName.equalsIgnoreCase(FUNCTION_DATA_TYPE.BOOLEAN.dataTypeLabel)) {
            this.addColumn(tableColumn, this.alias, 16);
        } else if (this.functionName.equalsIgnoreCase(FUNCTION_DATA_TYPE.DATE.dataTypeLabel)) {
            this.addColumn(tableColumn, this.alias, 91);
        } else if (this.functionName.equalsIgnoreCase(FUNCTION_DATA_TYPE.TIME.dataTypeLabel)) {
            this.addColumn(tableColumn, this.alias, 92);
        } else if (this.functionName.equalsIgnoreCase(FUNCTION_DATA_TYPE.NUMERIC.dataTypeLabel)) {
            this.addColumn(tableColumn, this.alias, 2);
        } else if (this.functionName.equalsIgnoreCase(FUNCTION_DATA_TYPE.NUMBER.dataTypeLabel)) {
            this.addColumn(tableColumn, this.alias, 2);
        }
    }

    public abstract void addColumn(Column var1, String var2, int var3);

    public static enum FUNCTION_DATA_TYPE {
        TIMESTAMP("to_timestamp"),
        DATE("to_date"),
        TIME("to_time"),
        BOOLEAN("to_boolean"),
        NUMERIC("to_numeric"),
        NUMBER("to_number");

        public String dataTypeLabel;

        private FUNCTION_DATA_TYPE(String dataTypeLabel) {
            this.dataTypeLabel = dataTypeLabel;
        }

        public String getDataTypeLabel() {
            return this.dataTypeLabel;
        }
    }
}

