/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.common.parser;

import com.stambia.jdbc.common.CreateMetaData;
import com.stambia.jdbc.common.TableMetaData;
import com.stambia.jdbc.common.parser.IWhereVisitor;
import com.stambia.jdbc.common.parser.InsertMetaData;
import com.stambia.jdbc.common.parser.Messages;
import com.stambia.jdbc.common.parser.SelectMetaData;
import java.io.Reader;
import java.io.StringReader;
import java.sql.SQLException;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.truncate.Truncate;
import net.sf.jsqlparser.statement.update.Update;

public class Parser {
    String sql;
    private Statement st;
    TYPE type;

    public SelectMetaData getSelectMetaData() {
        if (this.type == TYPE.SELECT) {
            SelectMetaData metaData = new SelectMetaData((PlainSelect)((Select)this.st).getSelectBody());
            return metaData;
        }
        return null;
    }

    public SelectMetaData getSelectMetaData(IWhereVisitor whereVisitor) {
        if (this.type == TYPE.SELECT) {
            SelectMetaData metaData = new SelectMetaData((PlainSelect)((Select)this.st).getSelectBody(), whereVisitor);
            return metaData;
        }
        return null;
    }

    public InsertMetaData getInsertMetaData() {
        if (this.type == TYPE.INSERT) {
            return new InsertMetaData((Insert)this.st);
        }
        return null;
    }

    public CreateMetaData getCreateMetaData() {
        if (this.type == TYPE.CREATE) {
            return new CreateMetaData((CreateTable)this.st);
        }
        return null;
    }

    public TYPE getType() {
        return this.type;
    }

    public Parser(String sql) throws SQLException {
        block8: {
            this.sql = sql;
            CCJSqlParserManager parserManager = new CCJSqlParserManager();
            try {
                this.st = parserManager.parse((Reader)new StringReader(sql));
                if (this.st instanceof Select) {
                    this.type = TYPE.SELECT;
                    break block8;
                }
                if (this.st instanceof Truncate) {
                    this.type = TYPE.TRUNCATE;
                    break block8;
                }
                if (this.st instanceof Insert) {
                    this.type = TYPE.INSERT;
                    break block8;
                }
                if (this.st instanceof Delete) {
                    this.type = TYPE.DELETE;
                    break block8;
                }
                if (this.st instanceof Update) {
                    this.type = TYPE.UPDATE;
                    break block8;
                }
                if (this.st instanceof CreateTable) {
                    this.type = TYPE.CREATE;
                    break block8;
                }
                throw new SQLException(Messages.getString("Parser.0"));
            }
            catch (JSQLParserException e) {
                throw new SQLException(Messages.getString("Parser.1") + sql, e);
            }
        }
    }

    public TableMetaData getTruncateParser() {
        if (this.type == TYPE.TRUNCATE) {
            Table tab = ((Truncate)this.st).getTable();
            return TableMetaData.toTableMetaData(tab);
        }
        return null;
    }

    public TableMetaData getDeleteParser() {
        if (this.type == TYPE.DELETE) {
            Table tab = ((Delete)this.st).getTable();
            return TableMetaData.toTableMetaData(tab);
        }
        return null;
    }

    static enum TYPE {
        SELECT,
        TRUNCATE,
        INSERT,
        UPDATE,
        DELETE,
        CREATE;

    }
}

