/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.common.parser;

import com.stambia.jdbc.common.TableMetaData;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.jsqlparser.expression.AllComparisonExpression;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.InverseExpression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.SubSelect;

public class WhereVisitor
implements ExpressionVisitor {
    private static final String REGEX_WHERE_MATCH = "\\(?\\s*\\d+\\s*=\\s*\\d+\\s*\\)?";
    protected Map<String, String> whereClauseReplacement = new LinkedHashMap<String, String>();

    public String replace(String baseWhereClause) {
        for (Map.Entry<String, String> entry : this.whereClauseReplacement.entrySet()) {
            String val = entry.getValue();
            if (val == null) continue;
            baseWhereClause = baseWhereClause.replace(entry.getKey(), val);
        }
        return baseWhereClause;
    }

    public void visit(NullValue arg0) {
        this.whereClauseReplacement.put("null", "\"\"");
    }

    public void visit(Function arg0) {
    }

    public void visit(InverseExpression arg0) {
    }

    public void visit(JdbcParameter arg0) {
    }

    public void visit(DoubleValue arg0) {
    }

    public void visit(LongValue arg0) {
    }

    public void visit(DateValue arg0) {
    }

    public void visit(TimeValue arg0) {
    }

    public void visit(TimestampValue arg0) {
    }

    public void visit(Parenthesis arg0) {
        String left = arg0.getExpression().toString();
        Pattern p = Pattern.compile(REGEX_WHERE_MATCH);
        if (p.matcher(left).matches()) {
            this.whereClauseReplacement.put(arg0.toString(), "");
        } else {
            arg0.getExpression().accept((ExpressionVisitor)this);
        }
    }

    public void visit(StringValue arg0) {
        this.whereClauseReplacement.put(arg0.toString(), "\"" + arg0.getValue() + "\"");
    }

    public void visit(Addition arg0) {
        this.visitBinaryExpression((BinaryExpression)arg0);
    }

    public void visit(Division arg0) {
        this.visitBinaryExpression((BinaryExpression)arg0);
    }

    public void visit(Multiplication arg0) {
        this.visitBinaryExpression((BinaryExpression)arg0);
    }

    public void visit(Subtraction arg0) {
        this.visitBinaryExpression((BinaryExpression)arg0);
    }

    public void visit(AndExpression arg0) {
        String left = arg0.getLeftExpression().toString();
        Pattern p = Pattern.compile(REGEX_WHERE_MATCH);
        if (p.matcher(left).matches()) {
            this.whereClauseReplacement.put(arg0.toString(), arg0.getRightExpression().toString());
            arg0.getRightExpression().accept((ExpressionVisitor)this);
        } else {
            this.visitBinaryExpression((BinaryExpression)arg0);
        }
    }

    public void visit(OrExpression arg0) {
        String left = arg0.getLeftExpression().toString();
        Pattern p = Pattern.compile(REGEX_WHERE_MATCH);
        if (p.matcher(left).matches()) {
            this.whereClauseReplacement.put(arg0.toString(), arg0.getRightExpression().toString());
            arg0.getRightExpression().accept((ExpressionVisitor)this);
        } else {
            this.visitBinaryExpression((BinaryExpression)arg0);
        }
    }

    public void visit(Between arg0) {
        String s = String.valueOf(arg0.getLeftExpression()) + " >= " + String.valueOf(arg0.getBetweenExpressionStart()) + " and " + String.valueOf(arg0.getLeftExpression()) + " <= " + String.valueOf(arg0.getBetweenExpressionEnd());
        this.whereClauseReplacement.put(arg0.toString(), s);
        arg0.getBetweenExpressionStart().accept((ExpressionVisitor)this);
        arg0.getBetweenExpressionEnd().accept((ExpressionVisitor)this);
    }

    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        binaryExpression.getLeftExpression().accept((ExpressionVisitor)this);
        binaryExpression.getRightExpression().accept((ExpressionVisitor)this);
    }

    public void visit(EqualsTo arg0) {
        this.visitBinaryExpression((BinaryExpression)arg0);
    }

    public void visit(GreaterThan arg0) {
        this.visitBinaryExpression((BinaryExpression)arg0);
    }

    public void visit(GreaterThanEquals arg0) {
        this.visitBinaryExpression((BinaryExpression)arg0);
    }

    public void visit(InExpression arg0) {
    }

    public void visit(IsNullExpression arg0) {
        Object left = arg0.getLeftExpression().toString();
        left = (String)left + "=\"\"";
        this.whereClauseReplacement.put(arg0.toString(), (String)left);
    }

    public void visit(LikeExpression arg0) {
        this.whereClauseReplacement.put(arg0.toString(), String.valueOf(arg0.getLeftExpression()) + " like " + ((StringValue)arg0.getRightExpression()).getValue());
    }

    public void visit(MinorThan arg0) {
        this.visitBinaryExpression((BinaryExpression)arg0);
    }

    public void visit(MinorThanEquals arg0) {
        this.visitBinaryExpression((BinaryExpression)arg0);
    }

    public void visit(NotEqualsTo arg0) {
        this.visitBinaryExpression((BinaryExpression)arg0);
    }

    public void visit(Column arg0) {
        this.whereClauseReplacement.put(arg0.getWholeColumnName(), arg0.getColumnName());
    }

    public void visit(SubSelect arg0) {
    }

    public void visit(CaseExpression arg0) {
    }

    public void visit(WhenClause arg0) {
    }

    public void visit(ExistsExpression arg0) {
    }

    public void visit(AllComparisonExpression arg0) {
    }

    public void visit(AnyComparisonExpression arg0) {
        arg0.accept((ExpressionVisitor)this);
    }

    public void visit(Concat arg0) {
        this.visitBinaryExpression((BinaryExpression)arg0);
    }

    public void visit(Matches arg0) {
        this.visitBinaryExpression((BinaryExpression)arg0);
    }

    public void visit(BitwiseAnd arg0) {
        this.visitBinaryExpression((BinaryExpression)arg0);
    }

    public void visit(BitwiseOr arg0) {
        this.visitBinaryExpression((BinaryExpression)arg0);
    }

    public void visit(BitwiseXor arg0) {
        this.visitBinaryExpression((BinaryExpression)arg0);
    }

    public String removeTableNamePrefix(String whereString, List<TableMetaData> table) {
        for (TableMetaData t : table) {
            String tableName = t.getTableName();
            if (tableName == null) continue;
            whereString = whereString.replace("\"" + tableName + "\".", "");
        }
        return whereString;
    }
}

