/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.common.parser;

import com.stambia.jdbc.common.parser.AbstractVisitor;
import com.stambia.jdbc.common.parser.IWhereVisitor;
import com.stambia.jdbc.common.parser.SelectMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.schema.Column;

public class XLSXWhereVisitor
extends AbstractVisitor
implements IWhereVisitor {
    private boolean isLeftCol = false;
    private boolean isRightCol = false;
    private boolean parsingLeft = false;
    private String leftExpression;
    private String rightExpression;
    private EvaluatorNode evalTree = new EvaluatorNode();
    private Stack<EvaluatorNode> stack = new Stack();

    @Override
    public void visit(NullValue paramNullValue) {
        if (this.parsingLeft) {
            this.leftExpression = null;
        } else {
            this.rightExpression = null;
        }
    }

    @Override
    public void visit(DoubleValue paramDoubleValue) {
        if (this.parsingLeft) {
            this.leftExpression = paramDoubleValue.toString();
        } else {
            this.rightExpression = paramDoubleValue.toString();
        }
    }

    @Override
    public void visit(LongValue paramLongValue) {
        if (this.parsingLeft) {
            this.leftExpression = paramLongValue.toString();
        } else {
            this.rightExpression = paramLongValue.toString();
        }
    }

    @Override
    public void visit(TimeValue paramTimeValue) {
        if (this.parsingLeft) {
            this.leftExpression = paramTimeValue.toString();
        } else {
            this.rightExpression = paramTimeValue.toString();
        }
    }

    @Override
    public void visit(TimestampValue paramTimestampValue) {
        if (this.parsingLeft) {
            this.leftExpression = paramTimestampValue.toString();
        } else {
            this.rightExpression = paramTimestampValue.toString();
        }
    }

    @Override
    public void visit(StringValue paramStringValue) {
        if (this.parsingLeft) {
            this.leftExpression = paramStringValue.toString().substring(1, paramStringValue.toString().length() - 1);
        } else {
            this.rightExpression = paramStringValue.toString().substring(1, paramStringValue.toString().length() - 1);
        }
    }

    @Override
    public void visit(EqualsTo paramEqualsTo) {
        this.visitBinaryExpression((BinaryExpression)paramEqualsTo);
    }

    @Override
    public void visit(Column paramColumn) {
        String columnName = paramColumn.getColumnName();
        if (columnName.equals("true") || columnName.equals("false") || columnName.equals("\"true\"") || columnName.equals("\"false\"")) {
            columnName = columnName.replace("\"", "");
            if (this.parsingLeft) {
                this.leftExpression = columnName.equals("true") ? "1" : "0";
            } else {
                this.rightExpression = columnName.equals("true") ? "1" : "0";
            }
        } else if (this.parsingLeft) {
            this.leftExpression = columnName;
            this.isLeftCol = true;
        } else {
            this.rightExpression = columnName;
            this.isRightCol = true;
        }
    }

    @Override
    public void visit(Matches paramMatches) {
        this.visitBinaryExpression((BinaryExpression)paramMatches);
    }

    @Override
    public void visit(Parenthesis arg0) {
    }

    @Override
    public void visit(AndExpression paramAndExpression) {
        IEvaluator c = null;
        this.stack.peek().addChild(c);
        this.stack.push((EvaluatorNode)c);
        paramAndExpression.getLeftExpression().accept((ExpressionVisitor)this);
        paramAndExpression.getLeftExpression().accept((ExpressionVisitor)this);
        this.stack.pop();
    }

    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        this.parsingLeft = true;
        binaryExpression.getLeftExpression().accept((ExpressionVisitor)this);
        this.parsingLeft = false;
        binaryExpression.getRightExpression().accept((ExpressionVisitor)this);
    }

    @Override
    public boolean isLeftCol() {
        return this.isLeftCol;
    }

    @Override
    public boolean isRightCol() {
        return this.isRightCol;
    }

    @Override
    public String getLeftExpression() {
        if (this.isLeftCol && this.leftExpression.startsWith("\"") && this.leftExpression.endsWith("\"")) {
            return this.leftExpression.substring(1, this.leftExpression.length() - 1);
        }
        return this.leftExpression;
    }

    @Override
    public String getRightExpression() {
        if (this.isRightCol && this.rightExpression.startsWith("\"") && this.rightExpression.endsWith("\"")) {
            return this.rightExpression.substring(1, this.rightExpression.length() - 1);
        }
        return this.rightExpression;
    }

    @Override
    public void setSelectMetaData(SelectMetaData selectMd) {
    }

    public class EvaluatorNode
    implements IEvaluator {
        private List<IEvaluator> children = new ArrayList<IEvaluator>();

        public void addChild(IEvaluator e) {
            this.children.add(e);
        }

        public List<IEvaluator> getChildren() {
            return this.children;
        }

        @Override
        public boolean isValid(String[] row) {
            for (IEvaluator e : this.getChildren()) {
                if (e.isValid(row)) continue;
                return false;
            }
            return true;
        }
    }

    public static interface IEvaluator {
        public boolean isValid(String[] var1);
    }

    public class IsNullEval
    extends EvaluatorNode {
    }

    public class AndEval
    extends EvaluatorNode {
    }

    public class LikeEval
    extends EvaluatorNode {
    }

    public class EqualsEval
    extends EvaluatorNode {
    }
}

