/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xls.xls;

import com.stambia.jdbc.common.parser.InsertMetaData;
import com.stambia.jdbc.common.parser.Parser;
import com.stambia.jdbc.driver.xls.xls.XlsConnection;
import com.stambia.jdbc.driver.xls.xls.XlsException;
import com.stambia.jdbc.driver.xls.xls.XlsStatement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;

public class XlsPrepareStatement
extends XlsStatement
implements PreparedStatement {
    private XlsStatement.InsertStatement is;
    List<Object[]> buffer;
    Object[] currentLine;

    public XlsPrepareStatement(XlsConnection connection, String sql) throws SQLException {
        super(connection);
        Parser parser = new Parser(sql);
        InsertMetaData insertParser = parser.getInsertMetaData();
        if (insertParser != null) {
            this.is = new XlsStatement.InsertStatement(this, insertParser);
            this.is.prepare();
            this.buffer = new ArrayList<Object[]>();
            this.currentLine = this.is.initNewRow();
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.buffer.add(this.currentLine);
        HashMap<String, Object> rowMap = new HashMap<String, Object>();
        for (int i = 0; i < this.currentLine.length; ++i) {
            rowMap.put(this.is.metaData[i].getColumnName(), this.currentLine[i]);
        }
        this.currentLine = this.is.initNewRow();
    }

    @Override
    public void clearParameters() throws SQLException {
        if (this.currentLine != null) {
            for (int i = 0; i < this.currentLine.length; ++i) {
                this.currentLine[i] = null;
            }
        }
    }

    @Override
    public boolean execute() throws SQLException {
        this.is.insert(this.currentLine);
        this.clearBatch();
        if (this.getConnection().getAutoCommit()) {
            this.getConnection().commit();
        }
        return true;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        return null;
    }

    @Override
    public int executeUpdate() throws SQLException {
        return 0;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        int[] ret = this.is.insert(this.buffer);
        if (this.getConnection().getAutoCommit()) {
            this.getConnection().commit();
        }
        this.clearBatch();
        return ret;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.buffer.clear();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return null;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new ParameterMetaData(){

            @Override
            public <T> T unwrap(Class<T> arg0) throws SQLException {
                return null;
            }

            @Override
            public boolean isWrapperFor(Class<?> arg0) throws SQLException {
                return false;
            }

            @Override
            public boolean isSigned(int param) throws SQLException {
                return false;
            }

            @Override
            public int isNullable(int param) throws SQLException {
                return 1;
            }

            @Override
            public int getScale(int param) throws SQLException {
                return 0;
            }

            @Override
            public int getPrecision(int param) throws SQLException {
                return 0;
            }

            @Override
            public String getParameterTypeName(int param) throws SQLException {
                return "Other";
            }

            @Override
            public int getParameterType(int param) throws SQLException {
                return 1111;
            }

            @Override
            public int getParameterMode(int param) throws SQLException {
                return 0;
            }

            @Override
            public int getParameterCount() throws SQLException {
                return XlsPrepareStatement.this.is.parameterNumber;
            }

            @Override
            public String getParameterClassName(int param) throws SQLException {
                return String.class.getName();
            }
        };
    }

    @Override
    public void setArray(int arg0, Array arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    private String inputStreamToString(InputStream is) throws IOException {
        return this.readerToString(new BufferedReader(new InputStreamReader(is)));
    }

    private String readerToString(Reader reader) throws IOException {
        String line;
        StringWriter writer = new StringWriter();
        BufferedReader buffer = new BufferedReader(reader);
        while (null != (line = buffer.readLine())) {
            writer.write(line);
        }
        return writer.toString();
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1) throws SQLException {
        if (arg1 != null) {
            try {
                this.currentLine[arg0 - 1] = this.inputStreamToString(arg1);
            }
            catch (IOException e) {
                throw new XlsException(e);
            }
        }
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        if (arg1 != null) {
            try {
                this.currentLine[arg0 - 1] = this.inputStreamToString(arg1).substring(0, arg2);
            }
            catch (IOException e) {
                throw new XlsException(e);
            }
        }
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        if (arg1 != null) {
            this.currentLine[arg0 - 1] = arg1;
        }
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(int arg0, Blob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(int arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBoolean(int arg0, boolean arg1) throws SQLException {
        this.currentLine[arg0 - 1] = arg1;
    }

    @Override
    public void setByte(int arg0, byte arg1) throws SQLException {
        this.currentLine[arg0 - 1] = arg1;
    }

    @Override
    public void setBytes(int arg0, byte[] arg1) throws SQLException {
        this.currentLine[arg0 - 1] = new String(arg1);
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1) throws SQLException {
        if (arg1 != null) {
            try {
                this.currentLine[arg0 - 1] = this.readerToString(arg1);
            }
            catch (IOException e) {
                throw new XlsException(e);
            }
        }
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        if (arg1 != null) {
            try {
                this.currentLine[arg0 - 1] = this.readerToString(arg1).substring(0, arg2);
            }
            catch (IOException e) {
                throw new XlsException(e);
            }
        }
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setClob(int arg0, Clob arg1) throws SQLException {
        if (arg1 != null) {
            this.setCharacterStream(arg0, arg1.getCharacterStream());
        }
    }

    @Override
    public void setClob(int arg0, Reader arg1) throws SQLException {
        this.setCharacterStream(arg0, arg1);
    }

    @Override
    public void setClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDate(int arg0, Date arg1) throws SQLException {
        if (arg1 != null) {
            this.currentLine[arg0 - 1] = arg1;
        }
    }

    @Override
    public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setDouble(int arg0, double arg1) throws SQLException {
        this.currentLine[arg0 - 1] = arg1;
    }

    @Override
    public void setFloat(int arg0, float arg1) throws SQLException {
        this.currentLine[arg0 - 1] = Float.valueOf(arg1);
    }

    @Override
    public void setInt(int arg0, int arg1) throws SQLException {
        this.currentLine[arg0 - 1] = arg1;
    }

    @Override
    public void setLong(int arg0, long arg1) throws SQLException {
        this.currentLine[arg0 - 1] = arg1;
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(int arg0, NClob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNString(int arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNull(int arg0, int arg1) throws SQLException {
        this.currentLine[arg0 - 1] = null;
    }

    @Override
    public void setNull(int arg0, int arg1, String arg2) throws SQLException {
        this.currentLine[arg0 - 1] = null;
    }

    @Override
    public void setObject(int arg0, Object arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(int arg0, Object arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setObject(int arg0, Object arg1, int arg2, int arg3) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setRef(int arg0, Ref arg1) throws SQLException {
        if (arg1 != null) {
            this.currentLine[arg0 - 1] = arg1.toString();
        }
    }

    @Override
    public void setRowId(int arg0, RowId arg1) throws SQLException {
        if (arg1 != null) {
            this.currentLine[arg0 - 1] = arg1.toString();
        }
    }

    @Override
    public void setSQLXML(int arg0, SQLXML arg1) throws SQLException {
        if (arg1 != null) {
            this.currentLine[arg0 - 1] = arg1.toString();
        }
    }

    @Override
    public void setShort(int arg0, short arg1) throws SQLException {
        this.currentLine[arg0 - 1] = Short.toString(arg1);
    }

    @Override
    public void setString(int arg0, String arg1) throws SQLException {
        this.currentLine[arg0 - 1] = arg1;
    }

    @Override
    public void setTime(int arg0, Time arg1) throws SQLException {
        if (arg1 != null) {
            this.currentLine[arg0 - 1] = arg1;
        }
    }

    @Override
    public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setTimestamp(int arg0, Timestamp arg1) throws SQLException {
        if (arg1 != null) {
            this.currentLine[arg0 - 1] = arg1;
        }
    }

    @Override
    public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setURL(int arg0, URL arg1) throws SQLException {
        if (arg1 != null) {
            this.currentLine[arg0 - 1] = arg1.toString();
        }
    }

    @Override
    public void setUnicodeStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

