/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xlsx;

import java.util.HashMap;
import java.util.Map;

public class DataFormat {
    private static HashMap<Integer, String> defaultsFormats = new HashMap();

    public static boolean isDateFormat(String format) {
        Integer formatIdx = DataFormat.getFormatIdx(format);
        if (formatIdx != null) {
            switch (formatIdx) {
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 45: 
                case 46: 
                case 47: {
                    return true;
                }
            }
        }
        return false;
    }

    public static Integer getFormatIdx(String format) {
        if (defaultsFormats.containsValue(format)) {
            for (Map.Entry<Integer, String> entry : defaultsFormats.entrySet()) {
                if (!entry.getValue().equals(format)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public static String getFormat(int formatIdx) {
        return defaultsFormats.get(formatIdx);
    }

    static {
        defaultsFormats.put(0, "General");
        defaultsFormats.put(1, "0");
        defaultsFormats.put(2, "0.00");
        defaultsFormats.put(3, "#,##0");
        defaultsFormats.put(4, "#,##0.00");
        defaultsFormats.put(5, "\"$\"#,##0_);(\"$\"#,##0)");
        defaultsFormats.put(6, "\"$\"#,##0_);[Red](\"$\"#,##0)");
        defaultsFormats.put(7, "\"$\"#,##0.00_);(\"$\"#,##0.00)");
        defaultsFormats.put(8, "\"$\"#,##0.00_);[Red](\"$\"#,##0.00)");
        defaultsFormats.put(9, "0%");
        defaultsFormats.put(10, "0.00%");
        defaultsFormats.put(11, "0.00E+00");
        defaultsFormats.put(12, "# ?/?");
        defaultsFormats.put(13, "# ??/??");
        defaultsFormats.put(14, "m/d/yy");
        defaultsFormats.put(15, "d-mmm-yy");
        defaultsFormats.put(16, "d-mmm");
        defaultsFormats.put(17, "mmm-yy");
        defaultsFormats.put(18, "h:mm AM/PM");
        defaultsFormats.put(19, "h:mm:ss AM/PM");
        defaultsFormats.put(20, "h:mm");
        defaultsFormats.put(21, "h:mm:ss");
        defaultsFormats.put(22, "m/d/yy h:mm");
        for (int i = 23; i <= 36; ++i) {
            defaultsFormats.put(i, "unused-0x" + Integer.toHexString(i));
        }
        defaultsFormats.put(37, "#,##0_);(#,##0)");
        defaultsFormats.put(38, "#,##0_);[Red](#,##0)");
        defaultsFormats.put(39, "#,##0.00_);(#,##0.00)");
        defaultsFormats.put(40, "#,##0.00_);[Red](#,##0.00)");
        defaultsFormats.put(41, "_(\"$\"* #,##0_);_(\"$\"* (#,##0);_(\"$\"* \"-\"_);_(@_)");
        defaultsFormats.put(42, "_(* #,##0_);_(* (#,##0);_(* \"-\"_);_(@_)");
        defaultsFormats.put(43, "_(\"$\"* #,##0.00_);_(\"$\"* (#,##0.00);_(\"$\"* \"-\"??_);_(@_)");
        defaultsFormats.put(44, "_(* #,##0.00_);_(* (#,##0.00);_(* \"-\"??_);_(@_)");
        defaultsFormats.put(45, "mm:ss");
        defaultsFormats.put(46, "[h]:mm:ss");
        defaultsFormats.put(47, "mm:ss.0");
        defaultsFormats.put(48, "##0.0E+0");
        defaultsFormats.put(49, "@");
    }
}

