/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xlsx;

import com.stambia.jdbc.driver.xlsx.Messages;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class XlsxUtils {
    public static final String TABLE_DELIMITER_PATTERN = ".*![a-zA-Z]+\\d+:[a-zA-Z]+\\d+";

    private XlsxUtils() {
    }

    public static int getExcelIndexLetterToInteger(String excelColumnIndex) {
        String columnLetter = excelColumnIndex.replaceAll("[^a-zA-Z]", "");
        columnLetter = columnLetter.toUpperCase();
        int number = 0;
        int pow = 1;
        for (int i = columnLetter.length() - 1; i >= 0; --i) {
            number += (columnLetter.charAt(i) - 65 + 1) * pow;
            pow *= 26;
        }
        return number;
    }

    public static String getExcelIndexStrFromRowNumberAndCellIdx(int rowNumber, int columnIdx) {
        int dividend = columnIdx;
        Object columnName = "";
        while (dividend > 0) {
            int modulo = (dividend - 1) % 26;
            int i = 65 + modulo;
            columnName = Character.toString((char)i) + (String)columnName;
            dividend = (dividend - modulo) / 26;
        }
        return (String)columnName + rowNumber;
    }

    public static int getRowStartFromTableDelimiter(String delimiter) {
        delimiter = delimiter.replace("$", "");
        String[] split = delimiter.split(":");
        return Integer.parseInt(split[0].replaceAll("[^0-9]", ""));
    }

    public static int getRowEndFromTableDelimiter(String delimiter) {
        delimiter = delimiter.replace("$", "");
        String[] split = delimiter.split(":");
        return Integer.parseInt(split[1].replaceAll("[^0-9]", ""));
    }

    public static int getColumnStartFromTableDelimiter(String delimiter) {
        delimiter = delimiter.replace("$", "");
        String[] split = delimiter.split(":");
        return XlsxUtils.getExcelIndexLetterToInteger(split[0]);
    }

    public static int getColumnEndFromTableDelimiter(String delimiter) {
        delimiter = delimiter.replace("$", "");
        String[] split = delimiter.split(":");
        return XlsxUtils.getExcelIndexLetterToInteger(split[1]);
    }

    public static String removeTableDelimiter(String tableNamePattern) {
        if (tableNamePattern.matches(TABLE_DELIMITER_PATTERN)) {
            return tableNamePattern.replaceAll("![a-zA-Z]+\\d+:[a-zA-Z]+\\d+", "");
        }
        return tableNamePattern;
    }

    public static String formatTableName(String tableName) {
        StringBuilder b = new StringBuilder();
        b.append(tableName);
        b.append("$");
        return b.toString();
    }

    public static String unformatTableName(String tableName) {
        if (tableName.startsWith("'")) {
            return tableName.substring(1, tableName.length() - 2);
        }
        if (tableName.endsWith("$")) {
            return tableName.substring(0, tableName.length() - 1);
        }
        return tableName;
    }

    public static double getExcelDate(boolean is1904DateSystem, Calendar date) {
        if (!is1904DateSystem && date.get(1) < 1900 || is1904DateSystem && date.get(1) < 1904) {
            throw new IllegalArgumentException(Messages.getString("XlsxUtils.0"));
        }
        double fraction = (double)(((date.get(11) * 60 + date.get(12)) * 60 + date.get(13)) * 1000 + date.get(14)) / 8.64E7;
        Calendar calStart = XlsxUtils.setCalendarToDayStart(date);
        double value = fraction + (double)XlsxUtils.getCalendarNumberOfDays(calStart, is1904DateSystem);
        if (!is1904DateSystem && value >= 60.0) {
            value += 1.0;
        } else if (is1904DateSystem) {
            value -= 1.0;
        }
        return value;
    }

    public static int getCalendarNumberOfDays(Calendar cal, boolean is1904DateSystem) {
        int calYear = cal.get(1);
        if (!is1904DateSystem && calYear < 1900 || is1904DateSystem && calYear < 1900) {
            throw new IllegalArgumentException(Messages.getString("XlsxUtils.1"));
        }
        int nbDayBeforeCalYear = 0;
        int yearToCountFrom = calYear - 1;
        int leapDays = yearToCountFrom / 4 - yearToCountFrom / 100 + yearToCountFrom / 400 - 460;
        nbDayBeforeCalYear = 365 * (calYear - (is1904DateSystem ? 1904 : 1900)) + leapDays;
        return cal.get(6) + nbDayBeforeCalYear;
    }

    public static Calendar setCalendarToDayStart(Calendar cal) {
        cal.get(11);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.get(11);
        return cal;
    }

    public static Object getExcelDateFromSqlDate(Object value, boolean is1904DateSystem) {
        if (value instanceof java.sql.Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(((java.sql.Date)value).getTime());
            return XlsxUtils.getExcelDate(is1904DateSystem, cal);
        }
        if (value instanceof Time) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(((Time)value).getTime());
            return XlsxUtils.getExcelDate(is1904DateSystem, cal);
        }
        if (value instanceof Timestamp) {
            Calendar cal = Calendar.getInstance();
            cal.setTimeInMillis(((Timestamp)value).getTime());
            return XlsxUtils.getExcelDate(is1904DateSystem, cal);
        }
        if (value instanceof Calendar) {
            return XlsxUtils.getExcelDate(is1904DateSystem, (Calendar)value);
        }
        if (value instanceof Date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime((Date)value);
            return XlsxUtils.getExcelDate(is1904DateSystem, cal);
        }
        return null;
    }

    public static Date xlsxDateToJavaDate(boolean is1904DateSystem, double date) {
        int dayAdjust;
        int wholeDays = (int)Math.floor(date);
        int millisecondsInDay = (int)((date - (double)wholeDays) * 8.64E7 + 0.5);
        GregorianCalendar calendar = new GregorianCalendar();
        int startYear = is1904DateSystem ? 1904 : 1900;
        int n = dayAdjust = is1904DateSystem ? 1 : -1;
        if (wholeDays < 61) {
            dayAdjust = 0;
        }
        calendar.set(startYear, 0, wholeDays + dayAdjust, 0, 0, 0);
        calendar.set(14, millisecondsInDay);
        return calendar.getTime();
    }
}

