/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xlsx.part;

import com.stambia.jdbc.driver.xlsx.Constant;
import com.stambia.jdbc.driver.xlsx.DataFormat;
import com.stambia.jdbc.driver.xlsx.part.WorkBook;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StyleSheet {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private Map<Integer, String> numFmts = new HashMap<Integer, String>();
    private List<Integer> cellFormat = new ArrayList<Integer>();

    public StyleSheet(WorkBook workbook, String pathInZip) {
    }

    private void parseCellXfs(XMLStreamReader reader) {
        try {
            boolean SHEET_CELL_XFS = true;
            while (reader.hasNext() && SHEET_CELL_XFS) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        int count = reader.getAttributeCount();
                        String numFmtId = null;
                        for (int i = 0; i < count; ++i) {
                            String name = reader.getAttributeLocalName(i);
                            String value = reader.getAttributeValue(i);
                            if (!name.equals(Constant.STYLE_SHEET_NUM_FMT_ID)) continue;
                            numFmtId = value;
                        }
                        if (numFmtId == null) break;
                        this.cellFormat.add(Integer.parseInt(numFmtId));
                        break;
                    }
                    case 2: {
                        if (!reader.getLocalName().equals(Constant.STYLE_SHEET_CELL_XFS)) break;
                        SHEET_CELL_XFS = false;
                    }
                }
            }
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            this.logger.warn("unexpected", e);
        }
    }

    private void parseNumFmts(XMLStreamReader reader) {
        try {
            boolean SHEET_NUM_FMTS = true;
            while (reader.hasNext() && SHEET_NUM_FMTS) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        int count = reader.getAttributeCount();
                        String numFmtId = null;
                        String formatCode = null;
                        for (int i = 0; i < count; ++i) {
                            String name = reader.getAttributeLocalName(i);
                            String value = reader.getAttributeValue(i);
                            if (name.equals(Constant.STYLE_SHEET_NUM_FMT_ID)) {
                                numFmtId = value;
                                continue;
                            }
                            if (!name.equals(Constant.STYLE_SHEET_NUM_FMT_FORMAT_CODE)) continue;
                            formatCode = value;
                        }
                        this.numFmts.put(Integer.parseInt(numFmtId), formatCode);
                        break;
                    }
                    case 2: {
                        if (!reader.getLocalName().equals(Constant.STYLE_SHEET_NUM_FMTS)) break;
                        SHEET_NUM_FMTS = false;
                    }
                }
            }
        }
        catch (FactoryConfigurationError | XMLStreamException e) {
            this.logger.warn("unexpected", e);
        }
    }

    public String getCellFormat(Integer cellStyle) {
        Integer numFmtid;
        if (cellStyle != null && (numFmtid = this.cellFormat.get(cellStyle)) != null) {
            if (this.numFmts.containsKey(numFmtid)) {
                return this.numFmts.get(numFmtid);
            }
            if (DataFormat.getFormat(numFmtid) != null) {
                return DataFormat.getFormat(numFmtid);
            }
        }
        return null;
    }
}

