/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xlsx.part;

import com.stambia.jdbc.common.tools.ColumnNameGeneratorUtil;
import com.stambia.jdbc.driver.xlsx.Constant;
import com.stambia.jdbc.driver.xlsx.part.DefinedName;
import com.stambia.jdbc.driver.xlsx.part.DefinedTable;
import com.stambia.jdbc.driver.xlsx.part.Package;
import com.stambia.jdbc.driver.xlsx.part.RelationShip;
import com.stambia.jdbc.driver.xlsx.part.SharedString;
import com.stambia.jdbc.driver.xlsx.part.Sheet;
import com.stambia.jdbc.driver.xlsx.part.StyleSheet;
import com.stambia.jdbc.driver.xlsx.part.XlsFileHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkBook {
    private Map<String, RelationShip> relations;
    private Map<String, Sheet> sheets;
    private HashMap<String, Boolean> sheetsComputingStatus;
    private SharedString sharedString;
    private String workbookFolder;
    private StyleSheet style;
    private boolean is1904DateSystem;
    private String workbookPathInZip;
    private Map<String, DefinedName> definedNames;
    private Package zipPackage;
    private ColumnNameGeneratorUtil definedNameGenerator;
    private Map<String, DefinedTable> definedTables = new HashMap<String, DefinedTable>();
    private final Logger logger = LogManager.getLogger(this.getClass());

    public WorkBook(Package zipPackage, String workbookPathInZip) {
        this.zipPackage = zipPackage;
        this.sheets = new HashMap<String, Sheet>();
        this.sharedString = new SharedString(0, 0, new HashMap<Integer, String>());
        this.relations = new HashMap<String, RelationShip>();
        this.definedNames = new HashMap<String, DefinedName>();
        this.sheetsComputingStatus = new HashMap();
        this.is1904DateSystem = false;
        this.workbookPathInZip = workbookPathInZip;
        this.definedNameGenerator = new ColumnNameGeneratorUtil(ColumnNameGeneratorUtil.Style.PRESERVE);
    }

    public Package getPackage() {
        return this.zipPackage;
    }

    public void refreshWorkbookParts() throws Exception {
        InputStream relationStream = null;
        try {
            this.initWorkbookFolder();
            relationStream = this.zipPackage.getFileHelper().getInputStreamFromZipStream(this.getWorkBookRelFile(this.workbookPathInZip));
            this.parseRelations(relationStream);
        }
        finally {
            if (relationStream != null) {
                try {
                    relationStream.close();
                }
                catch (IOException e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
        }
    }

    private void initWorkbookFolder() {
        int lastSeparator = Math.max(this.workbookPathInZip.lastIndexOf(47), this.workbookPathInZip.lastIndexOf(92));
        this.workbookFolder = this.workbookPathInZip.substring(0, lastSeparator);
    }

    private String getWorkBookRelFile(String workbookPathInZip) {
        int lastSeparator = Math.max(workbookPathInZip.lastIndexOf(47), workbookPathInZip.lastIndexOf(92));
        return this.workbookFolder + "/" + Constant.RELATION_FOLDER + "/" + workbookPathInZip.substring(lastSeparator + 1) + Constant.RELATION_FILE_EXT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parseWorkBook() throws Exception {
        XMLStreamReader reader = null;
        InputStream workbookStream = null;
        try {
            workbookStream = this.zipPackage.getFileHelper().getInputStreamFromZipStream(this.workbookPathInZip);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.supportDTD", false);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            reader = factory.createXMLStreamReader(workbookStream);
            while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if (Constant.WORKBOOK_SHEETS.equals(reader.getLocalName())) {
                            this.processSheets(reader);
                            break;
                        }
                        if (Constant.WORKBOOK_DEFINED_NAMES.equals(reader.getLocalName())) {
                            this.processDefinedNames(reader);
                            break;
                        }
                        if (!Constant.WORKBOOK_PR.equals(reader.getLocalName())) break;
                        this.processWorkbookPr(reader);
                    }
                }
            }
            this.parseDefinedTables();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
            if (workbookStream != null) {
                try {
                    workbookStream.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
        }
    }

    private String getTemporaryFileName(String tempFilePath) {
        int index;
        String temporaryFileName = tempFilePath;
        if (temporaryFileName.contains("/")) {
            index = temporaryFileName.lastIndexOf("/");
            temporaryFileName = temporaryFileName.substring(index + 1);
        }
        if (temporaryFileName.contains(".")) {
            index = temporaryFileName.indexOf(".");
            temporaryFileName = temporaryFileName.substring(0, index);
        }
        return temporaryFileName;
    }

    private void parseDefinedTables() throws Exception {
        Set<String> temporaryFilesNames = this.zipPackage.getFileHelper().getTemporaryFilesNames();
        if (temporaryFilesNames != null) {
            String temporaryFileName;
            HashMap<String, Set<String>> tableRelations = new HashMap<String, Set<String>>();
            HashMap<String, DefinedTable> definedTablePerFiles = new HashMap<String, DefinedTable>();
            for (String temporaryFile : temporaryFilesNames) {
                if (temporaryFile.startsWith("xl/tables/") && temporaryFile.endsWith(".xml")) {
                    DefinedTable definedTable = new DefinedTable(this.zipPackage, temporaryFile);
                    if (null == definedTable) continue;
                    String definedTableName = null != definedTable.getName() ? definedTable.getName() : definedTable.getDisplayName();
                    this.definedTables.put(definedTableName, definedTable);
                    temporaryFileName = this.getTemporaryFileName(temporaryFile);
                    definedTablePerFiles.put(temporaryFileName, definedTable);
                    continue;
                }
                if (!temporaryFile.startsWith("xl/worksheets/_rels/") || !temporaryFile.endsWith(".xml.rels")) continue;
                this.memoizeTableRelations(temporaryFile, tableRelations);
            }
            HashMap<String, Sheet> localSheets = new HashMap<String, Sheet>();
            for (Sheet sheet : this.getSheets().values()) {
                String pathInZip = sheet.getPathInsideZip();
                temporaryFileName = this.getTemporaryFileName(pathInZip);
                localSheets.put(temporaryFileName, sheet);
            }
            for (Map.Entry entry : tableRelations.entrySet()) {
                String sheetName = (String)entry.getKey();
                Sheet sheet = (Sheet)localSheets.get(sheetName);
                for (String tableFile : (Set)entry.getValue()) {
                    DefinedTable table = (DefinedTable)definedTablePerFiles.get(tableFile);
                    if (null == table) continue;
                    table.setSheet(sheet);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void memoizeTableRelations(String relationFile, Map<String, Set<String>> tableRelations) throws Exception {
        if (null != relationFile) {
            String sheet = this.getTemporaryFileName(relationFile);
            HashSet<String> tables = new HashSet<String>();
            tableRelations.put(sheet, tables);
            XMLStreamReader reader = null;
            InputStream stream = null;
            try {
                stream = this.zipPackage.getFileHelper().getInputStreamFromZipStream(relationFile);
                XMLInputFactory factory = XMLInputFactory.newInstance();
                factory.setProperty("javax.xml.stream.supportDTD", false);
                factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                reader = factory.createXMLStreamReader(stream);
                while (reader.hasNext()) {
                    int event = reader.next();
                    if (1 != event) continue;
                    String markup = reader.getLocalName();
                    int attributesNumber = reader.getAttributeCount();
                    if (!"Relationship".equals(markup)) continue;
                    String fileName = null;
                    for (int index = 0; index <= attributesNumber; ++index) {
                        String attributeName = reader.getAttributeLocalName(index);
                        if (!"Target".equals(attributeName)) continue;
                        fileName = reader.getAttributeValue(index);
                        break;
                    }
                    if (null != fileName) {
                        fileName = this.getTemporaryFileName(fileName);
                    }
                    tables.add(fileName);
                }
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        this.logger.warn("Unexpected", (Throwable)e);
                    }
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e) {
                        this.logger.warn("Unexpected", (Throwable)e);
                    }
                }
            }
        }
    }

    private void processDefinedNames(XMLStreamReader reader) {
        boolean state = true;
        try {
            StringBuilder builder = new StringBuilder(100);
            String definedName = null;
            block7: while (reader.hasNext() && state) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        int count = reader.getAttributeCount();
                        for (int i = 0; i < count; ++i) {
                            String name = reader.getAttributeLocalName(i);
                            String value = reader.getAttributeValue(i);
                            if (!name.equals(Constant.WORKBOOK_DEFINED_NAMES_NAME)) continue;
                            builder.setLength(0);
                            definedName = value;
                        }
                        continue block7;
                    }
                    case 4: {
                        builder.append(reader.getText());
                        break;
                    }
                    case 2: {
                        if (reader.getLocalName().equals(Constant.WORKBOOK_DEFINED_NAME)) {
                            String sheetNameAndRange = builder.toString();
                            if (sheetNameAndRange.contains("#REF") || !sheetNameAndRange.contains(":")) continue block7;
                            this.definedNames.put(this.definedNameGenerator.addColumnName(definedName), new DefinedName(definedName, sheetNameAndRange));
                            break;
                        }
                        if (!reader.getLocalName().equals(Constant.WORKBOOK_DEFINED_NAMES)) break;
                        state = false;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            this.logger.warn("Unexpected", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processWorkbookPr(XMLStreamReader reader) {
        boolean state = true;
        try {
            block6: while (reader.hasNext() && state) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        int count = reader.getAttributeCount();
                        for (int i = 0; i < count; ++i) {
                            String name = reader.getAttributeLocalName(i);
                            String value = reader.getAttributeValue(i);
                            if (!name.equals(Constant.WORKBOOK_PR_DATE_1904) || !value.equals("1")) continue;
                            this.is1904DateSystem = true;
                        }
                        continue block6;
                    }
                    case 2: {
                        if (!reader.getLocalName().equals(Constant.WORKBOOK_PR)) break;
                        state = false;
                        continue block6;
                    }
                }
            }
            return;
        }
        catch (XMLStreamException e) {
            this.logger.warn("Unexpected", (Throwable)e);
        }
    }

    private void processSheets(XMLStreamReader reader) {
        boolean state = true;
        try {
            while (reader.hasNext() && state) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        String sheetId = null;
                        String sheetName = null;
                        String sheetRelationId = null;
                        int count = reader.getAttributeCount();
                        for (int i = 0; i < count; ++i) {
                            String name = reader.getAttributeLocalName(i);
                            String value = reader.getAttributeValue(i);
                            if (name.equals(Constant.SHEET_ID)) {
                                sheetId = value;
                                continue;
                            }
                            if (name.equals(Constant.SHEET_NAME)) {
                                sheetName = value;
                                continue;
                            }
                            if (!name.equals(Constant.SHEET_RELATION_ID)) continue;
                            sheetRelationId = value;
                        }
                        this.sheets.put(sheetName, new Sheet(this, sheetName, sheetRelationId, this.getWorkBookDepencyFilePath(this.relations.get(sheetRelationId).getTarget())));
                        this.sheetsComputingStatus.put(sheetName, false);
                        break;
                    }
                    case 2: {
                        if (!reader.getLocalName().equals(Constant.WORKBOOK_SHEETS)) break;
                        state = false;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            this.logger.warn("Unexpected", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseRelations(InputStream stream) throws Exception {
        XMLStreamReader reader = null;
        try {
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.supportDTD", false);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            reader = factory.createXMLStreamReader(stream);
            while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if (!Constant.RELATIONSHIP_ELEMENT_NAME.equals(reader.getLocalName())) break;
                        this.processRelationships(reader);
                    }
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
        }
    }

    private void processRelationships(XMLStreamReader reader) throws Exception {
        int count = reader.getAttributeCount();
        String id = null;
        String relationType = null;
        String target = null;
        String targetMode = null;
        boolean isSharedString = false;
        for (int i = 0; i < count; ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            if (name.equals(Constant.RELATIONSHIP_ID)) {
                id = value;
            } else if (name.equals(Constant.RELATIONSHIP_TYPE)) {
                relationType = value;
                if (relationType.equals(Constant.SHARED_STRING_RELATIONS)) {
                    isSharedString = true;
                }
            } else if (name.equals(Constant.RELATIONSHIP_TARGET)) {
                target = value;
            } else if (name.equals(Constant.RELATIONSHIP_TARGET_MODE)) {
                targetMode = value;
            }
            if (targetMode == null) {
                targetMode = Constant.INTERNAL_TARGET;
            }
            if (isSharedString && target != null) {
                this.parseSharedString(target);
            }
            this.relations.put(id, new RelationShip(id, relationType, target, targetMode));
        }
    }

    private String getWorkBookDepencyFilePath(String filePath) {
        return this.workbookFolder + "/" + filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSharedString(String target) throws Exception {
        InputStream relsStream = null;
        XMLStreamReader reader = null;
        try {
            relsStream = this.zipPackage.getFileHelper().getInputStreamFromZipStream(this.getWorkBookDepencyFilePath(target));
            XMLInputFactory factory = XMLInputFactory.newInstance();
            factory.setProperty("javax.xml.stream.supportDTD", false);
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
            reader = factory.createXMLStreamReader(relsStream);
            boolean si = false;
            StringBuilder builder = new StringBuilder(100);
            Integer i = 0;
            int count = 0;
            int uniqueCount = 0;
            LinkedHashMap<Integer, String> sharedStringMap = new LinkedHashMap<Integer, String>();
            block32: while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 4: {
                        if (!si) break;
                        builder.append(reader.getText());
                        break;
                    }
                    case 1: {
                        String tagName = reader.getLocalName();
                        switch (tagName) {
                            case "sst": {
                                int attributesNumber = reader.getAttributeCount();
                                block33: for (int attributeIndex = 0; attributeIndex < attributesNumber; ++attributeIndex) {
                                    String attributeName = reader.getAttributeLocalName(attributeIndex);
                                    String attributeValue = reader.getAttributeValue(attributeIndex);
                                    switch (attributeName) {
                                        case "count": {
                                            count = Integer.valueOf(attributeValue);
                                            continue block33;
                                        }
                                        case "uniqueCount": {
                                            uniqueCount = Integer.valueOf(attributeValue);
                                            continue block33;
                                        }
                                    }
                                }
                                continue block32;
                            }
                            case "si": {
                                builder.setLength(0);
                                si = true;
                                break;
                            }
                        }
                        continue block32;
                    }
                    case 2: {
                        if (!"si".equals(reader.getLocalName())) break;
                        Object object = i;
                        i = i + 1;
                        sharedStringMap.put((Integer)object, builder.toString());
                        si = false;
                    }
                }
            }
            this.sharedString = new SharedString(count, uniqueCount, sharedStringMap);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
            try {
                relsStream.close();
            }
            catch (Exception e) {
                this.logger.warn("Unexpected", (Throwable)e);
            }
        }
    }

    public String getWorkbookFolder() {
        return this.workbookFolder;
    }

    public List<String> getSheetNames() {
        return new ArrayList<String>(this.sheets.keySet());
    }

    public Sheet getSheet(String sheetName) {
        if (sheetName.startsWith("[") && sheetName.endsWith("]")) {
            Integer idx = Integer.valueOf(sheetName.substring(1, sheetName.length() - 1));
            for (Map.Entry<String, Sheet> str : this.sheets.entrySet()) {
                Sheet sheet = str.getValue();
                if (!sheet.getRelationId().replace("rId", "").equals(String.valueOf(idx))) continue;
                return sheet;
            }
        } else {
            for (Map.Entry<String, Sheet> str : this.sheets.entrySet()) {
                if (!str.getKey().equalsIgnoreCase(sheetName)) continue;
                return str.getValue();
            }
        }
        return null;
    }

    public SharedString getSharedString() {
        return this.sharedString;
    }

    public StyleSheet getStyle() {
        return this.style;
    }

    public boolean is1904DateSystem() {
        return this.is1904DateSystem;
    }

    public void computeMetaData(Map<String, Map<String, DefinedName>> definedNames) throws Exception {
        this.refreshWorkbookParts();
        this.parseWorkBook();
        this.addFormatDefinedNames(definedNames);
    }

    private void addFormatDefinedNames(Map<String, Map<String, DefinedName>> definedNames) {
        if (definedNames != null) {
            for (Map.Entry<String, Map<String, DefinedName>> catalog : definedNames.entrySet()) {
                if (!catalog.getKey().equals(this.getPackage().getCatalog())) continue;
                for (DefinedName definedName : catalog.getValue().values()) {
                    String formatDefinedName = this.definedNameGenerator.addColumnName(definedName.getName());
                    this.definedNames.put(formatDefinedName, definedName);
                }
            }
        }
    }

    public void computeSheetData(String sheetName) {
        if (this.sheets.containsKey(sheetName) && !this.sheetsComputingStatus.get(sheetName).booleanValue()) {
            this.sheets.get(sheetName).parseSheet(false, false, true);
            this.sheetsComputingStatus.put(sheetName, true);
        }
    }

    public DefinedName getDefinedName(String definedName) {
        for (Map.Entry<String, DefinedName> str : this.definedNames.entrySet()) {
            if (!str.getKey().equalsIgnoreCase(definedName)) continue;
            return str.getValue();
        }
        return null;
    }

    public DefinedTable getDefinedTable(String definedTableName) {
        DefinedTable definedTable = null;
        if (null != this.definedTables) {
            definedTable = this.definedTables.getOrDefault(definedTableName, null);
        }
        return definedTable;
    }

    public Set<String> getDefinedNames() {
        return this.definedNames.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementeDefinedName(XMLInputFactory inFactory, XMLOutputFactory outFactory, String sheetName, int offset) throws Exception {
        DefinedName definedName = this.getDefinedName(sheetName);
        if (definedName != null && definedName.getRowStart() != definedName.getRowEnd()) {
            XMLEventWriter writer = null;
            XMLEventReader reader = null;
            XlsFileHelper.TemporaryOutputStream outStream = null;
            InputStream workbookStream = null;
            XMLEventFactory eventFactory = XMLEventFactory.newInstance();
            try {
                workbookStream = this.zipPackage.getFileHelper().getInputStreamFromZipStream(this.workbookPathInZip);
                reader = inFactory.createXMLEventReader(workbookStream);
                outStream = this.zipPackage.getFileHelper().getEntryTemporaryOutputStream(this.workbookPathInZip);
                writer = outFactory.createXMLEventWriter(outStream);
                boolean upgradeDefinedName = false;
                ArrayDeque<XMLEvent> eventStack = new ArrayDeque<XMLEvent>();
                StringBuilder builder = new StringBuilder(100);
                while (reader.hasNext()) {
                    XMLEvent event = reader.nextEvent();
                    switch (event.getEventType()) {
                        case 1: {
                            if (!Constant.WORKBOOK_DEFINED_NAME.equals(event.asStartElement().getName().getLocalPart())) break;
                            Iterator<Attribute> definedNameAttr = event.asStartElement().getAttributes();
                            while (definedNameAttr.hasNext()) {
                                Attribute attribute = definedNameAttr.next();
                                String name = attribute.getName().getLocalPart();
                                String value = attribute.getValue();
                                if (!name.equals(Constant.WORKBOOK_DEFINED_NAMES_NAME) || !value.equals(sheetName)) continue;
                                builder.setLength(0);
                                upgradeDefinedName = true;
                            }
                            break;
                        }
                        case 4: {
                            builder.append(event.asCharacters().getData());
                            break;
                        }
                        case 2: {
                            if (!Constant.WORKBOOK_DEFINED_NAME.equals(event.asEndElement().getName().getLocalPart()) || !upgradeDefinedName) break;
                            Object sheetNameAndRange = builder.toString();
                            builder.setLength(0);
                            if (((String)sheetNameAndRange).contains("#REF")) break;
                            if (!eventStack.isEmpty()) {
                                eventStack.pop();
                            }
                            Pattern p = Pattern.compile("\\d+$");
                            Matcher m = p.matcher((CharSequence)sheetNameAndRange);
                            Integer definedNameRowNumber = 0;
                            if (m.find()) {
                                definedNameRowNumber = Integer.parseInt(m.group());
                            }
                            sheetNameAndRange = ((String)sheetNameAndRange).substring(0, ((String)sheetNameAndRange).length() - String.valueOf(definedNameRowNumber).length());
                            sheetNameAndRange = (String)sheetNameAndRange + (definedNameRowNumber + offset);
                            eventStack.push(eventFactory.createCharacters((String)sheetNameAndRange));
                            upgradeDefinedName = false;
                        }
                    }
                    eventStack.push(event);
                    if (upgradeDefinedName) continue;
                    Iterator iterator = eventStack.descendingIterator();
                    while (iterator.hasNext()) {
                        writer.add((XMLEvent)iterator.next());
                    }
                    eventStack.clear();
                }
                writer.flush();
                outStream.save();
                outStream = null;
            }
            catch (Exception e) {
                this.logger.warn("Unexpected", (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        this.logger.warn("Unexpected", (Throwable)e);
                    }
                }
                if (workbookStream != null) {
                    try {
                        workbookStream.close();
                    }
                    catch (Exception e) {
                        this.logger.warn("Unexpected", (Throwable)e);
                    }
                }
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception e) {
                        this.logger.warn("Unexpected", (Throwable)e);
                    }
                } else if (outStream != null) {
                    try {
                        outStream.close();
                    }
                    catch (Exception e) {
                        this.logger.warn("Unexpected", (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsetcalcCompleted() throws Exception {
        XMLEventWriter writer = null;
        XMLEventReader reader = null;
        XlsFileHelper.TemporaryOutputStream outStream = null;
        InputStream workbookStream = null;
        XMLOutputFactory outFactory = XMLOutputFactory.newInstance();
        XMLInputFactory inFactory = XMLInputFactory.newInstance();
        inFactory.setProperty("javax.xml.stream.supportDTD", false);
        inFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
        XMLEventFactory eventFactory = XMLEventFactory.newInstance();
        try {
            workbookStream = this.zipPackage.getFileHelper().getInputStreamFromZipStream(this.workbookPathInZip);
            reader = inFactory.createXMLEventReader(workbookStream);
            outStream = this.zipPackage.getFileHelper().getEntryTemporaryOutputStream(this.workbookPathInZip);
            writer = outFactory.createXMLEventWriter(outStream);
            ArrayDeque<XMLEvent> eventStack = new ArrayDeque<XMLEvent>();
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                switch (event.getEventType()) {
                    case 1: {
                        if (Constant.WORKBOOK_CALCPR.equals(event.asStartElement().getName().getLocalPart())) {
                            boolean isCalcId = false;
                            Iterator<Attribute> calcPr = event.asStartElement().getAttributes();
                            StartElement newEvent = null;
                            while (calcPr.hasNext()) {
                                Attribute attribute = calcPr.next();
                                String name = attribute.getName().getLocalPart();
                                if (!name.equals(Constant.WORKBOOK_CALCPR_ID)) continue;
                                ArrayList<Attribute> attributes = new ArrayList<Attribute>();
                                attributes.add(eventFactory.createAttribute(name, "0"));
                                newEvent = eventFactory.createStartElement(event.asStartElement().getName(), attributes.iterator(), null);
                                isCalcId = true;
                            }
                            if (!isCalcId) {
                                eventStack.push(event);
                                break;
                            }
                            eventStack.push(newEvent);
                            break;
                        }
                        eventStack.push(event);
                        break;
                    }
                    default: {
                        eventStack.push(event);
                    }
                }
                Iterator iterator = eventStack.descendingIterator();
                while (iterator.hasNext()) {
                    writer.add((XMLEvent)iterator.next());
                }
                eventStack.clear();
            }
            writer.flush();
            outStream.save();
            outStream = null;
        }
        catch (Exception e) {
            this.logger.warn("Unexpected", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
            if (workbookStream != null) {
                try {
                    workbookStream.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            } else if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (Exception e) {
                    this.logger.warn("Unexpected", (Throwable)e);
                }
            }
        }
    }

    public Map<String, Sheet> getSheets() {
        return this.sheets;
    }

    public Map<String, DefinedTable> getDefinedTables() {
        return this.definedTables;
    }
}

