/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.driver.xlsx.part;

import com.stambia.jdbc.driver.xlsx.part.Messages;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class XlsFileHelper {
    private File zipFilePath;
    private File tempFolder;
    private HashMap<String, File> temporaryFiles = new HashMap();
    private HashMap<String, TemporaryOutputStream> temporaryOutputstream = new HashMap();

    public XlsFileHelper(File zipFile) throws Exception {
        this.zipFilePath = zipFile;
        Logger.getLogger(XlsFileHelper.class.getName()).log(Level.INFO, String.format(Messages.getString("XlsFileHelper.9"), zipFile.getAbsolutePath()));
        this.init();
    }

    private void init() throws Exception {
        this.tempFolder = Files.createTempDirectory(XlsFileHelper.class.getName(), new FileAttribute[0]).toFile();
        Logger.getLogger(XlsFileHelper.class.getName()).log(Level.INFO, String.format(Messages.getString("XlsFileHelper.10"), this.tempFolder.getAbsolutePath()));
        try (ZipFile zipFile = new ZipFile(this.zipFilePath);){
            Enumeration<? extends ZipEntry> en = zipFile.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                if (entry.isDirectory()) continue;
                InputStream is = zipFile.getInputStream(entry);
                File f = new File(this.tempFolder, entry.getName());
                f.getParentFile().mkdirs();
                try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(f));){
                    byte[] buffer = new byte[4096];
                    int read = is.read(buffer, 0, buffer.length);
                    while (read > -1) {
                        bos.write(buffer, 0, read);
                        read = is.read(buffer, 0, buffer.length);
                    }
                }
                this.temporaryFiles.put(entry.getName(), f);
            }
        }
    }

    public InputStream getInputStreamFromZipStream(String entryName) throws FileNotFoundException {
        File f = this.temporaryFiles.get(entryName);
        return new BufferedInputStream(new FileInputStream(f));
    }

    public void deleteEntryInsideZip(String entryName) throws Exception {
        File f = this.temporaryFiles.get(entryName);
        if (f == null) {
            throw new Exception(String.format(Messages.getString("XlsFileHelper.11"), entryName));
        }
        TemporaryOutputStream tos = this.temporaryOutputstream.get(entryName);
        if (tos != null) {
            throw new Exception(String.format(Messages.getString("XlsFileHelper.12"), entryName));
        }
        if (!Files.exists(f.toPath(), new LinkOption[0])) {
            throw new Exception(String.format(Messages.getString("XlsFileHelper.13"), entryName));
        }
        Files.delete(f.toPath());
    }

    public TemporaryOutputStream getEntryTemporaryOutputStream(String entryName) throws Exception {
        File f = this.temporaryFiles.get(entryName);
        if (f == null) {
            throw new Exception(String.format(Messages.getString("XlsFileHelper.14"), entryName));
        }
        TemporaryOutputStream tos = this.temporaryOutputstream.get(entryName);
        if (tos != null) {
            throw new Exception(String.format(Messages.getString("XlsFileHelper.15"), entryName));
        }
        String tmpFileName = entryName;
        if (entryName.contains("/")) {
            tmpFileName = entryName.substring(entryName.lastIndexOf("/") + 1);
        }
        tos = new TemporaryOutputStream(Files.createTempFile(this.tempFolder.toPath(), "tmpWrite", tmpFileName, new FileAttribute[0]).toFile(), f, entryName);
        this.temporaryOutputstream.put(entryName, tos);
        return tos;
    }

    /*
     * Exception decompiling
     */
    public void saveZip() throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void dispose() {
        try {
            this.temporaryOutputstream.values().forEach(os -> {
                try {
                    os.close();
                }
                catch (Exception ex) {
                    Logger.getLogger(XlsFileHelper.class.getName()).log(Level.FINE, "unexpected", ex);
                }
            });
            this.temporaryOutputstream.clear();
            Files.walkFileTree(this.tempFolder.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (Exception e) {
            Logger.getLogger(XlsFileHelper.class.getName()).log(Level.WARNING, "unexpected", e);
        }
    }

    public Set<String> getTemporaryFilesNames() {
        return null != this.temporaryFiles ? this.temporaryFiles.keySet() : Collections.emptySet();
    }

    class TemporaryOutputStream
    extends BufferedOutputStream {
        File tmpFile;
        File currentFile;
        String entryName;
        boolean saved;
        boolean closed;

        public TemporaryOutputStream(File file, File currentFile, String entryName) throws FileNotFoundException {
            super(new FileOutputStream(file));
            this.saved = false;
            this.closed = false;
            this.tmpFile = file;
            this.currentFile = currentFile;
            this.entryName = entryName;
            Logger.getLogger(XlsFileHelper.class.getName()).log(Level.INFO, String.format(Messages.getString("XlsFileHelper.0"), this.tmpFile.getAbsolutePath()));
        }

        public void save() throws Exception {
            Logger.getLogger(XlsFileHelper.class.getName()).log(Level.INFO, String.format(Messages.getString("XlsFileHelper.1"), this.tmpFile.getAbsolutePath()));
            this.saved = true;
            this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.closed) {
                Logger.getLogger(XlsFileHelper.class.getName()).log(Level.INFO, String.format(Messages.getString("XlsFileHelper.2"), this.tmpFile.getAbsolutePath()));
                return;
            }
            Logger.getLogger(XlsFileHelper.class.getName()).log(Level.INFO, String.format(Messages.getString("XlsFileHelper.3"), this.tmpFile.getAbsolutePath()));
            try {
                try {
                    super.close();
                    if (this.saved) {
                        File old = XlsFileHelper.this.temporaryFiles.put(this.entryName, this.tmpFile);
                        if (old != null) {
                            try {
                                Files.delete(old.toPath());
                                Logger.getLogger(XlsFileHelper.class.getName()).log(Level.INFO, String.format(Messages.getString("XlsFileHelper.4"), old.getAbsolutePath()));
                            }
                            catch (Throwable t) {
                                Logger.getLogger(XlsFileHelper.class.getName()).log(Level.INFO, String.format(Messages.getString("XlsFileHelper.5"), old.getAbsolutePath()), t);
                            }
                        }
                    } else {
                        try {
                            Files.delete(this.tmpFile.toPath());
                            Logger.getLogger(XlsFileHelper.class.getName()).log(Level.INFO, String.format(Messages.getString("XlsFileHelper.6"), this.tmpFile.getAbsolutePath()));
                        }
                        catch (Exception t) {
                            Logger.getLogger(XlsFileHelper.class.getName()).log(Level.INFO, String.format(Messages.getString("XlsFileHelper.7"), this.tmpFile.getAbsolutePath()), t);
                        }
                    }
                }
                catch (Exception t) {
                    Logger.getLogger(XlsFileHelper.class.getName()).log(Level.INFO, String.format(Messages.getString("XlsFileHelper.8"), this.tmpFile.getAbsolutePath()), t);
                    if (t instanceof IOException) {
                        throw t;
                    }
                    throw t;
                }
                finally {
                    XlsFileHelper.this.temporaryOutputstream.remove(this.entryName);
                }
            }
            finally {
                this.closed = true;
            }
        }
    }
}

