/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.services.registry;

import com.semarchy.xdi.designer.core.services.IRegistryService;
import com.semarchy.xdi.designer.core.services.cache.CacheHelper;
import com.semarchy.xdi.designer.core.services.registry.UDFImplementation;
import com.semarchy.xdi.designer.core.services.registry.UDFParameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;

public class UDF
implements IRegistryService.RegistryItem,
Serializable {
    private static final long serialVersionUID = 5657211998710640152L;
    private String description;
    private List<UDFParameter> parameters;
    private List<UDFImplementation> implementations = new ArrayList<UDFImplementation>();
    private UDFImplementation defaultImpl = null;
    private UDFKey key;
    private transient URI mdNodeSourceURI;
    public static final String URI_SCHEME_UDF = "udf";
    public static final String UDF_REGISTRY_SOURCE_ID = "UUID_REGISTRY_UDF";
    public static final URI UDF_REGISTRY_SOURCE_URI = URI.createURI((String)"udf:/udf");

    public UDF(String name, String libName, String prefix, String description, List<UDFImplementation> implementation, List<UDFParameter> parameters, URI mdNodeSourceURI, Collection<String> requiredLibPrefix) {
        this.description = description;
        this.parameters = parameters;
        this.implementations.addAll(implementation);
        for (UDFImplementation i : this.implementations) {
            if (i.getProductCode() != null && !i.getProductCode().isEmpty()) continue;
            this.defaultImpl = i;
            break;
        }
        this.key = new UDFKey(mdNodeSourceURI, prefix, name, parameters.size(), libName, requiredLibPrefix);
    }

    protected boolean hasDefinedImplementation() {
        for (UDFImplementation i : this.implementations) {
            if (i.getExpression() == null || !i.getExpression().trim().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.key.functionName;
    }

    public String getDescription() {
        return this.description;
    }

    public List<UDFParameter> getParameters() {
        return this.parameters;
    }

    public URI getMdNodeSourceURI() {
        if (this.mdNodeSourceURI == null) {
            this.mdNodeSourceURI = URI.createURI((String)this.key._mdNodeURIStr);
            return this.mdNodeSourceURI;
        }
        return this.mdNodeSourceURI;
    }

    public boolean supportParameterNumber(int pCount) {
        int i = this.parameters.size();
        while (i > 0) {
            if (i == pCount) {
                return true;
            }
            --i;
        }
        return pCount == 0;
    }

    protected UDFImplementation getImpl(String productCode) {
        for (UDFImplementation i : this.implementations) {
            if (!(i.getProductCode() == null ? productCode == null || productCode.isEmpty() : i.getProductCode().equals(productCode))) continue;
            return i;
        }
        return this.defaultImpl;
    }

    public boolean supportProduct(String productCode) {
        UDFImplementation i = this.getImpl(productCode);
        return i != null || this.defaultImpl != null;
    }

    public String getExpression(String productCode) {
        Assert.isTrue((boolean)this.supportProduct(productCode));
        UDFImplementation i = this.getImpl(productCode);
        return i == null ? null : i.getExpression();
    }

    @Override
    public IRegistryService.IRegistryKey getRegistrationKey() {
        return this.key;
    }

    public static final URI createUDFIdentificationURI(String functionName, String prefix, String paramCount) {
        StringBuffer buf = new StringBuffer();
        buf.append("udf:/udf#" + UDF.generateID(functionName, prefix, paramCount) + "?fileId=UUID_REGISTRY_UDF$name=" + prefix + "::" + functionName + "$type=udf?");
        return URI.createURI((String)buf.toString(), (boolean)false);
    }

    private static final URI createUDFIdentificationURI(UDFKey key) {
        StringBuffer buf = new StringBuffer();
        String[] nm = key.getFunctionFullName().split("::");
        String functionName = nm[1];
        String prefix = nm[0];
        String paramCount = "" + key.getParameterCount();
        buf.append("udf:/udf#" + UDF.generateID(functionName, prefix, paramCount) + "?fileId=UUID_REGISTRY_UDF$name=" + prefix + "::" + functionName + "$type=udf?");
        return URI.createURI((String)buf.toString(), (boolean)false);
    }

    private static String generateID(String functionName, String prefix, String paramCount) {
        return prefix + "!" + functionName + "!" + paramCount;
    }

    public List<String> getProductCodes() {
        ArrayList<String> l = new ArrayList<String>();
        for (UDFImplementation i : this.implementations) {
            String s = i.getProductCode();
            if (s == null) {
                l.add("*");
                continue;
            }
            l.add(s);
        }
        return l;
    }

    public URI getURI() {
        return this.key.getURI();
    }

    public String getFunctionFullName() {
        return this.key.getFunctionFullName();
    }

    public String getFunctionSignature() {
        StringBuffer buf = new StringBuffer(this.getFunctionFullName());
        buf.append("(");
        boolean first = true;
        for (UDFParameter p : this.getParameters()) {
            if (!first) {
                buf.append(",");
            } else {
                first = false;
            }
            buf.append(p.getName());
        }
        buf.append(")");
        return buf.toString();
    }

    public String getFormatedSignature() {
        StringBuffer buf = new StringBuffer(this.getName());
        buf.append("(");
        boolean first = true;
        for (UDFParameter p : this.getParameters()) {
            if (!first) {
                buf.append(",");
            } else {
                first = false;
            }
            buf.append("$");
            buf.append(p.getName());
        }
        buf.append(")");
        return buf.toString();
    }

    public final List<UDFImplementation> getImplementations() {
        return Collections.unmodifiableList(this.implementations);
    }

    public static class UDFKey
    implements IRegistryService.IRegistryKey,
    Serializable {
        private static final long serialVersionUID = -8679331003526993811L;
        private String functionName;
        private int parameterCount;
        private transient URI uri;
        private String fileID;
        private String _mdNodeURIStr;
        private String prefix;
        private String libName;
        private Collection<String> requiredLibPrefix;

        public UDFKey(URI mdNodeURI, String prefix, String functionName, int parameterCount, String libName, Collection<String> requiredLibPrefix) {
            this.fileID = CacheHelper.extractFileID(mdNodeURI.fragment());
            this.functionName = functionName;
            this.parameterCount = parameterCount;
            this._mdNodeURIStr = mdNodeURI.toString();
            this.prefix = prefix;
            this.libName = libName;
            this.requiredLibPrefix = requiredLibPrefix;
        }

        @Override
        public boolean match(Object o) {
            return o instanceof UDFKey && ((UDFKey)o).getFunctionFullName().equals(this.getFunctionFullName()) && ((UDFKey)o).parameterCount == this.parameterCount && ((UDFKey)o).getProviderFileID().equals(this.getProviderFileID());
        }

        public String getLibraryName() {
            return this.libName;
        }

        public int getParameterCount() {
            return this.parameterCount;
        }

        public String getFunctionFullName() {
            return this.prefix + "::" + this.functionName;
        }

        public URI getURI() {
            if (this.uri == null) {
                this.uri = UDF.createUDFIdentificationURI(this);
            }
            return this.uri;
        }

        @Override
        public String getProviderFileID() {
            return this.fileID;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public Collection<String> getRequiredLibPrefix() {
            return this.requiredLibPrefix;
        }

        public URI getMdNodeURI() {
            return URI.createURI((String)this._mdNodeURIStr);
        }
    }

    public static class UDFMatcher
    implements IRegistryService.IRegistryMatcher {
        private String functionName;
        private int parameterCount;

        public UDFMatcher(String functionName, int parameterCount) {
            this.functionName = functionName;
            this.parameterCount = parameterCount;
        }

        @Override
        public boolean match(Object o) {
            if (o instanceof UDFKey) {
                UDFKey key = (UDFKey)o;
                return this.functionName.equals(key.getFunctionFullName()) && this.parameterCount == key.getParameterCount();
            }
            return false;
        }
    }

    public static class UDFProviderMatcher
    implements IRegistryService.IRegistryMatcher {
        private String providerID;

        public UDFProviderMatcher(String providerID) {
            this.providerID = providerID;
        }

        @Override
        public boolean match(Object o) {
            if (o instanceof UDFKey) {
                UDFKey key = (UDFKey)o;
                return key.getProviderFileID().equals(this.providerID);
            }
            return false;
        }
    }
}

