/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.designer.core.services.registry.internal;

import com.semarchy.xdi.designer.core.services.IRegistryService;
import java.util.logging.Logger;

public class RegistryLoggerListener
implements IRegistryService.IRegistryItemEventListener {
    private Logger logger = null;

    public RegistryLoggerListener(String loggerName) {
        this.logger = Logger.getLogger(loggerName);
    }

    @Override
    public void handleItemAdded(IRegistryService.IRegistryKey key, Object item) {
        this.logEvent(key, item, "ADDED");
    }

    @Override
    public void handleItemRemoved(IRegistryService.IRegistryKey key, Object item) {
        this.logEvent(key, item, "REMOVED");
    }

    @Override
    public void handleItemUpdated(IRegistryService.IRegistryKey key, Object item) {
        this.logEvent(key, item, "UPDATED");
    }

    protected void logEvent(IRegistryService.IRegistryKey key, Object item, String event) {
        StringBuffer buf = new StringBuffer();
        buf.append(event);
        buf.append(" ");
        buf.append(this.format(key));
        if (item instanceof IRegistryService.RegistryItem) {
            buf.append(this.format((IRegistryService.RegistryItem)item));
        }
        this.getLogger().info(buf.toString());
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected String format(IRegistryService.IRegistryKey key) {
        return key.toString();
    }

    protected String format(IRegistryService.RegistryItem item) {
        return " ";
    }
}

