/*
 * Decompiled with CFR 0.152.
 */
package com.semarchy.xdi.base.core.auth;

import com.indy.runtime.json.JsonNode;
import com.semarchy.xdi.base.core.auth.BasicAuthentication;
import com.semarchy.xdi.base.core.auth.OAuth2Metadata;
import com.semarchy.xdi.base.core.auth.OAuth2TokenKey;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import jakarta.xml.bind.DatatypeConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class OAuth2 {
    private static final String GRANT_TYPE_PARAMETER = "grant_type";
    private static final String GRANT_STRING_REFRESH_TOKEN = "refresh_token";
    private static final String GRANT_STRING_4_1 = "authorization_code";
    private static final String GRANT_STRING_4_3 = "password";
    private static final String GRANT_STRING_4_4 = "client_credentials";
    private static final String REFRESH_TOKEN_PARAMETER = "refresh_token";
    private static final String PASSWORD_PARAMETER = "password";
    private static final String REDIRECT_URI_PARAMETER = "redirect_uri";
    private static final String CLIENT_SECRET_PARAMETER = "client_secret";
    private static final String CLIENT_ID_PARAMETER = "client_id";
    private static final String JDK_HTTP_AUTH_TUNNELING_DISABLED_SCHEMES_PROPERTY = "jdk.http.auth.tunneling.disabledSchemes";
    private static final HttpClient client = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).build();
    private static final Lock lock = new ReentrantLock();
    static Map<OAuth2TokenKey, Token> map = new HashMap<OAuth2TokenKey, Token>();

    private OAuth2() {
        throw new IllegalStateException("Utility class");
    }

    static Map<String, String> parseResponse(InputStream is) throws Exception {
        HashMap<String, String> prop = new HashMap<String, String>();
        JsonNode node = JsonNode.parse((InputStream)is, (String)"UTF-8");
        if (node.isObject()) {
            for (String key : node.keys()) {
                JsonNode o = node.get(key);
                if (!o.isString() && !o.isNumber()) continue;
                prop.put(key, o.getString());
            }
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getToken(OAuth2Metadata md, String grantType) throws Exception {
        HttpURLConnection conn;
        URLBuilder urlWrapper = new URLBuilder();
        boolean sendClientAndSecretAsAuthenticationHeader = false;
        if (md.flowType != null && (md.flowType.equals("Resource Owner Password Credentials Grant") || md.flowType.equals("Client Credentials Grant"))) {
            if (md.clientCredentialPolicy == CredentialMode.PARAMETER_CLIENT_ID) {
                OAuth2.checkClientIdValue(md);
                urlWrapper.parameters.put(CLIENT_ID_PARAMETER, md.clientId);
            } else if (md.clientCredentialPolicy == CredentialMode.PARAMETER_CLIENT_ID_AND_SECRET) {
                OAuth2.checkClientIdValue(md);
                urlWrapper.parameters.put(CLIENT_ID_PARAMETER, md.clientId);
                if (md.clientSecret == null) {
                    throw new EngineExceptionI("Error while building OAuth2 request: Client Secret must not be null when it is required to send Client Secret");
                }
                urlWrapper.parameters.put(CLIENT_SECRET_PARAMETER, md.clientSecret);
            } else if (md.clientCredentialPolicy == CredentialMode.AUTH_HEADER_CLIENT_ID_AND_SECRET) {
                sendClientAndSecretAsAuthenticationHeader = true;
            }
        } else {
            if (md.clientSecret != null) {
                urlWrapper.parameters.put(CLIENT_SECRET_PARAMETER, md.clientSecret);
            }
            if (md.clientId != null) {
                urlWrapper.parameters.put(CLIENT_ID_PARAMETER, md.clientId);
            }
        }
        if (md.state != null) {
            urlWrapper.parameters.put("state", md.state);
        }
        if (!(md.scope == null || md.flowType == null || md.flowType.equals("Authorization Code Grant") && "refresh_token".equals(grantType))) {
            urlWrapper.parameters.put("scope", md.scope);
        }
        if (md.refreshToken != null) {
            urlWrapper.parameters.put("refresh_token", md.refreshToken);
        }
        if (md.redirectEndpoint != null) {
            urlWrapper.parameters.put(REDIRECT_URI_PARAMETER, md.redirectEndpoint);
        }
        if (md.login != null) {
            urlWrapper.parameters.put("username", md.login);
        }
        if (md.password != null) {
            if (md.securityToken != null && !md.password.contains(md.securityToken)) {
                urlWrapper.parameters.put("password", md.password + md.securityToken);
            } else {
                urlWrapper.parameters.put("password", md.password);
            }
        }
        if (md.additionnalParameters != null) {
            urlWrapper.parameters.putAll(md.additionnalParameters);
        }
        urlWrapper.parameters.put(GRANT_TYPE_PARAMETER, grantType);
        String query2 = urlWrapper.getQuery(true, null);
        if (sendClientAndSecretAsAuthenticationHeader) {
            OAuth2.checkClientIdValue(md);
            if (md.clientSecret == null) {
                throw new EngineExceptionI("Error while building OAuth2 request: Client Secret must not be null when it is required to send Client Secret");
            }
        }
        String oldProperty = null;
        try {
            lock.lock();
            oldProperty = System.getProperty(JDK_HTTP_AUTH_TUNNELING_DISABLED_SCHEMES_PROPERTY);
            if (md.tokenEndpointHttpMethod != null && md.tokenEndpointHttpMethod.equals("GET")) {
                url = new URL(md.tokenEndpoint + "?" + query2);
                conn = OAuth2.buildHttpURLConnection(md, sendClientAndSecretAsAuthenticationHeader, url);
                conn.setRequestMethod("GET");
            } else {
                url = new URL(md.tokenEndpoint);
                conn = OAuth2.buildHttpURLConnection(md, sendClientAndSecretAsAuthenticationHeader, url);
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestMethod("POST");
                OutputStreamWriter osw = new OutputStreamWriter(conn.getOutputStream());
                osw.write(query2);
                osw.close();
            }
        }
        finally {
            if (md.getProxy() != null) {
                Authenticator.setDefault(null);
            }
            if (oldProperty != null) {
                System.setProperty(JDK_HTTP_AUTH_TUNNELING_DISABLED_SCHEMES_PROPERTY, oldProperty);
            }
            lock.unlock();
        }
        Map<String, String> ret = null;
        try {
            ret = OAuth2.parseResponse(conn.getInputStream());
        }
        catch (IOException e) {
            InputStreamReader isr = new InputStreamReader(conn.getErrorStream());
            BufferedReader in = new BufferedReader(isr);
            String line = null;
            StringBuilder sb = new StringBuilder();
            while ((line = in.readLine()) != null) {
                System.out.println(line);
                sb.append(line);
            }
            String output = sb.toString();
            throw new Exception("An error occured while generating OAuth2 token. " + output, e);
        }
        finally {
            conn.disconnect();
        }
        return ret;
    }

    private static HttpURLConnection buildHttpURLConnection(final OAuth2Metadata md, boolean sendClientAndSecretAsAuthenticationHeader, URL url) throws Exception {
        HttpURLConnection conn;
        if (md.getProxy() != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(md.proxyUser, md.proxyPassword.toCharArray());
                }
            });
            System.setProperty(JDK_HTTP_AUTH_TUNNELING_DISABLED_SCHEMES_PROPERTY, "");
            conn = (HttpURLConnection)url.openConnection(md.getProxy());
            OAuth2.setProxyHeader(conn, md.proxyUser, md.proxyPassword);
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        if (conn instanceof HttpsURLConnection) {
            if (md.enableCertificateVerification != null && !md.enableCertificateVerification.booleanValue()) {
                OAuth2.disableCertificateVerification((HttpsURLConnection)conn);
            }
            if (md.enableHostnameVerification != null && !md.enableHostnameVerification.booleanValue()) {
                OAuth2.disableHostnameVerification((HttpsURLConnection)conn);
            }
        }
        if (sendClientAndSecretAsAuthenticationHeader) {
            BasicAuthentication b = new BasicAuthentication(md.clientId, md.clientSecret);
            conn.setRequestProperty("Authorization", b.getAuthenticationHeaderValue(null));
        }
        if (md.connectionTimeout > -1) {
            conn.setConnectTimeout(md.connectionTimeout);
        }
        if (md.readTimeout > -1) {
            conn.setReadTimeout(md.readTimeout);
        }
        if (md.additionnalHttpHeaders != null) {
            for (Map.Entry<String, String> entry : md.additionnalHttpHeaders.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        return conn;
    }

    private static void checkClientIdValue(OAuth2Metadata md) throws EngineExceptionI {
        if (md.clientId == null) {
            throw new EngineExceptionI("Error while building OAuth2 request: Client Id must not be null when it is required to send Client Id");
        }
    }

    public static void disableHostnameVerification(HttpsURLConnection conn) {
        conn.setHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        });
    }

    public static void disableCertificateVerification(HttpsURLConnection conn) throws NoSuchAlgorithmException, KeyManagementException {
        X509TrustManager trustMgr = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        };
        SSLContext sslContext = SSLContext.getInstance("TLS");
        sslContext.init(null, new TrustManager[]{trustMgr}, null);
        conn.setSSLSocketFactory(sslContext.getSocketFactory());
    }

    public static Map<String, String> getNewToken(OAuth2Metadata md) throws Exception {
        URLBuilder urlWrapper = new URLBuilder();
        urlWrapper.parameters.put("code", md.code);
        urlWrapper.parameters.put(CLIENT_SECRET_PARAMETER, md.clientSecret);
        urlWrapper.parameters.put(CLIENT_ID_PARAMETER, md.clientId);
        urlWrapper.parameters.put(REDIRECT_URI_PARAMETER, md.redirectEndpoint);
        urlWrapper.parameters.put(GRANT_TYPE_PARAMETER, GRANT_STRING_4_1);
        String query = urlWrapper.getQuery(true, md.tokenEndpoint);
        URI uri = URI.create(query);
        HttpRequest.Builder builder = HttpRequest.newBuilder(uri);
        HttpRequest request = builder.header("Content-Type", "application/x-www-form-urlencoded").POST(HttpRequest.BodyPublishers.noBody()).build();
        HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
        return OAuth2.parseResponse(response.body());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getToken(OAuth2Metadata oAuth2Metadata) throws Exception {
        if (oAuth2Metadata.flowType == null ? oAuth2Metadata.refreshToken == null : oAuth2Metadata.flowType.equals("Authorization Code Grant") && oAuth2Metadata.refreshToken == null || oAuth2Metadata.flowType.equals("Implicit Grant")) {
            return oAuth2Metadata.accessToken;
        }
        Map<OAuth2TokenKey, Token> map = OAuth2.map;
        synchronized (map) {
            long currentTime;
            OAuth2TokenKey tokenKey = new OAuth2TokenKey(oAuth2Metadata);
            OAuth2Metadata.Logger logger = oAuth2Metadata.getLogger();
            Token token = OAuth2.map.get(tokenKey);
            if (token == null) {
                token = new Token();
                OAuth2.map.put(tokenKey, token);
            }
            if (token.expireTime < (currentTime = System.currentTimeMillis())) {
                String accessToken;
                if (logger != null) {
                    logger.debug("OAuth2, getting token: " + oAuth2Metadata.toString());
                }
                Map<String, String> ret = null;
                int i = 0;
                do {
                    try {
                        if (oAuth2Metadata.flowType == null || oAuth2Metadata.flowType.equals("Authorization Code Grant") || oAuth2Metadata.flowType.equals("Implicit Grant")) {
                            ret = OAuth2.getToken(oAuth2Metadata, "refresh_token");
                            continue;
                        }
                        if (oAuth2Metadata.flowType.equals("Resource Owner Password Credentials Grant")) {
                            ret = OAuth2.getToken(oAuth2Metadata, "password");
                            continue;
                        }
                        if (oAuth2Metadata.flowType.equals("Client Credentials Grant")) {
                            ret = OAuth2.getToken(oAuth2Metadata, GRANT_STRING_4_4);
                            continue;
                        }
                        throw new RuntimeException("Could not find a suitable token grant flow.");
                    }
                    catch (Exception e) {
                        ++i;
                        if (logger != null) {
                            logger.warn("OAuth2 token, Error during: " + i + " attempt number", e);
                        }
                        if (i < oAuth2Metadata.numberOfAttempts) continue;
                        if (logger != null) {
                            logger.warn("OAuth2 token, too much attempts: " + i);
                        }
                        throw e;
                    }
                } while (ret == null);
                token.accessToken = accessToken = ret.get("access_token");
                if (oAuth2Metadata.expiresIn > 0L) {
                    token.expireTime = currentTime + oAuth2Metadata.expiresIn * 1000L;
                } else {
                    String str = ret.get("expires_in");
                    if (str != null) {
                        try {
                            token.expireTime = currentTime + Long.parseLong(str) * 1000L;
                        }
                        catch (NumberFormatException e) {
                            token.expireTime = currentTime;
                        }
                    } else {
                        token.expireTime = currentTime;
                    }
                }
                return token.accessToken;
            }
            return token.accessToken;
        }
    }

    public static void setProxyHeader(URLConnection conn, String proxyUser, String proxyPassword) {
        if (proxyUser != null && proxyPassword != null) {
            String encoded = DatatypeConverter.printBase64Binary((byte[])new String(proxyUser + ":" + proxyPassword).getBytes());
            conn.setRequestProperty("Proxy-Authorization", "Basic " + encoded);
        }
    }

    public static String getAuthEndPointUrl(OAuth2Metadata md) throws MalformedURLException, UnsupportedEncodingException {
        URLBuilder urlWrapper = new URLBuilder();
        urlWrapper.parameters.put(CLIENT_ID_PARAMETER, md.clientId);
        urlWrapper.parameters.put(REDIRECT_URI_PARAMETER, md.redirectEndpoint);
        urlWrapper.parameters.put("scope", md.scope);
        urlWrapper.parameters.put("response_type", "code");
        return urlWrapper.getQuery(true, md.authEndpoint);
    }

    private static class URLBuilder {
        Map<String, String> parameters = new HashMap<String, String>();

        private URLBuilder() {
        }

        String getQuery(boolean encode, String url) throws MalformedURLException, UnsupportedEncodingException {
            int i = 0;
            Object _url = "";
            if (url != null) {
                _url = url;
            }
            for (String key : this.parameters.keySet()) {
                if (i != 0 || !((String)_url).isEmpty()) {
                    _url = i == 0 ? (String)_url + "?" : (String)_url + "&";
                }
                _url = (String)_url + key + "=";
                _url = encode ? (String)_url + URLEncoder.encode(this.parameters.get(key), "UTF-8") : (String)_url + this.parameters.get(key);
                ++i;
            }
            return _url;
        }
    }

    public static enum CredentialMode {
        NONE("None"),
        PARAMETER_CLIENT_ID("Send Client Id as parameter"),
        PARAMETER_CLIENT_ID_AND_SECRET("Send Client Id and Client Secret as parameters"),
        AUTH_HEADER_CLIENT_ID_AND_SECRET("Send Client Id and Client Secret as Basic Auth header");

        String label;

        private CredentialMode(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }

        public static CredentialMode fromLabel(String label) {
            for (CredentialMode m : CredentialMode.values()) {
                if (!m.getLabel().equals(label)) continue;
                return m;
            }
            return null;
        }
    }

    private static class Token {
        String accessToken;
        long expireTime;

        private Token() {
        }
    }
}

