/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.common;

import com.stambia.jdbc.common.CommonResultSetMetaData;
import com.stambia.jdbc.common.Messages;
import com.stambia.jdbc.common.RowData;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class CommonResultSet
implements ResultSet {
    CommonResultSetMetaData metadata;
    private int fetchSize;
    boolean wasNull;
    private final SimpleDateFormat sdf = new SimpleDateFormat();
    RowDataReader rowDataReader;
    RowData current;

    @Override
    public boolean absolute(int arg0) throws SQLException {
        return false;
    }

    @Override
    public void afterLast() throws SQLException {
    }

    @Override
    public void beforeFirst() throws SQLException {
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int findColumn(String arg0) throws SQLException {
        for (int i = 1; i <= this.metadata.getColumnCount(); ++i) {
            String label = this.metadata.getColumnLabel(i);
            if (label == null || !label.equals(arg0)) continue;
            return i;
        }
        throw new SQLException(Messages.getString("CommonResultSet.0") + arg0 + Messages.getString("CommonResultSet.1"));
    }

    @Override
    public boolean first() throws SQLException {
        return false;
    }

    @Override
    public Array getArray(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Array getArray(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getAsciiStream(int arg0) throws SQLException {
        this.wasNull = false;
        String str = this.getColData(arg0);
        if (str != null) {
            return new ByteArrayInputStream(str.getBytes());
        }
        this.wasNull = true;
        return null;
    }

    @Override
    public InputStream getAsciiStream(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(int arg0) throws SQLException {
        this.wasNull = false;
        String str = this.getColData(arg0);
        if (str != null) {
            return BigDecimal.valueOf(Double.valueOf(str));
        }
        this.wasNull = true;
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String arg0) throws SQLException {
        return this.getBigDecimal(this.findColumn(arg0));
    }

    @Override
    public BigDecimal getBigDecimal(int arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigDecimal getBigDecimal(String arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getBinaryStream(int arg0) throws SQLException {
        return this.getAsciiStream(arg0);
    }

    @Override
    public InputStream getBinaryStream(String arg0) throws SQLException {
        return this.getBinaryStream(this.findColumn(arg0));
    }

    @Override
    public Blob getBlob(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Blob getBlob(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getBoolean(int arg0) throws SQLException {
        this.wasNull = false;
        String str = this.getColData(arg0);
        if (str != null) {
            return Boolean.parseBoolean(str);
        }
        this.wasNull = true;
        return false;
    }

    @Override
    public boolean getBoolean(String arg0) throws SQLException {
        return this.getBoolean(this.findColumn(arg0));
    }

    @Override
    public byte getByte(int arg0) throws SQLException {
        this.wasNull = false;
        String str = this.getColData(arg0);
        if (str != null) {
            return Byte.parseByte(str);
        }
        this.wasNull = true;
        return 0;
    }

    @Override
    public byte getByte(String arg0) throws SQLException {
        return this.getByte(arg0);
    }

    @Override
    public byte[] getBytes(int arg0) throws SQLException {
        this.wasNull = false;
        String str = this.getColData(arg0);
        if (str != null) {
            return str.getBytes();
        }
        this.wasNull = true;
        return null;
    }

    @Override
    public byte[] getBytes(String arg0) throws SQLException {
        return this.getBytes(this.findColumn(arg0));
    }

    @Override
    public Reader getCharacterStream(int arg0) throws SQLException {
        this.wasNull = false;
        String str = this.getColData(arg0);
        if (str != null) {
            return new StringReader(str);
        }
        this.wasNull = true;
        return null;
    }

    @Override
    public Reader getCharacterStream(String arg0) throws SQLException {
        return this.getCharacterStream(this.findColumn(arg0));
    }

    @Override
    public Clob getClob(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Clob getClob(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        return "";
    }

    @Override
    public Date getDate(int arg0) throws SQLException {
        this.wasNull = false;
        String str = this.getColData(arg0);
        if (str != null) {
            return Date.valueOf(str);
        }
        this.wasNull = true;
        return null;
    }

    @Override
    public Date getDate(String arg0) throws SQLException {
        return this.getDate(this.findColumn(arg0));
    }

    @Override
    public Date getDate(int arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Date getDate(String arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getDouble(int arg0) throws SQLException {
        this.wasNull = false;
        String str = this.getColData(arg0);
        if (str != null) {
            return Double.parseDouble(str);
        }
        this.wasNull = true;
        return 0.0;
    }

    @Override
    public double getDouble(String arg0) throws SQLException {
        return this.getDouble(this.findColumn(arg0));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public float getFloat(int arg0) throws SQLException {
        this.wasNull = false;
        String str = this.getColData(arg0);
        if (str != null) {
            return Float.parseFloat(str);
        }
        this.wasNull = true;
        return 0.0f;
    }

    public void setDataReader(RowDataReader rowDataReader) {
        this.rowDataReader = rowDataReader;
    }

    public void setData(RowData[] datas) {
        this.rowDataReader = new RowDataReaderImpl(datas);
    }

    public void setData(List<RowData> datas) {
        this.rowDataReader = new RowDataReaderImpl(datas.toArray(new RowData[datas.size()]));
    }

    @Override
    public float getFloat(String arg0) throws SQLException {
        return this.getFloat(this.findColumn(arg0));
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getInt(int arg0) throws SQLException {
        this.wasNull = false;
        String str = this.getColData(arg0);
        if (str != null) {
            return Integer.parseInt(str);
        }
        this.wasNull = true;
        return 0;
    }

    @Override
    public int getInt(String arg0) throws SQLException {
        return this.getInt(this.findColumn(arg0));
    }

    @Override
    public long getLong(int arg0) throws SQLException {
        this.wasNull = false;
        String str = this.getColData(arg0);
        if (str != null) {
            return Long.parseLong(str);
        }
        this.wasNull = true;
        return 0L;
    }

    @Override
    public long getLong(String arg0) throws SQLException {
        return this.getLong(this.findColumn(arg0));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metadata;
    }

    @Override
    public Reader getNCharacterStream(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Reader getNCharacterStream(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public NClob getNClob(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNString(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(int arg0) throws SQLException {
        this.wasNull = false;
        int i = this.metadata.getColumnType(arg0);
        switch (i) {
            case 12: {
                return this.getString(arg0);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(arg0);
            }
            case 91: {
                return this.getDate(arg0);
            }
        }
        return this.getString(arg0);
    }

    @Override
    public Object getObject(String arg0) throws SQLException {
        return this.getObject(this.findColumn(arg0));
    }

    @Override
    public Object getObject(int arg0, Map<String, Class<?>> arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getObject(String arg0, Map<String, Class<?>> arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Ref getRef(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getRow() throws SQLException {
        return 0;
    }

    @Override
    public RowId getRowId(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RowId getRowId(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLXML getSQLXML(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(int arg0) throws SQLException {
        this.wasNull = false;
        String str = this.getColData(arg0);
        if (str != null) {
            return Short.parseShort(str);
        }
        this.wasNull = true;
        return 0;
    }

    @Override
    public short getShort(String arg0) throws SQLException {
        return this.getShort(this.findColumn(arg0));
    }

    @Override
    public Statement getStatement() throws SQLException {
        return null;
    }

    private String getColData(int arg0) throws SQLException {
        --arg0;
        if (this.current == null) {
            throw new SQLException(Messages.getString("CommonResultSet.3"));
        }
        RowData row = this.current;
        if (row.colData == null || row.colData.length == 0) {
            throw new SQLException(Messages.getString("CommonResultSet.4"));
        }
        if (row.colData.length <= arg0 || arg0 < 0) {
            throw new SQLException(Messages.getString("CommonResultSet.5") + arg0 + "1");
        }
        return row.colData[arg0];
    }

    @Override
    public String getString(int arg0) throws SQLException {
        this.wasNull = false;
        String str = this.getColData(arg0);
        if (str != null) {
            return str;
        }
        this.wasNull = true;
        return null;
    }

    @Override
    public String getString(String arg0) throws SQLException {
        return this.getString(this.findColumn(arg0));
    }

    @Override
    public Time getTime(int arg0) throws SQLException {
        this.wasNull = false;
        String str = this.getColData(arg0);
        if (str != null) {
            return Time.valueOf(str);
        }
        this.wasNull = true;
        return null;
    }

    @Override
    public Time getTime(String arg0) throws SQLException {
        return this.getTime(this.findColumn(arg0));
    }

    @Override
    public Time getTime(int arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Time getTime(String arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(int arg0) throws SQLException {
        this.wasNull = false;
        String str = this.getColData(arg0);
        if (str != null) {
            return Timestamp.valueOf(str);
        }
        this.wasNull = true;
        return null;
    }

    @Override
    public Timestamp getTimestamp(String arg0) throws SQLException {
        return this.getTimestamp(this.findColumn(arg0));
    }

    @Override
    public Timestamp getTimestamp(int arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Timestamp getTimestamp(String arg0, Calendar arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public URL getURL(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public URL getURL(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getUnicodeStream(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream getUnicodeStream(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return false;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return false;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return false;
    }

    @Override
    public boolean isLast() throws SQLException {
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        return false;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean next() throws SQLException {
        try {
            this.current = this.rowDataReader.nextRow();
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return this.current != null;
    }

    @Override
    public boolean previous() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void refreshRow() throws SQLException {
    }

    @Override
    public boolean relative(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
        this.fetchSize = arg0;
    }

    @Override
    public void updateArray(int arg0, Array arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateArray(String arg0, Array arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateAsciiStream(String arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBigDecimal(String arg0, BigDecimal arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBinaryStream(String arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int arg0, Blob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String arg0, Blob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String arg0, InputStream arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBlob(String arg0, InputStream arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(int arg0, boolean arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBoolean(String arg0, boolean arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(int arg0, byte arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateByte(String arg0, byte arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(int arg0, byte[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateBytes(String arg0, byte[] arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int arg0, Clob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String arg0, Clob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateClob(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(int arg0, Date arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDate(String arg0, Date arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(int arg0, double arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateDouble(String arg0, double arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(int arg0, float arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateFloat(String arg0, float arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(int arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateInt(String arg0, int arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(int arg0, long arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateLong(String arg0, long arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNCharacterStream(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int arg0, NClob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String arg0, NClob arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String arg0, Reader arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(int arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNClob(String arg0, Reader arg1, long arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(int arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNString(String arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(int arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateNull(String arg0) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int arg0, Object arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String arg0, Object arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(int arg0, Object arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateObject(String arg0, Object arg1, int arg2) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(int arg0, Ref arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRef(String arg0, Ref arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRow() throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(int arg0, RowId arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateRowId(String arg0, RowId arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(int arg0, SQLXML arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateSQLXML(String arg0, SQLXML arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(int arg0, short arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateShort(String arg0, short arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(int arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateString(String arg0, String arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(int arg0, Time arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTime(String arg0, Time arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(int arg0, Timestamp arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void updateTimestamp(String arg0, Timestamp arg1) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return null;
    }

    public void setMetaData(CommonResultSetMetaData commonResultSetMetaData) {
        this.metadata = commonResultSetMetaData;
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public static interface RowDataReader {
        public RowData nextRow() throws Exception;
    }

    public class RowDataReaderImpl
    implements RowDataReader {
        RowData[] list;
        int index = -1;

        public RowDataReaderImpl(RowData[] list) {
            this.list = list;
        }

        @Override
        public RowData nextRow() throws Exception {
            if (this.index + 1 < this.list.length) {
                return this.list[++this.index];
            }
            return null;
        }
    }
}

