/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.jdbc.common;

import com.stambia.jdbc.common.ColumnMetaDataSet;
import com.stambia.jdbc.common.Messages;
import com.stambia.jdbc.common.RowData;
import com.stambia.jdbc.common.parser.SelectMetaData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.OrderByElement;

public abstract class RowComparator
implements Comparator<RowData> {
    private List<OrderByElement> orderBy = new ArrayList<OrderByElement>();
    protected ColumnMetaDataSet colMd;

    public RowComparator(ColumnMetaDataSet colMd, SelectMetaData select) throws Exception {
        if (select.getOrderByElements() != null) {
            for (Object o : select.getOrderByElements()) {
                OrderByElement e = (OrderByElement)o;
                if (!(e.getExpression() instanceof Column)) {
                    throw new Exception(Messages.getString("RowComparator.0"));
                }
                this.orderBy.add(e);
            }
        }
        if (this.orderBy.isEmpty()) {
            throw new Exception(Messages.getString("RowComparator.1"));
        }
        this.colMd = colMd;
    }

    @Override
    public int compare(RowData o1, RowData o2) {
        String[] r1 = o1.colData;
        String[] r2 = o2.colData;
        for (OrderByElement e : this.orderBy) {
            try {
                int modifier;
                int i = this.getColumnIndex4(e);
                String s1 = r1[i];
                String s2 = r2[i];
                int n = modifier = e.isAsc() ? 1 : -1;
                int compare = this.compare(s1, s2, i);
                if (compare == 0) continue;
                return compare * modifier;
            }
            catch (Exception exception) {
            }
        }
        return 0;
    }

    private int getColumnIndex4(OrderByElement e) throws Exception {
        int i;
        for (i = 0; i < this.colMd.getColumns().size(); ++i) {
            if (!this.colMd.getColumnMetaData(i).getColumnLabel().equalsIgnoreCase(((Column)e.getExpression()).getColumnName())) continue;
            return i;
        }
        for (i = 0; i < this.colMd.getColumns().size(); ++i) {
            if (!this.colMd.getColumnMetaData(i).getColumnName().equalsIgnoreCase(((Column)e.getExpression()).getColumnName())) continue;
            return i;
        }
        throw new Exception(Messages.getString("RowComparator.2") + ((Column)e.getExpression()).getColumnName() + Messages.getString("RowComparator.3"));
    }

    protected abstract int compare(String var1, String var2, int var3);
}

