/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.googlesheets;

import com.google.api.services.sheets.v4.Sheets;
import com.google.api.services.sheets.v4.model.AppendValuesResponse;
import com.google.api.services.sheets.v4.model.ValueRange;
import com.stambia.jdbc.common.parser.InsertMetaData;
import com.stambia.jdbc.common.parser.Parser;
import com.stambia.udriver.googlesheets.GSheetsConnection;
import com.stambia.udriver.googlesheets.GSheetsDatabaseMetaData;
import com.stambia.udriver.jdbc.PreparedStatementImpl;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GSheetsPreparedStatement
extends PreparedStatementImpl {
    private ArrayList<List<Object>> currentBatch;
    private List<Object> currentRow;
    String spreadsheetId;
    String sheetName;
    private int[] columnIndices;
    private GSheetsConnection conn;

    public GSheetsPreparedStatement(GSheetsConnection conn, String sql) throws SQLException {
        this.conn = conn;
        Parser parser = new Parser(sql);
        InsertMetaData insertMD = parser.getInsertMetaData();
        this.sheetName = insertMD.getTableMetaData().getTableName();
        this.spreadsheetId = insertMD.getTableMetaData().getSchemaName();
        try {
            GSheetsDatabaseMetaData metadata = (GSheetsDatabaseMetaData)conn.getMetaData();
            List<String> allColumns = metadata.getListColumns(this.spreadsheetId, this.sheetName);
            List<String> insertColumns = insertMD.getColumnNames();
            this.columnIndices = new int[allColumns.size()];
            for (int i = 0; i < insertColumns.size(); ++i) {
                this.columnIndices[i] = allColumns.indexOf(insertColumns.get(i));
            }
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
        this.currentBatch = new ArrayList();
        ArrayList<String> row = new ArrayList<String>(Collections.nCopies(this.columnIndices.length, ""));
        this.currentBatch.add(row);
        this.currentRow = row;
    }

    @Override
    public void addBatch() throws SQLException {
        ArrayList<String> row = new ArrayList<String>(Collections.nCopies(this.columnIndices.length, ""));
        this.currentBatch.add(row);
        this.currentRow = row;
    }

    private String getInsertRange() {
        return "'" + this.sheetName + "'!A2";
    }

    @Override
    public void clearBatch() throws SQLException {
        this.currentBatch.clear();
        ArrayList<String> row = new ArrayList<String>(Collections.nCopies(this.columnIndices.length, ""));
        this.currentBatch.add(row);
        this.currentRow = row;
    }

    @Override
    public int[] executeBatch() throws SQLException {
        ValueRange body = new ValueRange().setValues(this.currentBatch);
        try {
            AppendValuesResponse res = (AppendValuesResponse)this.getService().spreadsheets().values().append(this.spreadsheetId, this.getInsertRange(), body).setValueInputOption("USER_ENTERED").execute();
            this.clearBatch();
            return new int[]{res.getUpdates().getUpdatedRows()};
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    private Sheets getService() {
        return this.conn.getService();
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.currentRow.set(this.columnIndices[parameterIndex - 1], x);
    }

    @Override
    public void setArray(int arg0, Array arg1) throws SQLException {
        this.setObject(arg0, arg1);
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1) throws SQLException {
        this.setObject(arg0, arg1);
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.setObject(arg0, arg1);
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        this.setObject(arg0, arg1);
    }

    @Override
    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        this.setObject(arg0, arg1);
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1) throws SQLException {
        this.setObject(arg0, arg1);
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.setObject(arg0, arg1);
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        this.setObject(arg0, arg1);
    }

    @Override
    public void setBlob(int arg0, Blob arg1) throws SQLException {
        this.setObject(arg0, arg1);
    }

    @Override
    public void setBlob(int arg0, InputStream arg1) throws SQLException {
        this.setObject(arg0, arg1);
    }

    @Override
    public void setBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
        this.setObject(arg0, arg1);
    }

    @Override
    public void setBoolean(int arg0, boolean arg1) throws SQLException {
        this.setObject(arg0, arg1);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.setObject(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setObject(parameterIndex, value);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.setObject(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setObject(parameterIndex, x);
    }
}

