/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.googlesheets;

import com.google.api.services.sheets.v4.model.ValueRange;
import com.stambia.udriver.googlesheets.GSheetsConnection;
import com.stambia.udriver.jdbc.ResultSetImpl;
import com.stambia.udriver.jdbc.ResultSetMetaDataImpl;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

public class GSheetsResultSet
extends ResultSetImpl {
    private int totalRow = 2;
    private int currentRow = -1;
    private List<List<Object>> currentBatch;
    private String spreadsheetId;
    private String sheetName;
    private GSheetsConnection conn;
    private int fetchSize = 1000;

    public GSheetsResultSet(GSheetsConnection conn, String spreadsheetId, String sheetName) {
        this.conn = conn;
        this.spreadsheetId = spreadsheetId;
        this.sheetName = sheetName;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.currentBatch == null || this.currentRow == this.getFetchSize() - 1) {
            this.fetchNextBatch();
            this.currentRow = -1;
        }
        ++this.currentRow;
        ++this.totalRow;
        if (this.currentBatch == null || this.currentRow == this.currentBatch.size() && this.currentRow != this.getFetchSize()) {
            return false;
        }
        return !this.currentBatch.isEmpty();
    }

    private void fetchNextBatch() throws SQLException {
        try {
            this.currentBatch = ((ValueRange)this.conn.getService().spreadsheets().values().get(this.spreadsheetId, "'" + this.sheetName + "'!A" + this.totalRow + ":ZZZ" + (this.totalRow + this.getFetchSize() - 1)).execute()).getValues();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        int position = ((ResultSetMetaDataImpl)this.getMetaData()).getColumn((int)columnIndex).position;
        List<Object> row = this.currentBatch.get(this.currentRow);
        if (position >= row.size()) {
            return null;
        }
        return (String)row.get(position);
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.fetchSize = rows;
    }
}

