/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.jdbc;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLDecoder;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class DriverImpl
implements Driver {
    String urlRegexpMatcher;
    int majorVersion = 1;
    int minorVersion = 0;

    public DriverImpl(String urlRegexpMatcher, int majorVersion, int minorVersion) {
        this.urlRegexpMatcher = urlRegexpMatcher;
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    protected Properties getProperties(String url, String encoding, Properties prop) throws SQLException {
        Properties _new;
        Properties properties = _new = prop != null ? new Properties(prop) : new Properties();
        if (url != null) {
            try {
                Map<String, List<String>> map = DriverImpl.parseURLQuery(url, encoding);
                for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                    if (entry.getValue() == null || entry.getValue().size() <= 0 || entry.getValue().get(0) == null) continue;
                    _new.put(entry.getKey(), entry.getValue().get(0));
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new SQLException(e);
            }
            catch (MalformedURLException e) {
                throw new SQLException(e);
            }
        }
        return _new;
    }

    private static Map<String, List<String>> parseURLQuery(String url, String encoding) throws UnsupportedEncodingException, MalformedURLException {
        LinkedHashMap<String, List<String>> query_pairs = new LinkedHashMap<String, List<String>>();
        int index = url.indexOf("?");
        if (index > -1) {
            String[] pairs;
            String query = url.substring(index + 1);
            for (String pair : pairs = query.split("&")) {
                String key;
                int idx = pair.indexOf("=");
                String string = key = idx > 0 ? URLDecoder.decode(pair.substring(0, idx), encoding) : pair;
                if (!query_pairs.containsKey(key)) {
                    query_pairs.put(key, new LinkedList());
                }
                String value = idx > 0 && pair.length() > idx + 1 ? URLDecoder.decode(pair.substring(idx + 1), encoding) : null;
                ((List)query_pairs.get(key)).add(value);
            }
        }
        return query_pairs;
    }

    @Override
    public boolean acceptsURL(String arg0) throws SQLException {
        return arg0.matches(this.urlRegexpMatcher);
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String arg0, Properties arg1) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }
}

