/*
 * Decompiled with CFR 0.152.
 */
package com.stambia.udriver.jdbc;

import com.stambia.udriver.jdbc.Messages;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ResultSetMetaDataImpl
implements ResultSetMetaData {
    Map<String, Integer> columnsByLabel = new HashMap<String, Integer>();
    List<ColumnMetadata> columnsByPosition = new ArrayList<ColumnMetadata>();

    public ColumnMetadata getColumnMetadata(int columnIndex) {
        return this.columnsByPosition.get(columnIndex - 1);
    }

    public void addColumn(ColumnMetadata column) {
        this.columnsByPosition.add(column);
        this.columnsByLabel.put(column.columnLabel, this.columnsByPosition.size());
    }

    public void addColumns(Collection<ColumnMetadata> sortedColumns) {
        for (ColumnMetadata cm : sortedColumns) {
            this.addColumn(cm);
        }
    }

    public ResultSetMetaDataImpl() {
    }

    public ResultSetMetaDataImpl(Collection<ColumnMetadata> sortedColumns) {
        this.addColumns(sortedColumns);
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getCatalogName(int arg0) throws SQLException {
        return this.getColumn((int)arg0).catalogName;
    }

    public ColumnMetadata getColumn(int position) throws SQLException {
        try {
            ColumnMetadata col = this.columnsByPosition.get(position - 1);
            return col;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SQLException(Messages.getString("ResultSetMetaDataImpl.0") + position + Messages.getString("ResultSetMetaDataImpl.1"));
        }
    }

    public int getColumnPosition(String label) throws SQLException {
        Integer col = this.columnsByLabel.get(label);
        if (col == null) {
            throw new SQLException(Messages.getString("ResultSetMetaDataImpl.2") + label + Messages.getString("ResultSetMetaDataImpl.3"));
        }
        return col;
    }

    @Override
    public String getColumnClassName(int arg0) throws SQLException {
        return this.getColumn((int)arg0).columnClassName;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnsByPosition.size();
    }

    @Override
    public int getColumnDisplaySize(int arg0) throws SQLException {
        return this.getColumn((int)arg0).displaySize;
    }

    @Override
    public String getColumnLabel(int arg0) throws SQLException {
        return this.getColumn((int)arg0).columnLabel;
    }

    @Override
    public String getColumnName(int arg0) throws SQLException {
        return this.getColumn((int)arg0).columnName;
    }

    @Override
    public int getColumnType(int arg0) throws SQLException {
        return this.getColumn((int)arg0).columnType;
    }

    @Override
    public String getColumnTypeName(int arg0) throws SQLException {
        return this.getColumn((int)arg0).columnTypeName;
    }

    @Override
    public int getPrecision(int arg0) throws SQLException {
        return this.getColumn((int)arg0).precision;
    }

    @Override
    public int getScale(int arg0) throws SQLException {
        return this.getColumn((int)arg0).scale;
    }

    @Override
    public String getSchemaName(int arg0) throws SQLException {
        return this.getColumn((int)arg0).schemaName;
    }

    @Override
    public String getTableName(int arg0) throws SQLException {
        return this.getColumn((int)arg0).tableName;
    }

    @Override
    public boolean isAutoIncrement(int arg0) throws SQLException {
        return this.getColumn((int)arg0).isAutoIncrement;
    }

    @Override
    public boolean isCaseSensitive(int arg0) throws SQLException {
        return this.getColumn((int)arg0).isCaseSensitive;
    }

    @Override
    public boolean isCurrency(int arg0) throws SQLException {
        return this.getColumn((int)arg0).isCurrency;
    }

    @Override
    public boolean isDefinitelyWritable(int arg0) throws SQLException {
        return this.getColumn((int)arg0).isDefinitelyWritable;
    }

    @Override
    public boolean isReadOnly(int arg0) throws SQLException {
        return this.getColumn((int)arg0).isReadOnly;
    }

    @Override
    public boolean isSearchable(int arg0) throws SQLException {
        return this.getColumn((int)arg0).isSearchable;
    }

    @Override
    public boolean isSigned(int arg0) throws SQLException {
        return this.getColumn((int)arg0).isSigned;
    }

    @Override
    public boolean isWritable(int arg0) throws SQLException {
        return this.getColumn((int)arg0).isWritable;
    }

    @Override
    public int isNullable(int arg0) throws SQLException {
        return this.getColumn((int)arg0).isNullable;
    }

    public static class ColumnMetadata {
        public String columnName;
        public String columnClassName;
        public boolean isReadOnly = false;
        public int isNullable = 0;
        public boolean isAutoIncrement = false;
        public int columnType = 12;
        public int displaySize = 255;
        public String columnLabel;
        public String columnTypeName = "VARCHAR";
        public String schemaName;
        public int scale = 0;
        public int precision = 255;
        public String tableName;
        public boolean isCaseSensitive = false;
        public boolean isCurrency = false;
        public boolean isDefinitelyWritable = false;
        public String catalogName;
        public boolean isSearchable = false;
        public boolean isSigned = false;
        public boolean isWritable = true;
        public int position = 0;
    }
}

