/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.action.common;

import com.indy.engine.action.common.BindExpressionReplacer;
import com.indy.engine.action.common.Messages;
import com.indy.engine.action.common.SecretValueImpl;
import com.indy.engine.action.common.SecretValueManager;
import com.indy.engine.core.ISessionContext;
import com.indy.engine.core.RuntimeContext;
import com.indy.engine.core.common.CommonUtils;
import com.indy.engine.core.common.VariableType;
import com.indy.engine.core.common.objects2.IVariable;
import com.indy.engine.core.common.objects2.Variable;
import com.indy.engine.core.jdbc.IPreparedStatementToResultSet;
import com.indy.engine.core.manager.IActionContext;
import com.indy.engine.core.objects.data.baseobjects.StringOperations;
import com.indy.engine.secret.ISecretStatement;
import com.indy.engine.secret.ISecretValue;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;

public class ActionCodeTypeI {
    public String actionTxtCode;
    public IActionContext actionContext;
    public ISessionContext engineContext;
    public RuntimeContext runtimeContext;
    public String actionClassName = "";
    public String actionName;
    public String actionCodeName;
    public String sessionName;
    public int actionLevel;
    public Boolean bNullCodeAllowed = false;
    public boolean bStoppingAction = false;
    public Integer sqlBindingFetchSize = null;
    public boolean setDateAsTimestamp = false;
    public boolean getDateAsTimestamp = false;
    public boolean setNVarcharAsVarchar = false;
    public boolean disableImplicitConversion = false;
    public boolean isRdbmsLinked = false;
    public Connection jdbcConnection = null;
    public String connectionName = null;
    public String sqlTransName = null;
    public String sqlSchemaName = null;
    public String sqlTransType = null;
    public int sqlReadAutocommitMode = 1;
    public int sqlTransactionIsolation = -1;
    public String finalConnectionName;
    public int sqlServerBatchSize = -1;
    public int sqlServerFetchSize = -1;
    public int varcharSize = 255;
    public String varcharType = "VARCHAR";
    public String numericType = "NUMERIC";
    public String objectStartDelimiter;
    public String objectEndDelimiter;
    public ResultSet currentRSet = null;
    public Logger logger = LogManager.getLogger((String)"com.indy.engine.actionCodes");
    ActionCodeTypeHandler actionCodeTypeHandler;
    private SecretValueManager secretManager = new SecretValueManager();
    int fileTableVersion = 0;
    boolean isSelect = false;
    public boolean encrypted;
    Map<String, Object> overLoadParamters = new HashMap<String, Object>();

    public void interruptedException() throws InterruptedException {
        if (Thread.interrupted()) {
            this.actionCodeTypeHandler.write(this.sessionName, this.actionCodeName + "=>executeSimpleCode", this.actionName + Messages.getString("ActionCodeTypeI.0"), 3, this.actionLevel, "DEBUG");
            throw new InterruptedException();
        }
    }

    protected Logger getLogger() {
        return this.logger;
    }

    public ActionCodeTypeI(String actionCodeName, boolean bNullCodeAllowed) {
        this.bNullCodeAllowed = bNullCodeAllowed;
        this.actionCodeName = actionCodeName;
        this.actionClassName = this.getClass().getName();
    }

    private void init() {
        this.objectStartDelimiter = this.runtimeContext.TECH_OBJECT_START_DELIMITER;
        this.objectEndDelimiter = this.runtimeContext.TECH_OBJECT_END_DELIMITER;
    }

    protected ActionCodeTypeI() {
        this.actionCodeName = "Default action";
        this.actionClassName = this.getClass().getName();
    }

    public IActionContext getActionContext() {
        return this.actionContext;
    }

    public void setActionContext(IActionContext actionContext) {
        this.actionContext = actionContext;
    }

    public ResultSet getCurrentRSet() {
        return this.currentRSet;
    }

    @Deprecated
    public IVariable addVariableWithULog(String vPath, String pValue, String pType, boolean pRealTimeReport) {
        return this.actionCodeTypeHandler.addVariableWithULog(vPath, pValue, pType, pRealTimeReport);
    }

    public IVariable getAbsoluteVariable(String path) {
        return this.actionCodeTypeHandler.getAbsoluteVariable(path);
    }

    public String getName() {
        return this.actionCodeName;
    }

    public void defineActionCode(String s) {
        this.actionTxtCode = s;
    }

    public String decryptString(String s) throws EngineExceptionI {
        return this.getActionContext().decryptString(s);
    }

    public String encryptString(String decrypt) throws EngineExceptionI {
        return this.getActionContext().encryptString(decrypt);
    }

    public String getFinalConnectionName() {
        return this.finalConnectionName;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public Connection setConnection(String pConnName, String pTransactionName, String pTransType) throws EngineExceptionI {
        try {
            this.traceConnection("getting connection", () -> this.getTraceLogParameters(pConnName));
            Connection connection = this.actionCodeTypeHandler.setConnection(pConnName, pTransactionName, pTransType);
            return connection;
        }
        finally {
            this.traceConnection("connection accessed", null);
        }
    }

    private Map<String, String> getTraceLogParameters(String connectionName) {
        HashMap<String, String> r = new HashMap<String, String>();
        r.put("actionName", this.actionName);
        if (connectionName != null) {
            r.put("connectionName", connectionName);
        }
        return r;
    }

    private void traceConnection(String message, Supplier<Map<String, String>> contextualInfo) {
        if (this.logger.isTraceEnabled()) {
            ThreadContext.clearMap();
            if (contextualInfo != null) {
                contextualInfo.get().entrySet().stream().forEach(e -> ThreadContext.put((String)((String)e.getKey()), (String)((String)e.getValue())));
            }
            this.logger.trace(message);
        }
    }

    public void setActionCodeTypeHandler(ActionCodeTypeHandler jdbcConnectionCreator) {
        this.actionCodeTypeHandler = jdbcConnectionCreator;
    }

    public void closeConnection(String pConnectionName, String pTransName, String pTransType, boolean pCommitTrans) {
        try {
            this.actionCodeTypeHandler.closeConnection(pConnectionName, pTransName, pTransType, pCommitTrans);
        }
        catch (Throwable throwable) {
            this.traceConnection("closed connection", () -> this.getTraceLogParameters(pConnectionName));
            throw throwable;
        }
        this.traceConnection("closed connection", () -> this.getTraceLogParameters(pConnectionName));
    }

    public void setStandardConnectionParameters(ResultSet rSet) throws EngineExceptionI {
        this.connectionName = this.getLocalStringBindedParameter(rSet, "SQL_CONNECTION", "");
        this.sqlTransName = this.getLocalStringBindedParameter(rSet, "SQL_TRANSACTION_NAME", "T1");
        this.sqlTransType = this.getLocalStringBindedParameter(rSet, "SQL_TRANSACTION_TYPE", "AUTOCOMMIT");
        this.sqlSchemaName = this.getLocalStringBindedParameter(rSet, "SQL_SCHEMA_NAME", "");
        if (!this.sqlSchemaName.equals("")) {
            this.sqlSchemaName = String.valueOf(this.sqlSchemaName) + ".";
        }
    }

    public String getFinalBindedCode(ResultSet sourceRSet, String txt) throws EngineExceptionI {
        if (txt == null) {
            return null;
        }
        String ret = null;
        try {
            ret = this.actionCodeTypeHandler.executeSubstitutionScript(this.actionContext, BindExpressionReplacer.replaceBindedExpressions(sourceRSet, txt, this.objectStartDelimiter, this.objectEndDelimiter, this), "b");
        }
        catch (SQLException e) {
            this.actionCodeTypeHandler.write(this.sessionName, "ActionCodeTypeI=>getFinalBindedCode", this.actionName + " : SQLException : " + e.getMessage(), 0, this.actionLevel, "ERROR");
            throw new EngineExceptionI(e);
        }
        return ret;
    }

    public ISecretValue getLocalFinalSecretBindedCode(ResultSet sourceRSet, String txt) throws EngineExceptionI {
        SecretValueImpl val = new SecretValueImpl(this::decryptString, this::encryptString);
        String str = sourceRSet == null ? txt : this.getFinalBindedCode(sourceRSet, txt);
        val.setSourceValue(str);
        return val;
    }

    public void setStoppingAction(Boolean b) {
        this.bStoppingAction = b;
    }

    public boolean getStoppingAction() {
        return this.bStoppingAction;
    }

    public void stopAction(Thread th) {
        this.setStoppingAction(true);
        if (th != null) {
            th.interrupt();
        }
    }

    public int prepareExecuteCode() throws EngineExceptionI {
        return 0;
    }

    public int prepareSimpleExecuteCode() throws EngineExceptionI {
        return 0;
    }

    public int finalizeExecuteCode(boolean withError) throws EngineExceptionI {
        try {
            return this.finalizeExecuteCode();
        }
        catch (EngineExceptionI e) {
            if (!withError) {
                throw e;
            }
            this.logger.warn("exception while finalizing", (Throwable)e);
            return 0;
        }
    }

    public int prepareDirectBindedFetch(ResultSet rSet) throws EngineExceptionI {
        return 0;
    }

    public void finalizeBadDirectBindedFetch() throws EngineExceptionI {
    }

    public int finalizeDirectBindedFetch(int numRecord) throws EngineExceptionI {
        int ret = 0;
        if (this.isRdbmsLinked && !this.connectionName.isEmpty() && this.isTransactionAutoCommit()) {
            this.closeConnection(this.connectionName, this.sqlTransName, this.sqlTransType, true);
        }
        return ret;
    }

    public int executeDirectBindedFetch(int numRecord, ResultSet sourceRSet, ResultSetMetaData sourceRSMD) throws Exception {
        return 0;
    }

    public Boolean getBooleanBindedParameter(ResultSet rSet, IVariable var) throws EngineExceptionI, SQLException {
        String strVarValue;
        block9: {
            block8: {
                strVarValue = null;
                String paramsReplaced = BindExpressionReplacer.replaceBindedExpressions(rSet, var.getValue(), this.objectStartDelimiter, this.objectEndDelimiter, this);
                try {
                    strVarValue = this.actionCodeTypeHandler.executeSubstitutionScript(this.actionContext, paramsReplaced, "b");
                    ((Variable)var).setLastBindedValue(strVarValue);
                }
                catch (EngineExceptionI e) {
                    if (e.exceptionType == 7 && this.actionContext.getAllowsScriptingErrors()) break block8;
                    throw new EngineExceptionI(e);
                }
            }
            try {
                strVarValue = this.actionCodeTypeHandler.executeSubstitutionScript(this.actionContext, strVarValue, "s");
            }
            catch (EngineExceptionI e) {
                if (e.exceptionType == 7 && this.actionContext.getAllowsScriptingErrors()) break block9;
                throw new EngineExceptionI(e);
            }
        }
        if (strVarValue != null) {
            if ((strVarValue = strVarValue.toLowerCase(Locale.getDefault())).equals("yes")) {
                strVarValue = "true";
            } else if (strVarValue.equals("no")) {
                strVarValue = "false";
            }
            strVarValue = strVarValue.replace("\n", "").replace("\r", "").replace(" ", "");
            StringOperations.verifyType(var.getName(), strVarValue, var.getType());
        }
        return Boolean.parseBoolean(strVarValue);
    }

    public Boolean getBooleanBindedParameter(ResultSet rSet, String varName) throws EngineExceptionI {
        Boolean ret = false;
        IVariable var = null;
        try {
            var = this.engineContext.getVariable(varName);
            ret = this.getBooleanBindedParameter(rSet, var);
        }
        catch (EngineExceptionI e) {
            throw new EngineExceptionI(e);
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI(Messages.getString("ActionCodeTypeI.1") + varName + Messages.getString("ActionCodeTypeI.2"), e);
        }
        catch (Exception e) {
            throw new EngineExceptionI(e);
        }
        return ret;
    }

    public Long getLongBindedParameter(ResultSet rSet, String varName) throws EngineExceptionI {
        Long ret = null;
        IVariable var = null;
        String strVarValue = null;
        try {
            block9: {
                block8: {
                    var = this.engineContext.getVariable(varName);
                    String paramsReplaced = BindExpressionReplacer.replaceBindedExpressions(rSet, var.getValue(), this.objectStartDelimiter, this.objectEndDelimiter, this);
                    try {
                        strVarValue = this.actionCodeTypeHandler.executeSubstitutionScript(this.actionContext, paramsReplaced, "b");
                        ((Variable)var).setLastBindedValue(strVarValue);
                    }
                    catch (EngineExceptionI e) {
                        if (e.exceptionType == 7 && this.actionContext.getAllowsScriptingErrors()) break block8;
                        throw new EngineExceptionI(e);
                    }
                }
                try {
                    strVarValue = this.actionCodeTypeHandler.executeSubstitutionScript(this.actionContext, strVarValue, "s");
                }
                catch (EngineExceptionI e) {
                    if (e.exceptionType == 7 && this.actionContext.getAllowsScriptingErrors()) break block9;
                    throw new EngineExceptionI(e);
                }
            }
            StringOperations.verifyType(var.getName(), strVarValue, var.getType());
            ret = Long.valueOf(strVarValue);
        }
        catch (EngineExceptionI e) {
            throw e;
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI(Messages.getString("ActionCodeTypeI.3") + varName + Messages.getString("ActionCodeTypeI.4"), e);
        }
        catch (Exception e) {
            throw new EngineExceptionI(e);
        }
        return ret;
    }

    public Integer getIntegerBindedParameter(ResultSet rSet, IVariable var) throws EngineExceptionI, SQLException {
        String strVarValue;
        block5: {
            block4: {
                strVarValue = null;
                String paramsReplaced = BindExpressionReplacer.replaceBindedExpressions(rSet, var.getValue(), this.objectStartDelimiter, this.objectEndDelimiter, this);
                try {
                    strVarValue = this.actionCodeTypeHandler.executeSubstitutionScript(this.actionContext, paramsReplaced, "b");
                    ((Variable)var).setLastBindedValue(strVarValue);
                }
                catch (EngineExceptionI e) {
                    if (e.exceptionType == 7 && this.actionContext.getAllowsScriptingErrors()) break block4;
                    throw new EngineExceptionI(e);
                }
            }
            try {
                strVarValue = this.actionCodeTypeHandler.executeSubstitutionScript(this.actionContext, strVarValue, "s");
            }
            catch (EngineExceptionI e) {
                if (e.exceptionType == 7 && this.actionContext.getAllowsScriptingErrors()) break block5;
                throw new EngineExceptionI(e);
            }
        }
        StringOperations.verifyType(var.getName(), strVarValue, var.getType());
        return Integer.parseInt(strVarValue);
    }

    public Integer getIntegerBindedParameter(ResultSet rSet, String varName) throws EngineExceptionI {
        Integer ret = null;
        IVariable var = null;
        try {
            var = this.engineContext.getVariable(varName);
            ret = this.getIntegerBindedParameter(rSet, var);
        }
        catch (EngineExceptionI e) {
            throw new EngineExceptionI(e);
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI(Messages.getString("ActionCodeTypeI.7") + varName + Messages.getString("ActionCodeTypeI.8"), e);
        }
        catch (Exception e) {
            throw new EngineExceptionI(e);
        }
        return ret;
    }

    public Map<String, Object> getAllBindedParameter(ResultSet rSet, String regexp) throws EngineExceptionI, SQLException {
        return this.actionCodeTypeHandler.getAllBindedParameter(rSet, regexp);
    }

    public String getStringBindedParameter(ResultSet rSet, IVariable var) throws SQLException, EngineExceptionI {
        String strVarValue;
        block5: {
            block4: {
                String paramsReplaced = BindExpressionReplacer.replaceBindedExpressions(rSet, var.getValue(), this.objectStartDelimiter, this.objectEndDelimiter, this);
                strVarValue = null;
                try {
                    strVarValue = this.actionCodeTypeHandler.executeSubstitutionScript(this.actionContext, paramsReplaced, "b");
                    ((Variable)var).setLastBindedValue(strVarValue);
                }
                catch (EngineExceptionI e) {
                    if (e.exceptionType == 7 && this.actionContext.getAllowsScriptingErrors()) break block4;
                    throw new EngineExceptionI(e);
                }
            }
            try {
                strVarValue = this.actionCodeTypeHandler.executeSubstitutionScript(this.actionContext, strVarValue, "s");
            }
            catch (EngineExceptionI e) {
                if (e.exceptionType == 7 && this.actionContext.getAllowsScriptingErrors()) break block5;
                throw new EngineExceptionI(e);
            }
        }
        StringOperations.verifyType(var.getName(), strVarValue, var.getType());
        return strVarValue;
    }

    public String getStringBindedParameter(ResultSet rSet, String varName) throws EngineExceptionI {
        String ret = null;
        IVariable var = null;
        try {
            var = this.engineContext.getVariable(varName);
            ret = this.getStringBindedParameter(rSet, var);
        }
        catch (EngineExceptionI e) {
            throw new EngineExceptionI(e);
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI(Messages.getString("ActionCodeTypeI.9") + varName + Messages.getString("ActionCodeTypeI.10"), e);
        }
        catch (Exception e) {
            throw new EngineExceptionI(e);
        }
        return ret;
    }

    protected ArrayList getLstTxtCodeBindedParameters(String txtCode) {
        this.actionCodeTypeHandler.write(this.sessionName, "ActionCodeTypeI=>getLstTxtCodeBindedParameters", this.actionName + Messages.getString("ActionCodeTypeI.11"), 3, this.actionLevel, "INFO");
        ArrayList retAList = (ArrayList)BindExpressionReplacer.getLstTxtCodeBindedParameters(txtCode, this.objectStartDelimiter, this.objectEndDelimiter);
        this.actionCodeTypeHandler.write(this.sessionName, "ActionCodeTypeI=>getLstTxtCodeBindedParameters", this.actionName + Messages.getString("ActionCodeTypeI.12"), 3, this.actionLevel, "INFO");
        return retAList;
    }

    public int executeSimpleCode() throws EngineExceptionI {
        return 0;
    }

    public static String rpad(String s, int n, String replace) {
        if (n > 0) {
            return String.format("%1$-" + n + "s", s).replace(" ", replace);
        }
        return "";
    }

    public static String lpad(String s, int n, String replace) {
        if (n > 0) {
            return String.format("%1$" + n + "s", s).replace(" ", replace);
        }
        return "";
    }

    public Long getLongParameter(String pName) throws EngineExceptionI {
        Long i;
        try {
            String sValue;
            IVariable v;
            block6: {
                v = this.engineContext.getVariable(pName);
                sValue = v.getValue();
                try {
                    sValue = this.actionCodeTypeHandler.executeSubstitutionScript(this.actionContext, sValue, "s");
                }
                catch (EngineExceptionI e) {
                    if (e.exceptionType == 7 && this.actionContext.getAllowsScriptingErrors()) break block6;
                    throw new EngineExceptionI(e);
                }
            }
            StringOperations.verifyType(v.getName(), sValue, v.getType());
            i = Long.parseLong(sValue);
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI(Messages.getString("ActionCodeTypeI.15") + pName + Messages.getString("ActionCodeTypeI.16"), e);
        }
        catch (EngineExceptionI e) {
            throw new EngineExceptionI(e);
        }
        catch (Exception e) {
            throw new EngineExceptionI(e);
        }
        return i;
    }

    public Integer getIntegerParameter(String pName) throws EngineExceptionI {
        Integer i;
        try {
            String sValue;
            IVariable v;
            block6: {
                v = this.engineContext.getVariable(pName);
                sValue = v.getValue();
                try {
                    sValue = this.actionCodeTypeHandler.executeSubstitutionScript(this.actionContext, sValue, "s");
                }
                catch (EngineExceptionI e) {
                    if (e.exceptionType == 7 && this.actionContext.getAllowsScriptingErrors()) break block6;
                    throw new EngineExceptionI(e);
                }
            }
            StringOperations.verifyType(v.getName(), sValue, v.getType());
            i = Integer.parseInt(sValue);
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI(Messages.getString("ActionCodeTypeI.17") + pName + Messages.getString("ActionCodeTypeI.18"), e);
        }
        catch (EngineExceptionI e) {
            throw new EngineExceptionI(e);
        }
        catch (Exception e) {
            throw new EngineExceptionI(e);
        }
        return i;
    }

    public Boolean getBooleanParameter(String pName) throws EngineExceptionI {
        Boolean b;
        try {
            String sValue;
            IVariable v;
            block9: {
                v = this.engineContext.getVariable(pName);
                sValue = v.getValue();
                try {
                    sValue = this.actionCodeTypeHandler.executeSubstitutionScript(this.actionContext, sValue, "s");
                }
                catch (EngineExceptionI e) {
                    if (e.exceptionType == 7 && this.actionContext.getAllowsScriptingErrors()) break block9;
                    throw new EngineExceptionI(e);
                }
            }
            sValue = sValue.toLowerCase(Locale.getDefault());
            if (sValue.equals("yes")) {
                sValue = "true";
            } else if (sValue.equals("no")) {
                sValue = "false";
            }
            sValue = sValue.replaceAll("\\n", "").replaceAll("\\r", "").replaceAll("\\s", "");
            StringOperations.verifyType(v.getName(), sValue, v.getType());
            b = Boolean.parseBoolean(sValue);
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI(Messages.getString("ActionCodeTypeI.19") + pName + Messages.getString("ActionCodeTypeI.20"), e);
        }
        catch (EngineExceptionI e) {
            throw new EngineExceptionI(e);
        }
        catch (Exception e) {
            throw new EngineExceptionI(e);
        }
        return b;
    }

    public String getStringParameter(String pName) throws EngineExceptionI {
        String s;
        try {
            String sValue;
            block6: {
                IVariable v = this.engineContext.getVariable(pName);
                sValue = v.getValue();
                try {
                    sValue = this.actionCodeTypeHandler.executeSubstitutionScript(this.actionContext, sValue, "s");
                }
                catch (EngineExceptionI e) {
                    if (e.exceptionType == 7 && this.actionContext.getAllowsScriptingErrors()) break block6;
                    throw new EngineExceptionI(e);
                }
            }
            s = sValue;
        }
        catch (NullPointerException e) {
            throw new EngineExceptionI(Messages.getString("ActionCodeTypeI.21") + pName + Messages.getString("ActionCodeTypeI.22"), e);
        }
        catch (EngineExceptionI e) {
            throw e;
        }
        catch (Exception e) {
            throw new EngineExceptionI(e);
        }
        return s;
    }

    protected void computeActionLevel() {
        int nbDot = 1;
        int i = 0;
        int j = 1;
        while (i != -1) {
            i = this.actionName.indexOf(this.runtimeContext.VARIABLE_PATH_SEPARATOR, j);
            if (i == -1) continue;
            j = i + 1;
            ++nbDot;
        }
        this.actionLevel = nbDot;
    }

    public void createFileTable() throws EngineExceptionI {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (Statement DMLStatement = this.jdbcConnection.createStatement();){
                this.actionCodeTypeHandler.write(this.sessionName, this.actionClassName + "=>createTables", this.actionName + Messages.getString("ActionCodeTypeI.23"), 2, this.actionLevel, "DEBUG");
                Object txtCode = "DROP TABLE " + this.sqlSchemaName + "IND_SESSION_FILE_OP_LST";
                try {
                    DMLStatement.execute((String)txtCode);
                }
                catch (Exception e) {
                    this.logger.warn("unexpected", (Throwable)e);
                }
                this.actionCodeTypeHandler.write(this.sessionName, this.actionClassName + "=>createTables", this.actionName + " : Drop OK", 2, this.actionLevel, "DEBUG");
                String strVarcharSize = String.valueOf(this.varcharSize);
                StringBuilder builder = new StringBuilder();
                builder.append("CREATE TABLE ");
                builder.append(this.sqlSchemaName);
                builder.append("IND_SESSION_FILE_OP_LST (");
                builder.append("SESS_ID           \t\t");
                builder.append(this.varcharType);
                builder.append("(50) NOT NULL, ");
                builder.append("SESS_NAME           \t\t");
                builder.append(this.varcharType);
                builder.append("(" + strVarcharSize + ") NOT NULL, ");
                builder.append("ACT_ID            \t\t");
                builder.append(this.varcharType);
                builder.append("(50) NOT NULL, ");
                builder.append("ACT_NAME          \t\t");
                builder.append(this.varcharType);
                builder.append("(" + strVarcharSize + ") NOT NULL, ");
                builder.append("ACT_ITER          \t\t");
                builder.append(this.numericType);
                builder.append("(10) NULL, ");
                builder.append("FILE_ID           \t\t");
                builder.append(this.numericType);
                builder.append("(10) NOT NULL, ");
                builder.append("FILE_OPERATION\t \t\t");
                builder.append(this.varcharType);
                builder.append("(50) NULL, ");
                builder.append("FILE_NAME\t\t\t\t");
                builder.append(this.varcharType);
                builder.append("(" + strVarcharSize + ") NULL, ");
                builder.append("FILE_DIR  \t \t\t\t");
                builder.append(this.varcharType);
                builder.append("(" + strVarcharSize + ") NULL, ");
                builder.append("FILE_FROM_DIR  \t \t\t\t");
                builder.append(this.varcharType);
                builder.append("(" + strVarcharSize + ") NULL, ");
                builder.append("FILE_FROM_FILE  \t \t\t\t");
                builder.append(this.varcharType);
                builder.append("(" + strVarcharSize + ") NULL, ");
                builder.append("FILE_TO_DIR  \t \t\t\t");
                builder.append(this.varcharType);
                builder.append("(" + strVarcharSize + ") NULL, ");
                builder.append("FILE_TO_FILE  \t \t\t\t");
                builder.append(this.varcharType);
                builder.append("(" + strVarcharSize + ") NULL, ");
                builder.append("FILE_OPERATION_DATE  \t");
                builder.append(this.varcharType);
                builder.append("(25) NOT NULL, ");
                builder.append("STATUS     \t \t\t");
                builder.append(this.varcharType);
                builder.append("(35) NULL, ");
                builder.append("STATUS_COMMENT  \t\t");
                builder.append(this.varcharType);
                builder.append("(" + strVarcharSize + ") NULL, ");
                builder.append("STATUS_DATE  \t\t");
                builder.append(this.varcharType);
                builder.append("(25) NULL, ");
                builder.append("USER_COMMENT  \t\t");
                builder.append(this.varcharType);
                builder.append("(" + strVarcharSize + ") NULL, ");
                builder.append("USER_FLAG  \t\t");
                builder.append(this.varcharType);
                builder.append("(35) NULL, ");
                builder.append("USER_DATE  \t\t");
                builder.append(this.varcharType);
                builder.append("(25) NULL, ");
                builder.append("FILE_IS_HIDDEN  \t\t");
                builder.append(this.numericType);
                builder.append("(1) NULL, ");
                builder.append("FILE_LAST_MODIFIED  \t\t");
                builder.append(this.numericType);
                builder.append("(20) NULL, ");
                builder.append("FILE_LAST_MODIFIED_DATE  \t\t");
                builder.append(this.varcharType);
                builder.append("(25) NULL, ");
                builder.append("FILE_CAN_READ  \t\t");
                builder.append(this.numericType);
                builder.append("(1) NULL, ");
                builder.append("FILE_CAN_WRITE  \t\t");
                builder.append(this.numericType);
                builder.append("(1) NULL, ");
                builder.append("FILE_CAN_EXECUTE  \t\t");
                builder.append(this.numericType);
                builder.append("(1) NULL, ");
                builder.append("FILE_IS_DIRECTORY  \t\t");
                builder.append(this.numericType);
                builder.append("(1) NULL, ");
                builder.append("FILE_LENGTH  \t\t");
                builder.append(this.numericType);
                builder.append("(20) NULL");
                builder.append(")");
                txtCode = builder.toString();
                DMLStatement.execute((String)txtCode);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            this.actionCodeTypeHandler.write(this.sessionName, this.actionClassName + "=>createTables", this.actionName + Messages.getString("ActionCodeTypeI.24") + e.getMessage(), 0, this.actionLevel, "ERROR");
            this.addVariableWithULog(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + VariableType.CORE_RET_MESS.getName(), this.actionClassName + "=>createTables : " + e.getMessage(), "String", false);
            throw new EngineExceptionI(e);
        }
        this.actionCodeTypeHandler.write(this.sessionName, this.actionClassName + "=>createTables", this.actionName + Messages.getString("ActionCodeTypeI.25"), 2, this.actionLevel, "DEBUG");
    }

    public void debugLog(String step, String sMessage, int lLevel, String sMode) {
        this.actionCodeTypeHandler.write(this.sessionName, this.getClass().getName() + "=>" + step, this.actionName + " : " + sMessage, lLevel, this.actionLevel, sMode);
    }

    public void publishVariable(String name, Object value) {
        this.publishVariable(name, value, null, false);
    }

    public void publishVariable(String name, Object value, String type) {
        this.publishVariable(name, value, type, false);
    }

    public boolean existsVariable(String name) {
        return this.actionContext.getGetter().existsVariable(name);
    }

    public void publishStatistic(String name, long value, boolean last) {
        if (!last) {
            this.publishVariable(name, String.valueOf(value), "Long", false);
        } else {
            this.publishCumulativeVariable(name, String.valueOf(value), "Long", false);
        }
    }

    public void publishVariable(String name, Object value, String type, boolean pRealTimeReport) {
        this.actionContext.getPublisher().publishVariable(name, value, type, pRealTimeReport);
    }

    public void publishCumulativeVariable(String name, Object value, String type, boolean pRealTimeReport) {
        this.actionContext.getPublisher().publishCumulativeVariable(name, value, type, pRealTimeReport);
    }

    public String getLocalStringParameter(String parameterName) throws EngineExceptionI {
        return this.getStringParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + parameterName);
    }

    public String getLocalStringParameter(String parameterName, String defaultValue) {
        String val = this.getOverload(parameterName, String.class);
        if (val != null) {
            return val;
        }
        try {
            val = this.getLocalStringParameter(parameterName);
        }
        catch (EngineExceptionI e) {
            val = defaultValue;
        }
        return val;
    }

    @Deprecated
    public String getLocalPasswordParameter(ResultSet rSet, String crypt, String uncrypt) throws EngineExceptionI {
        String s1 = this.getLocalStringBindedParameter(rSet, crypt, null);
        if (s1 != null) {
            return this.getActionContext().decryptString(s1);
        }
        return this.getLocalStringBindedParameter(rSet, uncrypt);
    }

    @Deprecated
    public String getLocalPasswordParameter(ResultSet rSet, String crypt, String uncrypt, String replace) throws EngineExceptionI {
        String val;
        try {
            val = this.getLocalPasswordParameter(rSet, crypt, uncrypt);
        }
        catch (EngineExceptionI e) {
            val = replace;
        }
        return val;
    }

    public String getLocalStringBindedParameter(ResultSet rSet, String varName) throws EngineExceptionI {
        String val = this.getOverload(varName, String.class);
        if (val != null) {
            return val;
        }
        if (rSet != null) {
            return this.getStringBindedParameter(rSet, this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + varName);
        }
        return this.getLocalStringParameter(varName);
    }

    public String getLocalStringBindedParameter(ResultSet rSet, String varName, String defaultValue) throws EngineExceptionI {
        if (rSet != null) {
            String val;
            try {
                val = this.getLocalStringBindedParameter(rSet, varName);
            }
            catch (EngineExceptionI e) {
                val = defaultValue;
            }
            return val;
        }
        return this.getLocalStringParameter(varName, defaultValue);
    }

    public <T> T secret(ISecretStatement<T> secret) throws EngineExceptionI {
        return this.secretManager.secret(secret);
    }

    public ISecretValue getLocalSecretBindedParameter(ResultSet rSet, String varName, String defaultValue) throws EngineExceptionI {
        String value = null;
        String localDefaultValue = null;
        if (rSet != null) {
            try {
                value = this.getLocalStringBindedParameter(rSet, varName);
            }
            catch (EngineExceptionI e) {
                localDefaultValue = defaultValue;
            }
        } else {
            value = this.getLocalStringParameter(varName, null);
            if (value == null) {
                localDefaultValue = defaultValue;
            }
        }
        SecretValueImpl ret = new SecretValueImpl(this::decryptString, this::encryptString);
        ret.setDefaultValue(localDefaultValue);
        ret.setSourceValue(value);
        return ret;
    }

    public Boolean getLocalBooleanParameter(String parameterName) throws EngineExceptionI {
        return this.getBooleanParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + parameterName);
    }

    public Boolean getLocalBooleanParameter(String parameterName, Boolean defaultValue) {
        Boolean val = this.getOverload(parameterName, Boolean.class);
        if (val != null) {
            return val;
        }
        try {
            val = this.getLocalBooleanParameter(parameterName);
        }
        catch (EngineExceptionI e) {
            val = defaultValue;
        }
        return val;
    }

    public Boolean getLocalBooleanBindedParameter(ResultSet rSet, String varName) throws EngineExceptionI {
        if (rSet != null) {
            Boolean b = this.getOverload(varName, Boolean.class);
            if (b != null) {
                return b;
            }
            return this.getBooleanBindedParameter(rSet, this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + varName);
        }
        return this.getLocalBooleanParameter(varName);
    }

    public Boolean getLocalBooleanBindedParameter(ResultSet rSet, String varName, Boolean defaultValue) throws EngineExceptionI {
        if (rSet != null) {
            Boolean val;
            try {
                val = this.getLocalBooleanBindedParameter(rSet, varName);
            }
            catch (EngineExceptionI e) {
                val = defaultValue;
            }
            return val;
        }
        return this.getLocalBooleanParameter(varName, defaultValue);
    }

    public Integer getLocalIntegerParameter(String parameterName) throws EngineExceptionI {
        Integer ret = this.getOverload(parameterName, Integer.class);
        if (ret != null) {
            return ret;
        }
        return this.getIntegerParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + parameterName);
    }

    public Integer getLocalIntegerParameter(String parameterName, Integer defaultValue) {
        Integer val;
        try {
            val = this.getLocalIntegerParameter(parameterName);
        }
        catch (EngineExceptionI e) {
            val = defaultValue;
        }
        return val;
    }

    public Integer getLocalIntegerBindedParameter(ResultSet rSet, String varName) throws EngineExceptionI {
        if (rSet != null) {
            Integer ret = this.getOverload(varName, Integer.class);
            if (ret != null) {
                return ret;
            }
            return this.getIntegerBindedParameter(rSet, this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + varName);
        }
        return this.getLocalIntegerParameter(varName);
    }

    public Integer getLocalIntegerBindedParameter(ResultSet rSet, String varName, Integer defaultValue) throws EngineExceptionI {
        if (rSet != null) {
            Integer val = defaultValue;
            try {
                val = this.getLocalIntegerBindedParameter(rSet, varName);
            }
            catch (EngineExceptionI e) {
                this.logger.debug("exception", (Throwable)e);
            }
            return val;
        }
        return this.getLocalIntegerParameter(varName, defaultValue);
    }

    public Long getLocalLongParameter(String parameterName) throws EngineExceptionI {
        return this.getLongParameter(this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + parameterName);
    }

    public Long getLocalLongParameter(String parameterName, Long defaultValue) {
        Long val = this.getOverload(parameterName, Long.class);
        if (val != null) {
            return val;
        }
        try {
            val = this.getLocalLongParameter(parameterName);
        }
        catch (EngineExceptionI e) {
            val = defaultValue;
        }
        return val;
    }

    public Long getLocalLongBindedParameter(ResultSet rSet, String varName) throws EngineExceptionI {
        if (rSet != null) {
            Long val = this.getOverload(varName, Long.class);
            if (val != null) {
                return val;
            }
            return this.getLongBindedParameter(rSet, this.runtimeContext.VAR_PREFIXE + this.actionName + this.runtimeContext.VARIABLE_PATH_SUFFIXE + varName);
        }
        return this.getLocalLongParameter(varName);
    }

    public Long getLocalLongBindedParameter(ResultSet rSet, String varName, Long defaultValue) throws EngineExceptionI {
        if (rSet != null) {
            Long val = defaultValue;
            try {
                val = this.getLocalLongBindedParameter(rSet, varName);
            }
            catch (EngineExceptionI e) {
                this.logger.debug("exception", (Throwable)e);
            }
            return val;
        }
        return this.getLocalLongParameter(varName, defaultValue);
    }

    public boolean existsFileTable() throws EngineExceptionI {
        return this.existsTable(null, null, "IND_SESSION_FILE_OP_LST");
    }

    protected boolean existsTable(Connection connection, String schema, String sTableName) throws EngineExceptionI {
        return CommonUtils.existsTable(connection != null ? connection : this.jdbcConnection, sTableName, schema != null ? schema : this.sqlSchemaName);
    }

    protected void logSqlException(SQLException e) {
        try {
            SQLException e1 = e;
            int i = 1;
            do {
                this.actionCodeTypeHandler.getActionCodeLogger().error("ActionCodeTypeI=>executeDirectBindedCode Exception " + i, (Throwable)e1);
            } while ((e1 = e1.getNextException()) != null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getFileTableVersion() {
        if (this.fileTableVersion == 0) {
            this.fileTableVersion = CommonUtils.existsField(this.jdbcConnection, this.sqlSchemaName, "IND_SESSION_FILE_OP_LST", "FILE_LENGTH") ? 2 : 1;
        }
        return this.fileTableVersion;
    }

    public void insertFileInTableFile(int num, String fromDir, String fromFile, String toDir, String toFile, String operation, File file, long lastModified) throws EngineExceptionI {
        if (file.exists()) {
            this.insertFileInTableFile(num, fromDir, fromFile, toDir, toFile, operation, true, file.length(), lastModified > -1L ? lastModified : file.lastModified(), file.canExecute(), file.canRead(), file.canWrite(), file.isDirectory(), file.isHidden());
        }
    }

    public void insertFileInTableFile(int num, String fromDir, String fromFile, String toDir, String toFile, String operation, boolean exists, long length, long lastModified, boolean canExecute, boolean canRead, boolean canWrite, boolean isDirectory, boolean isHidden) throws EngineExceptionI {
        int version = this.getFileTableVersion();
        String columns = this.getColumnNameForFileInTable(version, exists, 1);
        String values = this.getColumnNameForFileInTable(version, exists, 2);
        String txtCode = "INSERT into " + this.sqlSchemaName + "IND_SESSION_FILE_OP_LST (" + columns + ")  values (" + values + ") ";
        try {
            Throwable throwable = null;
            Object var22_22 = null;
            try (PreparedStatement sqlStatement = this.jdbcConnection.prepareStatement(txtCode);){
                this.debugLog("insertFileInTable", "Statement prepared", 6, "DEBUG");
                this.insertFileInTableFile(sqlStatement, num, fromDir, fromFile, toDir, toFile, operation, exists, length, lastModified, canExecute, canRead, canWrite, isDirectory, isHidden, version);
                this.debugLog("insertFileInTable", "Insert OK", 6, "DEBUG");
                if (this.sqlTransType.equals("COMMIT")) {
                    this.jdbcConnection.commit();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            this.publishVariable(VariableType.CORE_RET_MESS.getName(), this.getClass().getSimpleName() + "=>insertFileInTable : " + e.getMessage(), "String", false);
            throw new EngineExceptionI(e);
        }
    }

    public int finalizeExecuteCode() throws EngineExceptionI {
        return 0;
    }

    protected static Statement createResultSetStatement(Connection jdbcConnection) throws SQLException {
        return jdbcConnection.createStatement();
    }

    public boolean isAutoCommit() {
        boolean selectAndCommitOrRollback;
        boolean bl = selectAndCommitOrRollback = this.isSelect && this.sqlReadAutocommitMode == 2;
        return this.isTransactionAutoCommit() && !selectAndCommitOrRollback;
    }

    protected boolean isTransactionAutoCommit() {
        return this.sqlTransType.equals("AUTOCOMMIT") || this.sqlTransType.equals("AUTONOMOUS");
    }

    public void setTransactionAndCommit(String transType, boolean isSelect) {
        this.sqlTransType = transType;
        if (this.sqlTransType == null) {
            this.sqlTransType = "AUTOCOMMIT";
        }
        this.isSelect = isSelect;
    }

    public void addInfoOnSqlException(Throwable _e, int position) {
        Throwable e = _e;
        while (!(e instanceof SQLException) && e != null) {
            e = e.getCause();
        }
        if (e instanceof SQLException) {
            SQLException sql = (SQLException)e;
            while (sql.getNextException() != null) {
                sql = sql.getNextException();
            }
            if (sql.getNextException() == null) {
                SQLException ex1 = new SQLException(Messages.getString("ActionCodeTypeI.28") + position);
                sql.setNextException(ex1);
            }
        }
    }

    public static void setAutoCommit(Connection conn, boolean autocommit) throws SQLException {
        Boolean b = null;
        try {
            b = conn.getAutoCommit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (b != null) {
            if (b != autocommit) {
                conn.setAutoCommit(autocommit);
            }
        } else {
            conn.setAutoCommit(autocommit);
        }
    }

    public void insertFileInTableFile(PreparedStatement sqlstatement, int num, String fromDir, String fromFile, String toDir, String toFile, String operation, File file, long lastModified) throws EngineExceptionI, SQLException {
        if (file.exists()) {
            this.insertFileInTableFile(sqlstatement, num, fromDir, fromFile, toDir, toFile, operation, true, file.length(), lastModified > -1L ? lastModified : file.lastModified(), file.canExecute(), file.canRead(), file.canWrite(), file.isDirectory(), file.isHidden(), 100000);
        }
    }

    public void insertFileInTableFile(PreparedStatement sqlStatement, int num, String fromDir, String fromFile, String toDir, String toFile, String operation, boolean exists, long length, long lastModified, boolean canExecute, boolean canRead, boolean canWrite, boolean isDirectory, boolean isHidden, int version) throws SQLException {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.runtimeContext.GLOBAL_DATE_FORMAT);
        int index = 1;
        sqlStatement.setString(index++, this.getActionContext().getEngineContext().getSessionID());
        sqlStatement.setString(index++, this.getActionContext().getEngineContext().getSessionName());
        sqlStatement.setString(index++, this.getActionContext().getActionId());
        sqlStatement.setString(index++, this.getActionContext().getActionName());
        sqlStatement.setInt(index++, num);
        sqlStatement.setString(index++, operation);
        sqlStatement.setString(index++, fromDir);
        sqlStatement.setString(index++, fromFile);
        sqlStatement.setString(index++, fromDir);
        sqlStatement.setString(index++, fromFile);
        sqlStatement.setString(index++, toDir);
        sqlStatement.setString(index++, toFile);
        sqlStatement.setString(index++, dateFormat.format(new Date()));
        sqlStatement.setInt(index++, this.getActionContext().getNbExecution() + 1);
        if (version >= 2 && exists) {
            sqlStatement.setInt(index++, isHidden ? 1 : 0);
            long l = lastModified;
            sqlStatement.setLong(index++, l);
            sqlStatement.setString(index++, dateFormat.format(new Date(lastModified)));
            sqlStatement.setInt(index++, canRead ? 1 : 0);
            sqlStatement.setInt(index++, canWrite ? 1 : 0);
            sqlStatement.setInt(index++, canExecute ? 1 : 0);
            sqlStatement.setInt(index++, isDirectory ? 1 : 0);
            sqlStatement.setLong(index++, length);
        }
        sqlStatement.executeUpdate();
    }

    public IPreparedStatementToResultSet insertFileInTableFilePrepare() throws SQLException {
        IPreparedStatementToResultSet jpstrs = (IPreparedStatementToResultSet)this.getActionContext().createBindePreparedStatement();
        jpstrs.setColumnsName(this.getColumnNameForFileInTable(100000, true, 1), ",");
        jpstrs.setColumnsPrecision(this.getColumnNameForFileInTable(100000, true, 4), ",");
        return jpstrs;
    }

    private String getColumnNameForFileInTable(int version, boolean exists, int mode) {
        Object columns = "SESS_ID, SESS_NAME, ACT_ID, ACT_NAME, FILE_ID, FILE_OPERATION, FILE_DIR, FILE_NAME,FILE_FROM_DIR,FILE_FROM_FILE, FILE_TO_DIR, FILE_TO_FILE, FILE_OPERATION_DATE, ACT_ITER";
        String types = "VARCHAR,VARCHAR,VARCHAR,VARCHAR,VARCHAR,VARCHAR,VARCHAR,VARCHAR,VARCHAR,VARCHAR,VARCHAR,VARCHAR,VARCHAR,VARCHAR";
        Object precisions = "255,255,255,255,255,255,255,255,255,255,255,255,255,255";
        Object values = "?,?,?,?,?,?,?,?,?,?,?,?,?,?";
        if (version >= 2 && exists) {
            columns = (String)columns + ",FILE_IS_HIDDEN";
            columns = (String)columns + ",FILE_LAST_MODIFIED";
            columns = (String)columns + ",FILE_LAST_MODIFIED_DATE";
            columns = (String)columns + ",FILE_CAN_READ";
            columns = (String)columns + ",FILE_CAN_WRITE";
            columns = (String)columns + ",FILE_CAN_EXECUTE";
            columns = (String)columns + ",FILE_IS_DIRECTORY";
            columns = (String)columns + ",FILE_LENGTH";
            values = (String)values + ",?,?,?,?,?,?,?,?";
            precisions = (String)precisions + "255,255,255,255,255,255,255,255";
        }
        if (mode == 1) {
            return columns;
        }
        if (mode == 2) {
            return values;
        }
        if (mode == 3) {
            return types;
        }
        if (mode == 4) {
            return precisions;
        }
        return null;
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public int finalizeSimpleExecuteCode() throws EngineExceptionI {
        int ret = 0;
        if (this.isRdbmsLinked && this.isTransactionAutoCommit()) {
            this.closeConnection(this.connectionName, this.sqlTransName, this.sqlTransType, true);
        }
        return ret;
    }

    public void setContexts(String aName, IActionContext aContext, ISessionContext eContext) throws EngineExceptionI {
        this.runtimeContext = eContext.getRuntimeContext();
        this.init();
        this.actionContext = aContext;
        this.engineContext = eContext;
        this.actionName = aName;
        this.computeActionLevel();
        try {
            this.sessionName = aContext.getEngineContext().getSessionName();
        }
        catch (Exception e) {
            throw new EngineExceptionI(e);
        }
    }

    @Deprecated
    public synchronized void write(String sess, String ObjectMethod, String sMessage, int lLevel, int lIndent, String sMode) {
        this.actionCodeTypeHandler.write(sess, ObjectMethod, sMessage, lLevel, lIndent, sMode);
    }

    public Logger getActionCodeLogger() {
        return this.actionCodeTypeHandler.getActionCodeLogger();
    }

    public void fillOverLoadParameters(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            if (entry.getValue() == null || !(entry.getValue() instanceof String) || ((String)entry.getValue()).isEmpty()) continue;
            this.overLoadParamters.put((String)entry.getKey(), entry.getValue());
        }
    }

    public void clearOverLoadParameters() {
        this.overLoadParamters.clear();
    }

    private <T> T getOverload(String varName, Class<T> type) {
        Object str;
        if (this.overLoadParamters != null && !this.overLoadParamters.isEmpty() && (str = this.overLoadParamters.get(varName)) != null) {
            if (type.isInstance(str)) {
                return (T)str;
            }
            try {
                return (T)type.getMethod("valueOf", String.class).invoke(null, str);
            }
            catch (Throwable e) {
                throw new RuntimeException(String.format("Unable to invoke valueOf(String) on %s", type.getName()), e);
            }
        }
        return null;
    }

    public boolean isBindedAction() {
        return this.actionContext.isTrgBindedAction() && !this.actionContext.isSrcBindedAction();
    }

    public static interface ActionCodeTypeHandler {
        public Connection setConnection(String var1, String var2, String var3) throws EngineExceptionI;

        public void closeConnection(String var1, String var2, String var3, boolean var4);

        public String executeSubstitutionScript(IActionContext var1, String var2, String var3) throws EngineExceptionI;

        public IVariable addVariableWithULog(String var1, String var2, String var3, boolean var4);

        public IVariable getAbsoluteVariable(String var1);

        public Map<String, Object> getAllBindedParameter(ResultSet var1, String var2) throws EngineExceptionI, SQLException;

        public void write(String var1, String var2, String var3, int var4, int var5, String var6);

        public Logger getActionCodeLogger();

        public void write(String var1, String var2, int var3, int var4, String var5);
    }
}

