/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.common.tools;

import com.indy.engine.core.manager.IActionContext;
import com.indy.engine.core.tools.PipedStream;
import com.indy.engine.core.tools.PipedStream2;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class OutputStreamTransformer {
    protected Map<String, String> properties = new HashMap<String, String>();
    protected Map<String, Object> internalProperties = new HashMap<String, Object>();
    OutputStreamTransformerStatisticHandler handler;
    PipedStream2 ps;
    private Exception exception;
    PipedStream psInputStream;
    private IActionContext actionContext;

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public Set<String> getKeys() {
        return this.properties.keySet();
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public void setInternalProperty(String key, Object value) {
        this.internalProperties.put(key, value);
    }

    public void setStatisticHandler(OutputStreamTransformerStatisticHandler handler) {
        this.handler = handler;
    }

    public OutputStreamTransformerStatisticHandler getStatisticHandler() {
        return this.handler;
    }

    public abstract void transform(InputStream var1, OutputStream var2) throws Exception;

    public OutputStream start(final OutputStream os) throws IOException {
        this.ps = new PipedStream2(){

            @Override
            public void readInputStream(InputStream inputStream) throws Exception {
                try {
                    try {
                        OutputStreamTransformer.this.transform(inputStream, os);
                    }
                    catch (Exception e) {
                        OutputStreamTransformer.this.exception = e;
                        os.close();
                    }
                }
                finally {
                    os.close();
                }
            }
        };
        this.ps.start();
        return this.ps.getOutputStream();
    }

    public Exception getException() {
        return this.exception;
    }

    public InputStream start(final InputStream is) throws Exception {
        this.psInputStream = new PipedStream(){

            @Override
            public void putDataOnOutputStream(OutputStream out) throws Exception {
                try {
                    try {
                        OutputStreamTransformer.this.transform(is, out);
                    }
                    catch (Exception e) {
                        OutputStreamTransformer.this.exception = e;
                        out.close();
                    }
                }
                finally {
                    out.close();
                }
            }
        };
        this.psInputStream.start();
        return this.psInputStream.getInputStream();
    }

    public IActionContext getActionContext() {
        return this.actionContext;
    }

    public void setActionContext(IActionContext actionContext) {
        this.actionContext = actionContext;
    }

    public void close() throws Throwable {
        if (this.ps != null) {
            this.ps.close();
        }
        if (this.psInputStream != null) {
            this.psInputStream.close();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        this.handler = null;
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        OutputStreamTransformer osw = new OutputStreamTransformer(){

            @Override
            public void transform(InputStream inputStream, OutputStream outputStream) throws Exception {
                int i = -1;
                do {
                    if ((i = inputStream.read()) <= -1) continue;
                    outputStream.write(i);
                } while (i > -1);
                outputStream.flush();
            }
        };
        OutputStream os = osw.start(System.out);
        OutputStreamWriter osw2 = new OutputStreamWriter(os);
        osw2.write("azertyuiop1\n");
        osw2.close();
    }

    public void interrupt() {
    }

    public Set<Map.Entry<String, String>> getProperties() {
        return this.properties.entrySet();
    }

    @Deprecated
    public static interface OutputStreamTransformerStatisticHandler
    extends StatisticHandler {
    }

    public static interface StatisticHandler {
        public void handle(String var1, long var2);
    }
}

