/*
 * Decompiled with CFR 0.152.
 */
package com.indy.engine.core.actionCodes.convert;

import com.indy.engine.core.actionCodes.convert.JdbcConverter;
import com.indy.engine.core.actionCodes.convert.Messages;
import com.indy.engine.core.api.impl.jdbc.JdbcWriterProperties;
import com.semarchy.xdi.engine.common.exceptions.EngineExceptionI;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;

public abstract class AbstractParser<T> {
    public static final AbstractStringParser defaultStringParser = new AbstractStringParser(){

        @Override
        public String parse(String value) throws EngineExceptionI {
            return value;
        }
    };
    public static final AbstractShortParser defaultShortParser = new AbstractShortParser(){

        @Override
        public Short parse(String value) throws EngineExceptionI {
            return Short.parseShort(value);
        }
    };
    public static final AbstractIntegerParser defaultIntegerParser = new AbstractIntegerParser(){

        @Override
        public Integer parse(String value) throws EngineExceptionI {
            return Integer.parseInt(value);
        }
    };
    public static final AbstractDoubleParser defaultDoubleParser = new AbstractDoubleParser(){

        @Override
        public Double parse(String value) throws EngineExceptionI {
            return Double.parseDouble(value);
        }
    };
    public static final AbstractBigDecimalParser defaultBigDecimalParser = new AbstractBigDecimalParser(){

        @Override
        public BigDecimal parse(String value) throws EngineExceptionI {
            return new BigDecimal(value.trim());
        }
    };
    public static final AbstractByteParser defaultByteParser = new AbstractByteParser(){

        @Override
        public Byte parse(String value) throws EngineExceptionI {
            return Byte.parseByte(value);
        }
    };

    public String preTransformation(String str) {
        return str;
    }

    public T doParse(String value) throws EngineExceptionI {
        String newValue = this.preTransformation(value);
        if (newValue != null) {
            return this.parse(newValue);
        }
        return null;
    }

    protected abstract T parse(String var1) throws EngineExceptionI;

    public abstract void setJdbcStatement(PreparedStatement var1, int var2, T var3, boolean var4, int var5, JdbcWriterProperties var6) throws SQLException;

    public static abstract class AbstractBigDecimalParser
    extends AbstractParser<BigDecimal> {
        @Override
        public void setJdbcStatement(PreparedStatement ps, int index, BigDecimal value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertNumber(ps, index, value, wasNull, targetColType, converter);
        }
    }

    public static abstract class AbstractBigIntegerParser
    extends AbstractParser<BigInteger> {
        @Override
        public void setJdbcStatement(PreparedStatement ps, int index, BigInteger value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertNumber(ps, index, value, wasNull, targetColType, converter);
        }
    }

    public static abstract class AbstractBooleanParser
    extends AbstractParser<Boolean> {
        @Override
        public void setJdbcStatement(PreparedStatement ps, int index, Boolean value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertBoolean(ps, index, wasNull ? false : value, wasNull, targetColType, converter);
        }
    }

    public static abstract class AbstractByteParser
    extends AbstractParser<Byte> {
        @Override
        public void setJdbcStatement(PreparedStatement ps, int index, Byte value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertByte(ps, index, wasNull ? (byte)0 : value, wasNull, targetColType);
        }
    }

    public static abstract class AbstractDateParser
    extends AbstractParser<Date> {
        @Override
        public void setJdbcStatement(PreparedStatement ps, int index, Date value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertDate(ps, index, value, targetColType, converter);
        }
    }

    public static abstract class AbstractDoubleParser
    extends AbstractParser<Double> {
        @Override
        public void setJdbcStatement(PreparedStatement ps, int index, Double value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertDouble(ps, index, wasNull ? 0.0 : value, wasNull, targetColType, converter);
        }
    }

    public static abstract class AbstractFloatParser
    extends AbstractParser<Float> {
        @Override
        public void setJdbcStatement(PreparedStatement ps, int index, Float value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertFloat(ps, index, wasNull ? 0.0f : value.floatValue(), wasNull, targetColType, converter);
        }
    }

    public static abstract class AbstractIntegerParser
    extends AbstractParser<Integer> {
        @Override
        public void setJdbcStatement(PreparedStatement ps, int index, Integer value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertInteger(ps, index, wasNull ? 0 : value, wasNull, targetColType, converter);
        }
    }

    public static abstract class AbstractLongParser
    extends AbstractParser<Long> {
        @Override
        public void setJdbcStatement(PreparedStatement ps, int index, Long value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertLong(ps, index, wasNull ? 0L : value, wasNull, targetColType, converter);
        }
    }

    public static abstract class AbstractShortParser
    extends AbstractParser<Short> {
        @Override
        public void setJdbcStatement(PreparedStatement ps, int index, Short value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertShort(ps, index, wasNull ? (short)0 : value, wasNull, targetColType, converter);
        }
    }

    public static abstract class AbstractStringParser
    extends AbstractParser<String> {
        @Override
        public void setJdbcStatement(PreparedStatement ps, int index, String value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertString(ps, index, value, targetColType, false, converter);
        }
    }

    public static abstract class AbstractTimeParser
    extends AbstractParser<Time> {
        @Override
        public void setJdbcStatement(PreparedStatement ps, int index, Time value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertTime(ps, index, value, targetColType);
        }
    }

    public static abstract class AbstractTimestampParser
    extends AbstractParser<Timestamp> {
        @Override
        public void setJdbcStatement(PreparedStatement ps, int index, Timestamp value, boolean wasNull, int targetColType, JdbcWriterProperties converter) throws SQLException {
            JdbcConverter.convertTimeStamp(ps, index, value, targetColType, converter);
        }
    }

    public static class DefaultDateParser
    extends AbstractDateParser {
        DateFormat d;

        public DefaultDateParser(DateFormat d) {
            this.d = d;
        }

        @Override
        public Date parse(String value) throws EngineExceptionI {
            try {
                return new Date(this.d.parse(value).getTime());
            }
            catch (ParseException e) {
                throw new EngineExceptionI(Messages.getString("AbstractParser.0") + value, e);
            }
        }
    }

    public static class DefaultTimeParser
    extends AbstractTimeParser {
        DateFormat d;

        public DefaultTimeParser(DateFormat d) {
            this.d = d;
        }

        @Override
        public Time parse(String value) throws EngineExceptionI {
            try {
                return new Time(this.d.parse(value).getTime());
            }
            catch (ParseException e) {
                throw new EngineExceptionI(Messages.getString("AbstractParser.1") + value, e);
            }
        }
    }

    public class DefaultTimestampParser
    extends AbstractTimestampParser {
        DateFormat d;

        public DefaultTimestampParser(DateFormat d) {
            this.d = d;
        }

        @Override
        public Timestamp parse(String value) throws EngineExceptionI {
            try {
                return new Timestamp(this.d.parse(value).getTime());
            }
            catch (ParseException e) {
                throw new EngineExceptionI(Messages.getString("AbstractParser.2") + value, e);
            }
        }
    }
}

